/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.util.binFile;

public class BinaryMesh2DCalculator {
    protected long nx;
    protected long ny;
    private DataType numType;
    private long maxFilePos;
    private MeshOrder meshOrder = MeshOrder.FAST_XY;
    private int numBytesPerPoint;

    public BinaryMesh2DCalculator(DataType numType, long nx, long ny) {
        this.numBytesPerPoint = numType.getNumBytes();
        this.nx = nx;
        this.ny = ny;
        this.maxFilePos = this.calcMaxFilePos();
        this.numType = numType;
    }

    public long calcMeshIndex(long x, long y) {
        if (this.meshOrder == MeshOrder.FAST_XY) {
            return this.nx * y + x;
        }
        return this.ny * x + y;
    }

    public long calcFileX(long pos) {
        return this.calcMeshX(pos / (long)this.numBytesPerPoint);
    }

    public long calcMeshX(long index) {
        if (this.meshOrder == MeshOrder.FAST_XY) {
            return index % this.nx;
        }
        return index / this.ny;
    }

    public long calcFileY(long pos) {
        return this.calcMeshY(pos / (long)this.numBytesPerPoint);
    }

    public long calcMeshY(long index) {
        if (this.meshOrder == MeshOrder.FAST_XY) {
            return index / this.nx;
        }
        return index % this.ny;
    }

    public long calcFileIndex(long x, long y) {
        return (long)this.numBytesPerPoint * this.calcMeshIndex(x, y);
    }

    public long getNX() {
        return this.nx;
    }

    public void setNX(int nx) {
        this.nx = nx;
        this.maxFilePos = this.calcMaxFilePos();
    }

    public long getNY() {
        return this.ny;
    }

    public void setNY(int ny) {
        this.ny = ny;
        this.maxFilePos = this.calcMaxFilePos();
    }

    public long getMaxFilePos() {
        return this.maxFilePos;
    }

    private long calcMaxFilePos() {
        return (this.nx * this.ny - 1L) * (long)this.numBytesPerPoint;
    }

    public MeshOrder getMeshOrder() {
        return this.meshOrder;
    }

    public void setMeshOrder(MeshOrder meshOrder) {
        this.meshOrder = meshOrder;
    }

    public DataType getType() {
        return this.numType;
    }

    public static enum MeshOrder {
        FAST_XY,
        FAST_YX;

    }

    public static enum DataType {
        SHORT(2),
        INT(4),
        LONG(8),
        FLOAT(4),
        DOUBLE(8);

        private int bytes;

        private DataType(int bytes) {
            this.bytes = bytes;
        }

        public int getNumBytes() {
            return this.bytes;
        }
    }
}

