/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.util.binFile;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.util.Map;

public abstract class BinaryRandomAccessFile {
    private File file;
    private RandomAccessFile ra;
    private ByteOrder byteOrder;
    private int numRecords;
    private Map<Integer, BufferWrapper<IntBuffer>> intBuffMap = Maps.newHashMap();
    private Map<Integer, BufferWrapper<LongBuffer>> longBuffMap = Maps.newHashMap();
    private Map<Integer, BufferWrapper<FloatBuffer>> floatBuffMap = Maps.newHashMap();
    private Map<Integer, BufferWrapper<DoubleBuffer>> doubleBuffMap = Maps.newHashMap();

    public BinaryRandomAccessFile(File file, ByteOrder byteOrder, int numRecords) {
        this.file = file;
        this.byteOrder = byteOrder;
        this.numRecords = numRecords;
    }

    public int getNumRecords() {
        return this.numRecords;
    }

    private synchronized RandomAccessFile getRA() throws IOException {
        if (this.ra == null) {
            if (!this.file.exists()) {
                System.out.println("Warning, not initialized. Initializing with first archive");
                this.initialize();
            }
            this.ra = new RandomAccessFile(this.file, "rws");
        }
        return this.ra;
    }

    protected abstract int getHeaderLen();

    protected abstract int getRecordLen();

    protected long calcFilePos(int index) {
        return (long)this.getHeaderLen() + (long)this.getRecordLen() * (long)index;
    }

    protected abstract byte[] getHeader();

    protected abstract byte[] getBlankRecord();

    public void initialize() throws IOException {
        long expectedLen = this.calcFilePos(this.numRecords);
        if (this.file.exists() && this.file.length() == expectedLen) {
            return;
        }
        if (this.file.exists()) {
            Files.move((File)this.file, (File)new File(this.file.getAbsolutePath() + ".bad"));
        }
        Preconditions.checkState((!this.file.exists() ? 1 : 0) != 0);
        Preconditions.checkState((expectedLen < Integer.MAX_VALUE ? 1 : 0) != 0);
        byte[] bytes = new byte[(int)expectedLen];
        int pos = 0;
        byte[] header = this.getHeader();
        Preconditions.checkState((header.length == this.getHeaderLen() ? 1 : 0) != 0);
        for (int i = 0; i < header.length; ++i) {
            bytes[pos++] = header[i];
        }
        byte[] blank = this.getBlankRecord();
        Preconditions.checkState((blank.length == this.getRecordLen() ? 1 : 0) != 0);
        while ((long)pos < expectedLen) {
            for (int i = 0; i < blank.length; ++i) {
                bytes[pos++] = blank[i];
            }
        }
        this.ra = new RandomAccessFile(this.file, "rws");
        this.ra.write(bytes);
    }

    protected synchronized void writeRecord(int index, byte[] record) throws IOException {
        Preconditions.checkState((index < this.numRecords ? 1 : 0) != 0);
        Preconditions.checkState((record.length == this.getRecordLen() ? 1 : 0) != 0);
        RandomAccessFile ra = this.getRA();
        ra.seek(this.calcFilePos(index));
        ra.write(record);
    }

    protected synchronized byte[] readRecord(int index) throws IOException {
        byte[] record = new byte[this.getRecordLen()];
        RandomAccessFile ra = this.getRA();
        ra.seek(this.calcFilePos(index));
        ra.readFully(record, 0, record.length);
        return record;
    }

    public void close() throws IOException {
        RandomAccessFile ra = this.getRA();
        ra.close();
    }

    protected static byte[] cloneBytes(byte[] in) {
        byte[] out = new byte[in.length];
        for (int i = 0; i < in.length; ++i) {
            out[i] = in[i];
        }
        return out;
    }

    protected synchronized BufferWrapper<IntBuffer> getIntBuffer(int numInts) {
        BufferWrapper wrap = this.intBuffMap.get(numInts);
        if (wrap == null) {
            byte[] bytes = new byte[numInts * 4];
            ByteBuffer buff = this.buildBuff(bytes);
            wrap = new BufferWrapper(this, (Buffer)buff.asIntBuffer(), bytes);
            this.intBuffMap.put(numInts, wrap);
        }
        return wrap;
    }

    protected synchronized BufferWrapper<LongBuffer> getLongBuffer(int numLongs) {
        BufferWrapper wrap = this.longBuffMap.get(numLongs);
        if (wrap == null) {
            byte[] bytes = new byte[numLongs * 8];
            ByteBuffer buff = this.buildBuff(bytes);
            wrap = new BufferWrapper(this, (Buffer)buff.asLongBuffer(), bytes);
            this.longBuffMap.put(numLongs, wrap);
        }
        return wrap;
    }

    protected synchronized BufferWrapper<FloatBuffer> getFloatBuffer(int numFloats) {
        BufferWrapper wrap = this.floatBuffMap.get(numFloats);
        if (wrap == null) {
            byte[] bytes = new byte[numFloats * 4];
            ByteBuffer buff = this.buildBuff(bytes);
            wrap = new BufferWrapper(this, (Buffer)buff.asFloatBuffer(), bytes);
            this.floatBuffMap.put(numFloats, wrap);
        }
        return wrap;
    }

    protected synchronized BufferWrapper<DoubleBuffer> getDoubleBuffer(int numDoubles) {
        BufferWrapper wrap = this.doubleBuffMap.get(numDoubles);
        if (wrap == null) {
            byte[] bytes = new byte[numDoubles * 8];
            ByteBuffer buff = this.buildBuff(bytes);
            wrap = new BufferWrapper(this, (Buffer)buff.asDoubleBuffer(), bytes);
            this.doubleBuffMap.put(numDoubles, wrap);
        }
        return wrap;
    }

    private ByteBuffer buildBuff(byte[] bytes) {
        ByteBuffer buff = ByteBuffer.wrap(bytes);
        buff.order(this.byteOrder);
        return buff;
    }

    protected static class BufferWrapper<E extends Buffer> {
        E buffer;
        byte[] bytes;
        final /* synthetic */ BinaryRandomAccessFile this$0;

        public BufferWrapper(E buffer, byte[] bytes) {
            this.this$0 = this$0;
            this.buffer = buffer;
            this.bytes = bytes;
        }

        public E getBuffer() {
            return this.buffer;
        }

        public byte[] getBytes() {
            return this.bytes;
        }

        public int length() {
            return this.bytes.length;
        }
    }
}

