/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.util.cpt;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.StringTokenizer;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.opensha.commons.data.Named;
import org.opensha.commons.metadata.XMLSaveable;
import org.opensha.commons.util.ApplicationVersion;
import org.opensha.commons.util.XMLUtils;
import org.opensha.commons.util.cpt.Blender;
import org.opensha.commons.util.cpt.CPTVal;
import org.opensha.commons.util.cpt.LinearBlender;

public class CPT
extends ArrayList<CPTVal>
implements Named,
Serializable,
Cloneable,
XMLSaveable {
    private static final long serialVersionUID = 1L;
    public static final String XML_METADATA_NAME = "CPT";
    private Color nanColor;
    private Color belowMinColor;
    private Color aboveMaxColor;
    private Color gapColor;
    private Blender blender;
    private boolean isLog10;
    private double preferredTickInterval = Double.NaN;
    private String name;

    public CPT() {
        this((String)null);
    }

    public CPT(String name) {
        this.name = name;
        this.nanColor = Color.BLACK;
        this.gapColor = Color.BLACK;
        this.belowMinColor = Color.BLACK;
        this.aboveMaxColor = Color.BLACK;
        this.blender = new LinearBlender();
    }

    public CPT(double minVal, double maxVal, Color ... colors) {
        this((String)null);
        Preconditions.checkArgument((minVal < maxVal ? 1 : 0) != 0, (Object)"min must be less than max");
        Preconditions.checkArgument((colors.length > 1 ? 1 : 0) != 0, (Object)"must specify at least 2 colors");
        double delta = (maxVal - minVal) / (double)(colors.length - 1);
        for (int i = 0; i < colors.length - 1; ++i) {
            double start = minVal + delta * (double)i;
            double end = minVal + delta * (double)(i + 1);
            this.add(new CPTVal(start, colors[i], end, colors[i + 1]));
        }
        this.setBelowMinColor(colors[0]);
        this.setAboveMaxColor(colors[colors.length - 1]);
    }

    public boolean isLog10() {
        return this.isLog10;
    }

    public void setLog10(boolean isLog10) {
        this.isLog10 = isLog10;
    }

    public void setNanColor(int r, int g, int b) {
        this.nanColor = new Color(r, g, b);
    }

    public void setNanColor(Color color) {
        this.nanColor = color;
    }

    public void setBelowMinColor(Color color) {
        this.belowMinColor = color;
    }

    public void setAboveMaxColor(Color color) {
        this.aboveMaxColor = color;
    }

    public void setGapColor(Color color) {
        this.gapColor = color;
    }

    public void setGapColor(int r, int g, int b) {
        this.gapColor = new Color(r, g, b);
    }

    public void setBelowMinColor(int r, int g, int b) {
        this.belowMinColor = new Color(r, g, b);
    }

    public void setAboveMaxColor(int r, int g, int b) {
        this.aboveMaxColor = new Color(r, g, b);
    }

    public Color getAboveMaxColor() {
        return this.aboveMaxColor;
    }

    public Color getBelowMinColor() {
        return this.belowMinColor;
    }

    public Color getMinColor() {
        if (this.size() > 0) {
            return ((CPTVal)this.get((int)0)).minColor;
        }
        return null;
    }

    public Color getMaxColor() {
        if (this.size() > 0) {
            return ((CPTVal)this.get((int)(this.size() - 1))).maxColor;
        }
        return null;
    }

    public Color getNanColor() {
        return this.nanColor;
    }

    public Color getGapColor() {
        return this.gapColor;
    }

    public Color getColor(double value) {
        return this.getColor((float)value);
    }

    public Color getColor(float value) {
        if (this.isLog10) {
            value = (float)Math.log10(value);
        }
        return this.getColorRaw(value);
    }

    public Color getColorRaw(float value) {
        CPTVal cpt_val = this.getCPTVal(value);
        if (cpt_val != null) {
            if (value == (float)cpt_val.start) {
                return cpt_val.minColor;
            }
            if (value == (float)cpt_val.end) {
                return cpt_val.maxColor;
            }
            if (value > (float)cpt_val.start && value < (float)cpt_val.end) {
                float adjVal = (value - (float)cpt_val.start) / ((float)cpt_val.end - (float)cpt_val.start);
                return this.blendColors(cpt_val.minColor, cpt_val.maxColor, adjVal);
            }
        }
        if ((double)value < ((CPTVal)this.get((int)0)).start) {
            return this.getBelowMinColor();
        }
        if ((double)value > ((CPTVal)this.get((int)(this.size() - 1))).end) {
            return this.getAboveMaxColor();
        }
        if (Float.isNaN(value)) {
            return this.nanColor;
        }
        return this.gapColor;
    }

    private Color blendColors(Color smallColor, Color bigColor, float bias) {
        return this.blender.blend(smallColor, bigColor, bias);
    }

    public static CPT loadFromFile(File dataFile) throws FileNotFoundException, IOException {
        BufferedReader in = new BufferedReader(new FileReader(dataFile));
        return CPT.loadFromBufferedReader(in);
    }

    public static CPT loadFromStream(InputStream is) throws IOException {
        BufferedReader in = new BufferedReader(new InputStreamReader(is));
        return CPT.loadFromBufferedReader(in);
    }

    private static Color loadColor(StringTokenizer tok) {
        int R = Integer.parseInt(tok.nextToken());
        int G = Integer.parseInt(tok.nextToken());
        int B = Integer.parseInt(tok.nextToken());
        return new Color(R, G, B);
    }

    private static CPT loadFromBufferedReader(BufferedReader in) throws IOException {
        CPT cpt = new CPT();
        int lineNumber = 0;
        boolean hasMin = false;
        boolean hasMax = false;
        block8: while (in.ready()) {
            ++lineNumber;
            String line = in.readLine().trim();
            if (line.length() == 0) continue;
            StringTokenizer tok = new StringTokenizer(line);
            int tokens = tok.countTokens();
            char firstChar = line.charAt(0);
            try {
                switch (firstChar) {
                    case '#': {
                        line = line.substring(1).trim();
                        line = line.replace(" ", "");
                        if (!(line = line.toLowerCase()).startsWith("log10=true")) continue block8;
                        cpt.setLog10(true);
                        continue block8;
                    }
                    case 'N': {
                        tok.nextToken();
                        cpt.setNanColor(CPT.loadColor(tok));
                        continue block8;
                    }
                    case 'B': {
                        tok.nextToken();
                        cpt.setBelowMinColor(CPT.loadColor(tok));
                        hasMin = true;
                        continue block8;
                    }
                    case 'F': {
                        tok.nextToken();
                        cpt.setAboveMaxColor(CPT.loadColor(tok));
                        hasMax = true;
                        continue block8;
                    }
                }
                if (tokens < 8) {
                    System.out.println("Skipping line: " + lineNumber + "! (Comment or not properly formatted.): " + line);
                    continue;
                }
                float start = Float.parseFloat(tok.nextToken());
                Color minColor = CPT.loadColor(tok);
                float end = Float.parseFloat(tok.nextToken());
                Color maxColor = CPT.loadColor(tok);
                CPTVal cpt_val = new CPTVal(start, minColor, end, maxColor);
                cpt.add(cpt_val);
            }
            catch (NumberFormatException e1) {
                System.out.println("Skipping line: " + lineNumber + "! (bad number parse): " + line);
                continue;
            }
            if (tokens >= 8 && line.charAt(0) != '#') continue;
            System.out.println("Skipping line: " + lineNumber + "! (Comment or not properly formatted.): " + line);
        }
        if (!hasMin) {
            cpt.setBelowMinColor(cpt.getMinColor());
        }
        if (!hasMax) {
            cpt.setAboveMaxColor(cpt.getMaxColor());
        }
        return cpt;
    }

    @Override
    public Element toXMLMetadata(Element root) {
        Element xml = root.addElement(XML_METADATA_NAME);
        for (CPTVal val : this) {
            val.toXMLMetadata(xml);
        }
        XMLUtils.colorToXML(xml, this.aboveMaxColor, "AboveMaxColor");
        XMLUtils.colorToXML(xml, this.belowMinColor, "BelowMinColor");
        XMLUtils.colorToXML(xml, this.gapColor, "GapColor");
        XMLUtils.colorToXML(xml, this.nanColor, "NanColor");
        if (this.name != null && !this.name.isEmpty()) {
            xml.addAttribute("name", this.name);
        }
        xml.addAttribute("log10", "" + this.isLog10);
        return root;
    }

    public static CPT fromXMLMetadata(Element cptElem) {
        Attribute nameAtt = cptElem.attribute("name");
        CPT cpt = nameAtt != null ? new CPT(nameAtt.getStringValue()) : new CPT();
        Attribute logAtt = cptElem.attribute("log10");
        if (logAtt != null) {
            cpt.setLog10(Boolean.valueOf(logAtt.getStringValue()));
        }
        Iterator it = cptElem.elementIterator("CPTVal");
        while (it.hasNext()) {
            cpt.add(CPTVal.fromXMLMetadata((Element)it.next()));
        }
        cpt.setAboveMaxColor(XMLUtils.colorFromXML(cptElem.element("AboveMaxColor")));
        cpt.setBelowMinColor(XMLUtils.colorFromXML(cptElem.element("BelowMinColor")));
        cpt.setGapColor(XMLUtils.colorFromXML(cptElem.element("GapColor")));
        cpt.setNanColor(XMLUtils.colorFromXML(cptElem.element("NanColor")));
        return cpt;
    }

    private String getCPTValStr(CPTVal val) {
        return val.start + "\t" + val.minColor.getRed() + "\t" + String.valueOf(val.minColor);
    }

    public void writeCPTFile(String fileName) throws IOException {
        this.writeCPTFile(new File(fileName));
    }

    public void writeCPTFile(File file) throws IOException {
        FileWriter fw = new FileWriter(file);
        fw.write(this.toString());
        fw.close();
    }

    public Blender getBlender() {
        return this.blender;
    }

    public void setBlender(Blender blender) {
        this.blender = blender;
    }

    public CPTVal getCPTVal(float value) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            CPTVal val = (CPTVal)this.get(i);
            if (val.contains(value)) {
                return val;
            }
            if (val.end != (double)value) continue;
            if (i < size - 1) {
                if (!((double)value < ((CPTVal)this.get((int)(i + 1))).start)) continue;
                return val;
            }
            return val;
        }
        return null;
    }

    public void setCPTVal(CPTVal newcpt) {
        if (this.size() == 0) {
            this.add(newcpt);
        } else if (newcpt.compareTo((CPTVal)this.get(0)) < 0) {
            this.add(0, newcpt);
        } else if (newcpt.compareTo((CPTVal)this.get(this.size() - 1)) > 0) {
            this.add(newcpt);
        } else {
            boolean added = false;
            ListIterator<CPTVal> iter = this.listIterator();
            while (iter.hasNext()) {
                CPTVal cur = (CPTVal)iter.next();
                if (newcpt.start <= cur.start && cur.end <= newcpt.end) {
                    iter.remove();
                    if (added) continue;
                    iter.add(newcpt);
                    added = true;
                    continue;
                }
                if (newcpt.start <= cur.end && cur.end <= newcpt.end) {
                    cur.end = newcpt.start;
                    if (cur.start == cur.end) {
                        iter.remove();
                    }
                    iter.add(newcpt);
                    added = true;
                    continue;
                }
                if (newcpt.start <= cur.start && cur.start <= newcpt.end) {
                    cur.start = newcpt.end;
                    if (cur.start == cur.end) {
                        iter.remove();
                    }
                    if (!added) {
                        iter.add(newcpt);
                        added = true;
                    }
                    return;
                }
                if (!(cur.start <= newcpt.start) || !(newcpt.end <= cur.end)) continue;
                CPTVal newcur = new CPTVal(newcpt.end, newcpt.maxColor, cur.end, cur.maxColor);
                cur.end = newcpt.start;
                if (cur.end == cur.start) {
                    iter.remove();
                }
                if (newcur.start != newcur.end) {
                    iter.add(newcur);
                }
                iter.add(newcpt);
                return;
            }
        }
    }

    public void paintGrid(BufferedImage bi) {
        int width = bi.getWidth();
        int height = bi.getHeight();
        Graphics2D g = bi.createGraphics();
        Color color = this.getGapColor();
        g.setColor(color);
        g.fillRect(0, 0, width, height);
        if (this.size() > 0) {
            double minStart = ((CPTVal)this.get((int)0)).start;
            double maxEnd = ((CPTVal)this.get((int)(this.size() - 1))).end;
            double valsPerPixel = (maxEnd - minStart) / (double)width;
            int pixel = 0;
            double val = 0.0;
            for (CPTVal cptval : this) {
                double start = cptval.start;
                double end = cptval.end;
                Color startC = cptval.minColor;
                Color endC = cptval.maxColor;
                val = (double)pixel * valsPerPixel + minStart;
                while (val < start) {
                    val = (double)(++pixel) * valsPerPixel + minStart;
                }
                if (start == end) {
                    g.setColor(startC);
                    g.drawLine(pixel, 0, pixel, height);
                    ++pixel;
                    continue;
                }
                while (pixel < width && start <= val && val <= end) {
                    double bias = (val - start) / (end - start);
                    Color blend = this.blender.blend(startC, endC, (float)bias);
                    g.setColor(blend);
                    g.drawLine(pixel, 0, pixel, height);
                    val = (double)(++pixel) * valsPerPixel + minStart;
                }
            }
        }
    }

    public static String tabDelimColor(Color color) {
        return color.getRed() + "\t" + color.getGreen() + "\t" + color.getBlue();
    }

    @Override
    public String toString() {
        Object out = "# CPT File generated by OpenSHA (";
        try {
            out = (String)out + "version " + String.valueOf(ApplicationVersion.loadBuildVersion()) + ", ";
        }
        catch (IOException iOException) {
            // empty catch block
        }
        out = (String)out + "http://www.opensha.org)";
        out = (String)out + ": " + this.getClass().getName() + "\n";
        out = (String)out + "# Date: " + String.valueOf(new Date()) + "\n";
        if (this.isLog10) {
            out = (String)out + "# LOG10 = true\n";
        }
        for (CPTVal v : this) {
            out = (String)out + v.toString() + "\n";
        }
        if (this.belowMinColor != null) {
            out = (String)out + "B\t" + CPT.tabDelimColor(this.belowMinColor) + "\n";
        }
        if (this.aboveMaxColor != null) {
            out = (String)out + "F\t" + CPT.tabDelimColor(this.aboveMaxColor) + "\n";
        }
        if (this.nanColor != null) {
            out = (String)out + "N\t" + CPT.tabDelimColor(this.nanColor) + "\n";
        }
        return out;
    }

    public double getMinValue() {
        double min = this.getMinValueRaw();
        if (this.isLog10) {
            min = Math.pow(10.0, min);
        }
        return min;
    }

    public double getMaxValue() {
        double max = this.getMaxValueRaw();
        if (this.isLog10) {
            max = Math.pow(10.0, max);
        }
        return max;
    }

    public double getMinValueRaw() {
        double min = Double.POSITIVE_INFINITY;
        for (CPTVal cptVal : this) {
            if (cptVal.start < min) {
                min = cptVal.start;
            }
            if (!(cptVal.end < min)) continue;
            min = cptVal.end;
        }
        return min;
    }

    public double getMaxValueRaw() {
        double max = Double.NEGATIVE_INFINITY;
        for (CPTVal cptVal : this) {
            if (cptVal.start > max) {
                max = cptVal.start;
            }
            if (!(cptVal.end > max)) continue;
            max = cptVal.end;
        }
        return max;
    }

    public static void main(String[] args) throws FileNotFoundException, IOException {
        CPT cpt = CPT.loadFromFile(new File("/usr/share/gmt/cpt/GMT_seis.cpt"));
        System.out.println(cpt);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Object clone() {
        CPT cpt = new CPT(this.getName());
        cpt.setBelowMinColor(this.getBelowMinColor());
        cpt.setAboveMaxColor(this.getAboveMaxColor());
        cpt.setGapColor(this.getGapColor());
        cpt.setNanColor(this.getNanColor());
        cpt.setBlender(this.getBlender());
        cpt.setLog10(this.isLog10());
        for (CPTVal val : this) {
            cpt.add((CPTVal)val.clone());
        }
        cpt.setPreferredTickInterval(this.getPreferredTickInterval());
        return cpt;
    }

    public CPT asLog10() {
        Preconditions.checkState((this.getMinValueRaw() > 0.0 ? 1 : 0) != 0, (Object)"can only get log10 representation when min > 0");
        CPT cpt = this.rescale(Math.log10(this.getMinValueRaw()), Math.log10(this.getMaxValueRaw()));
        cpt.setLog10(true);
        return cpt;
    }

    public CPT asPow10() {
        CPT cpt = this.rescale(Math.pow(10.0, this.getMinValueRaw()), Math.pow(10.0, this.getMaxValueRaw()));
        cpt.setLog10(false);
        return cpt;
    }

    public CPT asDiscrete(int num, boolean preserveEdges) {
        CPT cpt = (CPT)this.clone();
        CPT orig = this;
        double min = this.getMinValueRaw();
        double max = this.getMaxValueRaw();
        double delta = (max - min) / (double)num;
        if (preserveEdges) {
            orig = (CPT)this.clone();
            orig = orig.rescale(min + 0.5 * delta, max - 0.5 * delta);
        }
        cpt.clear();
        for (int i = 0; i < num; ++i) {
            double start = min + (double)i * delta;
            double end = min + (double)(i + 1) * delta;
            Color color = preserveEdges && i == 0 ? this.getMinColor() : (preserveEdges && i == num - 1 ? this.getMaxColor() : orig.getColorRaw((float)(0.5 * (end + start))));
            cpt.add(new CPTVal(start, color, end, color));
        }
        return cpt;
    }

    public CPT asDiscrete(double delta, boolean preserveEdges) {
        CPT cpt = (CPT)this.clone();
        CPT orig = this;
        double min = this.getMinValueRaw();
        double max = this.getMaxValueRaw();
        if (preserveEdges) {
            orig = (CPT)this.clone();
            double lastBinStart = 0.0;
            double start = min;
            while ((float)start < (float)max) {
                lastBinStart = start;
                start += delta;
            }
            orig = orig.rescale(min + 0.5 * delta, lastBinStart + 0.5 * delta);
        }
        cpt.clear();
        double start = min;
        while ((float)start < (float)max) {
            double end = start + delta;
            Color color = preserveEdges && start == min ? this.getMinColor() : (preserveEdges && (float)end >= (float)max ? this.getMaxColor() : orig.getColor((float)(0.5 * (end + start))));
            cpt.add(new CPTVal(start, color, end, color));
            start += delta;
        }
        return cpt;
    }

    public CPT rescale(double min, double max) {
        Preconditions.checkState((this.getMaxValueRaw() > this.getMinValueRaw() ? 1 : 0) != 0, (Object)"in order to rescale, current max must be > min");
        Preconditions.checkArgument((max > min ? 1 : 0) != 0, (String)"new max must be > min: %s !> %s", (Object)max, (Object)min);
        CPT cpt = (CPT)this.clone();
        cpt.clear();
        for (CPTVal val : this) {
            double start = this.rescaleValue(val.start, min, max);
            double end = this.rescaleValue(val.end, min, max);
            CPTVal newVal = new CPTVal(start, val.minColor, end, val.maxColor);
            cpt.add(newVal);
        }
        return cpt;
    }

    private double rescaleValue(double oldVal, double newMin, double newMax) {
        double oldDelta = this.getMaxValueRaw() - this.getMinValueRaw();
        double newDelta = newMax - newMin;
        return newMin + (oldVal - this.getMinValueRaw()) / oldDelta * newDelta;
    }

    public CPT trim(double newMin, double newMax) {
        Preconditions.checkState((newMin >= this.getMinValueRaw() ? 1 : 0) != 0, (Object)"new minimum is lower than original minimum");
        Preconditions.checkState((newMax <= this.getMaxValueRaw() ? 1 : 0) != 0, (Object)"new maximum is greater than original maximum");
        Preconditions.checkState((newMax > newMin ? 1 : 0) != 0, (Object)"new max must be greater than new max");
        CPT cpt = (CPT)this.clone();
        cpt.clear();
        for (CPTVal val : this) {
            if ((float)val.end < (float)newMin) continue;
            if ((float)val.start > (float)newMax) break;
            CPTVal newVal = val;
            if ((float)val.start < (float)newMin) {
                Color minColor = this.getColor(newMin);
                newVal = new CPTVal(newMin, minColor, newVal.end, newVal.maxColor);
            }
            if ((float)val.end > (float)newMax) {
                Color maxColor = this.getColor(newMax);
                newVal = new CPTVal(newVal.start, newVal.minColor, newMax, maxColor);
            }
            cpt.add(newVal);
        }
        cpt.setBelowMinColor(cpt.getMinColor());
        cpt.setAboveMaxColor(cpt.getMaxColor());
        return cpt;
    }

    public CPT reverse() {
        CPT cpt = (CPT)this.clone();
        ArrayList colors = Lists.newArrayList();
        for (CPTVal val : cpt) {
            colors.add(val.minColor);
            colors.add(val.maxColor);
        }
        for (int i = 0; i < cpt.size(); ++i) {
            ((CPTVal)cpt.get((int)i)).minColor = (Color)colors.remove(colors.size() - 1);
            ((CPTVal)cpt.get((int)i)).maxColor = (Color)colors.remove(colors.size() - 1);
        }
        cpt.setBelowMinColor(this.getAboveMaxColor());
        cpt.setAboveMaxColor(this.getBelowMinColor());
        return cpt;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.aboveMaxColor == null ? 0 : this.aboveMaxColor.hashCode());
        result = 31 * result + (this.belowMinColor == null ? 0 : this.belowMinColor.hashCode());
        result = 31 * result + (this.blender == null ? 0 : this.blender.hashCode());
        result = 31 * result + (this.gapColor == null ? 0 : this.gapColor.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.nanColor == null ? 0 : this.nanColor.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CPT other = (CPT)obj;
        if (this.aboveMaxColor == null ? other.aboveMaxColor != null : !this.aboveMaxColor.equals(other.aboveMaxColor)) {
            return false;
        }
        if (this.belowMinColor == null ? other.belowMinColor != null : !this.belowMinColor.equals(other.belowMinColor)) {
            return false;
        }
        if (this.blender == null ? other.blender != null : !this.blender.equals(other.blender)) {
            return false;
        }
        if (this.gapColor == null ? other.gapColor != null : !this.gapColor.equals(other.gapColor)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.nanColor == null ? other.nanColor != null : !this.nanColor.equals(other.nanColor));
    }

    public double getPreferredTickInterval() {
        return this.preferredTickInterval;
    }

    public void setPreferredTickInterval(double preferredTickInterval) {
        this.preferredTickInterval = preferredTickInterval;
    }
}

