/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.util.http;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.Authenticator;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import org.opensha.commons.util.http.HTTPAuthenticator;
import org.opensha.commons.util.http.InstallSSLCert;

public class HTTPAuthTest {
    public static String intensityMD5 = "2a 74 46 db b4 47 64 db f2 26 9c 95 67 2a cb 57";

    public HTTPAuthTest() throws IOException {
        InstallSSLCert installCert = new InstallSSLCert(intensityMD5, "intensity.usc.edu");
        File keystore = installCert.getKeyStore();
        if (keystore != null) {
            System.out.println("Loading keystore from: " + keystore.getAbsolutePath());
            System.setProperty("javax.net.ssl.trustStore", keystore.getAbsolutePath());
            Authenticator.setDefault(new HTTPAuthenticator());
            URL url = new URL("https://intensity.usc.edu/trac/opensha/wiki/");
            while (true) {
                try {
                    InputStream ins = url.openConnection().getInputStream();
                    BufferedReader reader = new BufferedReader(new InputStreamReader(ins));
                    System.out.println("Authentication successful!");
                }
                catch (ProtocolException e) {
                    System.out.println("Your password is incorrect!");
                    continue;
                }
                break;
            }
            keystore.delete();
        }
    }

    public static void main(String[] args) {
        try {
            new HTTPAuthTest();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.exit(0);
    }
}

