/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.util.modules;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import java.net.InetAddress;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import mpi.MPI;
import org.apache.commons.lang3.ClassUtils;
import org.opensha.commons.data.Named;
import org.opensha.commons.util.modules.ModuleHelper;
import org.opensha.commons.util.modules.OpenSHA_Module;
import org.opensha.commons.util.modules.SubModule;

public class ModuleContainer<E extends OpenSHA_Module> {
    protected List<E> modules;
    private Map<Class<? extends E>, E> mappings;
    private List<Callable<E>> availableModules;
    private Map<Class<? extends E>, Callable<E>> availableMappings;
    public static boolean VERBOSE_DEFAULT = true;
    protected boolean verbose = VERBOSE_DEFAULT;
    private static DecimalFormat secsDF = new DecimalFormat("0.##");
    private String debugPrefix;
    private static String debug_common_prefix = null;

    public ModuleContainer() {
        this.modules = new ArrayList();
        this.mappings = new ConcurrentHashMap<Class<? extends E>, E>();
        this.availableModules = new ArrayList<Callable<E>>();
        this.availableMappings = new ConcurrentHashMap<Class<? extends E>, Callable<E>>();
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean hasModule(Class<? extends E> clazz) {
        return this.getModule(clazz) != null;
    }

    public boolean hasAllModules(Collection<Class<? extends E>> classes) {
        boolean hasAll = true;
        for (Class<E> clazz : classes) {
            if (this.hasModule(clazz)) continue;
            hasAll = false;
            break;
        }
        return hasAll;
    }

    public <M extends E> M requireModule(Class<M> clazz) throws IllegalStateException {
        M module = this.getModule(clazz);
        if (module == null) {
            throw new IllegalStateException("Missing required module: " + clazz.getName());
        }
        return module;
    }

    public <M extends E> M getModule(Class<M> clazz) {
        return this.getModule(clazz, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <M extends E> M getModule(Class<M> clazz, boolean loadAvailable) {
        OpenSHA_Module module = (OpenSHA_Module)this.mappings.get(clazz);
        if (module == null && loadAvailable) {
            Callable<E> call = this.availableMappings.get(clazz);
            module = (OpenSHA_Module)this.mappings.get(clazz);
            if (module != null) {
                return (M)module;
            }
            if (call != null) {
                ModuleContainer moduleContainer = this;
                synchronized (moduleContainer) {
                    module = (OpenSHA_Module)this.mappings.get(clazz);
                    if (module != null) {
                        return (M)module;
                    }
                    module = this.getLoadAvailableModule(call);
                }
            }
        }
        return (M)module;
    }

    public <M extends E> Optional<M> getOptionalModule(Class<M> clazz) {
        M module = this.getModule(clazz, true);
        if (module == null) {
            return Optional.empty();
        }
        return Optional.of(module);
    }

    public <M extends E> Optional<M> getOptionalModule(Class<M> clazz, boolean loadAvailable) {
        M module = this.getModule(clazz, loadAvailable);
        if (module == null) {
            return Optional.empty();
        }
        return Optional.of(module);
    }

    public boolean hasModuleSuperclass(Class<? extends E> clazz) {
        for (Class<OpenSHA_Module> assignable : ModuleContainer.getAssignableClasses(clazz)) {
            try {
                Class<OpenSHA_Module> assignableCast = assignable;
                if (!this.hasModule(assignableCast)) continue;
                return true;
            }
            catch (ClassCastException e) {
            }
        }
        return false;
    }

    public synchronized void addModule(E module) {
        Preconditions.checkState((module != this ? 1 : 0) != 0, (Object)"Cannot add a module to itself!");
        SubModule<ModuleContainer<ModuleContainer>> subModule = null;
        if (module instanceof SubModule && (module = this.checkCopySubModule(subModule = this.getAsSubModule(module))) != subModule) {
            subModule = this.getAsSubModule(module);
        }
        List<Class<OpenSHA_Module>> assignableClasses = ModuleContainer.getAssignableClasses(module.getClass());
        for (Class<OpenSHA_Module> clazz : assignableClasses) {
            this.removeModuleInstances(clazz);
        }
        this.modules.add(module);
        for (Class<OpenSHA_Module> clazz : assignableClasses) {
            this.mapModule(module, clazz);
        }
        if (subModule != null && subModule.getParent() == null) {
            subModule.setParent(this);
        }
        this.removeAvailableModuleInstances(module.getClass());
    }

    protected SubModule<ModuleContainer<E>> getAsSubModule(E module) {
        try {
            return (SubModule)module;
        }
        catch (Exception e) {
            throw new IllegalStateException("Can't add a sub-module that is not applicable to this container", e);
        }
    }

    private E checkCopySubModule(SubModule<ModuleContainer<E>> subModule) {
        ModuleContainer<E> parent = subModule.getParent();
        if (parent != null && !parent.equals(this)) {
            this.debug("Getting copy of sub-module '" + subModule.getName() + "' with updated parent");
            subModule = subModule.copy(this);
        }
        return (E)subModule;
    }

    private static List<Class<? extends OpenSHA_Module>> getAssignableClasses(Class<? extends OpenSHA_Module> moduleClass) {
        ArrayList<Class<? extends OpenSHA_Module>> assignableClasses = new ArrayList<Class<? extends OpenSHA_Module>>();
        assignableClasses.add(moduleClass);
        for (Class clazz : ClassUtils.getAllSuperclasses(moduleClass)) {
            if (!ModuleContainer.isValidModuleSubclass(clazz)) continue;
            assignableClasses.add(clazz);
        }
        for (Class clazz : ClassUtils.getAllInterfaces(moduleClass)) {
            if (!ModuleContainer.isValidModuleSubclass(clazz)) continue;
            assignableClasses.add(clazz);
        }
        return assignableClasses;
    }

    private static boolean isValidModuleSubclass(Class<?> clazz) {
        if (!OpenSHA_Module.class.isAssignableFrom(clazz)) {
            return false;
        }
        return clazz.getAnnotation(ModuleHelper.class) == null;
    }

    private void mapModule(E module, Class<? extends OpenSHA_Module> clazz) {
        boolean override;
        Preconditions.checkState((clazz.getAnnotation(ModuleHelper.class) == null ? 1 : 0) != 0, (String)"Cannot map a class that implements @ModuleHelper: %s", (Object)clazz.getName());
        Preconditions.checkState((boolean)OpenSHA_Module.class.isAssignableFrom(clazz), (String)"%s is not an OpenSHA_Module", clazz);
        boolean bl = override = this.mappings.put(clazz, module) != null;
        if (override) {
            this.debug("Overrode module type '" + clazz.getName() + "' with: " + module.getName());
        } else {
            this.debug("Mapped module type '" + clazz.getName() + "' to: " + module.getName());
        }
    }

    public synchronized boolean removeModule(E module) {
        boolean ret = this.modules.remove(module);
        if (ret) {
            Preconditions.checkState((boolean)this.removeMappings(module));
        }
        return ret;
    }

    public synchronized boolean removeModuleInstances(Class<? extends OpenSHA_Module> clazz) {
        boolean ret = false;
        int m = this.modules.size();
        while (--m >= 0) {
            OpenSHA_Module module = (OpenSHA_Module)this.modules.get(m);
            if (!clazz.isAssignableFrom(module.getClass())) continue;
            this.debug("Removing module '" + module.getName() + "' with type '" + module.getClass().getName() + "' as it is assignable from '" + clazz.getName() + "'");
            this.modules.remove(m);
            Preconditions.checkState((boolean)this.removeMappings(module));
            ret = true;
        }
        if (this.removeAvailableModuleInstances(clazz)) {
            ret = true;
        }
        return ret;
    }

    private boolean removeMappings(E module) {
        ArrayList<Class<? extends E>> oldMappings = new ArrayList<Class<? extends E>>();
        for (Class<? extends E> clazz : this.mappings.keySet()) {
            if (!((OpenSHA_Module)this.mappings.get(clazz)).equals(module)) continue;
            oldMappings.add(clazz);
        }
        boolean ret = false;
        for (Class clazz : oldMappings) {
            ret |= this.mappings.remove(clazz) != null;
        }
        return ret;
    }

    public synchronized void clearModules() {
        this.modules.clear();
        this.mappings.clear();
        this.availableMappings.clear();
        this.availableModules.clear();
    }

    public synchronized <M extends E> void addAvailableModule(Callable<? extends OpenSHA_Module> call, Class<M> moduleClass) {
        this.addAvailableModule(call, moduleClass, true);
    }

    public synchronized <M extends E> void addAvailableModule(Callable<? extends OpenSHA_Module> call, Class<M> moduleClass, boolean removeMatchingLoaded) {
        List<Class<OpenSHA_Module>> assignableClasses = ModuleContainer.getAssignableClasses(moduleClass);
        if (removeMatchingLoaded) {
            for (Class<OpenSHA_Module> clazz : assignableClasses) {
                this.removeModuleInstances(clazz);
            }
        }
        for (Class<OpenSHA_Module> clazz : assignableClasses) {
            this.removeAvailableModuleInstances(clazz);
        }
        this.availableModules.add(call);
        for (Class<OpenSHA_Module> clazz : assignableClasses) {
            this.mapAvailableModule(call, clazz);
        }
    }

    public synchronized <M extends E> void offerAvailableModule(Callable<M> call, Class<M> moduleClass) {
        if (!this.hasAvailableModule(moduleClass)) {
            this.addAvailableModule(call, moduleClass);
        }
    }

    public synchronized boolean hasAvailableModule(Class<? extends E> clazz) {
        OpenSHA_Module module = (OpenSHA_Module)this.mappings.get(clazz);
        if (module != null) {
            return true;
        }
        Callable<E> call = this.availableMappings.get(clazz);
        return call != null;
    }

    public synchronized void loadAllAvailableModules() {
        ArrayList<Callable<E>> available = new ArrayList<Callable<E>>(this.availableModules);
        for (Callable callable : available) {
            if (!this.availableModules.contains(callable)) continue;
            this.loadAvailableModule(callable);
        }
    }

    public boolean loadAvailableModule(Callable<? extends E> call) {
        E module = this.getLoadAvailableModule(call);
        return module != null;
    }

    private synchronized E getLoadAvailableModule(Callable<? extends E> call) {
        Preconditions.checkState((boolean)this.availableModules.remove(call));
        OpenSHA_Module module = null;
        Stopwatch watch = Stopwatch.createStarted();
        try {
            this.debug("Lazily loading available module from " + String.valueOf(call.getClass()) + "...");
            module = (OpenSHA_Module)call.call();
            double secs = (double)watch.elapsed(TimeUnit.MILLISECONDS) / 1000.0;
            this.debug("Took " + secsDF.format(secs) + " s to load " + (module == null ? "null" : module.getName()));
        }
        catch (Throwable e) {
            e.printStackTrace();
            this.debug("WARNING: failed to lazily load a module (see exception above): " + e.getMessage(), true);
        }
        watch.stop();
        if (module != null) {
            this.addModule(module);
        } else {
            this.removeAvailableMappings(call);
        }
        return (E)module;
    }

    private void mapAvailableModule(Callable<? extends OpenSHA_Module> call, Class<? extends OpenSHA_Module> clazz) {
        boolean override;
        Preconditions.checkState((clazz.getAnnotation(ModuleHelper.class) == null ? 1 : 0) != 0, (String)"Cannot map a class that implements @ModuleHelper: %s", (Object)clazz.getName());
        Preconditions.checkState((boolean)OpenSHA_Module.class.isAssignableFrom(clazz), (String)"%s is not an OpenSHA_Module", clazz);
        boolean bl = override = this.availableMappings.put(clazz, call) != null;
        if (override) {
            this.debug("Overrode available module with type: " + clazz.getName());
        } else {
            this.debug("Mapped available module with type: " + clazz.getName());
        }
    }

    public synchronized boolean removeAvailableModuleInstances(Class<? extends OpenSHA_Module> clazz) {
        boolean ret = false;
        HashSet<Callable<E>> removeCalls = new HashSet<Callable<E>>();
        for (Class<E> clazz2 : this.availableMappings.keySet()) {
            if (!clazz.isAssignableFrom(clazz2)) continue;
            this.debug("Removing available module with type '" + clazz2.getName() + "' as it is assignable from '" + clazz.getName() + "'");
            removeCalls.add(this.availableMappings.get(clazz2));
        }
        for (Callable callable : removeCalls) {
            this.availableModules.remove(callable);
            Preconditions.checkState((boolean)this.removeAvailableMappings(callable), (Object)"No mappings existed to callable");
            ret = true;
        }
        return ret;
    }

    private boolean removeAvailableMappings(Callable<? extends E> call) {
        ArrayList<Class<? extends E>> oldMappings = new ArrayList<Class<? extends E>>();
        for (Class<? extends E> clazz : this.availableMappings.keySet()) {
            if (!this.availableMappings.get(clazz).equals(call)) continue;
            oldMappings.add(clazz);
        }
        boolean ret = false;
        for (Class clazz : oldMappings) {
            boolean removed = this.availableMappings.remove(clazz) != null;
            ret |= removed;
        }
        return ret;
    }

    public List<E> getModules() {
        return this.getModules(true);
    }

    public synchronized List<E> getModules(boolean loadAvailable) {
        if (loadAvailable) {
            this.loadAllAvailableModules();
        }
        return Collections.unmodifiableList(this.modules);
    }

    public synchronized List<Callable<E>> getAvailableModules() {
        return Collections.unmodifiableList(this.availableModules);
    }

    public synchronized List<E> getModulesAssignableTo(Class<?> type, boolean loadAvailable) {
        return this.getModulesAssignableTo(type, loadAvailable, null);
    }

    private boolean isSkip(Class<?> type, Collection<Class<? extends OpenSHA_Module>> skipTypes) {
        if (skipTypes == null) {
            return false;
        }
        for (Class<? extends OpenSHA_Module> skipType : skipTypes) {
            if (!skipType.isAssignableFrom(type)) continue;
            return true;
        }
        return false;
    }

    public synchronized List<E> getModulesAssignableTo(Class<?> type, boolean loadAvailable, Collection<Class<? extends OpenSHA_Module>> skipTypes) {
        if (loadAvailable) {
            HashMap<Callable<E>, Class<Object>> matchingCalls = new HashMap<Callable<E>, Class<Object>>();
            for (Class<Object> clazz : this.availableMappings.keySet()) {
                Callable<E> call = this.availableMappings.get(clazz);
                if (matchingCalls.containsKey(call) || !type.isAssignableFrom(clazz) || this.isSkip(clazz, skipTypes)) continue;
                matchingCalls.put(call, clazz);
            }
            for (Callable callable : matchingCalls.keySet()) {
                if (!this.availableModules.contains(callable) || !this.loadAvailableModule(callable)) continue;
                Object module = this.getModule((Class)matchingCalls.get(callable));
                Preconditions.checkNotNull(module);
            }
        }
        ArrayList<OpenSHA_Module> ret = new ArrayList<OpenSHA_Module>();
        for (OpenSHA_Module openSHA_Module : this.getModules(false)) {
            if (!type.isAssignableFrom(openSHA_Module.getClass()) || this.isSkip(type, skipTypes)) continue;
            ret.add(openSHA_Module);
        }
        return ret;
    }

    protected String getNestingPrefix() {
        return null;
    }

    private void debug(String message) {
        this.debug(message, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void debug(String message, boolean err) {
        if (!err && !this.verbose) {
            return;
        }
        if (debug_common_prefix == null) {
            Class<ModuleContainer> clazz = ModuleContainer.class;
            // MONITORENTER : org.opensha.commons.util.modules.ModuleContainer.class
            if (debug_common_prefix == null) {
                try {
                    int rank = MPI.COMM_WORLD.Rank();
                    String hostname = InetAddress.getLocalHost().getHostName();
                    debug_common_prefix = hostname != null && !hostname.isBlank() ? hostname + ", " + rank : "" + rank;
                }
                catch (Throwable t) {
                    debug_common_prefix = "";
                }
            }
            // MONITOREXIT : clazz
        }
        if (this.debugPrefix == null) {
            String name;
            Object debugPrefix = debug_common_prefix;
            if (this instanceof Named && (name = ((Named)((Object)this)).getName()) != null && !name.isBlank()) {
                debugPrefix = name;
                if (!debug_common_prefix.isBlank()) {
                    debugPrefix = (String)debugPrefix + " (" + debug_common_prefix + ")";
                }
            }
            if (!((String)debugPrefix).isBlank()) {
                debugPrefix = (String)debugPrefix + ":\t";
            }
            this.debugPrefix = debugPrefix;
        }
        if (this instanceof Named) {
            message = this.debugPrefix + (String)message;
        }
        if (err) {
            System.err.println((String)message);
            return;
        }
        System.out.println((String)message);
    }
}

