/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.commons.util.modules.helpers;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.opensha.commons.data.CSVFile;
import org.opensha.commons.util.io.archive.ArchiveInput;
import org.opensha.commons.util.io.archive.ArchiveOutput;
import org.opensha.commons.util.modules.ModuleHelper;
import org.opensha.commons.util.modules.helpers.FileBackedModule;

@ModuleHelper
public interface CSV_BackedModule
extends FileBackedModule {
    public CSVFile<?> getCSV();

    public void initFromCSV(CSVFile<String> var1);

    @Override
    default public void writeToStream(OutputStream out) throws IOException {
        this.getCSV().writeToStream(out);
    }

    @Override
    default public void initFromStream(BufferedInputStream in) throws IOException {
        CSVFile<String> csv = CSVFile.readStream(in, false);
        this.initFromCSV(csv);
    }

    public static void writeToArchive(CSVFile<?> csv, ArchiveOutput output, String entryPrefix, String fileName) throws IOException {
        FileBackedModule.initEntry(output, entryPrefix, fileName);
        BufferedOutputStream out = new BufferedOutputStream(output.getOutputStream());
        csv.writeToStream(out);
        out.flush();
        output.closeEntry();
    }

    public static CSVFile<String> loadFromArchive(ArchiveInput input, String entryPrefix, String fileName) throws IOException {
        BufferedInputStream zin = FileBackedModule.getInputStream(input, entryPrefix, fileName);
        CSVFile<String> csv = CSVFile.readStream(zin, false);
        zin.close();
        return csv;
    }
}

