/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.nshmp2.erf.source;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.opensha.commons.data.Site;
import org.opensha.commons.geo.LocationList;
import org.opensha.nshmp2.erf.source.FaultSource;
import org.opensha.nshmp2.erf.source.SourceFile;
import org.opensha.sha.earthquake.ProbEqkRupture;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.faultSurface.EvenlyGriddedSurface;
import org.opensha.sha.magdist.IncrementalMagFreqDist;

public class ClusterSource
extends ProbEqkSource {
    List<FaultSource> sources = Lists.newArrayList();
    SourceFile file;
    String name;
    double weight;
    double rate;

    ClusterSource() {
    }

    public void init() {
        for (FaultSource fs : this.sources) {
            fs.init();
        }
    }

    public double getRate() {
        return this.rate;
    }

    public double getWeight() {
        return this.weight;
    }

    public List<FaultSource> getFaultSources() {
        return this.sources;
    }

    @Override
    public LocationList getAllSourceLocs() {
        throw new UnsupportedOperationException();
    }

    @Override
    public EvenlyGriddedSurface getSourceSurface() {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getMinDistance(Site site) {
        double d = Double.MAX_VALUE;
        for (FaultSource fs : this.sources) {
            d = Math.min(d, fs.getMinDistance(site));
        }
        return d;
    }

    @Override
    public int getNumRuptures() {
        int count = 0;
        for (FaultSource fs : this.sources) {
            count += fs.getNumRuptures();
        }
        return count;
    }

    @Override
    public ProbEqkRupture getRupture(int idx) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<ProbEqkRupture> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("=========  Cluster Source  =========");
        sb.append(IOUtils.LINE_SEPARATOR);
        sb.append(" Cluster name: ").append(this.name);
        sb.append(IOUtils.LINE_SEPARATOR);
        sb.append("  Ret. period: ").append(this.rate).append(" yrs");
        sb.append(IOUtils.LINE_SEPARATOR);
        sb.append("       Weight: ").append(this.weight);
        sb.append(IOUtils.LINE_SEPARATOR);
        for (FaultSource fs : this.sources) {
            sb.append(IOUtils.LINE_SEPARATOR);
            sb.append("        Fault: ").append(fs.getName());
            sb.append(IOUtils.LINE_SEPARATOR);
            ArrayList mags = Lists.newArrayList();
            ArrayList wts = Lists.newArrayList();
            for (IncrementalMagFreqDist mfd : fs.mfds) {
                mags.add(mfd.getX(0));
                wts.add(mfd.getY(0) * this.rate);
            }
            sb.append("         Mags: ").append(mags);
            sb.append(IOUtils.LINE_SEPARATOR);
            sb.append("          Wts: ").append(wts);
            sb.append(IOUtils.LINE_SEPARATOR);
            sb.append("         type: ").append((Object)fs.type);
            sb.append(IOUtils.LINE_SEPARATOR);
            sb.append("         mech: ").append((Object)fs.mech);
            sb.append(IOUtils.LINE_SEPARATOR);
            sb.append("       floats: ").append(fs.floats);
            sb.append(IOUtils.LINE_SEPARATOR);
            sb.append("          dip: ").append(fs.dip);
            sb.append(IOUtils.LINE_SEPARATOR);
            sb.append("        width: ").append(fs.width);
            sb.append(IOUtils.LINE_SEPARATOR);
            sb.append("          top: ").append(fs.top);
            sb.append(IOUtils.LINE_SEPARATOR);
        }
        return sb.toString();
    }
}

