/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.nshmp2.erf.source;

import com.google.common.collect.Lists;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.gui.plot.GraphWindow;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.commons.util.Interpolate;
import org.opensha.nshmp2.erf.source.FaultERF;
import org.opensha.nshmp2.erf.source.FaultParser;
import org.opensha.nshmp2.erf.source.FaultSource;
import org.opensha.nshmp2.erf.source.SourceFile;
import org.opensha.nshmp2.erf.source.SourceMgr;
import org.opensha.nshmp2.util.FaultType;
import org.opensha.nshmp2.util.NSHMP_Utils;
import org.opensha.nshmp2.util.SourceRegion;
import org.opensha.nshmp2.util.SourceType;
import org.opensha.nshmp2.util.Utils;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import org.opensha.sha.magdist.SummedMagFreqDist;

public class MFD_Plotter {
    private static final double M_MIN = 6.2;
    private static final double M_MAX = 8.2;
    private static final double M_DELTA = 0.05;
    private static final int M_NUM = 41;
    private static ArrayList<PlotCurveCharacterstics> plotChars;
    private static ArrayList<PlotCurveCharacterstics> plotCharsB;
    private static List<String> titles;
    private static List<Double> grWts;
    private static List<Double> chWts;
    private static String title;

    private static PlotCurveCharacterstics getLineChar(Color c) {
        return new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, c);
    }

    public static void main(String[] args) {
        ArrayList fltSrcs = Lists.newArrayList();
        fltSrcs.addAll(SourceMgr.get(SourceRegion.WUS, SourceType.FAULT, "nv.3dip.gr.in"));
        fltSrcs.addAll(SourceMgr.get(SourceRegion.WUS, SourceType.FAULT, "nv.3dip.ch.in"));
        String name = "1285_1654 Carson Range-Kings Canyon faults";
        double yMin = 1.0E-6;
        double yMax = 0.001;
        ArrayList sums = Lists.newArrayList();
        for (int i = 0; i < titles.size(); ++i) {
            if (i != 0) continue;
            List<IncrementalMagFreqDist> mfds = MFD_Plotter.getMFDs(fltSrcs, name, chWts.get(i), grWts.get(i));
            IncrementalMagFreqDist sum = MFD_Plotter.sum(mfds);
            sums.add(sum);
            mfds.add(sum);
            MFD_Plotter.plot(mfds, plotChars, titles.get(i), yMin, yMax);
        }
        MFD_Plotter.plot(sums, plotCharsB, title, yMin, yMax);
    }

    private static List<IncrementalMagFreqDist> getMFDs(List<SourceFile> srcFiles, String name, double chWt, double grWt) {
        Logger log = NSHMP_Utils.logger();
        Level level = Level.SEVERE;
        log.setLevel(level);
        for (Handler h : NSHMP_Utils.logger().getHandlers()) {
            h.setLevel(level);
        }
        ArrayList mfds = Lists.newArrayList();
        for (SourceFile sf : srcFiles) {
            FaultParser parser = new FaultParser(log);
            FaultERF erf = parser.parse(sf);
            ArrayList srcs = Lists.newArrayList();
            for (FaultSource src : erf.getSources()) {
                if (!src.getName().equals(name)) continue;
                srcs.add(src);
                System.out.println(src);
                System.out.println(src.trace);
            }
            mfds.addAll(MFD_Plotter.merge3dipMFDs(srcs, chWt, grWt));
        }
        return mfds;
    }

    private static List<IncrementalMagFreqDist> merge3dipMFDs(List<FaultSource> srcs, double chWt, double grWt) {
        ArrayList mfds = Lists.newArrayList();
        boolean first = true;
        int idx = 0;
        for (FaultSource src : srcs) {
            double scale = src.type.equals((Object)FaultType.CH) ? chWt : grWt;
            for (int i = 0; i < src.mfds.size(); ++i) {
                IncrementalMagFreqDist mfd = MFD_Plotter.toIncr(src.mfds.get(i));
                mfd.scale(scale);
                if (first) {
                    String info = MFD_Plotter.buildInfo(src, idx++);
                    mfd.setInfo(info);
                    mfds.add(mfd);
                    continue;
                }
                Utils.addFunc((DiscretizedFunc)mfds.get(i), mfd);
            }
            first = false;
        }
        return mfds;
    }

    private static String buildInfo(FaultSource src, int idx) {
        StringBuffer sb = new StringBuffer(src.name);
        FaultType type = src.type;
        sb.append(" ").append(src.type.name());
        Object unc = "epi";
        if (idx == 0) {
            unc = (String)unc + "-";
        }
        if (idx == 1) {
            unc = "";
        }
        if (idx == 2) {
            unc = (String)unc + "+";
        }
        sb.append(" ").append((String)unc);
        return sb.toString();
    }

    private static void plot(List<? extends DiscretizedFunc> mfds, ArrayList<PlotCurveCharacterstics> plotChars, String title, double yMin, double yMax) {
        ArrayList funcs = Lists.newArrayList();
        funcs.addAll(mfds);
        GraphWindow graph = new GraphWindow(funcs, title, plotChars);
        graph.setX_AxisLabel("Magnitude");
        graph.setY_AxisLabel("Incremental Rate");
        graph.setYLog(true);
        graph.setX_AxisRange(6.2, 8.2);
        graph.setY_AxisRange(yMin, yMax);
    }

    private static IncrementalMagFreqDist sum(List<IncrementalMagFreqDist> mfds) {
        SummedMagFreqDist sum = new SummedMagFreqDist(6.2, 41, 0.05);
        for (IncrementalMagFreqDist src : mfds) {
            IncrementalMagFreqDist dest = MFD_Plotter.createTarget();
            MFD_Plotter.resample(src, dest);
            sum.addIncrementalMagFreqDist(dest);
        }
        return sum;
    }

    private static IncrementalMagFreqDist createTarget() {
        return new IncrementalMagFreqDist(6.2, 41, 0.05);
    }

    private static void resample(IncrementalMagFreqDist src, IncrementalMagFreqDist dest) {
        double[] xSrc = new double[src.size()];
        double[] ySrc = new double[src.size()];
        int idx = 0;
        for (Point2D p : src) {
            xSrc[idx] = p.getX();
            ySrc[idx++] = p.getY();
        }
        double min = src.getMinX();
        double max = src.getMaxX();
        idx = 0;
        for (Point2D p : dest) {
            double x = p.getX();
            if (x < min || x > max) continue;
            double y = Interpolate.findLogLogY(xSrc, ySrc, x);
            dest.set(x, y);
        }
    }

    private static IncrementalMagFreqDist toIncr(IncrementalMagFreqDist in) {
        double delta = in.getDelta();
        double min = in.getMinX() - delta;
        double max = in.getMaxX() + delta;
        int num = in.size() + 2;
        IncrementalMagFreqDist out = new IncrementalMagFreqDist(min, max, num);
        out.set(0, 1.0E-30);
        out.set(num - 1, 1.0E-30);
        for (Point2D p : in) {
            out.set(p);
        }
        return out;
    }

    private static Point2D interpolate(Point2D p1, Point2D p2) {
        double x = (p1.getX() + p2.getX()) / 2.0;
        double y = (p1.getY() + p2.getY()) / 2.0;
        return new Point2D.Double(x, y);
    }

    static {
        title = "Carson Range-Kings Canyon";
        plotChars = Lists.newArrayList((Object[])new PlotCurveCharacterstics[]{MFD_Plotter.getLineChar(new Color(0, 174, 239)), MFD_Plotter.getLineChar(new Color(0, 84, 166)), MFD_Plotter.getLineChar(new Color(0, 174, 239)), MFD_Plotter.getLineChar(new Color(247, 148, 29)), MFD_Plotter.getLineChar(new Color(242, 101, 34)), MFD_Plotter.getLineChar(new Color(247, 148, 29)), MFD_Plotter.getLineChar(new Color(230, 20, 100))});
        plotCharsB = Lists.newArrayList((Object[])new PlotCurveCharacterstics[]{MFD_Plotter.getLineChar(new Color(0, 84, 166)), MFD_Plotter.getLineChar(new Color(230, 20, 100)), MFD_Plotter.getLineChar(new Color(242, 101, 34))});
        titles = Lists.newArrayList((Object[])new String[]{title + " GR 33% CH 67%", title + " GR 50% CH 50%", title + " GR 67% CH 33%"});
        grWts = Lists.newArrayList((Object[])new Double[]{0.333, 0.5, 0.667});
        chWts = Lists.newArrayList((Object[])new Double[]{0.667, 0.5, 0.333});
    }
}

