/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.nshmp2.erf.source;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.opensha.commons.data.Site;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.nshmp2.util.NSHMP_Utils;
import org.opensha.sha.earthquake.ProbEqkRupture;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.faultSurface.PointSurface;
import org.opensha.sha.faultSurface.RuptureSurface;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import org.opensha.sha.util.FocalMech;

class NSHMPPointSource
extends ProbEqkSource {
    private static final String NAME = "NSHMP Point Source";
    private static final double M_DEPTH_CUT = 6.5;
    public static final double M_FINITE_CUT = 6.0;
    private Location loc;
    private IncrementalMagFreqDist mfd;
    private double duration;
    private double lgMagDepth;
    private double smMagDepth;
    private Map<FocalMech, Double> mechWts;
    private int mechCount;
    private int ssIdx;
    private int revIdx;
    private PointSurface surface;
    protected ProbEqkRupture probEqkRupture;

    public NSHMPPointSource(Location loc, IncrementalMagFreqDist mfd, double duration, double[] depths, Map<FocalMech, Double> mechWtMap) {
        this.name = NAME;
        this.loc = loc;
        this.mfd = mfd;
        this.duration = duration;
        this.smMagDepth = depths[0];
        this.lgMagDepth = depths[1];
        this.mechWts = mechWtMap;
        this.mechCount = NSHMPPointSource.countMechs(mechWtMap);
        this.setMechIndices();
        this.probEqkRupture = new ProbEqkRupture();
        this.surface = new PointSurface(loc);
    }

    @Override
    public ProbEqkRupture getRupture(int idx) {
        FocalMech mech = this.mechForIndex(idx);
        double wt = this.mechWts.get((Object)mech);
        int magIdx = idx % this.mfd.size();
        double mag = this.mfd.getX(magIdx);
        double depth = this.depthForMag(mag);
        this.updateRupture(mag, mech.dip(), mech.rake(), depth);
        double rate = wt * this.mfd.getY(magIdx);
        this.probEqkRupture.setProbability(NSHMP_Utils.rateToProb(rate, this.duration));
        return this.probEqkRupture;
    }

    @Override
    public List<ProbEqkRupture> getRuptureList() {
        throw new UnsupportedOperationException("A PointSource does not allow access to the list of all possible ruptures.");
    }

    @Override
    public Iterator<ProbEqkRupture> iterator() {
        return new Iterator<ProbEqkRupture>(){
            int size;
            int caret;
            {
                this.size = NSHMPPointSource.this.getNumRuptures();
                this.caret = 0;
            }

            @Override
            public boolean hasNext() {
                return this.caret < this.size;
            }

            @Override
            public ProbEqkRupture next() {
                return NSHMPPointSource.this.getRupture(this.caret++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    protected void updateRupture(double mag, double dip, double rake, double depth) {
        this.probEqkRupture.setMag(mag);
        this.probEqkRupture.setAveRake(rake);
        this.surface.setAveDip(dip);
        if (this.surface.getDepth() != depth) {
            this.surface.setDepth(depth);
        }
        this.probEqkRupture.setPointSurface(this.surface);
    }

    @Override
    public LocationList getAllSourceLocs() {
        LocationList locList = new LocationList();
        locList.add(this.surface.getLocation());
        return locList;
    }

    @Override
    public RuptureSurface getSourceSurface() {
        return this.surface;
    }

    @Override
    public int getNumRuptures() {
        return this.mfd.size() * this.mechCount;
    }

    @Override
    public double getMinDistance(Site site) {
        return LocationUtils.horzDistanceFast(site.getLocation(), this.loc);
    }

    public Location getLocation() {
        return this.loc;
    }

    private FocalMech mechForIndex(int idx) {
        return idx < this.ssIdx ? FocalMech.STRIKE_SLIP : (idx < this.revIdx ? FocalMech.REVERSE : FocalMech.NORMAL);
    }

    private double depthForMag(double mag) {
        return mag >= 6.5 ? this.lgMagDepth : this.smMagDepth;
    }

    private static int countMechs(Map<FocalMech, Double> map) {
        int count = 0;
        for (Double d : map.values()) {
            if (!(d > 0.0)) continue;
            ++count;
        }
        return count;
    }

    private void setMechIndices() {
        int ssCount = (int)Math.ceil(this.mechWts.get((Object)FocalMech.STRIKE_SLIP)) * this.mfd.size();
        int revCount = (int)Math.ceil(this.mechWts.get((Object)FocalMech.REVERSE)) * this.mfd.size();
        this.ssIdx = ssCount > 0 ? ssCount : -1;
        this.revIdx = revCount > 0 ? ssCount + revCount : -1;
    }
}

