/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.nshmp2.imr;

import com.google.common.collect.Maps;
import java.util.Map;
import org.opensha.commons.data.Site;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.exceptions.ParameterException;
import org.opensha.nshmp2.imr.GridIMR;
import org.opensha.nshmp2.imr.NSHMP08_SUB_Slab;
import org.opensha.nshmp2.util.CurveTable;
import org.opensha.nshmp2.util.Period;
import org.opensha.sha.earthquake.EqkRupture;
import org.opensha.sha.imr.param.PropagationEffectParams.DistanceJBParameter;

public class NSHMP08_SUB_SlabGrid
extends NSHMP08_SUB_Slab
implements GridIMR {
    public static final String NAME = "NSHMP 2008 Subduction Slab Combined (Grid)";
    public static final String SHORT_NAME = "NSHMP08_SLAB_GRID";
    private static final long serialVersionUID = 1L;
    private static Map<Period, CurveTable> tables = Maps.newEnumMap(Period.class);
    private CurveTable table;
    private static final double R = 200.0;
    private static final double dR = 1.0;
    private static final double minM = 5.0;
    private static final double maxM = 7.3;
    private static final double dM = 0.1;

    @Override
    public String getShortName() {
        return SHORT_NAME;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void setSite(Site site) {
        this.site = site;
    }

    @Override
    public void setEqkRupture(EqkRupture eqkRupture) {
        this.eqkRupture = eqkRupture;
    }

    @Override
    public void setParamDefaults() {
        this.distanceJBParam.setValueAsDefault();
        super.setParamDefaults();
    }

    @Override
    protected void initPropagationEffectParams() {
        this.distanceJBParam = new DistanceJBParameter(0.0);
        this.distanceJBParam.setNonEditable();
        this.propagationEffectParams.addParameter(this.distanceJBParam);
        super.initPropagationEffectParams();
    }

    @Override
    protected void initParameterEventListeners() {
        this.distanceJBParam.addParameterChangeListener(this);
        super.initParameterEventListeners();
    }

    @Override
    public DiscretizedFunc getExceedProbabilities(DiscretizedFunc imls) throws ParameterException {
        double d = this.eqkRupture.getRuptureSurface().getDistanceJB(this.site.getLocation());
        double m = this.eqkRupture.getMag();
        return this.table.get(d, m);
    }

    @Override
    public DiscretizedFunc getExceedProbFromParent(DiscretizedFunc imls) {
        return super.getExceedProbabilities(imls);
    }

    public void setTable() {
        Period p = Period.valueForPeriod((Double)this.getParameter("SA Period").getValue());
        this.table = tables.get((Object)p);
        if (this.table == null) {
            this.table = NSHMP08_SUB_SlabGrid.initTable(p, (Double)this.getParameter("Rupture Top Depth").getValue());
        }
    }

    private static synchronized CurveTable initTable(Period period, double depth) {
        CurveTable table = tables.get((Object)period);
        if (table != null) {
            System.out.println("Cached slab table [" + String.valueOf((Object)period) + "]");
            return table;
        }
        System.out.println("Building slab table [" + String.valueOf((Object)period) + "]");
        NSHMP08_SUB_SlabGrid imr = new NSHMP08_SUB_SlabGrid();
        imr.setIntensityMeasure(period == Period.GM0P00 ? "PGA" : "SA");
        imr.getParameter("SA Period").setValue(period.getValue());
        imr.getParameter("Rupture Top Depth").setValue(depth);
        table = CurveTable.create(200.0, 1.0, 5.0, 7.3, 0.1, imr, period.getFunction());
        tables.put(period, table);
        return table;
    }

    public static void main(String[] args) {
        NSHMP08_SUB_SlabGrid imr = new NSHMP08_SUB_SlabGrid();
        Period per = Period.GM0P00;
        double depth = 50.0;
        imr.setIntensityMeasure(per == Period.GM0P00 ? "PGA" : "SA");
        imr.getParameter("SA Period").setValue(per.getValue());
        imr.getParameter("Rupture Top Depth").setValue(depth);
        imr.setTable();
        System.out.println(tables.size());
        for (Period p : tables.keySet()) {
            System.out.println(String.valueOf((Object)p) + " " + String.valueOf(tables.get((Object)p)));
        }
        System.out.println(tables.get((Object)per));
        System.out.println(tables.get((Object)per).get(10.5, 6.65));
        System.out.println(tables.get((Object)per).get(0.0, 5.0));
    }
}

