/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.nshmp2.imr.impl;

import com.google.common.collect.Maps;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.EnumSet;
import java.util.HashMap;
import org.opensha.commons.data.Site;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.exceptions.InvalidRangeException;
import org.opensha.commons.exceptions.ParameterException;
import org.opensha.commons.param.constraint.impl.DoubleConstraint;
import org.opensha.commons.param.constraint.impl.DoubleDiscreteConstraint;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.event.ParameterChangeWarningListener;
import org.opensha.commons.param.impl.BooleanParameter;
import org.opensha.commons.param.impl.EnumParameter;
import org.opensha.nshmp2.util.Params;
import org.opensha.nshmp2.util.SiteType;
import org.opensha.nshmp2.util.Utils;
import org.opensha.sha.earthquake.EqkRupture;
import org.opensha.sha.imr.AttenuationRelationship;
import org.opensha.sha.imr.param.EqkRuptureParams.MagParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.DampingParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.PGA_Param;
import org.opensha.sha.imr.param.IntensityMeasureParams.PeriodParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.SA_Param;
import org.opensha.sha.imr.param.PropagationEffectParams.DistanceRupParameter;

public class AB2006_140_AttenRel
extends AttenuationRelationship
implements ParameterChangeListener {
    public static final String SHORT_NAME = "AB2006_140";
    private static final long serialVersionUID = 1234567890987654353L;
    public static final String NAME = "Atkinson and Boore (2002) 140bar";
    private double[] c1;
    private double[] c2;
    private double[] c3;
    private double[] c4;
    private double[] c5;
    private double[] c6;
    private double[] c7;
    private double[] c8;
    private double[] c9;
    private double[] c10;
    private double[] clamp = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6.0, 6.0, 6.0, 6.0, 6.0, 6.0, 6.0, 6.0, 6.0, 6.0, 6.0, 6.0, 6.0, 3.0, 3.0, 3.0, 460.0};
    private double[] pd = new double[]{5.0, 4.0, 3.125, 2.5, 2.0, 1.5873, 1.25, 1.0, 0.7937, 0.6289, 0.5, 0.4, 0.3155, 0.2506, 0.2, 0.158, 0.1255, 0.0996, 0.0791, 0.0629, 0.0499, 0.0396, 0.0315, 0.025, 0.0, -1.0};
    private double[] Fr = new double[]{0.2, 0.25, 0.32, 0.4, 0.5, 0.63, 0.8, 1.0, 1.26, 1.59, 2.0, 2.52, 3.17, 3.99, 5.03, 6.33, 7.97, 10.0, 12.6, 15.9, 20.0, 25.2, 31.8, 40.0, 0.0, -1.0};
    private double[] c1hr = new double[]{-5.41, -5.79, -6.04, -6.17, -6.18, -6.04, -5.72, -5.27, -4.6, -3.92, -3.22, -2.44, -1.72, -1.12, -0.615, -0.146, 0.214, 0.48, 0.691, 0.911, 1.11, 1.26, 1.44, 1.52, 0.907, -1.44};
    private double[] c2hr = new double[]{1.71, 1.92, 2.08, 2.21, 2.3, 2.34, 2.32, 2.26, 2.13, 1.99, 1.83, 1.65, 1.48, 1.34, 1.23, 1.12, 1.05, 1.02, 0.997, 0.98, 0.972, 0.968, 0.959, 0.96, 0.983, 0.991};
    private double[] c3hr = new double[]{-0.0901, -0.107, -0.122, -0.135, -0.144, -0.15, -0.151, -0.148, -0.141, -0.131, -0.12, -0.108, -0.0974, -0.0872, -0.0789, -0.0714, -0.0666, -0.064, -0.0628, -0.0621, -0.062, -0.0623, -0.0628, -0.0635, -0.066, -0.0585};
    private double[] c4hr = new double[]{-2.54, -2.44, -2.37, -2.3, -2.22, -2.16, -2.1, -2.07, -2.06, -2.05, -2.02, -2.05, -2.08, -2.08, -2.09, -2.12, -2.15, -2.2, -2.26, -2.36, -2.47, -2.58, -2.71, -2.81, -2.7, -2.7};
    private double[] c5hr = new double[]{0.227, 0.211, 0.2, 0.19, 0.177, 0.166, 0.157, 0.15, 0.147, 0.142, 0.134, 0.136, 0.138, 0.135, 0.131, 0.13, 0.13, 0.127, 0.125, 0.126, 0.128, 0.132, 0.14, 0.146, 0.159, 0.216};
    private double[] c6hr = new double[]{-1.27, -1.16, -1.07, -0.986, -0.937, -0.87, -0.82, -0.813, -0.797, -0.782, -0.813, -0.843, -0.889, -0.971, -1.12, -1.3, -1.61, -2.01, -2.49, -2.97, -3.39, -3.64, -3.73, -3.65, -2.8, -2.44};
    private double[] c7hr = new double[]{0.116, 0.102, 0.0895, 0.0786, 0.0707, 0.0605, 0.0519, 0.0467, 0.0435, 0.043, 0.0444, 0.0448, 0.0487, 0.0563, 0.0679, 0.0831, 0.105, 0.133, 0.164, 0.191, 0.214, 0.228, 0.234, 0.236, 0.212, 0.266};
    private double[] c8hr = new double[]{0.979, 1.01, 1.0, 0.968, 0.952, 0.921, 0.856, 0.826, 0.775, 0.788, 0.884, 0.739, 0.61, 0.614, 0.606, 0.562, 0.427, 0.337, 0.214, 0.107, -0.139, -0.351, -0.543, -0.654, -0.301, 0.0848};
    private double[] c9hr = new double[]{-0.177, -0.182, -0.18, -0.177, -0.177, -0.173, -0.166, -0.162, -0.156, -0.159, -0.175, -0.156, -0.139, -0.143, -0.146, -0.144, -0.13, -0.127, -0.121, -0.117, -0.0984, -0.0813, -0.0645, -0.055, -0.0653, -0.0693};
    private double[] c10hr = new double[]{-1.76E-4, -2.01E-4, -2.31E-4, -2.82E-4, -3.22E-4, -3.75E-4, -4.33E-4, -4.86E-4, -5.79E-4, -6.95E-4, -7.7E-4, -8.51E-4, -9.54E-4, -0.00106, -0.00113, -0.00118, -0.00115, -0.00105, -8.47E-4, -5.79E-4, -3.17E-4, -1.23E-4, -3.23E-5, -4.85E-5, -4.48E-4, -3.73E-4};
    private double[] c1bc = new double[]{-4.85, -5.26, -5.59, -5.8, -5.85, -5.75, -5.49, -5.06, -4.45, -3.75, -3.01, -2.28, -1.56, -0.876, -0.306, 0.119, 0.536, 0.782, 0.967, 1.11, 1.21, 1.26, 1.19, 1.05, 0.523, -1.66};
    private double[] c2bc = new double[]{1.58, 1.79, 1.97, 2.13, 2.23, 2.29, 2.29, 2.23, 2.12, 1.97, 1.8, 1.63, 1.46, 1.29, 1.16, 1.06, 0.965, 0.924, 0.903, 0.888, 0.883, 0.879, 0.888, 0.903, 0.969, 1.05};
    private double[] c3bc = new double[]{-0.0807, -0.0979, -0.114, -0.128, -0.139, -0.145, -0.148, -0.145, -0.139, -0.129, -0.118, -0.105, -0.0931, -0.0819, -0.0721, -0.0647, -0.0584, -0.0556, -0.0548, -0.0539, -0.0544, -0.0552, -0.0564, -0.0577, -0.062, -0.0604};
    private double[] c4bc = new double[]{-2.53, -2.44, -2.33, -2.26, -2.2, -2.13, -2.08, -2.03, -2.01, -2.0, -1.98, -1.97, -1.98, -2.01, -2.04, -2.05, -2.11, -2.17, -2.25, -2.33, -2.44, -2.54, -2.58, -2.57, -2.44, -2.5};
    private double[] c5bc = new double[]{0.222, 0.207, 0.191, 0.179, 0.169, 0.158, 0.15, 0.141, 0.136, 0.131, 0.127, 0.123, 0.121, 0.123, 0.122, 0.119, 0.121, 0.119, 0.122, 0.123, 0.13, 0.139, 0.145, 0.148, 0.147, 0.184};
    private double[] c6bc = new double[]{-1.43, -1.31, -1.2, -1.12, -1.04, -0.957, -0.9, -0.874, -0.858, -0.842, -0.847, -0.888, -0.947, -1.03, -1.15, -1.36, -1.67, -2.1, -2.53, -2.88, -3.04, -2.99, -2.84, -2.65, -2.34, -2.3};
    private double[] c7bc = new double[]{0.136, 0.121, 0.11, 0.0954, 0.08, 0.0676, 0.0579, 0.0541, 0.0498, 0.0482, 0.047, 0.0503, 0.0558, 0.0634, 0.0738, 0.0916, 0.116, 0.148, 0.178, 0.201, 0.213, 0.216, 0.212, 0.207, 0.191, 0.25};
    private double[] c8bc = new double[]{0.634, 0.734, 0.845, 0.891, 0.867, 0.867, 0.821, 0.792, 0.708, 0.677, 0.667, 0.684, 0.65, 0.581, 0.508, 0.516, 0.343, 0.285, 0.1, -0.0319, -0.21, -0.391, -0.437, -0.408, -0.087, 0.127};
    private double[] c9bc = new double[]{-0.141, -0.156, -0.172, -0.18, -0.179, -0.179, -0.172, -0.17, -0.159, -0.156, -0.155, -0.158, -0.156, -0.149, -0.143, -0.15, -0.132, -0.132, -0.115, -0.107, -0.09, -0.0675, -0.0587, -0.0577, -0.0829, -0.087};
    private double[] c10bc = new double[]{-1.61E-4, -1.96E-4, -2.45E-4, -2.6E-4, -2.86E-4, -3.43E-4, -4.07E-4, -4.89E-4, -5.75E-4, -6.76E-4, -7.68E-4, -8.59E-4, -9.55E-4, -0.00105, -0.00114, -0.00118, -0.00113, -9.9E-4, -7.72E-4, -5.48E-4, -4.15E-4, -3.88E-4, -4.33E-4, -5.12E-4, -6.3E-4, -4.27E-4};
    private double[] bln = new double[]{-0.752, -0.745, -0.74, -0.735, -0.73, -0.726, -0.716, -0.7, -0.69, -0.67, -0.6, -0.5, -0.445, -0.39, -0.306, -0.28, -0.26, -0.25, -0.232, -0.249, -0.286, -0.314, -0.322, -0.33, -0.361, -0.6};
    private double[] b1 = new double[]{-0.3, -0.31, -0.33, -0.352, -0.375, -0.395, -0.34, -0.44, -0.465, -0.48, -0.495, -0.508, -0.513, -0.518, -0.521, -0.528, -0.56, -0.595, -0.637, -0.642, -0.643, -0.609, -0.618, -0.624, -0.641, -0.495};
    private double[] b2 = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.002, -0.031, -0.06, -0.095, -0.13, -0.16, -0.185, -0.185, -0.14, -0.132, -0.117, -0.105, -0.105, -0.105, -0.108, -0.115, -0.144, -0.06};
    private double[] del = new double[]{0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.11};
    private double[] m1 = new double[]{6.0, 5.75, 5.5, 5.25, 5.0, 4.84, 4.67, 4.5, 4.34, 4.17, 4.0, 3.65, 3.3, 2.9, 2.5, 1.85, 1.15, 0.5, 0.34, 0.17, 0.0, 0.0, 0.0, 0.0, 0.5, 2.0};
    private double[] mh = new double[]{8.5, 8.37, 8.25, 8.12, 8.0, 7.7, 7.45, 7.2, 6.95, 6.7, 6.5, 6.37, 6.25, 6.12, 6.0, 5.84, 5.67, 5.5, 5.34, 5.17, 5.0, 5.0, 5.0, 5.0, 5.5, 5.5};
    private HashMap<Double, Integer> indexFromPerHashMap;
    private int iper;
    private double rRup;
    private double mag;
    private SiteType siteType;
    private StressDrop stressDrop;
    private boolean clampMean;
    private boolean clampStd;
    private BooleanParameter clampMeanParam;
    private BooleanParameter clampStdParam;
    private EnumParameter<SiteType> siteTypeParam;
    protected EnumParameter<StressDrop> stressDropParam;
    private static final Double MAG_WARN_MIN = 4.0;
    private static final Double MAG_WARN_MAX = 8.0;
    private static final Double DISTANCE_RUP_WARN_MIN = 0.0;
    private static final Double DISTANCE_RUP_WARN_MAX = 1000.0;
    private transient ParameterChangeWarningListener warningListener = null;
    private static final double stressfac = 0.5146;
    private static final double gfac = 6.8875526;
    private static final double sfac = 2.302585;
    private static final double tfac = -0.5108256;
    private static final double vref = 760.0;
    private static final double v1 = 180.0;
    private static final double v2 = 300.0;
    private static final double fac70 = 1.845098;
    private static final double fac140 = 2.146128;
    private static final double facv1 = -0.5108256;
    private static final double facv2 = -0.929536;

    public AB2006_140_AttenRel(ParameterChangeWarningListener listener) {
        this.warningListener = listener;
        this.initSupportedIntensityMeasureParams();
        this.indexFromPerHashMap = Maps.newHashMap();
        for (int i = 0; i < this.pd.length; ++i) {
            this.indexFromPerHashMap.put(this.pd[i], i);
        }
        this.initEqkRuptureParams();
        this.initPropagationEffectParams();
        this.initSiteParams();
        this.initOtherParams();
        this.initIndependentParamLists();
        this.initParameterEventListeners();
        this.setParamDefaults();
    }

    @Override
    public void setEqkRupture(EqkRupture eqkRupture) throws InvalidRangeException {
        this.magParam.setValueIgnoreWarning(eqkRupture.getMag());
        this.eqkRupture = eqkRupture;
        this.setPropagationEffectParams();
    }

    @Override
    public void setSite(Site site) throws ParameterException {
        this.siteTypeParam.setValue((SiteType)((Object)site.getParameter(this.siteTypeParam.getName()).getValue()));
        this.site = site;
        this.setPropagationEffectParams();
    }

    @Override
    protected void setPropagationEffectParams() {
        if (this.site != null && this.eqkRupture != null) {
            this.distanceRupParam.setValue(this.eqkRupture, this.site);
        }
    }

    private void setCoeffIndex() throws ParameterException {
        if (this.im == null) {
            throw new ParameterException("Intensity Measure Param not set");
        }
        this.iper = this.indexFromPerHashMap.get(this.saPeriodParam.getValue());
        this.intensityMeasureChanged = false;
    }

    @Override
    public double getMean() {
        if (this.rRup > this.USER_MAX_DISTANCE) {
            return -35.0;
        }
        if (this.intensityMeasureChanged) {
            this.setCoeffIndex();
        }
        return this.getMean(this.iper, this.siteType, this.stressDrop, this.rRup, this.mag);
    }

    @Override
    public double getStdDev() {
        if (this.intensityMeasureChanged) {
            this.setCoeffIndex();
        }
        return this.getStdDev(this.iper);
    }

    @Override
    public void setParamDefaults() {
        this.siteTypeParam.setValueAsDefault();
        this.stressDropParam.setValueAsDefault();
        this.clampMeanParam.setValueAsDefault();
        this.clampStdParam.setValueAsDefault();
        this.magParam.setValueAsDefault();
        this.distanceRupParam.setValueAsDefault();
        this.saParam.setValueAsDefault();
        this.saPeriodParam.setValueAsDefault();
        this.saDampingParam.setValueAsDefault();
        this.pgaParam.setValueAsDefault();
        this.siteType = (SiteType)((Object)this.siteTypeParam.getValue());
        this.updateCoeffs();
        this.stressDrop = (StressDrop)((Object)this.stressDropParam.getValue());
        this.clampMean = (Boolean)this.clampMeanParam.getValue();
        this.clampStd = (Boolean)this.clampStdParam.getValue();
        this.rRup = (Double)this.distanceRupParam.getValue();
        this.mag = (Double)this.magParam.getValue();
    }

    protected void initIndependentParamLists() {
        this.meanIndependentParams.clear();
        this.meanIndependentParams.addParameter(this.distanceRupParam);
        this.meanIndependentParams.addParameter(this.siteTypeParam);
        this.meanIndependentParams.addParameter(this.magParam);
        this.stdDevIndependentParams.clear();
        this.exceedProbIndependentParams.clear();
        this.exceedProbIndependentParams.addParameterList(this.meanIndependentParams);
        this.exceedProbIndependentParams.addParameter(this.sigmaTruncTypeParam);
        this.exceedProbIndependentParams.addParameter(this.sigmaTruncLevelParam);
        this.imlAtExceedProbIndependentParams.addParameterList(this.exceedProbIndependentParams);
        this.imlAtExceedProbIndependentParams.addParameter(this.exceedProbParam);
    }

    @Override
    protected void initSiteParams() {
        this.siteTypeParam = Params.createSiteType();
        this.siteParams.clear();
        this.siteParams.addParameter(this.siteTypeParam);
    }

    @Override
    protected void initEqkRuptureParams() {
        this.magParam = new MagParam(MAG_WARN_MIN, (double)MAG_WARN_MAX);
        this.eqkRuptureParams.clear();
        this.eqkRuptureParams.addParameter(this.magParam);
    }

    @Override
    protected void initPropagationEffectParams() {
        this.distanceRupParam = new DistanceRupParameter(0.0);
        this.distanceRupParam.addParameterChangeWarningListener(this.warningListener);
        DoubleConstraint warn = new DoubleConstraint(DISTANCE_RUP_WARN_MIN, DISTANCE_RUP_WARN_MAX);
        warn.setNonEditable();
        this.distanceRupParam.setWarningConstraint(warn);
        this.distanceRupParam.setNonEditable();
        this.propagationEffectParams.addParameter(this.distanceRupParam);
    }

    @Override
    protected void initSupportedIntensityMeasureParams() {
        DoubleDiscreteConstraint perConstraint = new DoubleDiscreteConstraint();
        for (int i = 0; i < this.pd.length; ++i) {
            perConstraint.addDouble((Double)this.pd[i]);
        }
        perConstraint.setNonEditable();
        this.saPeriodParam = new PeriodParam(perConstraint);
        this.saDampingParam = new DampingParam();
        this.saParam = new SA_Param(this.saPeriodParam, this.saDampingParam);
        this.saParam.setNonEditable();
        this.pgaParam = new PGA_Param();
        this.pgaParam.setNonEditable();
        this.saParam.addParameterChangeWarningListener(this.warningListener);
        this.pgaParam.addParameterChangeWarningListener(this.warningListener);
        this.supportedIMParams.clear();
        this.supportedIMParams.addParameter(this.saParam);
        this.supportedIMParams.addParameter(this.pgaParam);
    }

    @Override
    protected void initOtherParams() {
        super.initOtherParams();
        this.stressDropParam = new EnumParameter<StressDrop>("Stress Drop", EnumSet.allOf(StressDrop.class), StressDrop.SD_140, null);
        this.clampMeanParam = new BooleanParameter("Clamp Mean", true);
        this.clampStdParam = new BooleanParameter("Clamp Std. Dev.", true);
        this.otherParams.addParameter(this.stressDropParam);
        this.otherParams.addParameter(this.clampMeanParam);
        this.otherParams.addParameter(this.clampStdParam);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getShortName() {
        return SHORT_NAME;
    }

    @Override
    public void parameterChange(ParameterChangeEvent e) {
        String pName = e.getParameterName();
        Object val = e.getNewValue();
        if (pName.equals("DistanceRup")) {
            this.rRup = (Double)val;
        } else if (pName.equals(this.siteTypeParam.getName())) {
            this.siteType = (SiteType)((Object)this.siteTypeParam.getValue());
            this.updateCoeffs();
        } else if (pName.equals(this.stressDropParam.getName())) {
            this.stressDrop = (StressDrop)((Object)this.stressDropParam.getValue());
        } else if (pName.equals(this.clampMeanParam.getName())) {
            this.clampMean = (Boolean)this.clampMeanParam.getValue();
        } else if (pName.equals(this.clampStdParam.getName())) {
            this.clampStd = (Boolean)this.clampStdParam.getValue();
        } else if (pName.equals("Magnitude")) {
            this.mag = (Double)val;
        } else if (pName.equals("SA Period")) {
            this.intensityMeasureChanged = true;
        }
    }

    @Override
    public void resetParameterEventListeners() {
        this.distanceRupParam.removeParameterChangeListener(this);
        this.siteTypeParam.removeParameterChangeListener(this);
        this.stressDropParam.removeParameterChangeListener(this);
        this.clampMeanParam.removeParameterChangeListener(this);
        this.clampStdParam.removeParameterChangeListener(this);
        this.magParam.removeParameterChangeListener(this);
        this.saPeriodParam.removeParameterChangeListener(this);
        this.initParameterEventListeners();
    }

    @Override
    protected void initParameterEventListeners() {
        this.distanceRupParam.addParameterChangeListener(this);
        this.siteTypeParam.addParameterChangeListener(this);
        this.stressDropParam.addParameterChangeListener(this);
        this.clampMeanParam.addParameterChangeListener(this);
        this.clampMeanParam.addParameterChangeListener(this);
        this.magParam.addParameterChangeListener(this);
        this.saPeriodParam.addParameterChangeListener(this);
    }

    public URL getAttenuationRelationshipURL() throws MalformedURLException {
        return null;
    }

    private double getMean(int iper, SiteType st, StressDrop sd, double rRup, double mag) {
        double gnd;
        double sf2;
        double vs30 = st == SiteType.HARD_ROCK ? 2000.0 : 760.0;
        double period = this.pd[iper];
        double gndm = this.c1[24] + this.c2[24] * mag + this.c3[24] * mag * mag;
        double gndmp = this.c1[iper] + this.c2[iper] * mag + this.c3[iper] * mag * mag;
        if (sd == StressDrop.SD_200) {
            double diff = Math.max(mag - this.m1[iper], 0.0);
            sf2 = 0.5146 * Math.min(this.del[iper] + 0.05, 0.05 + this.del[iper] * diff / (this.mh[iper] - this.m1[iper]));
        } else {
            sf2 = 0.0;
        }
        double rfac = Math.log10(rRup);
        double f0 = Math.max(1.0 - rfac, 0.0);
        double f1 = Math.min(rfac, 1.845098);
        double f2 = Math.max(rfac - 2.146128, 0.0);
        double S = 0.0;
        if (vs30 > 0.0) {
            gnd = gndm + (this.c4[24] + this.c5[24] * mag) * f1 + (this.c6[24] + this.c7[24] * mag) * f2 + (this.c8[24] + this.c9[24] * mag) * f0 + this.c10[24] * rRup + sf2;
            double bnl = vs30 <= 180.0 ? this.b1[iper] : (vs30 <= 300.0 ? (this.b1[iper] - this.b2[iper]) * Math.log(vs30 / 300.0) / -0.5108256 + this.b1[iper] : (vs30 <= 760.0 ? this.b2[iper] * Math.log(vs30 / 760.0) / -0.929536 : 0.0));
            double pga_bc = Math.pow(10.0, gnd);
            S = st == SiteType.HARD_ROCK ? 0.0 : (pga_bc <= 60.0 ? this.bln[iper] * Math.log(vs30 / 760.0) + bnl * -0.5108256 : this.bln[iper] * Math.log(vs30 / 760.0) + bnl * Math.log(pga_bc / 100.0));
            S = Math.log10(Math.exp(S));
        }
        gnd = gndmp + (this.c4[iper] + this.c5[iper] * mag) * f1 + (this.c6[iper] + this.c7[iper] * mag) * f2 + (this.c8[iper] + this.c9[iper] * mag) * f0 + this.c10[iper] * rRup + sf2 + S;
        gnd = iper < 26 ? gnd * 2.302585 - 6.8875526 : (gnd *= 2.302585);
        if (this.clampMean) {
            gnd = Utils.ceusMeanClip(period, gnd);
        }
        return gnd;
    }

    private double getStdDev(int iper) {
        return 0.6907755;
    }

    private void updateCoeffs() {
        if (this.siteType == SiteType.HARD_ROCK) {
            this.c1 = this.c1hr;
            this.c2 = this.c2hr;
            this.c3 = this.c3hr;
            this.c4 = this.c4hr;
            this.c5 = this.c5hr;
            this.c6 = this.c6hr;
            this.c7 = this.c7hr;
            this.c8 = this.c8hr;
            this.c9 = this.c9hr;
            this.c10 = this.c10hr;
        } else {
            this.c1 = this.c1bc;
            this.c2 = this.c2bc;
            this.c3 = this.c3bc;
            this.c4 = this.c4bc;
            this.c5 = this.c5bc;
            this.c6 = this.c6bc;
            this.c7 = this.c7bc;
            this.c8 = this.c8bc;
            this.c9 = this.c9bc;
            this.c10 = this.c10bc;
        }
    }

    @Override
    public DiscretizedFunc getExceedProbabilities(DiscretizedFunc imls) {
        return Utils.getExceedProbabilities(imls, this.getMean(), this.getStdDev(), this.clampStd, this.clamp[this.iper]);
    }

    public static enum StressDrop {
        SD_140("140 bar"),
        SD_200("200 bar");

        private String label;

        private StressDrop(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }
    }
}

