/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.nshmp2.imr.impl;

import com.google.common.collect.Maps;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import org.opensha.commons.data.Site;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.exceptions.InvalidRangeException;
import org.opensha.commons.exceptions.ParameterException;
import org.opensha.commons.param.constraint.impl.DoubleConstraint;
import org.opensha.commons.param.constraint.impl.DoubleDiscreteConstraint;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.event.ParameterChangeWarningListener;
import org.opensha.commons.param.impl.BooleanParameter;
import org.opensha.commons.param.impl.EnumParameter;
import org.opensha.nshmp2.util.Params;
import org.opensha.nshmp2.util.SiteType;
import org.opensha.nshmp2.util.Utils;
import org.opensha.sha.earthquake.EqkRupture;
import org.opensha.sha.imr.AttenuationRelationship;
import org.opensha.sha.imr.param.EqkRuptureParams.MagParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.DampingParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.PGA_Param;
import org.opensha.sha.imr.param.IntensityMeasureParams.PeriodParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.SA_Param;
import org.opensha.sha.imr.param.PropagationEffectParams.DistanceJBParameter;

public class SomervilleEtAl_2001_AttenRel
extends AttenuationRelationship
implements ParameterChangeListener {
    public static final String SHORT_NAME = "SomervilleEtAl2001";
    private static final long serialVersionUID = 1234567890987654353L;
    public static final String NAME = "Somerville et al. (2001)";
    private double[] pd = new double[]{0.0, 0.2, 1.0, 0.1, 0.3, 0.5, 2.0, -1.0};
    private double[] a1 = new double[]{0.658, 1.358, -0.0143, 1.442, 1.2353, 0.8532, -0.9497};
    private double[] a1h = new double[]{0.239, 0.793, -0.307, 0.888, 0.693, 0.3958, -1.132};
    private double[] a2 = new double[]{0.805, 0.805, 0.805, 0.805, 0.805, 0.805, 0.805};
    private double[] a3 = new double[]{-0.679, -0.679, -0.696, -0.679, -0.67023, -0.671792, -0.728};
    private double[] a4 = new double[]{0.0861, 0.0861, 0.0861, 0.0861, 0.0861, 0.0861, 0.0861};
    private double[] a5 = new double[]{-0.00498, -0.00498, -0.00362, -0.00498, -0.0048045, -0.00442189, -0.00221};
    private double[] a6 = new double[]{-0.477, -0.477, -0.755, -0.477, -0.523792, -0.605213, -0.946};
    private double[] a7 = new double[]{0.0, 0.0, -0.102, 0.0, -0.030298, -0.0640237, -0.14};
    private double[] sig0 = new double[]{0.587, 0.611, 0.693, 0.595, 0.6057, 0.6242, 0.824};
    private double[] clamp = new double[]{3.0, 6.0, 0.0, 6.0, 6.0, 6.0, 0.0};
    private HashMap<Double, Integer> indexFromPerHashMap;
    private int iper;
    private double rjb;
    private double mag;
    private SiteType siteType;
    private boolean clampMean;
    private boolean clampStd;
    private BooleanParameter clampMeanParam;
    private BooleanParameter clampStdParam;
    private EnumParameter<SiteType> siteTypeParam;
    private static final Double MAG_WARN_MIN = 4.0;
    private static final Double MAG_WARN_MAX = 8.0;
    private static final Double DISTANCE_JB_WARN_MIN = 0.0;
    private static final Double DISTANCE_JB_WARN_MAX = 1000.0;
    private transient ParameterChangeWarningListener warningListener = null;
    private static final double dist1 = Math.sqrt(2536.0);

    public SomervilleEtAl_2001_AttenRel(ParameterChangeWarningListener listener) {
        this.warningListener = listener;
        this.initSupportedIntensityMeasureParams();
        this.indexFromPerHashMap = Maps.newHashMap();
        for (int i = 0; i < this.pd.length; ++i) {
            this.indexFromPerHashMap.put(this.pd[i], i);
        }
        this.initEqkRuptureParams();
        this.initPropagationEffectParams();
        this.initSiteParams();
        this.initOtherParams();
        this.initIndependentParamLists();
        this.initParameterEventListeners();
        this.setParamDefaults();
    }

    @Override
    public void setEqkRupture(EqkRupture eqkRupture) throws InvalidRangeException {
        this.magParam.setValueIgnoreWarning(eqkRupture.getMag());
        this.eqkRupture = eqkRupture;
        this.setPropagationEffectParams();
    }

    @Override
    public void setSite(Site site) throws ParameterException {
        this.siteTypeParam.setValue((SiteType)((Object)site.getParameter(this.siteTypeParam.getName()).getValue()));
        this.site = site;
        this.setPropagationEffectParams();
    }

    @Override
    protected void setPropagationEffectParams() {
        if (this.site != null && this.eqkRupture != null) {
            this.distanceJBParam.setValue(this.eqkRupture, this.site);
        }
    }

    private void setCoeffIndex() throws ParameterException {
        if (this.im == null) {
            throw new ParameterException("Intensity Measure Param not set");
        }
        this.iper = this.indexFromPerHashMap.get(this.saPeriodParam.getValue());
        this.intensityMeasureChanged = false;
    }

    @Override
    public double getMean() {
        if (this.rjb > this.USER_MAX_DISTANCE) {
            return -35.0;
        }
        if (this.intensityMeasureChanged) {
            this.setCoeffIndex();
        }
        return this.getMean(this.iper, this.siteType, this.rjb, this.mag);
    }

    @Override
    public double getStdDev() {
        if (this.intensityMeasureChanged) {
            this.setCoeffIndex();
        }
        return this.getStdDev(this.iper);
    }

    @Override
    public void setParamDefaults() {
        this.siteTypeParam.setValueAsDefault();
        this.clampMeanParam.setValueAsDefault();
        this.clampStdParam.setValueAsDefault();
        this.magParam.setValueAsDefault();
        this.distanceJBParam.setValueAsDefault();
        this.saParam.setValueAsDefault();
        this.saPeriodParam.setValueAsDefault();
        this.saDampingParam.setValueAsDefault();
        this.pgaParam.setValueAsDefault();
        this.siteType = (SiteType)((Object)this.siteTypeParam.getValue());
        this.clampMean = (Boolean)this.clampMeanParam.getValue();
        this.clampStd = (Boolean)this.clampStdParam.getValue();
        this.rjb = (Double)this.distanceJBParam.getValue();
        this.mag = (Double)this.magParam.getValue();
    }

    protected void initIndependentParamLists() {
        this.meanIndependentParams.clear();
        this.meanIndependentParams.addParameter(this.distanceJBParam);
        this.meanIndependentParams.addParameter(this.siteTypeParam);
        this.meanIndependentParams.addParameter(this.magParam);
        this.stdDevIndependentParams.clear();
        this.exceedProbIndependentParams.clear();
        this.exceedProbIndependentParams.addParameterList(this.meanIndependentParams);
        this.exceedProbIndependentParams.addParameter(this.sigmaTruncTypeParam);
        this.exceedProbIndependentParams.addParameter(this.sigmaTruncLevelParam);
        this.imlAtExceedProbIndependentParams.addParameterList(this.exceedProbIndependentParams);
        this.imlAtExceedProbIndependentParams.addParameter(this.exceedProbParam);
    }

    @Override
    protected void initSiteParams() {
        this.siteTypeParam = Params.createSiteType();
        this.siteParams.clear();
        this.siteParams.addParameter(this.siteTypeParam);
    }

    @Override
    protected void initEqkRuptureParams() {
        this.magParam = new MagParam(MAG_WARN_MIN, (double)MAG_WARN_MAX);
        this.eqkRuptureParams.clear();
        this.eqkRuptureParams.addParameter(this.magParam);
    }

    @Override
    protected void initPropagationEffectParams() {
        this.distanceJBParam = new DistanceJBParameter(0.0);
        this.distanceJBParam.addParameterChangeWarningListener(this.warningListener);
        DoubleConstraint warn = new DoubleConstraint(DISTANCE_JB_WARN_MIN, DISTANCE_JB_WARN_MAX);
        warn.setNonEditable();
        this.distanceJBParam.setWarningConstraint(warn);
        this.distanceJBParam.setNonEditable();
        this.propagationEffectParams.addParameter(this.distanceJBParam);
    }

    @Override
    protected void initSupportedIntensityMeasureParams() {
        DoubleDiscreteConstraint perConstraint = new DoubleDiscreteConstraint();
        for (int i = 0; i < this.pd.length; ++i) {
            perConstraint.addDouble((Double)this.pd[i]);
        }
        perConstraint.setNonEditable();
        this.saPeriodParam = new PeriodParam(perConstraint);
        this.saDampingParam = new DampingParam();
        this.saParam = new SA_Param(this.saPeriodParam, this.saDampingParam);
        this.saParam.setNonEditable();
        this.pgaParam = new PGA_Param();
        this.pgaParam.setNonEditable();
        this.saParam.addParameterChangeWarningListener(this.warningListener);
        this.pgaParam.addParameterChangeWarningListener(this.warningListener);
        this.supportedIMParams.clear();
        this.supportedIMParams.addParameter(this.saParam);
        this.supportedIMParams.addParameter(this.pgaParam);
    }

    @Override
    protected void initOtherParams() {
        super.initOtherParams();
        this.clampMeanParam = new BooleanParameter("Clamp Mean", true);
        this.clampStdParam = new BooleanParameter("Clamp Std. Dev.", true);
        this.otherParams.addParameter(this.clampMeanParam);
        this.otherParams.addParameter(this.clampStdParam);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getShortName() {
        return SHORT_NAME;
    }

    @Override
    public void parameterChange(ParameterChangeEvent e) {
        String pName = e.getParameterName();
        Object val = e.getNewValue();
        if (pName.equals("DistanceJB")) {
            this.rjb = (Double)val;
        } else if (pName.equals(this.siteTypeParam.getName())) {
            this.siteType = (SiteType)((Object)this.siteTypeParam.getValue());
        } else if (pName.equals(this.clampMeanParam.getName())) {
            this.clampMean = (Boolean)this.clampMeanParam.getValue();
        } else if (pName.equals(this.clampStdParam.getName())) {
            this.clampStd = (Boolean)this.clampStdParam.getValue();
        } else if (pName.equals("Magnitude")) {
            this.mag = (Double)val;
        } else if (pName.equals("SA Period")) {
            this.intensityMeasureChanged = true;
        }
    }

    @Override
    public void resetParameterEventListeners() {
        this.distanceJBParam.removeParameterChangeListener(this);
        this.siteTypeParam.removeParameterChangeListener(this);
        this.clampMeanParam.removeParameterChangeListener(this);
        this.clampStdParam.removeParameterChangeListener(this);
        this.magParam.removeParameterChangeListener(this);
        this.saPeriodParam.removeParameterChangeListener(this);
        this.initParameterEventListeners();
    }

    @Override
    protected void initParameterEventListeners() {
        this.distanceJBParam.addParameterChangeListener(this);
        this.siteTypeParam.addParameterChangeListener(this);
        this.clampMeanParam.addParameterChangeListener(this);
        this.clampMeanParam.addParameterChangeListener(this);
        this.magParam.addParameterChangeListener(this);
        this.saPeriodParam.addParameterChangeListener(this);
    }

    public URL getAttenuationRelationshipURL() throws MalformedURLException {
        return null;
    }

    private double getMean(int iper, SiteType st, double rjb, double mag) {
        double period = this.pd[iper];
        double gnd0 = st == SiteType.HARD_ROCK ? this.a1h[iper] : this.a1[iper];
        double gndm = gnd0 + this.a2[iper] * (mag - 6.4) + this.a7[iper] * (8.5 - mag) * (8.5 - mag);
        double dist = Math.sqrt(rjb * rjb + 36.0);
        double gnd = rjb < 50.0 ? gndm + this.a3[iper] * Math.log(dist) + this.a4[iper] * (mag - 6.4) * Math.log(dist) + this.a5[iper] * rjb : gndm + this.a3[iper] * Math.log(dist1) + this.a4[iper] * (mag - 6.4) * Math.log(dist) + this.a5[iper] * rjb + this.a6[iper] * (Math.log(dist) - Math.log(dist1));
        if (this.clampMean) {
            gnd = Utils.ceusMeanClip(period, gnd);
        }
        return gnd;
    }

    private double getStdDev(int iper) {
        return this.sig0[iper];
    }

    @Override
    public DiscretizedFunc getExceedProbabilities(DiscretizedFunc imls) {
        return Utils.getExceedProbabilities(imls, this.getMean(), this.getStdDev(), this.clampStd, this.clamp[this.iper]);
    }
}

