/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.nshmp2.imr.impl;

import com.google.common.collect.Maps;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.EnumSet;
import java.util.HashMap;
import org.opensha.commons.data.Site;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.eq.cat.util.MagnitudeType;
import org.opensha.commons.exceptions.InvalidRangeException;
import org.opensha.commons.exceptions.ParameterException;
import org.opensha.commons.param.constraint.impl.DoubleConstraint;
import org.opensha.commons.param.constraint.impl.DoubleDiscreteConstraint;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.event.ParameterChangeWarningListener;
import org.opensha.commons.param.impl.BooleanParameter;
import org.opensha.commons.param.impl.EnumParameter;
import org.opensha.nshmp2.util.FaultCode;
import org.opensha.nshmp2.util.Params;
import org.opensha.nshmp2.util.SiteType;
import org.opensha.nshmp2.util.Utils;
import org.opensha.sha.earthquake.EqkRupture;
import org.opensha.sha.imr.AttenuationRelationship;
import org.opensha.sha.imr.param.EqkRuptureParams.MagParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.DampingParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.PGA_Param;
import org.opensha.sha.imr.param.IntensityMeasureParams.PeriodParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.SA_Param;
import org.opensha.sha.imr.param.PropagationEffectParams.DistanceJBParameter;

public class ToroEtAl_1997_AttenRel
extends AttenuationRelationship
implements ParameterChangeListener {
    private static final String C = "ToroEtAl_1997_AttenRel";
    private static final boolean D = false;
    public static final String SHORT_NAME = "ToroEtAl1997";
    private static final long serialVersionUID = 1234567890987654353L;
    public static final String NAME = "Toro et al. (1997)";
    private double[] perx = new double[]{0.0, 0.2, 1.0, 0.1, 0.3, 0.5, 2.0, 0.04, 0.4};
    private double[] tb1 = new double[]{2.489, 2.165, 0.173, 2.91, 1.7323, 1.109, -0.788, 4.0, 1.2};
    private double[] tb1h = new double[]{2.07, 1.6, -0.12, 2.36, 1.19, 0.652, -0.97, 3.54, 0.9};
    private double[] tb2 = new double[]{1.2, 1.24, 2.05, 1.23, 1.51, 1.785, 2.52, 1.19, 1.7};
    private double[] tb3 = new double[]{0.0, 0.0, -0.34, 0.0, -0.11, -0.2795, -0.47, 0.0, -0.26};
    private double[] tb4 = new double[]{1.28, 0.98, 0.9, 1.12, 0.96, 0.93, 0.93, 1.46, 0.94};
    private double[] tb5 = new double[]{1.23, 0.74, 0.59, 1.05, 0.6881, 0.6354, 0.6, 1.84, 0.65};
    private double[] tb6 = new double[]{0.0018, 0.0039, 0.0019, 0.0043, 0.0034, 0.002732, 0.0012, 0.001, 0.003};
    private double[] tc1 = new double[]{2.619, 2.295, 0.383, 2.92, 1.8823, 1.2887, -0.558, 4.0, 1.4};
    private double[] tc1h = new double[]{2.2, 1.73, 0.09, 2.37, 1.34, 0.8313, -0.74, 3.68, 1.07};
    private double[] tc2 = new double[]{0.81, 0.84, 1.42, 0.81, 0.964, 1.14, 1.86, 0.8, 1.05};
    private double[] tc3 = new double[]{0.0, 0.0, -0.2, 0.0, -0.059, -0.1244, -0.31, 0.0, -0.1};
    private double[] tc4 = new double[]{1.27, 0.98, 0.9, 1.1, 0.951, 0.9227, 0.92, 1.46, 0.93};
    private double[] tc5 = new double[]{1.16, 0.66, 0.49, 1.02, 0.601, 0.5429, 0.46, 1.77, 0.56};
    private double[] tc6 = new double[]{0.0021, 0.0042, 0.0023, 0.004, 0.00367, 0.00306, 0.0017, 0.0013, 0.0033};
    private double[] tbh = new double[]{9.3, 7.5, 6.8, 8.5, 7.35, 7.05, 7.0, 10.5, 7.2};
    private double[] th = new double[]{9.3, 7.5, 6.8, 8.3, 7.26, 7.027, 6.9, 10.5, 7.1};
    private double[] clamp = new double[]{3.0, 6.0, 0.0, 6.0, 6.0, 6.0, 0.0, 6.0, 6.0};
    private double[] tsigma = new double[]{0.7506, 0.7506, 0.799, 0.7506, 0.7506, 0.7506, 0.799, 0.7506, 0.7506};
    private HashMap<Double, Integer> indexFromPerHashMap;
    private int iper;
    private double rjb;
    private double mag;
    private SiteType siteType;
    private MagnitudeType magType;
    private boolean clampMean;
    private boolean clampStd;
    private BooleanParameter clampMeanParam;
    private BooleanParameter clampStdParam;
    private EnumParameter<MagnitudeType> magTypeParam;
    private EnumParameter<SiteType> siteTypeParam;
    private static final Double MAG_WARN_MIN = 4.0;
    private static final Double MAG_WARN_MAX = 8.0;
    private static final Double DISTANCE_JB_WARN_MIN = 0.0;
    private static final Double DISTANCE_JB_WARN_MAX = 1000.0;
    private transient ParameterChangeWarningListener warningListener = null;

    public ToroEtAl_1997_AttenRel(ParameterChangeWarningListener listener) {
        this.warningListener = listener;
        this.initSupportedIntensityMeasureParams();
        this.indexFromPerHashMap = Maps.newHashMap();
        for (int i = 0; i < this.perx.length; ++i) {
            this.indexFromPerHashMap.put(this.perx[i], i);
        }
        this.initEqkRuptureParams();
        this.initPropagationEffectParams();
        this.initSiteParams();
        this.initOtherParams();
        this.initIndependentParamLists();
        this.initParameterEventListeners();
        this.setParamDefaults();
    }

    @Override
    public void setEqkRupture(EqkRupture eqkRupture) throws InvalidRangeException {
        this.magParam.setValueIgnoreWarning(eqkRupture.getMag());
        this.eqkRupture = eqkRupture;
        this.setPropagationEffectParams();
    }

    @Override
    public void setSite(Site site) throws ParameterException {
        this.siteTypeParam.setValue((SiteType)((Object)site.getParameter(this.siteTypeParam.getName()).getValue()));
        this.site = site;
        this.setPropagationEffectParams();
    }

    @Override
    protected void setPropagationEffectParams() {
        if (this.site != null && this.eqkRupture != null) {
            this.distanceJBParam.setValue(this.eqkRupture, this.site);
        }
    }

    private void setCoeffIndex() throws ParameterException {
        if (this.im == null) {
            throw new ParameterException("Intensity Measure Param not set");
        }
        this.iper = this.indexFromPerHashMap.get(this.saPeriodParam.getValue());
        this.intensityMeasureChanged = false;
    }

    @Override
    public double getMean() {
        if (this.rjb > this.USER_MAX_DISTANCE) {
            return -35.0;
        }
        if (this.intensityMeasureChanged) {
            this.setCoeffIndex();
        }
        return this.getMean(this.iper, this.siteType, this.rjb, this.mag);
    }

    @Override
    public double getStdDev() {
        if (this.intensityMeasureChanged) {
            this.setCoeffIndex();
        }
        return this.getStdDev(this.iper);
    }

    @Override
    public void setParamDefaults() {
        this.siteTypeParam.setValueAsDefault();
        this.magTypeParam.setValueAsDefault();
        this.clampMeanParam.setValueAsDefault();
        this.clampStdParam.setValueAsDefault();
        this.magParam.setValueAsDefault();
        this.distanceJBParam.setValueAsDefault();
        this.saParam.setValueAsDefault();
        this.saPeriodParam.setValueAsDefault();
        this.saDampingParam.setValueAsDefault();
        this.pgaParam.setValueAsDefault();
        this.siteType = (SiteType)((Object)this.siteTypeParam.getValue());
        this.magType = (MagnitudeType)((Object)this.magTypeParam.getValue());
        this.clampMean = (Boolean)this.clampMeanParam.getValue();
        this.clampStd = (Boolean)this.clampStdParam.getValue();
        this.rjb = (Double)this.distanceJBParam.getValue();
        this.mag = (Double)this.magParam.getValue();
    }

    protected void initIndependentParamLists() {
        this.meanIndependentParams.clear();
        this.meanIndependentParams.addParameter(this.distanceJBParam);
        this.meanIndependentParams.addParameter(this.siteTypeParam);
        this.meanIndependentParams.addParameter(this.magParam);
        this.stdDevIndependentParams.clear();
        this.exceedProbIndependentParams.clear();
        this.exceedProbIndependentParams.addParameterList(this.meanIndependentParams);
        this.exceedProbIndependentParams.addParameter(this.sigmaTruncTypeParam);
        this.exceedProbIndependentParams.addParameter(this.sigmaTruncLevelParam);
        this.imlAtExceedProbIndependentParams.addParameterList(this.exceedProbIndependentParams);
        this.imlAtExceedProbIndependentParams.addParameter(this.exceedProbParam);
    }

    @Override
    protected void initSiteParams() {
        this.siteTypeParam = Params.createSiteType();
        this.siteParams.clear();
        this.siteParams.addParameter(this.siteTypeParam);
    }

    @Override
    protected void initEqkRuptureParams() {
        this.magParam = new MagParam(MAG_WARN_MIN, (double)MAG_WARN_MAX);
        this.eqkRuptureParams.clear();
        this.eqkRuptureParams.addParameter(this.magParam);
    }

    @Override
    protected void initPropagationEffectParams() {
        this.distanceJBParam = new DistanceJBParameter(0.0);
        this.distanceJBParam.addParameterChangeWarningListener(this.warningListener);
        DoubleConstraint warn = new DoubleConstraint(DISTANCE_JB_WARN_MIN, DISTANCE_JB_WARN_MAX);
        warn.setNonEditable();
        this.distanceJBParam.setWarningConstraint(warn);
        this.distanceJBParam.setNonEditable();
        this.propagationEffectParams.addParameter(this.distanceJBParam);
    }

    @Override
    protected void initSupportedIntensityMeasureParams() {
        DoubleDiscreteConstraint perConstraint = new DoubleDiscreteConstraint();
        for (int i = 0; i < this.perx.length; ++i) {
            perConstraint.addDouble((Double)this.perx[i]);
        }
        perConstraint.setNonEditable();
        this.saPeriodParam = new PeriodParam(perConstraint);
        this.saDampingParam = new DampingParam();
        this.saParam = new SA_Param(this.saPeriodParam, this.saDampingParam);
        this.saParam.setNonEditable();
        this.pgaParam = new PGA_Param();
        this.pgaParam.setNonEditable();
        this.saParam.addParameterChangeWarningListener(this.warningListener);
        this.pgaParam.addParameterChangeWarningListener(this.warningListener);
        this.supportedIMParams.clear();
        this.supportedIMParams.addParameter(this.saParam);
        this.supportedIMParams.addParameter(this.pgaParam);
    }

    @Override
    protected void initOtherParams() {
        super.initOtherParams();
        this.magTypeParam = new EnumParameter<MagnitudeType>("Magnitude Type", EnumSet.of(MagnitudeType.MOMENT, MagnitudeType.LG_PHASE), MagnitudeType.MOMENT, null);
        this.clampMeanParam = new BooleanParameter("Clamp Mean", true);
        this.clampStdParam = new BooleanParameter("Clamp Std. Dev.", true);
        this.otherParams.addParameter(this.magTypeParam);
        this.otherParams.addParameter(this.clampMeanParam);
        this.otherParams.addParameter(this.clampStdParam);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getShortName() {
        return SHORT_NAME;
    }

    @Override
    public void parameterChange(ParameterChangeEvent e) {
        String pName = e.getParameterName();
        Object val = e.getNewValue();
        if (pName.equals("DistanceJB")) {
            this.rjb = (Double)val;
        } else if (pName.equals(this.siteTypeParam.getName())) {
            this.siteType = (SiteType)((Object)this.siteTypeParam.getValue());
        } else if (pName.equals(this.magTypeParam.getName())) {
            this.magType = (MagnitudeType)((Object)this.magTypeParam.getValue());
        } else if (pName.equals(this.clampMeanParam.getName())) {
            this.clampMean = (Boolean)this.clampMeanParam.getValue();
        } else if (pName.equals(this.clampStdParam.getName())) {
            this.clampStd = (Boolean)this.clampStdParam.getValue();
        } else if (pName.equals("Magnitude")) {
            this.mag = (Double)val;
        } else if (pName.equals("SA Period")) {
            this.intensityMeasureChanged = true;
        }
    }

    @Override
    public void resetParameterEventListeners() {
        this.distanceJBParam.removeParameterChangeListener(this);
        this.siteTypeParam.removeParameterChangeListener(this);
        this.magTypeParam.removeParameterChangeListener(this);
        this.clampMeanParam.removeParameterChangeListener(this);
        this.clampStdParam.removeParameterChangeListener(this);
        this.magParam.removeParameterChangeListener(this);
        this.saPeriodParam.removeParameterChangeListener(this);
        this.initParameterEventListeners();
    }

    @Override
    protected void initParameterEventListeners() {
        this.distanceJBParam.addParameterChangeListener(this);
        this.siteTypeParam.addParameterChangeListener(this);
        this.magTypeParam.addParameterChangeListener(this);
        this.clampMeanParam.addParameterChangeListener(this);
        this.clampMeanParam.addParameterChangeListener(this);
        this.magParam.addParameterChangeListener(this);
        this.saPeriodParam.addParameterChangeListener(this);
    }

    public URL getAttenuationRelationshipURL() throws MalformedURLException {
        return null;
    }

    private double getMean(int iper, SiteType st, double rjb, double mag) {
        double mCorr;
        double t1h;
        double thsq;
        double t6;
        double t5;
        double t4;
        double t3;
        double t2;
        double t1;
        double period = this.perx[iper];
        if (this.magType == MagnitudeType.LG_PHASE) {
            t1 = this.tb1[iper];
            t2 = this.tb2[iper];
            t3 = this.tb3[iper];
            t4 = this.tb4[iper];
            t5 = this.tb5[iper];
            t6 = this.tb6[iper];
            thsq = this.tbh[iper] * this.tbh[iper];
            t1h = this.tb1h[iper];
        } else {
            t1 = this.tc1[iper];
            t2 = this.tc2[iper];
            t3 = this.tc3[iper];
            t4 = this.tc4[iper];
            t5 = this.tc5[iper];
            t6 = this.tc6[iper];
            thsq = this.th[iper] * this.th[iper];
            t1h = this.tc1h[iper];
        }
        if (this.magType == MagnitudeType.LG_PHASE) {
            double mag1 = Utils.mblgToMw(FaultCode.M_CONV_J, mag);
            double cor1 = Math.exp(-1.25 + 0.227 * mag1);
            double mag2 = Utils.mblgToMw(FaultCode.M_CONV_AB, mag);
            double cor2 = Math.exp(-1.25 + 0.227 * mag2);
            mCorr = Math.sqrt(cor1 * cor2);
        } else {
            mCorr = Math.exp(-1.25 + 0.227 * mag);
        }
        double corsq = mCorr * mCorr;
        double dist0 = rjb;
        double dist = Math.sqrt(dist0 * dist0 + thsq * corsq);
        double gnd0 = st == SiteType.HARD_ROCK ? t1h : t1;
        double gndm = gnd0 + t2 * (mag - 6.0) + t3 * ((mag - 6.0) * (mag - 6.0));
        double gnd = gndm - t4 * Math.log(dist) - t6 * dist;
        double factor = Math.log(dist / 100.0);
        if (factor > 0.0) {
            gnd -= (t5 - t4) * factor;
        }
        if (this.clampMean) {
            gnd = Utils.ceusMeanClip(period, gnd);
        }
        return gnd;
    }

    private double getStdDev(int iper) {
        return this.tsigma[iper];
    }

    @Override
    public DiscretizedFunc getExceedProbabilities(DiscretizedFunc imls) {
        return Utils.getExceedProbabilities(imls, this.getMean(), this.getStdDev(), this.clampStd, this.clamp[this.iper]);
    }

    public static void main(String[] args) {
    }
}

