/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.nshmp2.imr.impl;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import org.opensha.commons.data.Site;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.exceptions.ParameterException;
import org.opensha.commons.param.constraint.impl.DoubleDiscreteConstraint;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.event.ParameterChangeWarningListener;
import org.opensha.commons.param.impl.EnumParameter;
import org.opensha.nshmp2.util.Params;
import org.opensha.nshmp2.util.Utils;
import org.opensha.sha.earthquake.EqkRupture;
import org.opensha.sha.imr.AttenuationRelationship;
import org.opensha.sha.imr.param.EqkRuptureParams.MagParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.DampingParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.PGA_Param;
import org.opensha.sha.imr.param.IntensityMeasureParams.PeriodParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.SA_Param;
import org.opensha.sha.imr.param.PropagationEffectParams.DistanceRupParameter;
import org.opensha.sha.imr.param.SiteParams.Vs30_Param;
import org.opensha.sha.util.TectonicRegionType;

public class ZhaoEtAl_2006_AttenRel
extends AttenuationRelationship
implements ParameterChangeListener {
    public static final String NAME = "ZhaoEtAl (2006)";
    public static final String SHORT_NAME = "ZhaoEtAl2006";
    private static final long serialVersionUID = 1L;
    private static final double[] period = new double[]{0.0, 0.05, 0.1, 0.15, 0.2, 0.25, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0, 1.25, 1.5, 2.0, 2.5, 3.0, 4.0, 5.0};
    private static final double[] a = new double[]{1.101, 1.076, 1.118, 1.134, 1.147, 1.149, 1.163, 1.2, 1.25, 1.293, 1.336, 1.386, 1.433, 1.479, 1.551, 1.621, 1.694, 1.748, 1.759, 1.826, 1.825};
    private static final double[] b = new double[]{-0.00564, -0.00671, -0.00787, -0.00722, -0.00659, -0.0059, -0.0052, -0.00422, -0.00338, -0.00282, -0.00258, -0.00242, -0.00232, -0.0022, -0.00207, -0.00224, -0.00201, -0.00187, -0.00147, -0.00195, -0.00237};
    private static final double[] c = new double[]{0.0055, 0.0075, 0.009, 0.01, 0.012, 0.014, 0.015, 0.01, 0.006, 0.003, 0.0025, 0.0022, 0.002, 0.002, 0.002, 0.002, 0.0025, 0.0028, 0.0032, 0.004, 0.005};
    private static final double[] d = new double[]{1.07967, 1.05984, 1.08274, 1.05292, 1.0136, 0.96638, 0.93427, 0.9588, 1.00779, 1.08773, 1.08384, 1.08849, 1.1092, 1.11474, 1.08295, 1.09117, 1.05492, 1.05191, 1.02452, 1.04356, 1.06518};
    private static final double[] e = new double[]{0.01412, 0.01463, 0.01423, 0.01509, 0.01462, 0.01459, 0.01458, 0.01257, 0.01114, 0.01019, 0.00979, 0.00944, 0.00972, 0.01005, 0.01003, 0.00928, 0.00833, 0.00776, 0.00644, 0.0059, 0.0051};
    private static final double[] Si = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.0412, -0.0528, -0.1034, -0.146, -0.1638, -0.2062, -0.2393, -0.2557, -0.3065, -0.3214, -0.3366, -0.3306, -0.3898, -0.4978};
    private static final double[] C1 = new double[]{1.1111, 1.6845, 2.0609, 1.9165, 1.6688, 1.4683, 1.172, 0.6548, 0.0713, -0.4288, -0.8656, -1.325, -1.7322, -2.1522, -2.9226, -3.5476, -4.4102, -5.0492, -5.4307, -6.1813, -6.3471};
    private static final double[] C2 = new double[]{1.344, 1.793, 2.1346, 2.168, 2.0854, 1.9416, 1.6829, 1.1271, 0.5149, -0.0027, -0.4493, -0.9284, -1.349, -1.7757, -2.5422, -3.1689, -4.0387, -4.6979, -5.089, -5.8821, -6.0512};
    private static final double[] C3 = new double[]{1.3548, 1.7474, 2.0311, 2.0518, 2.0007, 1.9407, 1.8083, 1.4825, 0.9339, 0.3936, -0.1109, -0.62, -1.0665, -1.5228, -2.3272, -2.9789, -3.8714, -4.4963, -4.8932, -5.6981, -5.8733};
    private static final double[] sigma = new double[]{0.6039, 0.6399, 0.6936, 0.7017, 0.6917, 0.6823, 0.6696, 0.6589, 0.653, 0.6527, 0.6516, 0.6467, 0.6525, 0.657, 0.6601, 0.664, 0.6694, 0.6706, 0.6671, 0.6468, 0.6431};
    private static final double[] tau = new double[]{0.3976, 0.4437, 0.4903, 0.4603, 0.4233, 0.3908, 0.379, 0.3897, 0.389, 0.4014, 0.4079, 0.4183, 0.4106, 0.4101, 0.4021, 0.4076, 0.4138, 0.4108, 0.3961, 0.3821, 0.3766};
    private static final double[] Qi = new double[]{0.0, 0.0, 0.0, -0.0138, -0.0256, -0.0348, -0.0423, -0.0541, -0.0632, -0.0707, -0.0771, -0.0825, -0.0874, -0.0917, -0.1009, -0.1083, -0.1202, -0.1293, -0.1368, -0.1486, -0.1578};
    private static final double[] Wi = new double[]{0.0, 0.0, 0.0, 0.0286, 0.0352, 0.0403, 0.0445, 0.0511, 0.0562, 0.0604, 0.0639, 0.067, 0.0697, 0.0721, 0.0772, 0.0814, 0.088, 0.0931, 0.0972, 0.1038, 0.109};
    private HashMap<Double, Integer> indexFromPerHashMap;
    private int iper;
    private double mag;
    private double rRup;
    private double vs30;
    private TectonicRegionType subType;
    private EnumParameter<TectonicRegionType> subTypeParam;
    private transient ParameterChangeWarningListener warningListener = null;
    private static final double DEPTH = 20.0;
    private static final double HC = 15.0;
    private static final double MC = 6.3;
    private static final double GCOR = 6.88806;

    public ZhaoEtAl_2006_AttenRel(ParameterChangeWarningListener listener) {
        this.warningListener = listener;
        this.initSupportedIntensityMeasureParams();
        this.indexFromPerHashMap = new HashMap();
        for (int i = 0; i < period.length; ++i) {
            this.indexFromPerHashMap.put(period[i], i);
        }
        this.initEqkRuptureParams();
        this.initPropagationEffectParams();
        this.initSiteParams();
        this.initOtherParams();
        this.initIndependentParamLists();
        this.initParameterEventListeners();
        this.setParamDefaults();
    }

    @Override
    public void setEqkRupture(EqkRupture eqkRupture) {
        this.magParam.setValueIgnoreWarning(eqkRupture.getMag());
        this.eqkRupture = eqkRupture;
        this.setPropagationEffectParams();
    }

    @Override
    public void setSite(Site site) throws ParameterException {
        this.vs30Param.setValueIgnoreWarning((Double)site.getParameter("Vs30").getValue());
        this.site = site;
        this.setPropagationEffectParams();
    }

    @Override
    public void setPropagationEffectParams() {
        if (this.site != null && this.eqkRupture != null) {
            this.distanceRupParam.setValue(this.eqkRupture, this.site);
        }
    }

    private void setCoeffIndex() throws ParameterException {
        if (this.im == null) {
            throw new ParameterException("Intensity Measure Param not set");
        }
        this.iper = this.indexFromPerHashMap.get(this.saPeriodParam.getValue());
        this.intensityMeasureChanged = false;
    }

    @Override
    public double getMean() {
        if (this.rRup > this.USER_MAX_DISTANCE) {
            return -35.0;
        }
        if (this.intensityMeasureChanged) {
            this.setCoeffIndex();
        }
        return this.getMean(this.iper, this.mag, this.rRup, this.vs30);
    }

    @Override
    public double getStdDev() {
        if (this.intensityMeasureChanged) {
            this.setCoeffIndex();
        }
        return this.getStdDev(this.iper);
    }

    @Override
    public void setParamDefaults() {
        this.vs30Param.setValueAsDefault();
        this.subTypeParam.setValueAsDefault();
        this.magParam.setValueAsDefault();
        this.distanceRupParam.setValueAsDefault();
        this.saParam.setValueAsDefault();
        this.saPeriodParam.setValueAsDefault();
        this.saDampingParam.setValueAsDefault();
        this.pgaParam.setValueAsDefault();
        this.vs30 = (Double)this.vs30Param.getValue();
        this.subType = (TectonicRegionType)this.subTypeParam.getValue();
        this.mag = (Double)this.magParam.getValue();
        this.rRup = (Double)this.distanceRupParam.getValue();
    }

    protected void initIndependentParamLists() {
        this.meanIndependentParams.clear();
        this.meanIndependentParams.addParameter(this.magParam);
        this.meanIndependentParams.addParameter(this.vs30Param);
        this.meanIndependentParams.addParameter(this.distanceRupParam);
        this.meanIndependentParams.addParameter(this.subTypeParam);
        this.stdDevIndependentParams.clear();
        this.stdDevIndependentParams.addParameter(this.saPeriodParam);
        this.stdDevIndependentParams.addParameter(this.magParam);
        this.exceedProbIndependentParams.clear();
        this.exceedProbIndependentParams.addParameterList(this.meanIndependentParams);
        this.exceedProbIndependentParams.addParameter(this.sigmaTruncTypeParam);
        this.exceedProbIndependentParams.addParameter(this.sigmaTruncLevelParam);
        this.imlAtExceedProbIndependentParams.addParameterList(this.exceedProbIndependentParams);
        this.imlAtExceedProbIndependentParams.addParameter(this.exceedProbParam);
    }

    @Override
    protected void initSiteParams() {
        this.vs30Param = new Vs30_Param(150.0, 1500.0);
        this.siteParams.clear();
        this.siteParams.addParameter(this.vs30Param);
    }

    @Override
    protected void initEqkRuptureParams() {
        this.magParam = new MagParam(7.5);
        this.eqkRuptureParams.clear();
        this.eqkRuptureParams.addParameter(this.magParam);
    }

    @Override
    protected void initPropagationEffectParams() {
        this.distanceRupParam = new DistanceRupParameter(0.0);
        this.distanceRupParam.addParameterChangeWarningListener(this.listener);
        this.distanceRupParam.setNonEditable();
        this.propagationEffectParams.addParameter(this.distanceRupParam);
    }

    @Override
    protected void initSupportedIntensityMeasureParams() {
        DoubleDiscreteConstraint periodConstraint = new DoubleDiscreteConstraint();
        for (int i = 0; i < period.length; ++i) {
            periodConstraint.addDouble((Double)period[i]);
        }
        periodConstraint.setNonEditable();
        this.saPeriodParam = new PeriodParam(periodConstraint);
        this.saDampingParam = new DampingParam();
        this.saParam = new SA_Param(this.saPeriodParam, this.saDampingParam);
        this.saParam.setNonEditable();
        this.pgaParam = new PGA_Param();
        this.pgaParam.setNonEditable();
        this.saParam.addParameterChangeWarningListener(this.warningListener);
        this.pgaParam.addParameterChangeWarningListener(this.warningListener);
        this.supportedIMParams.clear();
        this.supportedIMParams.addParameter(this.saParam);
        this.supportedIMParams.addParameter(this.pgaParam);
    }

    @Override
    protected void initOtherParams() {
        super.initOtherParams();
        this.subTypeParam = Params.createSubType();
        this.otherParams.addParameter(this.subTypeParam);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getShortName() {
        return SHORT_NAME;
    }

    @Override
    public DiscretizedFunc getExceedProbabilities(DiscretizedFunc imls) {
        return Utils.getExceedProbabilities(imls, this.getMean(), this.getStdDev(), false, 0.0);
    }

    public double getMean(int iper, double mag, double rRup, double vs30) {
        double site = vs30 > 599.0 ? C1[iper] : (vs30 > 299.0 ? C2[iper] : C3[iper]);
        double afac = Si[iper];
        double hfac = 5.0;
        double m2 = mag - 6.3;
        double xmcor = Qi[iper] * m2 * m2 + Wi[iper];
        double r = rRup + c[iper] * Math.exp(d[iper] * mag);
        double gnd = a[iper] * mag + b[iper] * rRup - Math.log(r) + site;
        gnd = gnd + e[iper] * hfac + afac;
        gnd += xmcor;
        return gnd -= 6.88806;
    }

    public double getStdDev(int iper) {
        return Math.sqrt(tau[iper] * tau[iper] + sigma[iper] * sigma[iper]);
    }

    @Override
    public void parameterChange(ParameterChangeEvent e) {
        String pName = e.getParameterName();
        Object val = e.getNewValue();
        if (pName.equals("DistanceRup")) {
            this.rRup = (Double)val;
        } else if (pName.equals("Magnitude")) {
            this.mag = (Double)val;
        } else if (pName.equals("Vs30")) {
            this.vs30 = (Double)val;
        } else if (pName.equals("SA Period")) {
            this.intensityMeasureChanged = true;
        } else if (pName.equals(this.subTypeParam.getName())) {
            this.subType = (TectonicRegionType)val;
        }
    }

    @Override
    public void resetParameterEventListeners() {
        this.distanceRupParam.removeParameterChangeListener(this);
        this.vs30Param.removeParameterChangeListener(this);
        this.magParam.removeParameterChangeListener(this);
        this.saPeriodParam.removeParameterChangeListener(this);
        this.subTypeParam.removeParameterChangeListener(this);
        this.initParameterEventListeners();
    }

    @Override
    protected void initParameterEventListeners() {
        this.distanceRupParam.addParameterChangeListener(this);
        this.vs30Param.addParameterChangeListener(this);
        this.magParam.addParameterChangeListener(this);
        this.saPeriodParam.addParameterChangeListener(this);
        this.subTypeParam.addParameterChangeListener(this);
    }

    @Override
    public URL getInfoURL() throws MalformedURLException {
        return new URL("http://www.opensha.org/documentation/modelsImplemented/attenRel/ZhaoEtAl_2006.html");
    }
}

