/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.nshmp2.tmp;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Closeables;
import com.google.common.io.Files;
import com.google.common.io.Flushables;
import java.awt.geom.Point2D;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.Flushable;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.commons.io.IOUtils;
import org.opensha.commons.data.Site;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.nshmp2.calc.HazardResult;
import org.opensha.nshmp2.erf.NSHMP_ListERF;
import org.opensha.nshmp2.erf.source.ClusterERF;
import org.opensha.nshmp2.erf.source.ClusterSource;
import org.opensha.nshmp2.erf.source.FaultSource;
import org.opensha.nshmp2.erf.source.GridERF;
import org.opensha.nshmp2.erf.source.NSHMP_ERF;
import org.opensha.nshmp2.imr.NSHMP08_CEUS_Grid;
import org.opensha.nshmp2.imr.NSHMP08_SUB_SlabGrid;
import org.opensha.nshmp2.imr.NSHMP08_WUS;
import org.opensha.nshmp2.imr.NSHMP08_WUS_Grid;
import org.opensha.nshmp2.util.NSHMP_Utils;
import org.opensha.nshmp2.util.Period;
import org.opensha.nshmp2.util.SiteTypeParam;
import org.opensha.nshmp2.util.SourceIMR;
import org.opensha.nshmp2.util.SourceType;
import org.opensha.nshmp2.util.Utils;
import org.opensha.sha.earthquake.ERF;
import org.opensha.sha.earthquake.EpistemicListERF;
import org.opensha.sha.imr.ScalarIMR;
import org.opensha.sha.imr.param.SiteParams.DepthTo1pt0kmPerSecParam;
import org.opensha.sha.imr.param.SiteParams.DepthTo2pt5kmPerSecParam;
import org.opensha.sha.imr.param.SiteParams.Vs30_Param;
import org.opensha.sha.imr.param.SiteParams.Vs30_TypeParam;
import org.opensha.sha.util.FocalMech;
import scratch.peter.nshmp.DeterministicResult;
import scratch.peter.nshmp.HazardCurveCalculatorNSHMP;

public class JordanMadridHazardCalc
implements Callable<HazardResult> {
    private EpistemicListERF erfList;
    private SourceIMR imrRef;
    private Site site;
    private Period period;
    private boolean epiUncert;
    private DiscretizedFunc curve;
    private boolean determ = false;
    private DeterministicResult detData = null;
    private HazardCurveCalculatorNSHMP calc;
    private ResWriter resWriter;
    public static DiscretizedFunc dfAB = null;
    public static DiscretizedFunc dfJ = null;
    private Map<String, DiscretizedFunc> map750 = Maps.newHashMap();
    public static final String PATH = "tmp/forJordan/Memphis/Memphis_tmp.csv";
    private static final Joiner J = Joiner.on((char)',').useForNull(" ");

    private JordanMadridHazardCalc() {
        this.resWriter = new ResWriter();
    }

    public static JordanMadridHazardCalc create(EpistemicListERF erfList, Site site, Period period, boolean epiUncert) {
        JordanMadridHazardCalc hc = new JordanMadridHazardCalc();
        hc.erfList = erfList;
        hc.site = site;
        hc.period = period;
        hc.epiUncert = epiUncert;
        hc.resWriter.writeHeader(period);
        return hc;
    }

    public static JordanMadridHazardCalc create(EpistemicListERF erfList, SourceIMR imrRef, Site site, Period period, boolean epiUncert, boolean determ) {
        JordanMadridHazardCalc hc = new JordanMadridHazardCalc();
        hc.erfList = erfList;
        hc.site = site;
        hc.period = period;
        hc.epiUncert = epiUncert;
        hc.imrRef = imrRef;
        hc.determ = determ;
        return hc;
    }

    @Override
    public HazardResult call() {
        JordanMadridHazardCalc.initSite(this.site);
        this.curve = this.period.getFunction();
        Utils.zeroFunc(this.curve);
        this.calc = new HazardCurveCalculatorNSHMP();
        if (this.erfList instanceof NSHMP_ListERF) {
            this.callNSHMP((NSHMP_ListERF)this.erfList);
        } else {
            this.callCalc();
        }
        try {
            this.resWriter.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return new HazardResult(this.period, this.site.getLocation(), this.curve, this.detData);
    }

    private void callCalc() {
        ScalarIMR imr = this.imrRef != null ? this.imrRef.instance(this.period) : SourceIMR.WUS_FAULT_14.instance(this.period);
        imr.getParameter("IMR uncertainty").setValue(this.epiUncert);
        imr.setSite(this.site);
        DiscretizedFunc f = this.period.getFunction();
        if (this.determ) {
            this.detData = new DeterministicResult();
        }
        for (int i = 0; i < this.erfList.getNumERFs(); ++i) {
            ERF erf = this.erfList.getERF(i);
            f = this.basicCalc(this.calc, f, this.site, imr, erf, this.detData, null);
            f.scale(this.erfList.getERF_RelativeWeight(i));
            Utils.addFunc(this.curve, f);
        }
    }

    private void callNSHMP(NSHMP_ListERF erfList) {
        Map<SourceIMR, ScalarIMR> imrMap = SourceIMR.map(this.period);
        for (ScalarIMR imr : imrMap.values()) {
            imr.setSite(this.site);
            if (!(imr instanceof NSHMP08_WUS)) continue;
            imr.getParameter("IMR uncertainty").setValue(this.epiUncert);
        }
        DiscretizedFunc f = this.period.getFunction();
        for (NSHMP_ERF erf : erfList.asFilteredIterable(this.site.getLocation())) {
            ScalarIMR imr = imrMap.get((Object)erf.getSourceIMR());
            SourceType st = erf.getSourceType();
            if (st == SourceType.GRIDDED) {
                JordanMadridHazardCalc.initGridIMR(imr, (GridERF)erf);
            }
            if (st == SourceType.CLUSTER) {
                f = this.clusterCalc(f, this.site, imr, (ClusterERF)erf);
            } else {
                this.calc.getAdjustableParams().getParameter("Maximum Distance").setValue(erf.getMaxDistance());
                f = this.basicCalc(this.calc, f, this.site, imr, erf, null, this.resWriter);
                if (erf.getName().contains("all8.AB")) {
                    dfAB = f.deepClone();
                }
                if (erf.getName().contains("all8.J")) {
                    dfJ = f.deepClone();
                }
            }
            f.scale(erf.getSourceWeight());
            Utils.addFunc(this.curve, f);
        }
    }

    private static void initGridIMR(ScalarIMR imr, final GridERF erf) {
        if (imr instanceof NSHMP08_CEUS_Grid) {
            NSHMP08_CEUS_Grid ceusIMR = (NSHMP08_CEUS_Grid)imr;
            ceusIMR.setTable(erf.getFaultCode());
        } else if (imr instanceof NSHMP08_WUS_Grid) {
            NSHMP08_WUS_Grid wusIMR = (NSHMP08_WUS_Grid)imr;
            Map<FocalMech, Double> mechMap = erf.getFocalMechs();
            double sWt = mechMap.get((Object)FocalMech.STRIKE_SLIP);
            double rWt = mechMap.get((Object)FocalMech.REVERSE);
            double nWt = mechMap.get((Object)FocalMech.NORMAL);
            String fltType = rWt > 0.0 ? "Reverse" : (nWt > 0.0 ? "Normal" : "Strike-Slip");
            wusIMR.getParameter("Fault Type").setValue(fltType);
            wusIMR.setGridHybrid(sWt > 0.0 && sWt < 1.0);
            Function<Double, Double> func = new Function<Double, Double>(){
                double[] depths;
                {
                    this.depths = erf.getDepths();
                }

                public Double apply(Double mag) {
                    return mag < 6.5 ? this.depths[0] : this.depths[1];
                }
            };
            wusIMR.setTable(func);
        } else if (imr instanceof NSHMP08_SUB_SlabGrid) {
            NSHMP08_SUB_SlabGrid slabIMR = (NSHMP08_SUB_SlabGrid)imr;
            slabIMR.getParameter("Rupture Top Depth").setValue(erf.getDepths()[0]);
            slabIMR.setTable();
        }
    }

    private DiscretizedFunc basicCalc(HazardCurveCalculatorNSHMP c, DiscretizedFunc f, Site s, ScalarIMR imr, ERF erf, DeterministicResult detResult, ResWriter resWriter) {
        c.getHazardCurve(f, s, imr, erf, detResult, resWriter);
        for (Point2D p : f) {
            f.set(p.getX(), NSHMP_Utils.probToRate(p.getY(), 1.0));
        }
        return f;
    }

    private DiscretizedFunc clusterCalc(DiscretizedFunc f, Site s, ScalarIMR imr, ClusterERF erf) {
        double maxDistance = erf.getMaxDistance();
        Utils.zeroFunc(f);
        DiscretizedFunc peFunc = f.deepClone();
        for (ClusterSource cs : erf.getSources()) {
            double dist = cs.getMinDistance(s);
            if (dist > maxDistance) continue;
            ArrayList fltFuncList = Lists.newArrayList();
            for (FaultSource fs : cs.getFaultSources()) {
                DiscretizedFunc fltFunc = peFunc.deepClone();
                Utils.zeroFunc(fltFunc);
                for (int i = 0; i < fs.getNumRuptures(); ++i) {
                    imr.setEqkRupture(fs.getRupture(i));
                    imr.getExceedProbabilities(peFunc);
                    double weight = fs.getMFDs().get(i).getY(0) * cs.getRate();
                    peFunc.scale(weight);
                    Utils.addFunc(fltFunc, peFunc);
                }
                fltFuncList.add(fltFunc);
            }
            DiscretizedFunc fOut = JordanMadridHazardCalc.calcClusterExceedProb(fltFuncList);
            double csWeight = cs.getWeight();
            double csRate = 1.0 / cs.getRate();
            fOut.scale(csRate);
            if (cs.getRate() == 750.0) {
                this.map750.put(cs.getName(), fOut.deepClone());
            } else {
                String id1 = cs.getName() + " " + cs.getRate() + " bgAB";
                double outWt = csWeight * erf.getSourceWeight() * 0.5;
                DiscretizedFunc f1 = fOut.deepClone();
                if (cs.getRate() == 1500.0) {
                    JordanMadridHazardCalc.addFuncs(f1, this.map750.get(cs.getName()));
                }
                JordanMadridHazardCalc.addFuncs(f1, dfAB);
                this.resWriter.writeCurve(id1, outWt, f1);
                String id2 = cs.getName() + " " + cs.getRate() + " bgJ";
                DiscretizedFunc f2 = fOut.deepClone();
                if (cs.getRate() == 1500.0) {
                    JordanMadridHazardCalc.addFuncs(f2, this.map750.get(cs.getName()));
                }
                JordanMadridHazardCalc.addFuncs(f2, dfJ);
                this.resWriter.writeCurve(id2, outWt, f2);
            }
            fOut.scale(csWeight);
            Utils.addFunc(f, fOut);
        }
        return f;
    }

    public static void addFuncs(DiscretizedFunc f1, DiscretizedFunc f2) {
        for (int i = 0; i < f1.size(); ++i) {
            f1.set(i, f1.getY(i) + f2.getY(i));
        }
    }

    private static DiscretizedFunc calcClusterExceedProb(List<DiscretizedFunc> fList) {
        DiscretizedFunc firstFunc = fList.get(0);
        for (int i = 0; i < fList.size(); ++i) {
            DiscretizedFunc f = fList.get(i);
            Utils.complementFunc(f);
            if (i == 0) continue;
            Utils.multiplyFunc(firstFunc, f);
        }
        Utils.complementFunc(firstFunc);
        return firstFunc;
    }

    public static void initSite(Site s) {
        DepthTo1pt0kmPerSecParam d10p = new DepthTo1pt0kmPerSecParam(null, 0.0, 1000.0, true);
        d10p.setValueAsDefault();
        s.addParameter(d10p);
        DepthTo2pt5kmPerSecParam d25p = new DepthTo2pt5kmPerSecParam(null, 0.0, 1000.0, true);
        d25p.setValueAsDefault();
        s.addParameter(d25p);
        Vs30_Param vs30p = new Vs30_Param(760.0);
        vs30p.setValueAsDefault();
        s.addParameter(vs30p);
        Vs30_TypeParam vs30tp = new Vs30_TypeParam();
        vs30tp.setValueAsDefault();
        s.addParameter(vs30tp);
        SiteTypeParam siteTypeParam = new SiteTypeParam();
        s.addParameter(siteTypeParam);
    }

    private static void throwCalcException(Exception e, int srcIdx, int rupIdx, ERF erf, ScalarIMR imr, Site s, DiscretizedFunc f) {
        StringBuffer sb = new StringBuffer();
        sb.append("Calculator error in: ");
        sb.append("Source [").append(srcIdx).append("] ");
        sb.append("Rupture [").append(rupIdx).append("]");
        sb.append(IOUtils.LINE_SEPARATOR);
        sb.append("  ERF: " + erf.getName());
        sb.append(IOUtils.LINE_SEPARATOR);
        sb.append("  IMR: " + imr.getName());
        sb.append(IOUtils.LINE_SEPARATOR);
        sb.append("  Site: " + String.valueOf(s));
        sb.append(IOUtils.LINE_SEPARATOR);
        sb.append("  Curve: " + String.valueOf(f));
        sb.append(IOUtils.LINE_SEPARATOR);
        System.err.println(sb.toString());
        Throwables.propagate((Throwable)e);
    }

    public static class ResWriter {
        private BufferedWriter writer;

        ResWriter() {
            try {
                File out = new File(JordanMadridHazardCalc.PATH);
                Files.createParentDirs((File)out);
                this.writer = Files.newWriter((File)out, (Charset)Charsets.US_ASCII);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }

        private void writeHeader(Period p) {
            try {
                ArrayList headerVals = Lists.newArrayList();
                headerVals.add("id");
                headerVals.add("weight");
                for (Double d : p.getIMLs()) {
                    headerVals.add(d.toString());
                }
                this.writer.write(J.join((Iterable)headerVals));
                this.writer.newLine();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }

        public void writeCurve(String id, double weight, DiscretizedFunc curve) {
            try {
                String resultStr = ResWriter.formatCurve(id, weight, curve);
                this.writer.write(resultStr);
                this.writer.newLine();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }

        private static String formatCurve(String id, double weight, DiscretizedFunc curve) {
            ArrayList dat = Lists.newArrayList();
            dat.add(id);
            dat.add(String.format("%.8f", weight));
            for (Point2D p : curve) {
                dat.add(String.format("%.8g", p.getY()));
            }
            return J.join((Iterable)dat);
        }

        public void close() throws IOException {
            Flushables.flushQuietly((Flushable)this.writer);
            Closeables.close((Closeable)this.writer, (boolean)true);
        }
    }
}

