/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.nshmp2.util;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.io.Resources;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.opensha.nshmp2.util.Utils;

public class NSHMP_IMR_Util {
    private static Map<Integer, Map<Integer, Double>> rjb_map;
    private static Map<Integer, Map<Integer, Map<Integer, Double>>> cbhw_map;
    private static Map<Integer, Map<Integer, Map<Integer, Double>>> cyhw_map;
    private static String rjbDatPath;
    private static String cbhwDatPath;
    private static String cyhwDatPath;

    private static void readRjbDat() {
        String magID = "#Mag";
        try {
            URL url = Utils.getResource(rjbDatPath);
            List lines = Resources.readLines((URL)url, (Charset)Charsets.US_ASCII);
            HashMap<Integer, Double> magMap = null;
            for (String line : lines) {
                String[] dVal;
                if (line.startsWith(magID)) {
                    double mag = Double.parseDouble(line.substring(magID.length() + 1).trim());
                    int magKey = Double.valueOf(mag * 100.0).intValue();
                    magMap = new HashMap<Integer, Double>();
                    rjb_map.put(magKey, magMap);
                    continue;
                }
                if (line.startsWith("#") || (dVal = StringUtils.split((String)line)).length == 0) continue;
                int distKey = Double.valueOf(dVal[0]).intValue();
                magMap.put(distKey, Double.parseDouble(dVal[1]));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void readHwDat(Map<Integer, Map<Integer, Map<Integer, Double>>> map, String path, double startMag) {
        try {
            URL url = Utils.getResource(path);
            List lines = Resources.readLines((URL)url, (Charset)Charsets.US_ASCII);
            HashMap<Integer, HashMap<Integer, Double>> periodMap = null;
            for (String line : lines) {
                if (line.startsWith("C")) {
                    double per = Double.parseDouble(StringUtils.split((String)line)[4]);
                    int perKey = (int)(per * 1000.0);
                    periodMap = new HashMap<Integer, HashMap<Integer, Double>>();
                    map.put(perKey, periodMap);
                    continue;
                }
                String[] values = StringUtils.split((String)line);
                if (values.length == 0) continue;
                int distKey = Integer.parseInt(values[0]);
                int magIdx = Integer.parseInt(values[1]);
                int magKey = (int)(startMag * 100.0) + (magIdx - 1) * 10;
                double hwVal = Double.parseDouble(values[2]);
                HashMap<Integer, Double> magMap = (HashMap<Integer, Double>)periodMap.get(magKey);
                if (magMap == null) {
                    magMap = new HashMap<Integer, Double>();
                    periodMap.put(magKey, magMap);
                }
                magMap.put(distKey, hwVal);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static double getMeanRJB(double M, double D) {
        Preconditions.checkArgument((M >= 6.0 ? 1 : 0) != 0, (String)"Supplied M is too small [%s]", (Object)M);
        int magIdx = Math.max(0, (int)Math.round((M - 6.05) / 0.1));
        magIdx = Math.min(15, magIdx);
        int magKey = 605 + magIdx * 10;
        int distKey = (int)Math.floor(D);
        return D <= 1000.0 ? rjb_map.get(magKey).get(distKey) : D;
    }

    public static double getAvgHW_CB(double M, double D, double P) {
        return NSHMP_IMR_Util.getAvgHW(cbhw_map, M, D, P);
    }

    public static double getAvgHW_CY(double M, double D, double P) {
        return NSHMP_IMR_Util.getAvgHW(cyhw_map, M, D, P);
    }

    private static double getAvgHW(Map<Integer, Map<Integer, Map<Integer, Double>>> map, double M, double D, double P) {
        int perKey = (int)(P * 1000.0);
        Preconditions.checkArgument((boolean)map.containsKey(perKey), (Object)("Invalid period: " + P));
        Map<Integer, Map<Integer, Double>> magMap = map.get(perKey);
        int magKey = Double.valueOf(M * 100.0).intValue();
        if (!magMap.containsKey(magKey)) {
            return 0.0;
        }
        int distKey = Double.valueOf(Math.floor(D)).intValue();
        return distKey > 200 ? 0.0 : magMap.get(magKey).get(distKey);
    }

    public static void main(String[] args) {
    }

    static {
        rjbDatPath = "/rjbmean.dat";
        cbhwDatPath = "/avghw_cb.dat";
        cyhwDatPath = "/avghw_cy.dat";
        rjb_map = new HashMap<Integer, Map<Integer, Double>>();
        cbhw_map = new HashMap<Integer, Map<Integer, Map<Integer, Double>>>();
        cyhw_map = new HashMap<Integer, Map<Integer, Map<Integer, Double>>>();
        NSHMP_IMR_Util.readRjbDat();
        NSHMP_IMR_Util.readHwDat(cbhw_map, cbhwDatPath, 6.05);
        NSHMP_IMR_Util.readHwDat(cyhw_map, cyhwDatPath, 5.05);
    }
}

