/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.nshmp2.util;

import com.google.common.collect.Lists;
import com.google.common.io.LittleEndianDataInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.opensha.commons.data.region.CaliforniaRegions;
import org.opensha.commons.eq.MagUtils;
import org.opensha.commons.geo.BorderType;
import org.opensha.commons.geo.GriddedRegion;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.commons.geo.LocationVector;
import org.opensha.commons.geo.Region;
import org.opensha.nshmp2.util.Utils;

public class NSHMP_Utils {
    public static final String WARN_INDENT = "          ";
    public static final String CONF_DIR = "/data/nshmp/sources/";
    private static Logger log;

    public static List<String> readLines(Iterator<String> it, int n) {
        ArrayList<String> lineSet = new ArrayList<String>();
        for (int i = 0; i < n; ++i) {
            lineSet.add(it.next());
        }
        return lineSet;
    }

    public static int readInt(String line, int pos) {
        return NSHMP_Utils.readInt(StringUtils.split((String)line), pos);
    }

    public static int readInt(String[] vals, int pos) {
        return Integer.parseInt(vals[pos]);
    }

    public static int[] readInts(String line, int n) {
        String[] dat = StringUtils.split((String)line);
        int[] vals = new int[n];
        for (int i = 0; i < n; ++i) {
            vals[i] = Integer.parseInt(dat[i]);
        }
        return vals;
    }

    public static double readDouble(String line, int pos) {
        return NSHMP_Utils.readDouble(StringUtils.split((String)line), pos);
    }

    public static double readDouble(String[] vals, int pos) {
        return Double.parseDouble(vals[pos]);
    }

    public static double[] readDoubles(String line, int n) {
        String[] dat = StringUtils.split((String)line);
        double[] vals = new double[n];
        for (int i = 0; i < n; ++i) {
            vals[i] = Double.parseDouble(dat[i]);
        }
        return vals;
    }

    public static double totalMoRate(double mMin, int nMag, double dMag, double a, double b) {
        double moRate = 1.0E-10;
        for (int i = 0; i < nMag; ++i) {
            double M = mMin + (double)i * dMag;
            moRate += MagUtils.gr_rate(a, b, M) * MagUtils.magToMoment(M);
        }
        return moRate;
    }

    public static double incrRate(double a, double b, double mMin) {
        return a * Math.pow(10.0, -b * mMin);
    }

    public static Logger logger() {
        if (log != null) {
            return log;
        }
        log = Logger.getLogger("org.opensha.sha.nshmp");
        log.setLevel(Level.WARNING);
        log.setUseParentHandlers(false);
        Formatter cf = new Formatter(){

            @Override
            public String format(LogRecord lr) {
                StringBuilder b = new StringBuilder();
                Level l = lr.getLevel();
                b.append("[").append(l).append("]");
                if (l == Level.SEVERE || l == Level.WARNING) {
                    b.append(" ").append(lr.getMessage()).append(IOUtils.LINE_SEPARATOR).append(NSHMP_Utils.WARN_INDENT).append(lr.getSourceClassName()).append(": ").append(lr.getSourceMethodName()).append("()").append(IOUtils.LINE_SEPARATOR);
                    if (lr.getThrown() != null) {
                        b.append(lr.getThrown());
                    }
                } else {
                    b.append(" ").append(lr.getMessage());
                }
                b.append(IOUtils.LINE_SEPARATOR);
                return b.toString();
            }
        };
        ConsoleHandler ch = new ConsoleHandler();
        ch.setFormatter(cf);
        ch.setLevel(log.getLevel());
        log.addHandler(ch);
        return log;
    }

    public static double[] readGrid(URL url, int nRows, int nCols) {
        int count = nRows * nCols;
        double[] data = new double[count];
        try {
            LittleEndianDataInputStream in = new LittleEndianDataInputStream(url.openStream());
            for (int i = 0; i < count; ++i) {
                double value;
                data[NSHMP_Utils.calcIndex((int)i, (int)nRows, (int)nCols)] = value = Float.valueOf(in.readFloat()).doubleValue();
            }
            in.close();
        }
        catch (IOException ioe) {
            System.out.println(ioe);
        }
        return data;
    }

    public static boolean[] readBoolGrid(URL url, int nRows, int nCols) {
        int count = nRows * nCols;
        boolean[] data = new boolean[count];
        try {
            DataInputStream in = new DataInputStream(url.openStream());
            in.skipBytes(4);
            for (int i = 0; i < count; ++i) {
                int iCor = NSHMP_Utils.calcIndex(i, nRows, nCols);
                data[iCor] = in.readByte() != 0;
                in.skipBytes(3);
            }
            in.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return data;
    }

    private static int calcIndex(int idx, int nRows, int nCols) {
        return (nRows - idx / nCols - 1) * nCols + idx % nCols;
    }

    public static double rateToProb(double rate, double time) {
        return 1.0 - Math.exp(-rate * time);
    }

    public static double probToRate(double P, double time) {
        return -Math.log(1.0 - P) / time;
    }

    public static void main(String[] args) {
        NSHMP_Utils.generateUCERF2pdf();
    }

    private static void generateUCERF2pdf() {
        double minLat = 24.6;
        double maxLat = 50.0;
        double dLat = 0.1;
        double minLon = -125.0;
        double maxLon = -100.0;
        double dLon = 0.1;
        GriddedRegion gridRegion = new GriddedRegion(new Location(minLat, minLon), new Location(maxLat, maxLon), dLat, GriddedRegion.ANCHOR_0_0);
        CaliforniaRegions.RELM_TESTING_GRIDDED ucerfRegion = new CaliforniaRegions.RELM_TESTING_GRIDDED();
        int nRows = (int)Math.rint((maxLat - minLat) / dLat) + 1;
        int nCols = (int)Math.rint((maxLon - minLon) / dLon) + 1;
        ArrayList gridNames = Lists.newArrayList();
        gridNames.add("CA/gridded/GR_DOS/agrd_brawly.out");
        gridNames.add("CA/gridded/GR_DOS/agrd_mendos.out");
        gridNames.add("CA/gridded/GR_DOS/agrd_creeps.out");
        gridNames.add("CA/gridded/GR_DOS/agrd_deeps.out");
        gridNames.add("CA/gridded/GR_DOS/agrd_impext.out");
        gridNames.add("CA/gridded/GR_DOS/agrd_cstcal.out");
        gridNames.add("WUS/gridded/GR_DOS/agrd_wuscmp.out");
        gridNames.add("WUS/gridded/GR_DOS/agrd_wusext.out");
        double[] gridSum = null;
        for (String gridName : gridNames) {
            URL gridURL = Utils.getResource("/sources/" + gridName);
            double[] aDat = NSHMP_Utils.readGrid(gridURL, nRows, nCols);
            if (gridSum == null) {
                gridSum = aDat;
                continue;
            }
            NSHMP_Utils.addArray(gridSum, aDat);
        }
        double regionSum = 0.0;
        for (Object loc : ucerfRegion) {
            int idx = gridRegion.indexForLocation((Location)loc);
            regionSum += idx == -1 ? 0.0 : gridSum[idx];
        }
        ArrayList records = Lists.newArrayList();
        for (Location loc : ucerfRegion) {
            int idx = gridRegion.indexForLocation(loc);
            double value = idx == -1 ? 0.0 : gridSum[idx] / regionSum;
            records.add(String.format("%.3f %.3f %.10f", loc.getLatitude(), loc.getLongitude(), value));
        }
        File dir = new File("tmp");
        File out = new File(dir, "SmoothSeis_UCERF2.txt");
        try {
            FileUtils.writeLines((File)out, (Collection)records);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private static void addArray(double[] a1, double[] a2) {
        for (int i = 0; i < a1.length; ++i) {
            int n = i;
            a1[n] = a1[n] + a2[i];
        }
    }

    public static Region createBounds(LocationList locs, double buffer) {
        double minLat = LocationUtils.calcMinLat(locs);
        double maxLat = LocationUtils.calcMaxLat(locs);
        double minLon = LocationUtils.calcMinLon(locs);
        double maxLon = LocationUtils.calcMaxLon(locs);
        return NSHMP_Utils.creatBounds(minLat, maxLat, minLon, maxLon, buffer);
    }

    public static Region creatBounds(double minLat, double maxLat, double minLon, double maxLon, double buffer) {
        Location isw = new Location(minLat, minLon);
        Location ise = new Location(minLat, maxLon);
        Location inw = new Location(maxLat, minLon);
        Location ine = new Location(maxLat, maxLon);
        LocationVector v = new LocationVector(90.0, buffer, 0.0);
        Location seEdge = LocationUtils.location(ise, v);
        Location neEdge = LocationUtils.location(ine, v);
        v.reverse();
        Location swEdge = LocationUtils.location(isw, v);
        Location nwEdge = LocationUtils.location(inw, v);
        v.setAzimuth(LocationUtils.azimuth(seEdge, neEdge));
        v.reverse();
        Location ose = LocationUtils.location(seEdge, v);
        v.setAzimuth(LocationUtils.azimuth(neEdge, seEdge));
        v.reverse();
        Location one = LocationUtils.location(neEdge, v);
        v.setAzimuth(LocationUtils.azimuth(swEdge, nwEdge));
        v.reverse();
        Location osw = LocationUtils.location(swEdge, v);
        v.setAzimuth(LocationUtils.azimuth(nwEdge, swEdge));
        v.reverse();
        Location onw = LocationUtils.location(nwEdge, v);
        LocationList corners = new LocationList();
        corners.addAll(Lists.newArrayList((Object[])new Location[]{onw, one, ose, osw}));
        return new Region(corners, BorderType.MERCATOR_LINEAR);
    }
}

