/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.nshmp2.util;

import com.google.common.primitives.Doubles;
import java.awt.Color;
import java.net.URL;
import java.util.List;
import java.util.Random;
import org.apache.commons.math3.special.Erf;
import org.opensha.commons.calc.GaussianDistCalc;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.nshmp2.util.FaultCode;
import org.opensha.nshmp2.util.GaussTruncation;
import org.opensha.nshmp2.util.Period;

public class Utils {
    public static final double LOG_BASE_10_TO_E = 2.302587647998821;
    public static final double SQRT_2 = Math.sqrt(2.0);
    private static double[][] imrUncertVals = new double[][]{{0.375, 0.21, 0.245}, {0.23, 0.225, 0.23}, {0.4, 0.36, 0.31}};
    public static final String NSHMP_DAT_PATH = "/data/nshmp";

    public static double mblgToMw(FaultCode code, double mag) {
        switch (code) {
            case M_CONV_J: {
                return 1.14 + 0.24 * mag + 0.0933 * mag * mag;
            }
            case M_CONV_AB: {
                return 2.715 - 0.277 * mag + 0.127 * mag * mag;
            }
        }
        return mag;
    }

    public static double ceusMeanClip(double period, double gnd) {
        if (period == 0.0) {
            return Math.min(0.405, gnd);
        }
        if (period > 0.02 && period < 0.5) {
            return Math.min(gnd, 1.099);
        }
        return gnd;
    }

    public static double ceusTailClip(double period, double gnd) {
        if (period == 0.0) {
            return Math.min(1.09861229, gnd);
        }
        if (period > 0.0 && period < 0.75) {
            return Math.min(gnd, 1.79175947);
        }
        return gnd;
    }

    public static double gmUncertainty(double M, double D) {
        int mi;
        int n = M < 6.0 ? 0 : (mi = M < 7.0 ? 1 : 2);
        int di = D < 10.0 ? 0 : (D < 30.0 ? 1 : 2);
        return imrUncertVals[di][mi];
    }

    public static double getExceedProbability1(double mean, double std, double iml, GaussTruncation trunc, double level) {
        if (std == 0.0) {
            return iml > mean ? 0.0 : 1.0;
        }
        double stRndVar = (iml - mean) / std;
        switch (trunc) {
            case NONE: {
                return GaussianDistCalc.getExceedProb(stRndVar);
            }
            case ONE_SIDED: {
                return GaussianDistCalc.getExceedProb(stRndVar, 1, level);
            }
            case TWO_SIDED: {
                return GaussianDistCalc.getExceedProb(stRndVar, 2, level);
            }
        }
        return Double.NaN;
    }

    public static double gaussProbExceed(double mean, double std, double value, double trunc, GaussTruncation type) {
        double P = Utils.gaussProbExceed(mean, std, value);
        if (type == GaussTruncation.ONE_SIDED) {
            P = (P - trunc) / (1.0 - trunc);
            return Utils.probBoundsCheck(P);
        }
        if (type == GaussTruncation.TWO_SIDED) {
            P = (P - trunc) / (1.0 - 2.0 * trunc);
            return Utils.probBoundsCheck(P);
        }
        return P;
    }

    private static double probBoundsCheck(double P) {
        return P < 0.0 ? 0.0 : (P > 1.0 ? 1.0 : P);
    }

    public static double gaussProbExceed(double mean, double std, double value) {
        return (Erf.erf((double)((mean - value) / (std * SQRT_2))) + 1.0) * 0.5;
    }

    public static URL getResource(String path) {
        String fullPath = NSHMP_DAT_PATH + path;
        return Utils.class.getResource(fullPath);
    }

    public static List<Double> stringsToDoubles(String[] source) {
        double[] values = new double[source.length];
        for (int i = 0; i < source.length; ++i) {
            values[i] = Double.valueOf(source[i]);
        }
        return Doubles.asList((double[])values);
    }

    public static DiscretizedFunc getExceedProbabilities(DiscretizedFunc imls, double mean, double sigma, boolean clamp, double clampVal) {
        double clip3s;
        double clipPer;
        double clip = mean + 3.0 * sigma;
        if (clamp && (clipPer = clampVal) < (clip3s = Math.exp(clip)) && clipPer > 0.0) {
            clip = Math.log(clipPer);
        }
        try {
            double Pclip = Utils.gaussProbExceed(mean, sigma, clip);
            for (int i = 0; i < imls.size(); ++i) {
                double x = imls.getX(i);
                double y = Utils.gaussProbExceed(mean, sigma, Math.log(x), Pclip, GaussTruncation.ONE_SIDED);
                imls.set(i, y);
            }
        }
        catch (RuntimeException me) {
            me.printStackTrace();
        }
        return imls;
    }

    public static double getExceedProbability(double iml, double mean, double sigma, boolean clamp, double clampVal) {
        double clip3s;
        double clipPer;
        double clip = mean + 3.0 * sigma;
        if (clamp && (clipPer = clampVal) < (clip3s = Math.exp(clip)) && clipPer > 0.0) {
            clip = Math.log(clipPer);
        }
        double Pclip = Utils.gaussProbExceed(mean, sigma, clip);
        return Utils.gaussProbExceed(mean, sigma, Math.log(iml), Pclip, GaussTruncation.ONE_SIDED);
    }

    private static double poissProb(double r, double t) {
        return 1.0 - Math.exp(-r * t);
    }

    private static double poissProbInv(double P, double t) {
        return -Math.log(1.0 - P) / t;
    }

    private static double interp1(double x1, double x2, double y1, double y2, double y) {
        x1 = Math.log10(x1);
        y1 = Math.log10(y1);
        x2 = Math.log10(x2);
        y2 = Math.log10(y2);
        double x = x2 - (x2 - x1) * (y2 - Math.log10(y)) / (y2 - y1);
        return Math.pow(10.0, x);
    }

    private static double interp2(double x1, double x2, double y1, double y2, double y) {
        x1 = Math.log(x1);
        y1 = Math.log(y1);
        x2 = Math.log(x2);
        y2 = Math.log(y2);
        double tmp = y2 - y1;
        double x = x1 + (x2 - x1) * (Math.log(y) - y1) / tmp;
        return Math.exp(x);
    }

    public static void addFunc(DiscretizedFunc f1, DiscretizedFunc f2) {
        for (int i = 0; i < f1.size(); ++i) {
            f1.set(i, f1.getY(i) + f2.getY(i));
        }
    }

    public static void multiplyFunc(DiscretizedFunc f1, DiscretizedFunc f2) {
        for (int i = 0; i < f1.size(); ++i) {
            f1.set(i, f1.getY(i) * f2.getY(i));
        }
    }

    public static void complementFunc(DiscretizedFunc f) {
        for (int i = 0; i < f.size(); ++i) {
            f.set(i, 1.0 - f.getY(i));
        }
    }

    public static void zeroFunc(DiscretizedFunc f) {
        Utils.setFunc(f, 0.0);
    }

    public static void oneFunc(DiscretizedFunc f) {
        Utils.setFunc(f, 1.0);
    }

    public static void setFunc(DiscretizedFunc f, double v) {
        for (int i = 0; i < f.size(); ++i) {
            f.set(i, v);
        }
    }

    public static Color randomColor() {
        Random rand = new Random();
        float hue = rand.nextFloat();
        float sat = 0.5f + rand.nextFloat() * 0.3f;
        float brt = 0.8f;
        return Color.getHSBColor(hue, sat, brt);
    }

    public static void main(String[] args) {
        ArbitrarilyDiscretizedFunc f = Period.GM1P00.getFunction();
        System.out.println(Utils.getExceedProbabilities(f, -2.8119645744516117, 0.6924081166479781, false, 0.0));
    }
}

