/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.refFaultParamDb.calc.sectionDists;

import java.io.IOException;
import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.Stack;
import org.opensha.commons.util.FileUtils;
import org.opensha.commons.util.threads.ThreadedTaskComputer;
import org.opensha.refFaultParamDb.calc.sectionDists.CalcTask;
import org.opensha.refFaultParamDb.calc.sectionDists.FaultSectDistRecord;
import org.opensha.refFaultParamDb.calc.sectionDists.Pairing;
import org.opensha.refFaultParamDb.calc.sectionDists.SmartSurfaceFilter;
import org.opensha.refFaultParamDb.calc.sectionDists.SurfaceFilter;
import org.opensha.refFaultParamDb.vo.FaultSectionPrefData;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.data.finalReferenceFaultParamDb.DeformationModelPrefDataFinal;
import org.opensha.sha.faultSurface.EvenlyGriddedSurface;
import org.opensha.sha.faultSurface.FrankelGriddedSurface;
import org.opensha.sha.faultSurface.SimpleFaultData;

public class FaultSectDistCalculator
implements Runnable {
    private ArrayList<Integer> sectionIDs;
    private ArrayList<EvenlyGriddedSurface> surfaces;
    private HashMap<Pairing, FaultSectDistRecord> records;
    private Stack<FaultSectDistRecord> calcStack;
    private boolean fast;
    private double calcTimeSecs;
    private double pairTimeSecs;

    public FaultSectDistCalculator(double disc, boolean fast, DeformationModelPrefDataFinal deformationModelPrefDB, int deformationModelId) {
        this(disc, fast, deformationModelPrefDB.getAllFaultSectionPrefData(deformationModelId));
    }

    public FaultSectDistCalculator(double disc, boolean fast, ArrayList<FaultSectionPrefData> data) {
        this(fast, FaultSectDistCalculator.createSurfaces(disc, data), FaultSectDistCalculator.getIDs(data));
    }

    public FaultSectDistCalculator(boolean fast, ArrayList<EvenlyGriddedSurface> surfaces, ArrayList<Integer> ids) {
        this.fast = fast;
        this.surfaces = surfaces;
        this.sectionIDs = ids;
    }

    private static ArrayList<Integer> getIDs(ArrayList<FaultSectionPrefData> data) {
        ArrayList<Integer> sectionIDs = new ArrayList<Integer>();
        for (FaultSectionPrefData val : data) {
            sectionIDs.add(val.getSectionId());
        }
        return sectionIDs;
    }

    private static ArrayList<EvenlyGriddedSurface> createSurfaces(double disc, ArrayList<FaultSectionPrefData> data) {
        ArrayList<EvenlyGriddedSurface> surfaces = new ArrayList<EvenlyGriddedSurface>();
        for (FaultSectionPrefData section : data) {
            SimpleFaultData simpleFaultData = section.getSimpleFaultData(false);
            FrankelGriddedSurface surface = new FrankelGriddedSurface(simpleFaultData, disc);
            surfaces.add(surface);
        }
        return surfaces;
    }

    public void calcDistances() {
        long start = System.currentTimeMillis();
        for (FaultSectDistRecord record : this.records.values()) {
            record.calcDistances(this.fast);
        }
        this.calcTimeSecs = (double)(System.currentTimeMillis() - start) / 1000.0;
    }

    public void calcDistances(int numThreads) throws InterruptedException {
        Stack<CalcTask> tasks = new Stack<CalcTask>();
        for (FaultSectDistRecord record : this.records.values()) {
            tasks.push(new CalcTask(record, this.fast));
        }
        ThreadedTaskComputer threaded = new ThreadedTaskComputer(tasks, true);
        long start = System.currentTimeMillis();
        threaded.computeThreaded(numThreads);
        this.calcTimeSecs = (double)(System.currentTimeMillis() - start) / 1000.0;
    }

    public void createPairings() {
        this.createPairings(null, -1.0);
    }

    public void createPairings(SurfaceFilter filter, double filterDist) {
        long start = System.currentTimeMillis();
        this.records = new HashMap();
        for (int i = 0; i < this.surfaces.size(); ++i) {
            EvenlyGriddedSurface surface1 = this.surfaces.get(i);
            for (int j = 0; j < this.surfaces.size(); ++j) {
                int id2;
                int id1;
                EvenlyGriddedSurface surface2 = this.surfaces.get(j);
                if (surface1 == surface2 || (id1 = this.sectionIDs.get(i).intValue()) >= (id2 = this.sectionIDs.get(j).intValue())) continue;
                FaultSectDistRecord record = new FaultSectDistRecord(id1, surface1, id2, surface2);
                if (filter != null && record.calcMinCornerMidptDist(this.fast) > filter.getCornerMidptFilterDist()) continue;
                if (filter != null && filterDist > 0.0) {
                    record.calcDistances(filter, this.fast);
                    if (record.getMinDist() > filterDist) continue;
                }
                this.records.put(record.getPairing(), record);
            }
        }
        System.out.println("Created " + this.records.size() + " pairings!");
        this.pairTimeSecs = (double)(System.currentTimeMillis() - start) / 1000.0;
    }

    public HashMap<Pairing, FaultSectDistRecord> getRecords() {
        return this.records;
    }

    public static void main(String[] args) throws IOException {
        long start = System.currentTimeMillis();
        int deformationModelId = 82;
        DeformationModelPrefDataFinal deformationModelPrefDB = new DeformationModelPrefDataFinal();
        double disc = 1.0;
        double filterDist = 15.0;
        double cornerMidptFilterDist = 50.0;
        int outlineModulus = 4;
        int internalModulus = 5;
        SmartSurfaceFilter filter = new SmartSurfaceFilter(outlineModulus, internalModulus, cornerMidptFilterDist);
        FaultSectDistCalculator calc = new FaultSectDistCalculator(disc, true, deformationModelPrefDB, deformationModelId);
        calc.createPairings(filter, filterDist);
        System.out.println("Pair time: " + calc.getPairTimeSecs());
        int threads = Runtime.getRuntime().availableProcessors();
        System.out.println("Disc: " + disc + ", filter dist: " + filterDist + ", outline modulus: " + outlineModulus + ", internal modulus: " + internalModulus);
        System.out.println("Calculating with " + threads + " threads.");
        try {
            calc.calcDistances(threads);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        System.out.println("Calc time: " + calc.getCalcTimeSecs());
        FileUtils.saveObjectInFile("faultSectDistances.obj", calc.getRecords());
        int count = 0;
        for (FaultSectDistRecord record : calc.getRecords().values()) {
            if (!(record.getMinDist() < 10.0)) continue;
            ++count;
        }
        System.out.println("Found " + count + " under cutoff!");
        long end = System.currentTimeMillis();
        System.out.println("Total time: " + (double)(end - start) / 1000.0 + " secs");
    }

    private synchronized FaultSectDistRecord getRecordToCalc() throws EmptyStackException {
        return this.calcStack.pop();
    }

    @Override
    public void run() {
        try {
            while (true) {
                FaultSectDistRecord record = this.getRecordToCalc();
                record.calcDistances(this.fast);
            }
        }
        catch (EmptyStackException e) {
            return;
        }
    }

    public void filterOutByCornerMidptDistance(double maxDist, boolean fast) {
        ArrayList<Pairing> toBeRemoved = new ArrayList<Pairing>();
        for (Pairing pairing : this.records.keySet()) {
            FaultSectDistRecord record = this.records.get(pairing);
            double minDist = record.calcMinCornerMidptDist(fast);
            if (!(minDist > maxDist)) continue;
            toBeRemoved.add(pairing);
        }
        System.out.println("filtered out " + toBeRemoved.size() + "/" + this.records.size());
        for (Pairing remove : toBeRemoved) {
            this.records.remove(remove);
        }
    }

    public void filterRecords(SurfaceFilter filter, double maxDist, boolean fast) {
        ArrayList<Pairing> toBeRemoved = new ArrayList<Pairing>();
        for (Pairing pairing : this.records.keySet()) {
            FaultSectDistRecord record = this.records.get(pairing);
            double minDist = record.calcMinDist(filter, fast);
            if (!(minDist > maxDist)) continue;
            toBeRemoved.add(pairing);
        }
        System.out.println("filtered out " + toBeRemoved.size() + "/" + this.records.size());
        for (Pairing remove : toBeRemoved) {
            this.records.remove(remove);
        }
    }

    public double getCalcTimeSecs() {
        return this.calcTimeSecs;
    }

    public double getPairTimeSecs() {
        return this.pairTimeSecs;
    }
}

