/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.refFaultParamDb.dao.db;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.sql.rowset.CachedRowSet;
import org.opensha.refFaultParamDb.dao.db.ContributorDB_DAO;
import org.opensha.refFaultParamDb.dao.db.DB_AccessAPI;
import org.opensha.refFaultParamDb.dao.db.FaultModelSummaryDB_DAO;
import org.opensha.refFaultParamDb.dao.exception.InsertException;
import org.opensha.refFaultParamDb.dao.exception.QueryException;
import org.opensha.refFaultParamDb.dao.exception.UpdateException;
import org.opensha.refFaultParamDb.gui.infotools.SessionInfo;
import org.opensha.refFaultParamDb.vo.DeformationModelSummary;

public class DeformationModelSummaryDB_DAO
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String SEQUENCE_NAME = "Def_Model_Summary_Sequence";
    private static final String TABLE_NAME = "Deformation_Model_Summary";
    private static final String DEF_MODEL_ID = "Deformation_Model_Id";
    private static final String FAULT_MODEL_ID = "Fault_Model_Id";
    private static final String CONTRIBUTOR_ID = "Contributor_Id";
    private static final String DEF_MODEL_NAME = "Deformation_Model_Name";
    private FaultModelSummaryDB_DAO faultModelSummaryDAO;
    private DB_AccessAPI dbAccessAPI;

    public DeformationModelSummaryDB_DAO(DB_AccessAPI dbAccessAPI) {
        this.setDB_Connection(dbAccessAPI);
    }

    public void setDB_Connection(DB_AccessAPI dbAccessAPI) {
        this.dbAccessAPI = dbAccessAPI;
        this.faultModelSummaryDAO = new FaultModelSummaryDB_DAO(dbAccessAPI);
    }

    public int addDeformationModel(DeformationModelSummary deformationModel) throws InsertException {
        int deformationModelId = -1;
        try {
            deformationModelId = this.dbAccessAPI.getNextSequenceNumber(SEQUENCE_NAME);
        }
        catch (SQLException e) {
            throw new InsertException(e.getMessage());
        }
        String sql = "insert into Deformation_Model_Summary(Deformation_Model_Id,Fault_Model_Id,Contributor_Id,Deformation_Model_Name)  values (" + deformationModelId + "," + deformationModel.getFaultModel().getFaultModelId() + "," + SessionInfo.getContributor().getId() + ",'" + deformationModel.getDeformationModelName() + "')";
        try {
            this.dbAccessAPI.insertUpdateOrDeleteData(sql);
            deformationModel.setDeformationModelId(deformationModelId);
        }
        catch (SQLException e) {
            throw new InsertException(e.getMessage());
        }
        return deformationModelId;
    }

    public boolean updateDeformationModel(int deformationModelId, DeformationModelSummary deformationModel) throws UpdateException {
        String sql = "update Deformation_Model_Summary set Deformation_Model_Name= '" + deformationModel.getDeformationModelName() + "',Contributor_Id=" + SessionInfo.getContributor().getId() + ",Fault_Model_Id=" + deformationModel.getFaultModel().getFaultModelId() + " where Deformation_Model_Id=" + deformationModelId;
        try {
            int numRows = this.dbAccessAPI.insertUpdateOrDeleteData(sql);
            if (numRows == 1) {
                return true;
            }
        }
        catch (SQLException e) {
            throw new UpdateException(e.getMessage());
        }
        return false;
    }

    public DeformationModelSummary getDeformationModel(int deformationModelId) throws QueryException {
        DeformationModelSummary deformationModel = null;
        String condition = " where Deformation_Model_Id=" + deformationModelId;
        ArrayList<DeformationModelSummary> deformationModelList = this.query(condition);
        if (deformationModelList.size() > 0) {
            deformationModel = deformationModelList.get(0);
        }
        return deformationModel;
    }

    public DeformationModelSummary getDeformationModel(String deformationModelName) throws QueryException {
        DeformationModelSummary deformationModel = null;
        String condition = " where Deformation_Model_Name='" + deformationModelName + "'";
        ArrayList<DeformationModelSummary> deformationModelList = this.query(condition);
        if (deformationModelList.size() > 0) {
            deformationModel = deformationModelList.get(0);
        }
        return deformationModel;
    }

    public boolean removeDeformationModel(int deformationModelId) throws UpdateException {
        String sql = "delete from Deformation_Model_Summary  where Deformation_Model_Id=" + deformationModelId;
        try {
            int numRows = this.dbAccessAPI.insertUpdateOrDeleteData(sql);
            if (numRows == 1) {
                return true;
            }
        }
        catch (SQLException e) {
            throw new UpdateException(e.getMessage());
        }
        return false;
    }

    public ArrayList<DeformationModelSummary> getAllDeformationModels() throws QueryException {
        return this.query(" ");
    }

    private ArrayList<DeformationModelSummary> query(String condition) throws QueryException {
        ArrayList<DeformationModelSummary> deformationModelList = new ArrayList<DeformationModelSummary>();
        String sql = "select Deformation_Model_Id,Fault_Model_Id,Deformation_Model_Name,Contributor_Id from Deformation_Model_Summary" + condition + " order by Deformation_Model_Id";
        try {
            CachedRowSet rs = this.dbAccessAPI.queryData(sql);
            ContributorDB_DAO contributorDAO = new ContributorDB_DAO(this.dbAccessAPI);
            while (rs.next()) {
                DeformationModelSummary defModelSummary = new DeformationModelSummary();
                defModelSummary.setContributor(contributorDAO.getContributor(rs.getInt(CONTRIBUTOR_ID)));
                defModelSummary.setDeformationModelId(rs.getInt(DEF_MODEL_ID));
                defModelSummary.setDeformationModelName(rs.getString(DEF_MODEL_NAME));
                defModelSummary.setFaultModel(this.faultModelSummaryDAO.getFaultModel(rs.getInt(FAULT_MODEL_ID)));
                deformationModelList.add(defModelSummary);
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new QueryException(e.getMessage());
        }
        return deformationModelList;
    }
}

