/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.refFaultParamDb.dao.db;

import java.sql.SQLException;
import java.util.ArrayList;
import javax.sql.rowset.CachedRowSet;
import org.opensha.commons.data.estimate.Estimate;
import org.opensha.commons.data.estimate.NormalEstimate;
import org.opensha.refFaultParamDb.dao.EstimateDAO_API;
import org.opensha.refFaultParamDb.dao.db.DB_AccessAPI;
import org.opensha.refFaultParamDb.dao.exception.InsertException;
import org.opensha.refFaultParamDb.dao.exception.QueryException;
import org.opensha.refFaultParamDb.dao.exception.UpdateException;

public class NormalEstimateDB_DAO
implements EstimateDAO_API {
    private static final String TABLE_NAME = "Normal_Est";
    private static final String EST_ID = "Est_Id";
    private static final String MEAN = "MEAN";
    private static final String STD_DEV = "STD_DEV";
    private static final String MIN_X = "Min_X";
    private static final String MAX_X = "Max_X";
    private DB_AccessAPI dbAccessAPI;
    public static final String EST_TYPE_NAME = "NormalEstimate";
    private static final String ERR_MSG = "This class just deals with Normal Estimates";

    public NormalEstimateDB_DAO(DB_AccessAPI dbAccessAPI) {
        this.setDB_Connection(dbAccessAPI);
    }

    public NormalEstimateDB_DAO() {
    }

    @Override
    public void setDB_Connection(DB_AccessAPI dbAccessAPI) {
        this.dbAccessAPI = dbAccessAPI;
    }

    @Override
    public void addEstimate(int estimateInstanceId, Estimate estimate) throws InsertException {
        double maxX;
        if (!(estimate instanceof NormalEstimate)) {
            throw new InsertException(ERR_MSG);
        }
        Object colNames = "";
        Object colVals = "";
        NormalEstimate normalEstimate = (NormalEstimate)estimate;
        double minX = normalEstimate.getMin();
        if (!Double.isInfinite(minX)) {
            colNames = (String)colNames + "Min_X,";
            colVals = (String)colVals + minX + ",";
        }
        if (!Double.isInfinite(maxX = normalEstimate.getMax())) {
            colNames = (String)colNames + "Max_X,";
            colVals = (String)colVals + maxX + ",";
        }
        String sql = "insert into Normal_Est(Est_Id," + (String)colNames + "MEAN,STD_DEV) values (" + estimateInstanceId + "," + (String)colVals + estimate.getMean() + "," + estimate.getStdDev() + ")";
        try {
            this.dbAccessAPI.insertUpdateOrDeleteData(sql);
        }
        catch (SQLException e) {
            throw new InsertException(e.getMessage());
        }
    }

    @Override
    public Estimate getEstimate(int estimateInstanceId) throws QueryException {
        NormalEstimate estimate = null;
        String condition = " where Est_Id=" + estimateInstanceId;
        ArrayList<Estimate> estimateList = this.query(condition);
        if (estimateList.size() > 0) {
            estimate = (NormalEstimate)estimateList.get(0);
        }
        return estimate;
    }

    @Override
    public boolean removeEstimate(int estimateInstanceId) throws UpdateException {
        String sql = "delete from Normal_Est  where Est_Id=" + estimateInstanceId;
        try {
            int numRows = this.dbAccessAPI.insertUpdateOrDeleteData(sql);
            if (numRows == 1) {
                return true;
            }
        }
        catch (SQLException e) {
            throw new UpdateException(e.getMessage());
        }
        return false;
    }

    @Override
    public String getEstimateTypeName() {
        return EST_TYPE_NAME;
    }

    private ArrayList<Estimate> query(String condition) throws QueryException {
        ArrayList<Estimate> estimateList = new ArrayList<Estimate>();
        String sql = "select Est_Id,(MEAN+0) MEAN,(STD_DEV+0) STD_DEV, (Min_X+0) Min_X,(Max_X+0) Max_X from Normal_Est " + condition;
        try {
            CachedRowSet rs = this.dbAccessAPI.queryData(sql);
            while (rs.next()) {
                NormalEstimate normalEstimate = new NormalEstimate(rs.getFloat(MEAN), rs.getFloat(STD_DEV));
                double minX = rs.getFloat(MIN_X);
                if (rs.wasNull()) {
                    minX = Double.NEGATIVE_INFINITY;
                }
                double maxX = rs.getFloat(MAX_X);
                if (rs.wasNull()) {
                    maxX = Double.POSITIVE_INFINITY;
                }
                normalEstimate.setMinMax(minX, maxX);
                estimateList.add(normalEstimate);
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new QueryException(e.getMessage());
        }
        return estimateList;
    }
}

