/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.refFaultParamDb.dao.db;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.sql.rowset.CachedRowSet;
import org.opensha.refFaultParamDb.dao.db.ContributorDB_DAO;
import org.opensha.refFaultParamDb.dao.db.DB_AccessAPI;
import org.opensha.refFaultParamDb.dao.db.ReferenceDB_DAO;
import org.opensha.refFaultParamDb.dao.db.SiteRepresentationDB_DAO;
import org.opensha.refFaultParamDb.dao.db.SiteTypeDB_DAO;
import org.opensha.refFaultParamDb.dao.exception.InsertException;
import org.opensha.refFaultParamDb.dao.exception.QueryException;
import org.opensha.refFaultParamDb.gui.infotools.SessionInfo;
import org.opensha.refFaultParamDb.vo.PaleoSitePublication;

public class PaleoSitePublicationsDB_DAO {
    private static final String TABLE_NAME = "Paleo_Site_Publications";
    private static final String SITE_ID = "Site_Id";
    private static final String SITE_ENTRY_DATE = "Site_Entry_Date";
    private static final String ENTRY_DATE = "Entry_Date";
    private static final String SITE_TYPE_ID = "Site_Type_Id";
    private static final String REPRESENTATIVE_STRAND_INDEX = "Representative_Strand_Index";
    private static final String REFERENCE_ID = "Reference_Id";
    private static final String CONTRIBUTOR_ID = "Contributor_Id";
    private DB_AccessAPI dbAccess;
    private SiteRepresentationDB_DAO siteRepresentationDAO;
    private SiteTypeDB_DAO siteTypeDAO;
    private ReferenceDB_DAO referenceDAO;
    private ContributorDB_DAO contributorDAO;

    public PaleoSitePublicationsDB_DAO(DB_AccessAPI dbAccess) {
        this.setDB_Connection(dbAccess);
    }

    public void setDB_Connection(DB_AccessAPI dbAccess) {
        this.dbAccess = dbAccess;
        this.siteRepresentationDAO = new SiteRepresentationDB_DAO(dbAccess);
        this.siteTypeDAO = new SiteTypeDB_DAO(dbAccess);
        this.referenceDAO = new ReferenceDB_DAO(dbAccess);
        this.contributorDAO = new ContributorDB_DAO(dbAccess);
    }

    public void addPaleoSitePublicationInfo(PaleoSitePublication paleoSitePublication) {
        String systemDate;
        try {
            systemDate = this.dbAccess.getSystemDate();
        }
        catch (SQLException e) {
            throw new InsertException(e.getMessage());
        }
        int siteRepIndex = this.siteRepresentationDAO.getSiteRepresentation(paleoSitePublication.getRepresentativeStrandName()).getSiteRepresentationId();
        ArrayList<String> siteTypeNames = paleoSitePublication.getSiteTypeNames();
        try {
            for (int i = 0; i < siteTypeNames.size(); ++i) {
                int siteTypeId = this.siteTypeDAO.getSiteType(siteTypeNames.get(i)).getSiteTypeId();
                String sql = "insert into Paleo_Site_Publications(Site_Id,Site_Entry_Date,Entry_Date,Site_Type_Id,Representative_Strand_Index,Contributor_Id,Reference_Id) values (" + paleoSitePublication.getSiteId() + ",'" + paleoSitePublication.getSiteEntryDate() + "','" + systemDate + "'," + siteTypeId + "," + siteRepIndex + "," + SessionInfo.getContributor().getId() + "," + paleoSitePublication.getReference().getReferenceId() + ")";
                this.dbAccess.insertUpdateOrDeleteData(sql);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new InsertException(e.getMessage());
        }
    }

    public ArrayList<PaleoSitePublication> getPaleoSitePublicationInfo(int siteId) {
        String condition = " where Site_Id=" + siteId;
        return this.query(condition);
    }

    private ArrayList<PaleoSitePublication> query(String condition) {
        ArrayList<PaleoSitePublication> paleoSitePubList = new ArrayList<PaleoSitePublication>();
        String sql = "select Site_Id,to_char(Site_Entry_Date) as Site_Entry_Date,to_char(Entry_Date) as Entry_Date,Site_Type_Id,Representative_Strand_Index,Contributor_Id,Reference_Id from Paleo_Site_Publications" + condition;
        HashMap<Integer, PaleoSitePublication> refIdPublicationMap = new HashMap<Integer, PaleoSitePublication>();
        try {
            CachedRowSet rs = this.dbAccess.queryData(sql);
            while (rs.next()) {
                ArrayList<String> siteTypeNames;
                PaleoSitePublication paleoSitePublication;
                int referenceId = rs.getInt(REFERENCE_ID);
                String siteTypeName = this.siteTypeDAO.getSiteType(rs.getInt(SITE_TYPE_ID)).getSiteType();
                String contributorName = this.contributorDAO.getContributor(rs.getInt(CONTRIBUTOR_ID)).getName();
                if (refIdPublicationMap.containsKey(referenceId)) {
                    paleoSitePublication = (PaleoSitePublication)refIdPublicationMap.get(referenceId);
                    paleoSitePublication.setContributorName(contributorName);
                    paleoSitePublication.setEntryDate(rs.getString(ENTRY_DATE));
                    siteTypeNames = paleoSitePublication.getSiteTypeNames();
                    if (siteTypeNames.contains(siteTypeName)) continue;
                    siteTypeNames.add(siteTypeName);
                    continue;
                }
                paleoSitePublication = new PaleoSitePublication();
                paleoSitePublication.setSiteId(rs.getInt(SITE_ID));
                paleoSitePublication.setSiteEntryDate(rs.getString(SITE_ENTRY_DATE));
                paleoSitePublication.setContributorName(contributorName);
                paleoSitePublication.setEntryDate(rs.getString(ENTRY_DATE));
                paleoSitePublication.setRepresentativeStrandName(this.siteRepresentationDAO.getSiteRepresentation(rs.getInt(REPRESENTATIVE_STRAND_INDEX)).getSiteRepresentationName());
                siteTypeNames = new ArrayList();
                siteTypeNames.add(siteTypeName);
                paleoSitePublication.setSiteTypeNames(siteTypeNames);
                paleoSitePublication.setReference(this.referenceDAO.getReference(rs.getInt(REFERENCE_ID)));
                paleoSitePubList.add(paleoSitePublication);
                refIdPublicationMap.put(rs.getInt(REFERENCE_ID), paleoSitePublication);
            }
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new QueryException(e.getMessage());
        }
        return paleoSitePubList;
    }
}

