/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.refFaultParamDb.dao.db;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.sql.rowset.CachedRowSet;
import oracle.spatial.geometry.JGeometry;
import org.opensha.commons.geo.BorderType;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.geo.Region;
import org.opensha.commons.util.FileUtils;
import org.opensha.commons.util.PrintAndExitUncaughtExceptionHandler;
import org.opensha.refFaultParamDb.dao.db.ContributorDB_DAO;
import org.opensha.refFaultParamDb.dao.db.DB_AccessAPI;
import org.opensha.refFaultParamDb.dao.db.FaultSectionVer2_DB_DAO;
import org.opensha.refFaultParamDb.dao.db.PrioritizedDB_Access;
import org.opensha.refFaultParamDb.dao.db.ServerDB_Access;
import org.opensha.refFaultParamDb.dao.db.SpatialQueryResult;
import org.opensha.refFaultParamDb.dao.db.SpatialUtils;
import org.opensha.refFaultParamDb.dao.exception.InsertException;
import org.opensha.refFaultParamDb.dao.exception.QueryException;
import org.opensha.refFaultParamDb.dao.exception.UpdateException;
import org.opensha.refFaultParamDb.gui.infotools.SessionInfo;
import org.opensha.refFaultParamDb.vo.FaultSectionData;
import org.opensha.refFaultParamDb.vo.FaultSectionPrefData;
import org.opensha.sha.faultSurface.FaultTrace;

public class PrefFaultSectionDataDB_DAO
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String TABLE_NAME = "Pref_Fault_Section_Data";
    public static final String SECTION_ID = "Section_Id";
    public static final String PREF_SLIP_RATE = "Pref_Slip_Rate";
    public static final String PREF_DIP = "Pref_Dip";
    public static final String PREF_RAKE = "Pref_Rake";
    public static final String PREF_UPPER_DEPTH = "Pref_Upper_Depth";
    public static final String PREF_LOWER_DEPTH = "Pref_Lower_Depth";
    public static final String SECTION_NAME = "Name";
    public static final String SHORT_NAME = "Short_Name";
    public static final String FAULT_TRACE = "Fault_Section_Trace";
    public static final String PREF_ASEISMIC_SLIP = "Pref_Aseismic_Slip";
    public static final String DIP_DIRECTION = "Dip_Direction";
    private DB_AccessAPI dbAccess;
    private HashMap<Integer, FaultSectionPrefData> cachedSections = new HashMap();
    private ArrayList<FaultSectionPrefData> faultSectionsList;

    public PrefFaultSectionDataDB_DAO(DB_AccessAPI dbAccess) {
        this.setDB_Connection(dbAccess);
    }

    public void setDB_Connection(DB_AccessAPI dbAccess) {
        this.dbAccess = dbAccess;
    }

    public void rePopulatePrefDataTable() {
        if (this.dbAccess instanceof ServerDB_Access) {
            ((ServerDB_Access)this.dbAccess).updateAllPrefData();
            return;
        }
        FaultSectionVer2_DB_DAO faultSectionVer2DAO = new FaultSectionVer2_DB_DAO(this.dbAccess);
        ArrayList<FaultSectionData> faultSectionsDataList = faultSectionVer2DAO.getAllFaultSections();
        this.removeAll();
        for (int i = 0; i < faultSectionsDataList.size(); ++i) {
            FaultSectionData faultSection = faultSectionsDataList.get(i);
            this.addFaultSectionPrefData(faultSection.getFaultSectionPrefData());
        }
    }

    public void rePopulatePrefDataTable(int faultSectionId) {
        FaultSectionVer2_DB_DAO faultSectionVer2DAO = new FaultSectionVer2_DB_DAO(this.dbAccess);
        FaultSectionData faultSectionData = faultSectionVer2DAO.getFaultSection(faultSectionId);
        this.removeFaultSection(faultSectionId);
        this.addFaultSectionPrefData(faultSectionData.getFaultSectionPrefData());
    }

    private void addFaultSectionPrefData(FaultSectionPrefData faultSectionPrefData) {
        String shortName;
        float dipDirection;
        double rake;
        JGeometry faultSectionTraceGeom = SpatialUtils.getMultiPointGeomtery(faultSectionPrefData.getFaultTrace());
        Object columnNames = "";
        Object columnVals = "";
        double slipRate = faultSectionPrefData.getOrigAveSlipRate();
        if (!Double.isNaN(slipRate)) {
            columnNames = (String)columnNames + "Pref_Slip_Rate,";
            columnVals = (String)columnVals + slipRate + ",";
        }
        if (!Double.isNaN(rake = faultSectionPrefData.getAveRake())) {
            columnNames = (String)columnNames + "Pref_Rake,";
            columnVals = (String)columnVals + rake + ",";
        }
        if (!Float.isNaN(dipDirection = faultSectionPrefData.getDipDirection())) {
            columnNames = (String)columnNames + "Dip_Direction,";
            columnVals = (String)columnVals + dipDirection + ",";
        }
        if ((shortName = faultSectionPrefData.getShortName()) != null) {
            columnNames = (String)columnNames + "Short_Name,";
            columnVals = (String)columnVals + "'" + shortName + "',";
        }
        ArrayList<JGeometry> geomteryObjectList = new ArrayList<JGeometry>();
        if (faultSectionPrefData.getZonePolygon() != null) {
            columnNames = (String)columnNames + "FAULT_ZONE_POLYGON,";
            columnVals = (String)columnVals + "?,";
            geomteryObjectList.add(SpatialUtils.getMultiPointGeomtery(faultSectionPrefData.getZonePolygon().getBorder()));
        }
        String connectorStr = faultSectionPrefData.isConnector() ? "Y" : "N";
        columnNames = (String)columnNames + "CONNECTOR_FLAG,";
        columnVals = (String)columnVals + "'" + connectorStr + "',";
        geomteryObjectList.add(faultSectionTraceGeom);
        String sql = "insert into Pref_Fault_Section_Data(Section_Id," + (String)columnNames + "Pref_Dip,Pref_Upper_Depth,Pref_Lower_Depth,Name,Fault_Section_Trace,Pref_Aseismic_Slip) values (" + faultSectionPrefData.getSectionId() + "," + (String)columnVals + faultSectionPrefData.getAveDip() + "," + faultSectionPrefData.getOrigAveUpperDepth() + "," + faultSectionPrefData.getAveLowerDepth() + ",'" + faultSectionPrefData.getSectionName() + "',?," + faultSectionPrefData.getAseismicSlipFactor() + ")";
        try {
            this.dbAccess.insertUpdateOrDeleteData(sql, geomteryObjectList);
        }
        catch (SQLException e) {
            throw new InsertException(e.getMessage());
        }
    }

    private void removeAll() {
        String sql = "delete from Pref_Fault_Section_Data";
        try {
            this.dbAccess.insertUpdateOrDeleteData(sql);
        }
        catch (SQLException e) {
            throw new UpdateException(e.getMessage());
        }
    }

    private void removeFaultSection(int faultSectionId) {
        String sql = "delete from Pref_Fault_Section_Data where Section_Id=" + faultSectionId;
        try {
            this.dbAccess.insertUpdateOrDeleteData(sql);
        }
        catch (SQLException e) {
            throw new UpdateException(e.getMessage());
        }
    }

    public ArrayList<FaultSectionPrefData> getAllFaultSectionPrefData() {
        if (this.faultSectionsList == null) {
            this.faultSectionsList = this.query("");
        }
        for (FaultSectionPrefData data : this.faultSectionsList) {
            this.cachedSections.put(data.getSectionId(), data);
        }
        return this.faultSectionsList;
    }

    public FaultSectionPrefData getFaultSectionPrefData(int faultSectionId) {
        String condition = " where Section_Id=" + faultSectionId;
        if (this.cachedSections.containsKey(faultSectionId)) {
            return this.cachedSections.get(faultSectionId);
        }
        ArrayList<FaultSectionPrefData> faultSectionsList = this.query(condition);
        FaultSectionPrefData faultSectionPrefData = null;
        if (faultSectionsList.size() > 0) {
            faultSectionPrefData = faultSectionsList.get(0);
        }
        return faultSectionPrefData;
    }

    private ArrayList<FaultSectionPrefData> query(String condition) {
        ArrayList<FaultSectionPrefData> faultSectionsList = new ArrayList<FaultSectionPrefData>();
        String sqlWithSpatialColumnNames = "select Section_Id, (Pref_Slip_Rate+0) Pref_Slip_Rate, (Pref_Dip+0) Pref_Dip, (Pref_Rake+0) Pref_Rake, (Pref_Upper_Depth+0) Pref_Upper_Depth, (Pref_Lower_Depth+0) Pref_Lower_Depth,Name,Fault_Section_Trace,Short_Name,(Pref_Aseismic_Slip+0) Pref_Aseismic_Slip,(Dip_Direction+0) Dip_Direction,CONNECTOR_FLAG,FAULT_ZONE_POLYGON from Pref_Fault_Section_Data" + condition + " order by Name";
        String sqlWithNoSpatialColumnNames = "select Section_Id, (Pref_Slip_Rate+0) Pref_Slip_Rate, (Pref_Dip+0) Pref_Dip, (Pref_Rake+0) Pref_Rake, (Pref_Upper_Depth+0) Pref_Upper_Depth, (Pref_Lower_Depth+0) Pref_Lower_Depth,Name,Short_Name,(Pref_Aseismic_Slip+0) Pref_Aseismic_Slip,(Dip_Direction+0) Dip_Direction,CONNECTOR_FLAG from Pref_Fault_Section_Data" + condition + " order by Name";
        ArrayList<String> spatialColumnNames = new ArrayList<String>();
        spatialColumnNames.add(FAULT_TRACE);
        spatialColumnNames.add("FAULT_ZONE_POLYGON");
        try {
            SpatialQueryResult spatialQueryResult = this.dbAccess.queryData(sqlWithSpatialColumnNames, sqlWithNoSpatialColumnNames, spatialColumnNames);
            CachedRowSet rs = spatialQueryResult.getCachedRowSet();
            int i = 0;
            while (rs.next()) {
                Region zone;
                FaultSectionPrefData faultSectionPrefData = new FaultSectionPrefData();
                faultSectionPrefData.setSectionId(rs.getInt(SECTION_ID));
                faultSectionPrefData.setSectionName(rs.getString(SECTION_NAME));
                faultSectionPrefData.setAseismicSlipFactor(rs.getFloat(PREF_ASEISMIC_SLIP));
                faultSectionPrefData.setAveDip(rs.getFloat(PREF_DIP));
                double slipRate = rs.getFloat(PREF_SLIP_RATE);
                if (rs.wasNull()) {
                    slipRate = Double.NaN;
                }
                faultSectionPrefData.setAveSlipRate(slipRate);
                double rake = rs.getFloat(PREF_RAKE);
                if (rs.wasNull()) {
                    rake = Double.NaN;
                }
                faultSectionPrefData.setAveRake(rake);
                float dipDirection = rs.getFloat(DIP_DIRECTION);
                if (rs.wasNull()) {
                    dipDirection = Float.NaN;
                }
                faultSectionPrefData.setDipDirection(dipDirection);
                faultSectionPrefData.setAveLowerDepth(rs.getFloat(PREF_LOWER_DEPTH));
                faultSectionPrefData.setAveUpperDepth(rs.getFloat(PREF_UPPER_DEPTH));
                String sectionName = faultSectionPrefData.getSectionName();
                String shortName = rs.getString(SHORT_NAME);
                if (!rs.wasNull()) {
                    faultSectionPrefData.setShortName(shortName);
                }
                ArrayList<JGeometry> geometries = spatialQueryResult.getGeometryObjectsList(i++);
                FaultTrace faultTrace = FaultSectionVer2_DB_DAO.getFaultTrace(sectionName, faultSectionPrefData.getOrigAveUpperDepth(), geometries);
                String connStr = rs.getString("CONNECTOR_FLAG");
                boolean connector = connStr.equals("Y");
                faultSectionPrefData.setConnector(connector);
                if (geometries.size() < 2 || geometries.get(1) == null) {
                    zone = null;
                } else {
                    JGeometry geom = geometries.get(1);
                    LocationList zoneLocs = SpatialUtils.loadMultiPointGeometries(geom, 0.0);
                    zone = new Region(zoneLocs, BorderType.MERCATOR_LINEAR);
                }
                faultSectionPrefData.setZonePolygon(zone);
                faultSectionPrefData.setFaultTrace(faultTrace);
                faultSectionsList.add(faultSectionPrefData);
                this.cachedSections.put(faultSectionPrefData.getSectionId(), faultSectionPrefData);
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new QueryException(e.getMessage());
        }
        return faultSectionsList;
    }

    public static void main(String[] args) {
        try {
            String pass;
            String user;
            Preconditions.checkArgument((args.length == 2 ? 1 : 0) != 0, (Object)"Must have 2 arguments!");
            Thread.setDefaultUncaughtExceptionHandler(new PrintAndExitUncaughtExceptionHandler());
            ServerDB_Access dbAccessAPI = new ServerDB_Access(ServerDB_Access.SERVLET_URL_DB3);
            Preconditions.checkState((boolean)PrioritizedDB_Access.isAccessorValid(dbAccessAPI), (Object)"error connecting to db!");
            if (args[0].equals("--file")) {
                if (!new File(args[1]).exists()) {
                    throw new FileNotFoundException("Password file not found: " + args[1]);
                }
                String[] up = FileUtils.loadFile(args[1]).get(0).trim().split(":");
                Preconditions.checkState((up.length == 2 ? 1 : 0) != 0, (Object)"user/pass file has incorrect format (should be 'user:pass'");
                user = up[0];
                pass = up[1];
            } else {
                user = args[0];
                pass = args[1];
            }
            SessionInfo.setUserName(user);
            SessionInfo.setPassword(pass);
            SessionInfo.setContributorInfo();
            System.out.println("Encryped Pass: " + ContributorDB_DAO.getEnryptedPassword(pass));
            PrefFaultSectionDataDB_DAO prefFaultSectionDAO = new PrefFaultSectionDataDB_DAO(dbAccessAPI);
            prefFaultSectionDAO.rePopulatePrefDataTable();
            System.exit(0);
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.exit(1);
        }
    }

    public double getMaxSlipRate() {
        String sql = "select max(Pref_Slip_Rate) from Pref_Fault_Section_Data";
        double maxSlipRate = 0.0;
        try {
            CachedRowSet rs = this.dbAccess.queryData(sql);
            rs.next();
            maxSlipRate = rs.getFloat(0);
            rs.close();
        }
        catch (SQLException e) {
            throw new QueryException(e.getMessage());
        }
        return maxSlipRate;
    }

    public double getMinSlipRate() {
        String sql = "select min(Pref_Slip_Rate) from Pref_Fault_Section_Data";
        double minSlipRate = 0.0;
        try {
            CachedRowSet rs = this.dbAccess.queryData(sql);
            rs.next();
            minSlipRate = rs.getFloat(0);
            rs.close();
        }
        catch (SQLException e) {
            throw new QueryException(e.getMessage());
        }
        return minSlipRate;
    }
}

