/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.refFaultParamDb.excelToDatabase;

import java.util.ArrayList;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.refFaultParamDb.dao.db.DB_ConnectionPool;
import org.opensha.refFaultParamDb.dao.db.FaultSectionVer2_DB_DAO;
import org.opensha.refFaultParamDb.dao.db.PrefFaultSectionDataDB_DAO;
import org.opensha.refFaultParamDb.vo.FaultSectionPrefData;
import org.opensha.sha.faultSurface.FaultTrace;

public class CheckDipDirections {
    private PrefFaultSectionDataDB_DAO prefFaultSectionDAO = new PrefFaultSectionDataDB_DAO(DB_ConnectionPool.getDB2ReadOnlyConn());
    private FaultSectionVer2_DB_DAO faultSectionDAO = new FaultSectionVer2_DB_DAO(DB_ConnectionPool.getDB2ReadOnlyConn());

    public CheckDipDirections() {
        ArrayList<FaultSectionPrefData> faultSectionPrefDataList = this.prefFaultSectionDAO.getAllFaultSectionPrefData();
        for (int i = 0; i < faultSectionPrefDataList.size(); ++i) {
            FaultSectionPrefData faultSectionPrefData = faultSectionPrefDataList.get(i);
            FaultTrace faultSectionTrace = faultSectionPrefData.getFaultTrace();
            double dipDirectionFromOpenSHA = 90.0 + LocationUtils.vector((Location)faultSectionTrace.get(0), (Location)faultSectionTrace.get(faultSectionTrace.getNumLocations() - 1)).getAzimuth();
            if (dipDirectionFromOpenSHA < 0.0) {
                dipDirectionFromOpenSHA += 360.0;
            } else if (dipDirectionFromOpenSHA > 360.0) {
                dipDirectionFromOpenSHA -= 360.0;
            }
            System.out.println(faultSectionPrefData.getSectionId() + "\t" + dipDirectionFromOpenSHA + "\t" + faultSectionPrefData.getSectionName());
            this.faultSectionDAO.updateDipDirection(faultSectionPrefData.getSectionId(), (float)dipDirectionFromOpenSHA);
        }
    }

    public static void main(String[] args) {
        new CheckDipDirections();
    }
}

