/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.refFaultParamDb.excelToDatabase;

import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import org.opensha.commons.geo.Location;
import org.opensha.refFaultParamDb.dao.db.DB_ConnectionPool;
import org.opensha.refFaultParamDb.dao.db.FaultSectionVer2_DB_DAO;
import org.opensha.refFaultParamDb.vo.EstimateInstances;
import org.opensha.refFaultParamDb.vo.FaultSectionData;
import org.opensha.sha.faultSurface.FaultTrace;

public class MakeFaultSectionsTextFile {
    private static final String SECTIONS_TXT_FILENAME = "FaultSectionsVer2.txt";
    private static final String ESTIMATE = "Estimate";
    private static final String SECTION_SOURCE = "Section_Source";

    public MakeFaultSectionsTextFile() {
        FaultSectionVer2_DB_DAO faultSectionDAO = new FaultSectionVer2_DB_DAO(DB_ConnectionPool.getDB2ReadOnlyConn());
        try {
            FileWriter fw = new FileWriter(SECTIONS_TXT_FILENAME);
            ArrayList<FaultSectionData> faultSections = faultSectionDAO.getAllFaultSections();
            int numSections = faultSections.size();
            for (int i = 0; i < numSections; ++i) {
                FaultSectionData faultSection = faultSections.get(i);
                fw.write(faultSection.getSectionId() + ";" + faultSection.getSectionName() + ";" + faultSection.getSource() + "\n");
            }
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void writeFaultTraceToFile(FileWriter fw, FaultTrace faultTrace) throws IOException {
        fw.write("Fault_Section_Trace=" + faultTrace.getNumLocations() + "\n");
        for (int i = 0; i < faultTrace.getNumLocations(); ++i) {
            Location location = (Location)faultTrace.get(i);
            fw.write(location.getLongitude() + "\t" + location.getLatitude() + "\n");
        }
    }

    private void writeEstimateToFile(FileWriter fw, EstimateInstances estimateInstance, String label) throws IOException {
        fw.write(label + "=Estimate\n");
        fw.write(estimateInstance.getEstimate().toString() + "\n");
        fw.write(label + " Units=" + estimateInstance.getUnits() + "\n");
    }

    public static void main(String[] args) {
        new MakeFaultSectionsTextFile();
    }
}

