/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.refFaultParamDb.excelToDatabase;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.opensha.commons.util.FileUtils;
import org.opensha.refFaultParamDb.dao.db.DB_ConnectionPool;
import org.opensha.refFaultParamDb.dao.db.PaleoSiteDB_DAO;
import org.opensha.refFaultParamDb.dao.db.ReferenceDB_DAO;
import org.opensha.refFaultParamDb.vo.PaleoSite;
import org.opensha.refFaultParamDb.vo.PaleoSitePublication;

public class ReadSitesFile {
    private static final String FILENAME = "org\\opensha\\refFaultParamDb\\PaleoSites.txt";
    private PaleoSiteDB_DAO paleoSiteDAO = new PaleoSiteDB_DAO(DB_ConnectionPool.getDB2ReadOnlyConn());
    private ReferenceDB_DAO referenceDAO = new ReferenceDB_DAO(DB_ConnectionPool.getDB2ReadOnlyConn());
    private static final String COMMENTS_DEFAULT = "Site Information provided by Chris Wills from Excel file";
    private static final String STRAND_DEFAULT = "Unknown";
    private static final String SITE_TYPE_DEFAULT = "Unknown";
    private static final float SITE_ELEVATION_DEFAULT = Float.NaN;
    private static final int REFERENCE_ID_DEFAULT = 6530;
    private static final String NONAME_SITENAME = "no name";
    private static final int FAULT_SECTION_ID = 1;

    public ReadSitesFile() {
        try {
            ArrayList<String> referencesList = FileUtils.loadFile(FILENAME);
            for (int i = 0; i < referencesList.size(); ++i) {
                String line = referencesList.get(i);
                PaleoSite paleoSite = new PaleoSite();
                StringTokenizer tokenizer = new StringTokenizer(line, "|");
                paleoSite.setOldSiteId(tokenizer.nextToken().trim());
                paleoSite.setSiteName(tokenizer.nextToken().trim());
                if (paleoSite.getSiteName().equalsIgnoreCase(NONAME_SITENAME)) {
                    paleoSite.setSiteName(" ");
                }
                paleoSite.setFaultSectionNameId(tokenizer.nextToken().trim(), 1);
                String references = tokenizer.nextToken().trim();
                paleoSite.setSiteLon1(Float.parseFloat(tokenizer.nextToken().trim()));
                paleoSite.setSiteLat1(Float.parseFloat(tokenizer.nextToken().trim()));
                paleoSite.setSiteElevation1(Float.NaN);
                paleoSite.setSiteLon2(paleoSite.getSiteLon1());
                paleoSite.setSiteLat2(paleoSite.getSiteLat1());
                paleoSite.setSiteElevation2(Float.NaN);
                paleoSite.setGeneralComments(COMMENTS_DEFAULT);
                ArrayList<String> siteTypeNames = new ArrayList<String>();
                siteTypeNames.add("Unknown");
                PaleoSitePublication paleoSitePub = new PaleoSitePublication();
                paleoSitePub.setRepresentativeStrandName("Unknown");
                paleoSitePub.setSiteTypeNames(siteTypeNames);
                paleoSitePub.setReference(this.referenceDAO.getReference(6530));
                ArrayList<PaleoSitePublication> paleoSitePubList = new ArrayList<PaleoSitePublication>();
                paleoSitePubList.add(paleoSitePub);
                paleoSite.setPaleoSitePubList(paleoSitePubList);
                this.paleoSiteDAO.addPaleoSite(paleoSite);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

