/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.refFaultParamDb.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import org.opensha.commons.data.estimate.Estimate;
import org.opensha.commons.exceptions.ConstraintException;
import org.opensha.commons.exceptions.ParameterException;
import org.opensha.commons.gui.LabeledBoxPanel;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.constraint.impl.EstimateConstraint;
import org.opensha.commons.param.editor.impl.ConstrainedEstimateParameterEditor;
import org.opensha.commons.param.editor.impl.ConstrainedStringParameterEditor;
import org.opensha.commons.param.editor.impl.IntegerParameterEditor;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.impl.EstimateParameter;
import org.opensha.commons.param.impl.IntegerParameter;
import org.opensha.commons.param.impl.StringParameter;
import org.opensha.refFaultParamDb.data.ExactTime;
import org.opensha.refFaultParamDb.data.TimeAPI;
import org.opensha.refFaultParamDb.data.TimeEstimate;
import org.opensha.refFaultParamDb.gui.ExactTimeGuiBean;
import org.opensha.refFaultParamDb.gui.infotools.GUI_Utils;

public class TimeGuiBean
extends LabeledBoxPanel
implements ParameterChangeListener {
    private StringParameter yearUnitsParam;
    private IntegerParameter zeroYearParam;
    private StringParameter eraParam;
    private IntegerParameter publicationYearParam;
    private EstimateParameter estimateParameter;
    private StringParameter timeOptionsParam;
    private static final String YEAR_UNITS_PARAM_NAME = "Year Units";
    private static final String CALENDAR_YEAR = "Calendar Year";
    private static final String ZERO_YEAR_PARAM_NAME = "Zero Year";
    private static final String CALENDAR_ERA_PARAM_NAME = "Era";
    private static final String AD = "AD";
    private static final String BC = "BC";
    private static final String KA = "ka";
    private static final Integer YEAR1950 = 1950;
    private static final String YEARS = "Years";
    private static final String PUBLICATION_YEAR_PARAM_NAME = "Publication Year";
    private static final int DEFAULT_PUB_YEAR_VAL = 0;
    private ConstrainedStringParameterEditor yearUnitsParamEditor;
    private IntegerParameterEditor zeroYearParamEditor;
    private ConstrainedStringParameterEditor eraParamEditor;
    private IntegerParameterEditor publicationYearParamEditor;
    private static final String TIME_OPTIONS_PARAM_NAME = "Type of Time";
    private static final String ESTIMATE = "Estimate";
    private static final String EXACT = "Exact";
    private static final String NOW = "Now";
    private ExactTimeGuiBean exactTimeGuiBean;
    private ConstrainedEstimateParameterEditor estimateParamEditor;
    private ConstrainedStringParameterEditor timeOptionsParamEditor;
    private boolean isNowAllowed;

    public TimeGuiBean(String title, boolean isNowAllowed) {
        try {
            this.isNowAllowed = isNowAllowed;
            this.title = title;
            this.initParamListAndEditors();
            this.addEditorsToPanel();
            this.setParametersVisible();
            this.setTitle(title);
            this.setDateParamsVisibleBasedOnUnits();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setTime(TimeAPI time) {
        if (time instanceof ExactTime) {
            ExactTime exactTime = (ExactTime)time;
            if (exactTime.getIsNow()) {
                this.setParametersForNow(exactTime);
            } else {
                this.timeOptionsParam.setValue(EXACT);
                this.exactTimeGuiBean.setTime(exactTime);
            }
        } else {
            this.setParametersForTimeEstimate(time);
        }
        this.timeOptionsParamEditor.refreshParamEditor();
    }

    private void setParametersForNow(ExactTime exactTime) throws ParameterException, ConstraintException {
        this.timeOptionsParam.setValue(NOW);
        int year = exactTime.getYear();
        if (year != 0) {
            this.publicationYearParam.setValue(year);
            this.publicationYearParamEditor.refreshParamEditor();
        }
    }

    private void setParametersForTimeEstimate(TimeAPI time) throws ParameterException, ConstraintException {
        this.timeOptionsParam.setValue(ESTIMATE);
        TimeEstimate timeEstimate = (TimeEstimate)time;
        timeEstimate.getEstimate().setUnits(null);
        this.estimateParameter.setValue(timeEstimate.getEstimate());
        this.estimateParamEditor.refreshParamEditor();
        this.eraParam.setValue(timeEstimate.getEra());
        this.eraParamEditor.refreshParamEditor();
        if (timeEstimate.isKaSelected()) {
            this.yearUnitsParam.setValue(KA);
            this.zeroYearParam.setValue(timeEstimate.getZeroYear());
            this.zeroYearParamEditor.refreshParamEditor();
        } else {
            this.yearUnitsParam.setValue(CALENDAR_YEAR);
        }
        this.yearUnitsParamEditor.refreshParamEditor();
    }

    public void setNowYearVal(int year) {
        this.publicationYearParam.setValue(year);
        this.publicationYearParamEditor.refreshParamEditor();
    }

    private void initParamListAndEditors() throws Exception {
        ArrayList availableTimeOptions = this.getAvailableTimeOptions();
        this.timeOptionsParam = new StringParameter(TIME_OPTIONS_PARAM_NAME, availableTimeOptions, (String)availableTimeOptions.get(0));
        this.timeOptionsParam.addParameterChangeListener(this);
        this.timeOptionsParamEditor = new ConstrainedStringParameterEditor(this.timeOptionsParam);
        this.exactTimeGuiBean = new ExactTimeGuiBean(" ");
        ArrayList allowedDateEstimates = EstimateConstraint.createConstraintForDateEstimates();
        this.estimateParameter = new EstimateParameter(YEARS, 0.0, Double.POSITIVE_INFINITY, allowedDateEstimates);
        this.estimateParamEditor = new ConstrainedEstimateParameterEditor(this.estimateParameter, true);
        ArrayList<String> yearUnitsList = new ArrayList<String>();
        yearUnitsList.add(CALENDAR_YEAR);
        yearUnitsList.add(KA);
        this.yearUnitsParam = new StringParameter(YEAR_UNITS_PARAM_NAME, yearUnitsList, (String)yearUnitsList.get(0));
        this.yearUnitsParam.addParameterChangeListener(this);
        this.yearUnitsParamEditor = new ConstrainedStringParameterEditor(this.yearUnitsParam);
        ArrayList<String> eras = new ArrayList<String>();
        eras.add(AD);
        eras.add(BC);
        this.eraParam = new StringParameter(CALENDAR_ERA_PARAM_NAME, eras, (String)eras.get(0));
        this.eraParamEditor = new ConstrainedStringParameterEditor(this.eraParam);
        this.zeroYearParam = new IntegerParameter(ZERO_YEAR_PARAM_NAME, 0, new GregorianCalendar().get(1), AD, YEAR1950);
        this.zeroYearParamEditor = new IntegerParameterEditor((Parameter)this.zeroYearParam);
        this.publicationYearParam = new IntegerParameter(PUBLICATION_YEAR_PARAM_NAME, 0, new GregorianCalendar().get(1), AD);
        this.publicationYearParamEditor = new IntegerParameterEditor((Parameter)this.publicationYearParam);
        this.publicationYearParamEditor.setEnabled(false);
    }

    private void addEditorsToPanel() {
        this.setLayout(GUI_Utils.gridBagLayout);
        int yPos = 0;
        this.add((Component)this.timeOptionsParamEditor, new GridBagConstraints(0, yPos++, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.yearUnitsParamEditor, new GridBagConstraints(0, yPos++, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.eraParamEditor, new GridBagConstraints(0, yPos++, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.zeroYearParamEditor, new GridBagConstraints(0, yPos++, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.publicationYearParamEditor, new GridBagConstraints(0, yPos++, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.exactTimeGuiBean, new GridBagConstraints(0, yPos++, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.estimateParamEditor, new GridBagConstraints(0, yPos++, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    private ArrayList getAvailableTimeOptions() {
        ArrayList<String> availableTimes = new ArrayList<String>();
        availableTimes.add(ESTIMATE);
        availableTimes.add(EXACT);
        if (this.isNowAllowed) {
            availableTimes.add(NOW);
        }
        return availableTimes;
    }

    @Override
    public void parameterChange(ParameterChangeEvent event) {
        String paramName = event.getParameterName();
        if (paramName.equalsIgnoreCase(TIME_OPTIONS_PARAM_NAME)) {
            this.setParametersVisible();
        } else if (event.getParameterName().equalsIgnoreCase(YEAR_UNITS_PARAM_NAME)) {
            this.setDateParamsVisibleBasedOnUnits();
        }
    }

    private void setDateParamsVisibleBasedOnUnits() {
        String yearUnitsVal = (String)this.yearUnitsParam.getValue();
        if (yearUnitsVal.equalsIgnoreCase(CALENDAR_YEAR)) {
            this.zeroYearParamEditor.setVisible(false);
            this.eraParamEditor.setVisible(true);
        } else if (yearUnitsVal.equalsIgnoreCase(KA)) {
            this.zeroYearParamEditor.setVisible(true);
            this.eraParamEditor.setVisible(false);
        }
    }

    private void setParametersVisible() {
        String timeOptionChosen = (String)this.timeOptionsParam.getValue();
        if (timeOptionChosen.equalsIgnoreCase(EXACT)) {
            this.setParametersVisibleForEstimateTime(false);
            this.setParametersVisibleForExactTime(true);
            this.publicationYearParamEditor.setVisible(false);
        } else if (timeOptionChosen.equalsIgnoreCase(ESTIMATE)) {
            this.setParametersVisibleForExactTime(false);
            this.setParametersVisibleForEstimateTime(true);
            this.publicationYearParamEditor.setVisible(false);
            this.setDateParamsVisibleBasedOnUnits();
        } else if (timeOptionChosen.equalsIgnoreCase(NOW)) {
            this.setParametersVisibleForExactTime(false);
            this.setParametersVisibleForEstimateTime(false);
            this.publicationYearParamEditor.setVisible(true);
        }
    }

    private void setParametersVisibleForExactTime(boolean isVisible) {
        this.exactTimeGuiBean.setVisible(isVisible);
        this.eraParamEditor.setVisible(isVisible);
    }

    private void setParametersVisibleForEstimateTime(boolean isVisible) {
        this.estimateParamEditor.setVisible(isVisible);
        this.yearUnitsParamEditor.setVisible(isVisible);
        this.eraParamEditor.setVisible(isVisible);
        this.zeroYearParamEditor.setVisible(isVisible);
    }

    public TimeAPI getSelectedTime() {
        TimeAPI timeAPI;
        String timeOptionChosen = (String)this.timeOptionsParam.getValue();
        if (timeOptionChosen.equalsIgnoreCase(EXACT)) {
            timeAPI = this.getExactTime();
        } else if (timeOptionChosen.equalsIgnoreCase(ESTIMATE)) {
            timeAPI = this.getTimeEstimate();
        } else {
            Integer pubYearVal = (Integer)this.publicationYearParam.getValue();
            if (pubYearVal == null) {
                pubYearVal = 0;
            }
            timeAPI = new ExactTime(pubYearVal, 0, 0, 0, 0, 0, AD, true);
        }
        return timeAPI;
    }

    private TimeAPI getExactTime() {
        ExactTime exactTime = this.exactTimeGuiBean.getExactTime();
        exactTime.setEra((String)this.eraParam.getValue());
        return exactTime;
    }

    private TimeEstimate getTimeEstimate() {
        this.estimateParamEditor.setEstimateInParameter();
        TimeEstimate timeEstimate = new TimeEstimate();
        String yearUnitsVal = (String)this.yearUnitsParam.getValue();
        if (yearUnitsVal.equalsIgnoreCase(KA)) {
            timeEstimate.setForKaUnits((Estimate)this.estimateParameter.getValue(), (Integer)this.zeroYearParam.getValue());
        } else {
            timeEstimate.setForCalendarYear((Estimate)this.estimateParameter.getValue(), (String)this.eraParam.getValue());
        }
        return timeEstimate;
    }
}

