/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.refFaultParamDb.gui.addEdit.faultSection;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import org.opensha.commons.data.estimate.Estimate;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.geo.Region;
import org.opensha.commons.gui.LabeledBorderPanel;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.constraint.impl.EstimateConstraint;
import org.opensha.commons.param.constraint.impl.StringConstraint;
import org.opensha.commons.param.editor.impl.ConstrainedDoubleParameterEditor;
import org.opensha.commons.param.editor.impl.ConstrainedEstimateParameterEditor;
import org.opensha.commons.param.editor.impl.ConstrainedStringParameterEditor;
import org.opensha.commons.param.editor.impl.StringParameterEditor;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.impl.DoubleParameter;
import org.opensha.commons.param.impl.EstimateParameter;
import org.opensha.commons.param.impl.StringParameter;
import org.opensha.refFaultParamDb.dao.db.DB_AccessAPI;
import org.opensha.refFaultParamDb.dao.db.FaultSectionVer2_DB_DAO;
import org.opensha.refFaultParamDb.dao.db.SectionSourceDB_DAO;
import org.opensha.refFaultParamDb.gui.params.CommentsParameterEditor;
import org.opensha.refFaultParamDb.gui.view.ViewFaultSection;
import org.opensha.refFaultParamDb.vo.EstimateInstances;
import org.opensha.refFaultParamDb.vo.FaultSectionData;
import org.opensha.refFaultParamDb.vo.SectionSource;
import org.opensha.sha.faultSurface.FaultTrace;

public class EditFaultSection
extends JFrame
implements ActionListener,
ParameterChangeListener {
    private JPanel mainPanel = new JPanel();
    private JSplitPane topSplitPane = new JSplitPane();
    private JSplitPane innerSplitPane = new JSplitPane();
    protected JButton cancelButton = new JButton();
    protected JButton okButton = new JButton();
    private JPanel leftPanel = new JPanel();
    private JPanel rightPanel = new JPanel();
    private JPanel centerPanel = new JPanel();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private BorderLayout borderLayout1 = new BorderLayout();
    private static final String DIP_UNITS = "degrees";
    public static final String SLIP_RATE_UNITS = "mm/yr";
    private static final String DEPTH_UNITS = "km";
    public static final String RAKE_UNITS = "degrees";
    private static final String ASEISMIC_SLIP_FACTOR_UNITS = "";
    private static final String FAULT_SECTION_PARAM_NAME = "Fault Section";
    private StringParameter faultSectionNameParam;
    private static final String SOURCE = "Source";
    private static final String SOURCE_ADD = "new...";
    private StringParameter sectionSourceParam;
    private static final String AVE_LONG_TERM_SLIP_RATE = "Ave Long Term Slip Rate";
    private EstimateParameter avgLongTermSlipRateEstParam;
    private ConstrainedEstimateParameterEditor avgLongTermSlipRateEstParamEditor;
    private static final double SLIP_RATE_MIN = Double.NEGATIVE_INFINITY;
    private static final double SLIP_RATE_MAX = Double.POSITIVE_INFINITY;
    private static final String SLIP_RATE_TYPE_PARAM_NAME = "Slip Rate Type";
    private StringParameter slipRateTypeParam;
    private ConstrainedStringParameterEditor slipRateTypeParamEditor;
    private static final String DIP = "Ave Dip";
    private EstimateParameter aveDipEstParam;
    private ConstrainedEstimateParameterEditor aveDipEstParamEditor;
    private static final double DIP_MIN = Double.NEGATIVE_INFINITY;
    private static final double DIP_MAX = Double.POSITIVE_INFINITY;
    private static final String DIP_DIRECTION = "Dip Direction";
    private DoubleParameter dipDirectionParam;
    private static final double MIN_DIP_DIRECTION = 0.0;
    private static final double MAX_DIP_DIRECTION = 360.0;
    private static final String RAKE = "Ave Rake";
    private EstimateParameter aveRakeEstParam;
    private ConstrainedEstimateParameterEditor aveRakeEstParamEditor;
    private static final double RAKE_MIN = Double.NEGATIVE_INFINITY;
    private static final double RAKE_MAX = Double.POSITIVE_INFINITY;
    private static final String RAKE_TYPE_PARAM_NAME = "Rake Type";
    private StringParameter rakeTypeParam;
    private ConstrainedStringParameterEditor rakeTypeParamEditor;
    private static final String UPPER_DEPTH = "Upper Seis Depth";
    private EstimateParameter upperDepthEstParam;
    private ConstrainedEstimateParameterEditor upperDepthEstParamEditor;
    private static final double UPPER_DEPTH_MIN = Double.NEGATIVE_INFINITY;
    private static final double UPPER_DEPTH_MAX = Double.POSITIVE_INFINITY;
    private static final String LOWER_DEPTH = "Lower Seis Depth";
    private EstimateParameter lowerDepthEstParam;
    private ConstrainedEstimateParameterEditor lowerDepthEstParamEditor;
    private static final double LOWER_DEPTH_MIN = Double.NEGATIVE_INFINITY;
    private static final double LOWER_DEPTH_MAX = Double.POSITIVE_INFINITY;
    private static final String ASEISMIC_SLIP = "Aseismic Slip Factor";
    private EstimateParameter aseimsicSlipEstParam;
    private ConstrainedEstimateParameterEditor aseimsicSlipEstParamEditor;
    private static final double ASEISMIC_SLIP_FACTOR_MIN = 0.0;
    private static final double ASEISMIC_SLIP_FACTOR_MAX = 1.0;
    private JTextArea faultTraceArea;
    private JTextArea faultPolygonArea;
    private static final String QFAULT_ID = "QFault_Id";
    private StringParameter qFaultIdParam;
    private static final String SHORT_NAME = "Short_Name";
    private StringParameter shortNameParam;
    private static final String COMMENTS = "COMMENTS";
    private StringParameter commentsParam;
    private FaultSectionData selectedFaultSection;
    private static final String TITLE = "Edit Fault Section";
    private static final String MSG_FAULT_TRACE_FORMAT = "Fault Trace should be specified with a lon-lat pair\non each line separated by comma";
    private static final String MSG_UPDATE_SUCCESS = "Fault Section updated successfully in the database";
    private static final String MSG_ADD_SUCCESS = "Fault Section added succesfully to the database";
    private static final String KNOWN = "Known";
    private static final String UNKNOWN = "Unknown";
    private ViewFaultSection viewFaultSection;
    private boolean isEdit = false;
    private DB_AccessAPI dbConnection;
    private SectionSourceDB_DAO sectionSourceDB_DAO;
    private static final int DEAFULT_WIDTH = 1200;
    private static final int DEAFULT_HEIGHT = 800;

    public EditFaultSection(DB_AccessAPI dbConnection, FaultSectionData faultSection, ViewFaultSection viewFaultSection) {
        this.dbConnection = dbConnection;
        this.sectionSourceDB_DAO = new SectionSourceDB_DAO(dbConnection);
        try {
            if (faultSection != null) {
                this.selectedFaultSection = faultSection;
                this.isEdit = true;
            } else {
                this.selectedFaultSection = new FaultSectionData();
                this.isEdit = false;
            }
            this.viewFaultSection = viewFaultSection;
            this.jbInit();
            this.initParamsAndEditors();
            this.setRakeVisibility();
            this.setSlipRateVisibility();
            this.okButton.addActionListener(this);
            this.cancelButton.addActionListener(this);
            this.setTitle(TITLE);
            this.setSize(1200, 800);
            this.topSplitPane.setDividerLocation(840);
            this.innerSplitPane.setDividerLocation(396);
            this.setVisible(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.getContentPane().setLayout(this.borderLayout1);
        this.mainPanel.setLayout(this.gridBagLayout1);
        this.cancelButton.setText("Cancel");
        this.okButton.setText("Update");
        this.leftPanel.setLayout(this.gridBagLayout1);
        this.centerPanel.setLayout(this.gridBagLayout1);
        this.rightPanel.setLayout(this.gridBagLayout1);
        this.topSplitPane.add((Component)this.innerSplitPane, "left");
        this.topSplitPane.add((Component)new JScrollPane(this.rightPanel), "right");
        this.innerSplitPane.add((Component)new JScrollPane(this.leftPanel), "left");
        this.innerSplitPane.add((Component)new JScrollPane(this.centerPanel), "right");
        this.mainPanel.add((Component)this.topSplitPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(4, 4, 0, 3), 0, 0));
        this.mainPanel.add((Component)this.getButtonPanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.getContentPane().add((Component)this.mainPanel, "Center");
    }

    protected JPanel getButtonPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(this.okButton);
        panel.add(this.cancelButton);
        return panel;
    }

    private void initParamsAndEditors() throws Exception {
        String qfaultId;
        this.faultSectionNameParam = new StringParameter(FAULT_SECTION_PARAM_NAME, this.selectedFaultSection.getSectionName());
        StringParameterEditor faultSectionNameParamEditor = new StringParameterEditor((Parameter)this.faultSectionNameParam);
        this.leftPanel.add((Component)faultSectionNameParamEditor, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        String shortName = this.selectedFaultSection.getShortName();
        if (shortName == null) {
            shortName = ASEISMIC_SLIP_FACTOR_UNITS;
        }
        this.shortNameParam = new StringParameter(SHORT_NAME, shortName);
        StringParameterEditor shortNameParamEditor = new StringParameterEditor((Parameter)this.shortNameParam);
        this.leftPanel.add((Component)shortNameParamEditor, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        if (this.dbConnection != null) {
            ArrayList<SectionSource> sectionSourcesList = this.sectionSourceDB_DAO.getAllSectionSource();
            ArrayList<String> sectionSourceNamesList = new ArrayList<String>();
            for (int i = 0; i < sectionSourcesList.size(); ++i) {
                sectionSourceNamesList.add(sectionSourcesList.get(i).getSectionSourceName());
            }
            sectionSourceNamesList.add(SOURCE_ADD);
            this.sectionSourceParam = new StringParameter(SOURCE, sectionSourceNamesList, (String)sectionSourceNamesList.get(0));
            this.sectionSourceParam.addParameterChangeListener(this);
            this.leftPanel.add((Component)this.sectionSourceParam.getEditor().getComponent(), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        }
        if ((qfaultId = this.selectedFaultSection.getQFaultId()) == null) {
            qfaultId = ASEISMIC_SLIP_FACTOR_UNITS;
        }
        this.qFaultIdParam = new StringParameter(QFAULT_ID, qfaultId);
        StringParameterEditor qFaultIdParamEditor = new StringParameterEditor((Parameter)this.qFaultIdParam);
        this.leftPanel.add((Component)qFaultIdParamEditor, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        float dipDirection = this.selectedFaultSection.getDipDirection();
        Double val = Double.isNaN(dipDirection) ? null : Double.valueOf(dipDirection);
        this.dipDirectionParam = new DoubleParameter(DIP_DIRECTION, 0.0, 360.0, val);
        if (val == null && this.selectedFaultSection.getFaultTrace() != null) {
            this.dipDirectionParam.setInfo("No value stored in db.\nCalculated value would be: " + this.selectedFaultSection.getFaultTrace().getDipDirection());
        }
        this.dipDirectionParam.getConstraint().setNullAllowed(true);
        ConstrainedDoubleParameterEditor dipDirectionParamEditor = new ConstrainedDoubleParameterEditor((Parameter)this.dipDirectionParam);
        this.leftPanel.add((Component)dipDirectionParamEditor, new GridBagConstraints(0, 4, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.commentsParam = new StringParameter(COMMENTS, this.selectedFaultSection.getComments());
        CommentsParameterEditor commentsParamEditor = new CommentsParameterEditor(this.commentsParam);
        this.leftPanel.add((Component)commentsParamEditor, new GridBagConstraints(0, 5, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.makeFaultTraceParamAndEditor();
        LabeledBorderPanel traceBorder = new LabeledBorderPanel(new BorderLayout());
        traceBorder.initParameterLookAndFeel();
        traceBorder.add((Component)this.faultTraceArea, "Center");
        traceBorder.setTitle("Fault Trace");
        this.leftPanel.add((Component)new JScrollPane(traceBorder), new GridBagConstraints(0, 6, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.makeFaultPolygonParamAndEditor();
        LabeledBorderPanel polygonBorder = new LabeledBorderPanel(new BorderLayout());
        polygonBorder.initParameterLookAndFeel();
        polygonBorder.add((Component)this.faultPolygonArea, "Center");
        polygonBorder.setTitle("Fault Zone Polygon");
        this.leftPanel.add((Component)new JScrollPane(polygonBorder), new GridBagConstraints(0, 7, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        ArrayList allowedEstimates = EstimateConstraint.createConstraintForPositiveDoubleValues();
        this.makeUpperDepthParamAndEditor(allowedEstimates);
        this.centerPanel.add((Component)this.upperDepthEstParamEditor, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.makeLowerDepthParamAndEditor(allowedEstimates);
        this.centerPanel.add((Component)this.lowerDepthEstParamEditor, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.makeAveDipParamAndEditor(allowedEstimates);
        this.centerPanel.add((Component)this.aveDipEstParamEditor, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.makeSlipRateParamAndEditor(allowedEstimates);
        this.rightPanel.add((Component)this.slipRateTypeParamEditor, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.rightPanel.add((Component)this.avgLongTermSlipRateEstParamEditor, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.makeAveRakeParamAndEditor(allowedEstimates);
        this.rightPanel.add((Component)this.rakeTypeParamEditor, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.rightPanel.add((Component)this.aveRakeEstParamEditor, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.makeAseismicSlipParamAndEditor(allowedEstimates);
        this.rightPanel.add((Component)this.aseimsicSlipEstParamEditor, new GridBagConstraints(0, 4, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.okButton) {
            try {
                this.setParamsInSelectedFaultSection();
                FaultSectionVer2_DB_DAO faultSectionDAO = new FaultSectionVer2_DB_DAO(this.dbConnection);
                if (this.isEdit) {
                    faultSectionDAO.update(this.selectedFaultSection);
                    this.viewFaultSection.refreshFaultSectionValues();
                    JOptionPane.showMessageDialog(this, MSG_UPDATE_SUCCESS);
                } else {
                    faultSectionDAO.addFaultSection(this.selectedFaultSection);
                    JOptionPane.showMessageDialog(this, MSG_ADD_SUCCESS);
                    this.viewFaultSection.makeFaultSectionNamesEditor();
                }
                this.dispose();
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, e.getMessage());
            }
        } else if (source == this.cancelButton) {
            this.dispose();
        }
    }

    protected FaultSectionData getSelectedFaultSection() {
        return this.selectedFaultSection;
    }

    public void setParamsInSelectedFaultSection() {
        this.selectedFaultSection.setSectionName((String)this.faultSectionNameParam.getValue());
        if (this.sectionSourceParam != null) {
            if (((String)this.sectionSourceParam.getValue()).equals(SOURCE_ADD)) {
                this.addNewSource();
            }
            this.selectedFaultSection.setSource((String)this.sectionSourceParam.getValue());
        }
        if (((String)this.slipRateTypeParam.getValue()).equalsIgnoreCase(KNOWN)) {
            this.avgLongTermSlipRateEstParamEditor.setEstimateInParameter();
            this.selectedFaultSection.setAveLongTermSlipRateEst(new EstimateInstances((Estimate)this.avgLongTermSlipRateEstParam.getValue(), SLIP_RATE_UNITS));
        } else {
            this.selectedFaultSection.setAveLongTermSlipRateEst(null);
        }
        if (((String)this.rakeTypeParam.getValue()).equalsIgnoreCase(KNOWN)) {
            this.aveRakeEstParamEditor.setEstimateInParameter();
            this.selectedFaultSection.setAveRakeEst(new EstimateInstances((Estimate)this.aveRakeEstParam.getValue(), "degrees"));
        } else {
            this.selectedFaultSection.setAveRakeEst(null);
        }
        this.aveDipEstParamEditor.setEstimateInParameter();
        this.selectedFaultSection.setAveDipEst(new EstimateInstances((Estimate)this.aveDipEstParam.getValue(), "degrees"));
        this.upperDepthEstParamEditor.setEstimateInParameter();
        this.selectedFaultSection.setAveUpperDepthEst(new EstimateInstances((Estimate)this.upperDepthEstParam.getValue(), DEPTH_UNITS));
        this.lowerDepthEstParamEditor.setEstimateInParameter();
        this.selectedFaultSection.setAveLowerDepthEst(new EstimateInstances((Estimate)this.lowerDepthEstParam.getValue(), DEPTH_UNITS));
        this.aseimsicSlipEstParamEditor.setEstimateInParameter();
        this.selectedFaultSection.setAseismicSlipFactorEst(new EstimateInstances((Estimate)this.aseimsicSlipEstParam.getValue(), ASEISMIC_SLIP_FACTOR_UNITS));
        this.selectedFaultSection.setComments((String)this.commentsParam.getValue());
        String qFaultId = (String)this.qFaultIdParam.getValue();
        if (qFaultId.trim().equalsIgnoreCase(ASEISMIC_SLIP_FACTOR_UNITS)) {
            qFaultId = null;
        }
        this.selectedFaultSection.setQFaultId(qFaultId);
        String shortName = (String)this.shortNameParam.getValue();
        if (shortName.trim().equalsIgnoreCase(ASEISMIC_SLIP_FACTOR_UNITS)) {
            shortName = null;
        }
        this.selectedFaultSection.setShortName(shortName);
        Double dipDirectionVal = (Double)this.dipDirectionParam.getValue();
        float dipDirection = dipDirectionVal == null ? Float.NaN : dipDirectionVal.floatValue();
        this.selectedFaultSection.setDipDirection(dipDirection);
        this.selectedFaultSection.setFaultTrace(this.getFaultTrace());
        this.selectedFaultSection.setZonePolygon(this.getFaultZonePolygon());
    }

    private FaultTrace getFaultTrace() {
        FaultTrace faultTrace = new FaultTrace(this.selectedFaultSection.getSectionName());
        faultTrace.addAll(this.parseLocs(this.faultTraceArea));
        return faultTrace;
    }

    private Region getFaultZonePolygon() {
        LocationList border = this.parseLocs(this.faultPolygonArea);
        if (border.isEmpty()) {
            return null;
        }
        return new Region(border, FaultSectionVer2_DB_DAO.POLYGON_BORDER_TYPE);
    }

    private LocationList parseLocs(JTextArea area) {
        LocationList locs = new LocationList();
        String text = area.getText();
        try {
            StringTokenizer tokenizer = new StringTokenizer(text, "\n");
            while (tokenizer.hasMoreTokens()) {
                String line = tokenizer.nextToken();
                if (line.trim().equalsIgnoreCase(ASEISMIC_SLIP_FACTOR_UNITS)) continue;
                StringTokenizer lineTokenizer = new StringTokenizer(line, ",");
                double lon = Double.parseDouble(lineTokenizer.nextToken().trim());
                double lat = Double.parseDouble(lineTokenizer.nextToken().trim());
                locs.add(new Location(lat, lon));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(MSG_FAULT_TRACE_FORMAT);
        }
        return locs;
    }

    private void makeSlipRateParamAndEditor(ArrayList allowedEstimates) {
        EstimateConstraint slipEstConstraint = new EstimateConstraint(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, allowedEstimates);
        Estimate slipRateEst = null;
        if (this.selectedFaultSection.getAveLongTermSlipRateEst() != null) {
            slipRateEst = this.selectedFaultSection.getAveLongTermSlipRateEst().getEstimate();
        }
        this.avgLongTermSlipRateEstParam = new EstimateParameter(AVE_LONG_TERM_SLIP_RATE, slipEstConstraint, SLIP_RATE_UNITS, slipRateEst);
        this.avgLongTermSlipRateEstParamEditor = new ConstrainedEstimateParameterEditor(this.avgLongTermSlipRateEstParam, true);
        ArrayList<String> slipRateTypes = new ArrayList<String>();
        slipRateTypes.add(UNKNOWN);
        slipRateTypes.add(KNOWN);
        String defaultVal = KNOWN;
        if (slipRateEst == null) {
            defaultVal = UNKNOWN;
        }
        this.slipRateTypeParam = new StringParameter(SLIP_RATE_TYPE_PARAM_NAME, slipRateTypes, defaultVal);
        this.slipRateTypeParam.addParameterChangeListener(this);
        this.slipRateTypeParamEditor = new ConstrainedStringParameterEditor(this.slipRateTypeParam);
    }

    private void makeAveDipParamAndEditor(ArrayList allowedEstimates) {
        EstimateConstraint dipEstConstraint = new EstimateConstraint(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, allowedEstimates);
        Estimate dipEst = null;
        if (this.selectedFaultSection.getAveDipEst() != null) {
            dipEst = this.selectedFaultSection.getAveDipEst().getEstimate();
        }
        this.aveDipEstParam = new EstimateParameter(DIP, dipEstConstraint, "degrees", dipEst);
        this.aveDipEstParamEditor = new ConstrainedEstimateParameterEditor(this.aveDipEstParam, true);
    }

    private void makeAveRakeParamAndEditor(ArrayList allowedEstimates) {
        EstimateConstraint rakeEstConstraint = new EstimateConstraint(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, allowedEstimates);
        Estimate rakeEst = null;
        if (this.selectedFaultSection.getAveRakeEst() != null) {
            rakeEst = this.selectedFaultSection.getAveRakeEst().getEstimate();
        }
        this.aveRakeEstParam = new EstimateParameter(RAKE, rakeEstConstraint, "degrees", rakeEst);
        this.aveRakeEstParamEditor = new ConstrainedEstimateParameterEditor(this.aveRakeEstParam, true);
        ArrayList<String> rakeTypes = new ArrayList<String>();
        rakeTypes.add(UNKNOWN);
        rakeTypes.add(KNOWN);
        String defaultVal = KNOWN;
        if (rakeEst == null) {
            defaultVal = UNKNOWN;
        }
        this.rakeTypeParam = new StringParameter(RAKE_TYPE_PARAM_NAME, rakeTypes, defaultVal);
        this.rakeTypeParam.addParameterChangeListener(this);
        this.rakeTypeParamEditor = new ConstrainedStringParameterEditor(this.rakeTypeParam);
    }

    @Override
    public void parameterChange(ParameterChangeEvent event) {
        String name = event.getParameterName();
        if (name.equalsIgnoreCase(RAKE_TYPE_PARAM_NAME)) {
            this.setRakeVisibility();
        } else if (name.equalsIgnoreCase(SLIP_RATE_TYPE_PARAM_NAME)) {
            this.setSlipRateVisibility();
        } else if (name.equals(SOURCE) && ((String)this.sectionSourceParam.getValue()).equals(SOURCE_ADD)) {
            this.addNewSource();
        }
    }

    private void addNewSource() {
        String defaultName = "(name)";
        String name = JOptionPane.showInputDialog("New Source Name", (Object)defaultName);
        StringConstraint constr = (StringConstraint)this.sectionSourceParam.getConstraint();
        if (name == null || name.length() == 0 || name.equals(defaultName)) {
            this.sectionSourceParam.setValue(constr.getAllowedStrings().get(0));
            this.sectionSourceParam.getEditor().setParameter(this.sectionSourceParam);
        } else {
            this.sectionSourceDB_DAO.addSectionSource(name);
            ArrayList<String> names = new ArrayList<String>();
            for (SectionSource source : this.sectionSourceDB_DAO.getAllSectionSource()) {
                names.add(source.getSectionSourceName());
            }
            names.add(SOURCE_ADD);
            constr.setStrings(names);
            this.sectionSourceParam.setValue(name);
            this.sectionSourceParam.getEditor().setParameter(this.sectionSourceParam);
        }
    }

    private void setRakeVisibility() {
        String rakeType = (String)this.rakeTypeParam.getValue();
        if (rakeType.equalsIgnoreCase(UNKNOWN)) {
            this.aveRakeEstParamEditor.setVisible(false);
        } else {
            this.aveRakeEstParamEditor.setVisible(true);
        }
    }

    private void setSlipRateVisibility() {
        String slipRateType = (String)this.slipRateTypeParam.getValue();
        if (slipRateType.equalsIgnoreCase(UNKNOWN)) {
            this.avgLongTermSlipRateEstParamEditor.setVisible(false);
        } else {
            this.avgLongTermSlipRateEstParamEditor.setVisible(true);
        }
    }

    private void makeUpperDepthParamAndEditor(ArrayList allowedEstimates) {
        EstimateConstraint upperDepthConstraint = new EstimateConstraint(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, allowedEstimates);
        Estimate upperDepthEst = null;
        if (this.selectedFaultSection.getAveUpperDepthEst() != null) {
            upperDepthEst = this.selectedFaultSection.getAveUpperDepthEst().getEstimate();
        }
        this.upperDepthEstParam = new EstimateParameter(UPPER_DEPTH, upperDepthConstraint, DEPTH_UNITS, upperDepthEst);
        this.upperDepthEstParamEditor = new ConstrainedEstimateParameterEditor(this.upperDepthEstParam, true);
    }

    private void makeLowerDepthParamAndEditor(ArrayList allowedEstimates) {
        EstimateConstraint lowerDepthConstraint = new EstimateConstraint(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, allowedEstimates);
        Estimate lowerDepthEst = null;
        if (this.selectedFaultSection.getAveLowerDepthEst() != null) {
            lowerDepthEst = this.selectedFaultSection.getAveLowerDepthEst().getEstimate();
        }
        this.lowerDepthEstParam = new EstimateParameter(LOWER_DEPTH, lowerDepthConstraint, DEPTH_UNITS, lowerDepthEst);
        this.lowerDepthEstParamEditor = new ConstrainedEstimateParameterEditor(this.lowerDepthEstParam, true);
    }

    private void makeAseismicSlipParamAndEditor(ArrayList allowedEstimates) {
        EstimateConstraint aseismicSlipConstraint = new EstimateConstraint(0.0, 1.0, allowedEstimates);
        Estimate aseimsicSlipEst = null;
        if (this.selectedFaultSection.getAseismicSlipFactorEst() != null) {
            aseimsicSlipEst = this.selectedFaultSection.getAseismicSlipFactorEst().getEstimate();
        }
        this.aseimsicSlipEstParam = new EstimateParameter(ASEISMIC_SLIP, aseismicSlipConstraint, ASEISMIC_SLIP_FACTOR_UNITS, aseimsicSlipEst);
        this.aseimsicSlipEstParamEditor = new ConstrainedEstimateParameterEditor(this.aseimsicSlipEstParam, true);
    }

    private void makeFaultTraceParamAndEditor() {
        this.faultTraceArea = new JTextArea();
        FaultTrace faultTrace = this.selectedFaultSection.getFaultTrace();
        this.populateTextArea(this.faultTraceArea, faultTrace);
    }

    private void makeFaultPolygonParamAndEditor() {
        this.faultPolygonArea = new JTextArea();
        Region zone = this.selectedFaultSection.getZonePolygon();
        if (zone == null) {
            this.populateTextArea(this.faultPolygonArea, null);
        } else {
            this.populateTextArea(this.faultPolygonArea, zone.getBorder());
        }
    }

    private void populateTextArea(JTextArea area, LocationList locs) {
        area.setText(ASEISMIC_SLIP_FACTOR_UNITS);
        if (locs != null) {
            for (Location loc : locs) {
                area.append(loc.getLongitude() + "," + loc.getLatitude() + "\n");
            }
        }
    }
}

