/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.refFaultParamDb.gui.addEdit.paleoSite;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import javax.swing.JOptionPane;
import org.opensha.commons.data.estimate.IntegerEstimate;
import org.opensha.commons.data.function.AbstractDiscretizedFunc;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.gui.LabeledBoxPanel;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.editor.impl.ArbitrarilyDiscretizedFuncParameterEditor;
import org.opensha.commons.param.editor.impl.IntegerParameterEditor;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.impl.ArbitrarilyDiscretizedFuncParameter;
import org.opensha.commons.param.impl.IntegerParameter;
import org.opensha.commons.param.impl.StringParameter;
import org.opensha.refFaultParamDb.gui.infotools.GUI_Utils;
import org.opensha.refFaultParamDb.gui.params.CommentsParameterEditor;
import org.opensha.refFaultParamDb.vo.CombinedNumEventsInfo;
import org.opensha.refFaultParamDb.vo.EstimateInstances;

public class AddEditNumEvents
extends LabeledBoxPanel
implements ParameterChangeListener {
    private static final String NUM_EVENTS_PARAM_NAME = "Number of Events";
    private static final String MIN_EVENTS_PARAM_NAME = "Min # of Events";
    private static final String MAX_EVENTS_PARAM_NAME = "Max # of Events";
    private static final String NUM_EVENTS_COMMENTS_PARAM_NAME = "Comments";
    private static final String NUM_EVENTS_LIST_HEADER = "# of Events";
    private static final String PROB_HEADER = "Prob. this is correct # events";
    private static final String EVENT_PROB_PARAM_NAME = "Events Prob";
    private static final int NUM_EVENTS_MIN = 0;
    private static final int NUM_EVENTS_MAX = Integer.MAX_VALUE;
    public static final String NUM_EVENTS_UNITS = " ";
    private IntegerParameter minEventsParam;
    private IntegerParameter maxEventsParam;
    private StringParameter numEventsCommentsParam;
    private ArbitrarilyDiscretizedFuncParameter eventsProbParameter;
    private IntegerParameterEditor minEventsParamEditor;
    private IntegerParameterEditor maxEventsParamEditor;
    private CommentsParameterEditor numEventsCommentsParamEditor;
    private ArbitrarilyDiscretizedFuncParameterEditor eventsProbParameterEditor;
    private ArbitrarilyDiscretizedFunc eventProbs = new ArbitrarilyDiscretizedFunc();
    private static final String NUM_EVENTS_PARAMS_TITLE = "Num Events Params";

    public AddEditNumEvents() {
        try {
            this.setLayout(GUI_Utils.gridBagLayout);
            this.addNumEventsParameters();
            this.setMinimumSize(new Dimension(0, 0));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public AddEditNumEvents(CombinedNumEventsInfo combinedNumEventsInfo) {
        this();
        if (combinedNumEventsInfo != null) {
            this.minEventsParam.removeParameterChangeListener(this);
            this.setParameterValues(combinedNumEventsInfo);
            this.minEventsParam.addParameterChangeListener(this);
        }
    }

    private void setParameterValues(CombinedNumEventsInfo combinedNumEventsInfo) {
        this.numEventsCommentsParam.setValue(combinedNumEventsInfo.getNumEventsComments());
        this.numEventsCommentsParamEditor.refreshParamEditor();
        IntegerEstimate estimate = (IntegerEstimate)combinedNumEventsInfo.getNumEventsEstimate().getEstimate();
        AbstractDiscretizedFunc func = estimate.getValues();
        this.minEventsParam.setValue((int)func.getMinX());
        this.minEventsParamEditor.refreshParamEditor();
        this.maxEventsParam.setValue((int)func.getMaxX());
        this.maxEventsParamEditor.refreshParamEditor();
        this.eventsProbParameter.setValue((ArbitrarilyDiscretizedFunc)func);
        this.eventsProbParameterEditor.refreshParamEditor();
    }

    private void addNumEventsParameters() throws Exception {
        this.minEventsParam = new IntegerParameter(MIN_EVENTS_PARAM_NAME, 0, Integer.MAX_VALUE);
        this.minEventsParam.addParameterChangeListener(this);
        this.minEventsParamEditor = new IntegerParameterEditor((Parameter)this.minEventsParam);
        this.maxEventsParam = new IntegerParameter(MAX_EVENTS_PARAM_NAME, 0, Integer.MAX_VALUE);
        this.maxEventsParam.addParameterChangeListener(this);
        this.maxEventsParamEditor = new IntegerParameterEditor((Parameter)this.maxEventsParam);
        this.eventProbs.setXAxisName(NUM_EVENTS_LIST_HEADER);
        this.eventProbs.setYAxisName(PROB_HEADER);
        this.eventsProbParameter = new ArbitrarilyDiscretizedFuncParameter(EVENT_PROB_PARAM_NAME, this.eventProbs);
        this.eventsProbParameterEditor = new ArbitrarilyDiscretizedFuncParameterEditor(this.eventsProbParameter);
        this.eventsProbParameterEditor.setXEnabled(false);
        this.numEventsCommentsParam = new StringParameter(NUM_EVENTS_COMMENTS_PARAM_NAME);
        this.numEventsCommentsParamEditor = new CommentsParameterEditor(this.numEventsCommentsParam);
        int yPos = 0;
        this.add((Component)this.minEventsParamEditor, new GridBagConstraints(0, yPos++, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.maxEventsParamEditor, new GridBagConstraints(0, yPos++, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.eventsProbParameterEditor, new GridBagConstraints(0, yPos++, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.numEventsCommentsParamEditor, new GridBagConstraints(0, yPos++, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.setTitle(NUM_EVENTS_PARAMS_TITLE);
    }

    @Override
    public void parameterChange(ParameterChangeEvent event) {
        this.updateNumEventsList();
    }

    private void updateNumEventsList() {
        Integer minVal = (Integer)this.minEventsParam.getValue();
        if (minVal == null) {
            JOptionPane.showMessageDialog(this, this.minEventsParam.getName() + " is missing");
            return;
        }
        int min = minVal;
        Integer maxVal = (Integer)this.maxEventsParam.getValue();
        if (maxVal == null) {
            JOptionPane.showMessageDialog(this, this.maxEventsParam.getName() + " is missing");
            return;
        }
        int max = maxVal;
        String text = "";
        this.eventProbs.clear();
        for (int i = min; i <= max; ++i) {
            this.eventProbs.set((double)i, 0.0);
        }
        this.eventsProbParameter.setValue(this.eventProbs);
        this.eventsProbParameterEditor.refreshParamEditor();
    }

    public CombinedNumEventsInfo getCombinedNumEventsInfo() {
        CombinedNumEventsInfo combinedNumEventsInfo = new CombinedNumEventsInfo();
        combinedNumEventsInfo.setNumEventsComments(this.getNumEventsComments());
        combinedNumEventsInfo.setNumEventsEstimate(this.getNumEventsEstimate());
        return combinedNumEventsInfo;
    }

    private String getNumEventsComments() {
        return (String)this.numEventsCommentsParam.getValue();
    }

    private EstimateInstances getNumEventsEstimate() {
        ArbitrarilyDiscretizedFunc eventProb = (ArbitrarilyDiscretizedFunc)this.eventsProbParameter.getValue();
        IntegerEstimate numEventsEstimate = new IntegerEstimate(eventProb, true);
        return new EstimateInstances(numEventsEstimate, NUM_EVENTS_UNITS);
    }
}

