/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.refFaultParamDb.gui.view;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import org.opensha.refFaultParamDb.dao.db.DB_AccessAPI;
import org.opensha.refFaultParamDb.dao.db.ReferenceDB_DAO;
import org.opensha.refFaultParamDb.gui.view.ChatTableModel;
import org.opensha.refFaultParamDb.gui.view.TextAreaRenderer;
import org.opensha.refFaultParamDb.vo.Reference;
import org.opensha.sha.gui.infoTools.CalcProgressBar;

public class ViewAllReferences
extends JFrame
implements ActionListener {
    private static final String[] columnNames = new String[]{"Author", "Year", "Full Bibliographic Reference", "Qfault Ref Id"};
    private JLabel referencesLabel = new JLabel();
    private JTable referencesTable;
    private JButton refreshButton = new JButton();
    private JButton closeButton = new JButton();
    private JScrollPane referencesScrollPane = new JScrollPane();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private ReferenceDB_DAO referenceDAO;
    private static final String MSG_MINUTE_TO_LOAD = " May take a minute to load ........";
    private CalcProgressBar progressBar = new CalcProgressBar("Getting References", " May take a minute to load ........");
    private static final String TITLE = "All References";

    public ViewAllReferences(DB_AccessAPI dbConnection) {
        this.referenceDAO = new ReferenceDB_DAO(dbConnection);
        try {
            this.progressBar.setVisible(true);
            this.jbInit();
            this.makeReferencesTable();
            this.addActionListeners();
            this.setTitle(TITLE);
            this.pack();
            this.setLocationRelativeTo(null);
            this.setVisible(true);
            this.progressBar.setVisible(false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.closeButton) {
            this.dispose();
        } else if (source == this.refreshButton) {
            this.makeReferencesTable();
        }
    }

    private void addActionListeners() {
        this.refreshButton.addActionListener(this);
        this.closeButton.addActionListener(this);
    }

    private void makeReferencesTable() {
        if (this.referencesTable != null) {
            this.referencesScrollPane.remove(this.referencesTable);
        }
        this.referencesTable = new JTable(new ChatTableModel(this.getReferencesInfo(), columnNames));
        this.referencesTable.setRowHeight(this.referencesTable.getRowHeight() + 40);
        this.referencesTable.setRowSelectionAllowed(false);
        this.referencesTable.getColumnModel().getColumn(2).setCellRenderer(new TextAreaRenderer());
        this.referencesScrollPane.getViewport().add((Component)this.referencesTable, null);
    }

    private Object[][] getReferencesInfo() {
        ArrayList<Reference> allReferences = this.referenceDAO.getAllReferences();
        int numRefs = allReferences.size();
        Object[][] tableData = new Object[numRefs][columnNames.length];
        for (int i = 0; i < numRefs; ++i) {
            Reference ref = allReferences.get(i);
            tableData[i][0] = ref.getRefAuth();
            tableData[i][1] = ref.getRefYear();
            tableData[i][2] = ref.getFullBiblioReference();
            tableData[i][3] = ref.getQfaultReferenceId();
        }
        return tableData;
    }

    private void jbInit() throws Exception {
        this.referencesLabel.setFont(new Font("Dialog", 1, 15));
        this.referencesLabel.setForeground(new Color(100, 100, 130));
        this.referencesLabel.setHorizontalAlignment(0);
        this.referencesLabel.setText(TITLE);
        this.getContentPane().setLayout(this.gridBagLayout1);
        this.refreshButton.setText("Refresh");
        this.closeButton.setText("Close");
        this.getContentPane().add((Component)this.referencesLabel, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 15), 273, 10));
        this.getContentPane().add((Component)this.refreshButton, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(6, 51, 0, 8), 11, 1));
        this.getContentPane().add((Component)this.closeButton, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 158, 8, 0), 40, 7));
        this.getContentPane().add((Component)this.referencesScrollPane, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 10, 0, 8), -73, -44));
    }
}

