/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.refFaultParamDb.gui.view;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.opensha.commons.data.estimate.Estimate;
import org.opensha.refFaultParamDb.dao.db.DB_AccessAPI;
import org.opensha.refFaultParamDb.dao.db.DeformationModelDB_DAO;
import org.opensha.refFaultParamDb.gui.infotools.GUI_Utils;
import org.opensha.refFaultParamDb.gui.infotools.InfoLabel;
import org.opensha.refFaultParamDb.vo.EstimateInstances;

public class ViewDeformationModel
extends JFrame {
    private DeformationModelDB_DAO deformationModelDAO;
    private static final String SLIP_RATE = "Slip Rate (mm/year)";
    private static final String ASEISMIC_SLIP_FACTOR = "Aseismic Slip Factor";

    public ViewDeformationModel(DB_AccessAPI dbConnection, int deformationModelId, int faultSectionId) {
        this.deformationModelDAO = new DeformationModelDB_DAO(dbConnection);
        this.getContentPane().setLayout(new GridBagLayout());
        EstimateInstances asesmicSlipEstInstance = this.deformationModelDAO.getAseismicSlipEstimate(deformationModelId, faultSectionId);
        EstimateInstances slipRateEstInstance = this.deformationModelDAO.getSlipRateEstimate(deformationModelId, faultSectionId);
        Estimate slipRateEstimate = null;
        Estimate aseismicSlipEstimate = null;
        if (slipRateEstInstance != null) {
            slipRateEstimate = slipRateEstInstance.getEstimate();
        }
        if (asesmicSlipEstInstance != null) {
            aseismicSlipEstimate = asesmicSlipEstInstance.getEstimate();
        }
        JPanel slipRatePanel = GUI_Utils.getPanel(new InfoLabel(slipRateEstimate, SLIP_RATE, ""), SLIP_RATE);
        this.getContentPane().add((Component)slipRatePanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        JPanel aseicmicSlipPanel = GUI_Utils.getPanel(new InfoLabel(aseismicSlipEstimate, ASEISMIC_SLIP_FACTOR, ""), ASEISMIC_SLIP_FACTOR);
        this.getContentPane().add((Component)aseicmicSlipPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.pack();
        this.show();
    }
}

