/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.refFaultParamDb.gui.view;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.JPanel;
import org.opensha.commons.data.estimate.Estimate;
import org.opensha.commons.data.estimate.LogNormalEstimate;
import org.opensha.commons.data.estimate.NormalEstimate;
import org.opensha.commons.gui.LabeledBoxPanel;
import org.opensha.commons.param.editor.impl.ConstrainedStringParameterEditor;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.impl.StringParameter;
import org.opensha.refFaultParamDb.dao.db.DB_AccessAPI;
import org.opensha.refFaultParamDb.dao.db.PaleoEventDB_DAO;
import org.opensha.refFaultParamDb.data.TimeAPI;
import org.opensha.refFaultParamDb.data.TimeEstimate;
import org.opensha.refFaultParamDb.gui.infotools.GUI_Utils;
import org.opensha.refFaultParamDb.gui.infotools.InfoLabel;
import org.opensha.refFaultParamDb.vo.EstimateInstances;
import org.opensha.refFaultParamDb.vo.PaleoEvent;
import org.opensha.refFaultParamDb.vo.PaleoSite;
import org.opensha.refFaultParamDb.vo.Reference;

public class ViewIndividualEvent
extends LabeledBoxPanel
implements ParameterChangeListener {
    private static final String EVENT_NAME_PARAM_NAME = "Event Name";
    private static final String COMMENTS_PARAM_NAME = "Comments";
    private static final String REFERENCES_PARAM_NAME = "References";
    private static final String TIME_ESTIMATE_PARAM_NAME = "Event Time Estimate";
    private static final String SLIP_ESTIMATE_PARAM_NAME = "Event Slip Estimate";
    private static final String DISPLACEMENT_SHARED_PARAM_NAME = "Slip Shared With Other Events";
    private static final String SHARED_EVENT_PARAM_NAME = "Names of Events Sharing Slip";
    private static final String TITLE = "Individual Events";
    private static final String TEST_EVENT1 = "Test Event 1";
    private static final String TEST_EVENT2 = "Test Event 2";
    private static final String SHARED = "Shared";
    private static final String NOT_SHARED = "Not Shared";
    private static final String SLIP = "Slip";
    private static final String PROB = "Prob this is correct value";
    private static final String SENSE_OF_MOTION_TITLE = "Sense of Motion";
    private static final String MEASURED_COMP_SLIP_TITLE = "Measured Component of Slip";
    private static final String DISPLACEMENT = "Displacement";
    private static final String RAKE = "Rake";
    private static final String QUALITATIVE = "Qualitative";
    private StringParameter eventNameParam;
    private InfoLabel commentsLabel = new InfoLabel();
    private InfoLabel timeEstLabel = new InfoLabel();
    private InfoLabel slipEstLabel = new InfoLabel();
    private InfoLabel displacementSharedLabel = new InfoLabel();
    private InfoLabel sharedEventLabel = new InfoLabel();
    private InfoLabel referencesLabel = new InfoLabel();
    private InfoLabel senseOfMotionRakeLabel = new InfoLabel();
    private InfoLabel senseOfMotionQualLabel = new InfoLabel();
    private InfoLabel measuredCompQualLabel = new InfoLabel();
    private ConstrainedStringParameterEditor eventNameParamEditor;
    private PaleoSite paleoSite = null;
    private PaleoEventDB_DAO paleoEventDAO;
    private ArrayList paleoEventsList;
    private ArrayList eventNamesList;

    public ViewIndividualEvent(DB_AccessAPI dbConnection) {
        this.paleoEventDAO = new PaleoEventDB_DAO(dbConnection);
        try {
            this.setLayout(GUI_Utils.gridBagLayout);
            this.createEventListParameterEditor();
            this.addEditorstoGUI();
            this.setTitle(TITLE);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void createEventListParameterEditor() {
        if (this.eventNameParamEditor != null) {
            this.remove(this.eventNameParamEditor);
        }
        ArrayList eventNamesList = this.getEventNamesList();
        this.eventNameParam = new StringParameter(EVENT_NAME_PARAM_NAME, eventNamesList, (String)eventNamesList.get(0));
        this.eventNameParam.addParameterChangeListener(this);
        this.eventNameParamEditor = new ConstrainedStringParameterEditor(this.eventNameParam);
        this.add((Component)this.eventNameParamEditor, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.eventNameParamEditor.refreshParamEditor();
        this.updateUI();
        this.setEventInfo((String)this.eventNameParam.getValue());
    }

    private ArrayList getEventNamesList() {
        this.paleoEventsList = null;
        this.eventNamesList = new ArrayList();
        if (this.isTestSite()) {
            this.eventNamesList.add(TEST_EVENT1);
            this.eventNamesList.add(TEST_EVENT2);
        } else {
            this.paleoEventsList = this.paleoEventDAO.getAllEvents(this.paleoSite.getSiteId());
            if (this.paleoEventsList == null || this.paleoEventsList.size() == 0) {
                this.eventNamesList.add("NA");
            } else {
                for (int i = 0; i < this.paleoEventsList.size(); ++i) {
                    this.eventNamesList.add(((PaleoEvent)this.paleoEventsList.get(i)).getEventName());
                }
            }
        }
        return this.eventNamesList;
    }

    private boolean isTestSite() {
        return this.paleoSite == null || this.paleoSite.getSiteName().equalsIgnoreCase("A Sample Site");
    }

    private void addEditorstoGUI() {
        int yPos = 1;
        JPanel senseOfMotionPanel = GUI_Utils.getPanel(SENSE_OF_MOTION_TITLE);
        JPanel measuredSlipCompPanel = GUI_Utils.getPanel(MEASURED_COMP_SLIP_TITLE);
        senseOfMotionPanel.add((Component)this.senseOfMotionRakeLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        senseOfMotionPanel.add((Component)this.senseOfMotionQualLabel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        measuredSlipCompPanel.add((Component)this.measuredCompQualLabel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)GUI_Utils.getPanel(this.timeEstLabel, TIME_ESTIMATE_PARAM_NAME), new GridBagConstraints(0, yPos++, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.add((Component)GUI_Utils.getPanel(this.slipEstLabel, SLIP_ESTIMATE_PARAM_NAME), new GridBagConstraints(0, yPos++, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.add((Component)GUI_Utils.getPanel(this.displacementSharedLabel, DISPLACEMENT_SHARED_PARAM_NAME), new GridBagConstraints(0, yPos++, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.add((Component)GUI_Utils.getPanel(this.sharedEventLabel, SHARED_EVENT_PARAM_NAME), new GridBagConstraints(0, yPos++, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.add((Component)GUI_Utils.getPanel(this.commentsLabel, COMMENTS_PARAM_NAME), new GridBagConstraints(0, yPos++, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.add((Component)GUI_Utils.getPanel(this.referencesLabel, REFERENCES_PARAM_NAME), new GridBagConstraints(0, yPos++, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.add((Component)measuredSlipCompPanel, new GridBagConstraints(0, yPos++, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.add((Component)senseOfMotionPanel, new GridBagConstraints(0, yPos++, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
    }

    @Override
    public void parameterChange(ParameterChangeEvent event) {
        this.setEventInfo((String)this.eventNameParam.getValue());
    }

    public void setSite(PaleoSite paleoSite) {
        this.paleoSite = paleoSite;
        this.createEventListParameterEditor();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setEventInfo(String eventName) {
        block8: {
            block9: {
                if (!this.isTestSite()) break block8;
                if (eventName.equalsIgnoreCase(TEST_EVENT1)) break block9;
                if (!eventName.equalsIgnoreCase(TEST_EVENT2)) break block8;
            }
            TimeEstimate startTime = new TimeEstimate();
            startTime.setForKaUnits(new NormalEstimate(1000.0, 50.0), 1950);
            String comments = "Comments about this event";
            ArrayList<String> references = new ArrayList<String>();
            references.add("Ref 4");
            references.add("Ref 1");
            LogNormalEstimate slipRateEstimate = new LogNormalEstimate(1.5, 0.25);
            String displacement = SHARED;
            ArrayList<String> eventsList = new ArrayList<String>();
            eventsList.add("Event 10");
            eventsList.add("Event 11");
            this.updateLabels(startTime, slipRateEstimate, comments, references, displacement, eventsList, null, null, null);
            return;
        }
        if (this.paleoEventsList != null && this.paleoEventsList.size() != 0) {
            int index = this.eventNamesList.indexOf(eventName);
            PaleoEvent paleoEvent = (PaleoEvent)this.paleoEventsList.get(index);
            ArrayList<String> sharingEventNames = this.paleoEventDAO.getEventNamesForDisplacement(paleoEvent.getDisplacementEstId());
            String displacement = NOT_SHARED;
            if (sharingEventNames != null && sharingEventNames.size() > 0) {
                displacement = SHARED;
            } else {
                sharingEventNames = null;
            }
            ArrayList<Reference> refList = paleoEvent.getReferenceList();
            ArrayList<String> summaryList = new ArrayList<String>();
            int i = 0;
            while (true) {
                if (i >= refList.size()) {
                    this.updateLabels(paleoEvent.getEventTime(), paleoEvent.getDisplacementEst().getEstimate(), paleoEvent.getComments(), summaryList, displacement, sharingEventNames, paleoEvent.getSenseOfMotionRake(), paleoEvent.getSenseOfMotionQual(), paleoEvent.getMeasuredComponentQual());
                    return;
                }
                summaryList.add(refList.get(i).getSummary());
                ++i;
            }
        }
        this.updateLabels(null, null, null, null, null, null, null, null, null);
    }

    private void updateLabels(TimeAPI eventTime, Estimate slipEstimate, String comments, ArrayList references, String displacement, ArrayList sharingEvents, EstimateInstances rakeForSenseOfMotion, String senseOfMotionQual, String measuredSlipQual) {
        this.commentsLabel.setTextAsHTML(comments);
        this.timeEstLabel.setTextAsHTML(eventTime);
        this.slipEstLabel.setTextAsHTML(slipEstimate, SLIP, PROB);
        this.displacementSharedLabel.setTextAsHTML(displacement);
        this.sharedEventLabel.setTextAsHTML(sharingEvents);
        this.referencesLabel.setTextAsHTML(references);
        this.measuredCompQualLabel.setTextAsHTML(QUALITATIVE, measuredSlipQual);
        Estimate rakeEst = null;
        if (rakeForSenseOfMotion != null) {
            rakeEst = rakeForSenseOfMotion.getEstimate();
        }
        this.senseOfMotionRakeLabel.setTextAsHTML(rakeEst, RAKE, PROB);
        this.senseOfMotionQualLabel.setTextAsHTML(QUALITATIVE, senseOfMotionQual);
    }
}

