/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.refFaultParamDb.gui.view;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import org.opensha.commons.gui.LabeledBoxPanel;
import org.opensha.commons.gui.TitledBorderPanel;
import org.opensha.commons.param.editor.impl.ConstrainedStringParameterEditor;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.impl.StringParameter;
import org.opensha.refFaultParamDb.dao.db.DB_AccessAPI;
import org.opensha.refFaultParamDb.dao.db.PaleoSiteDB_DAO;
import org.opensha.refFaultParamDb.gui.addEdit.paleoSite.AddEditIndividualEvent;
import org.opensha.refFaultParamDb.gui.addEdit.paleoSite.AddEditSiteCharacteristics;
import org.opensha.refFaultParamDb.gui.addEdit.paleoSite.AddSiteInfo;
import org.opensha.refFaultParamDb.gui.event.DbAdditionListener;
import org.opensha.refFaultParamDb.gui.event.DbAdditionSuccessEvent;
import org.opensha.refFaultParamDb.gui.infotools.GUI_Utils;
import org.opensha.refFaultParamDb.gui.infotools.InfoLabel;
import org.opensha.refFaultParamDb.gui.infotools.SessionInfo;
import org.opensha.refFaultParamDb.gui.view.SiteSelectionAPI;
import org.opensha.refFaultParamDb.vo.CombinedDisplacementInfo;
import org.opensha.refFaultParamDb.vo.CombinedEventsInfo;
import org.opensha.refFaultParamDb.vo.CombinedNumEventsInfo;
import org.opensha.refFaultParamDb.vo.CombinedSlipRateInfo;
import org.opensha.refFaultParamDb.vo.FaultSectionSummary;
import org.opensha.refFaultParamDb.vo.PaleoSite;
import org.opensha.refFaultParamDb.vo.PaleoSitePublication;
import org.opensha.refFaultParamDb.vo.PaleoSiteSummary;

public class ViewSiteCharacteristics
extends JPanel
implements ActionListener,
ParameterChangeListener,
DbAdditionListener {
    private static final String SITE_NAME_PARAM_NAME = "Site Name";
    private static final String SITE_LOCATION_PARAM_NAME = "Site Location";
    private static final String SITE_ELEVATION_PARAM_NAME = "Site Elevation";
    private static final String ASSOCIATED_WITH_FAULT_PARAM_NAME = "Associated With Fault Section";
    private static final String SITE_TYPE_PARAM_NAME = "Site Type";
    private static final String SITE_REPRESENTATION_PARAM_NAME = "How Representative is this Site";
    private static final String SITE_REFERENCES_PARAM_NAME = "References";
    private static final String AVAILABLE_INFO_PARAM_NAME = "I have Publication data for";
    private static final String SLIP_RATE_INFO = "Slip Rate";
    private static final String CUMULATIVE_DISPLACEMENT_INFO = "Cumulative Displacement";
    private static final String NUM_EVENTS_INFO = "Number of Events";
    private static final String INDIVIDUAL_EVENTS_INFO = "Individual Events";
    private static final String SEQUENCE_INFO = "Sequence Info";
    private static final String NO_SITE_NAME = "No Site Name-";
    private static final String CONTRIBUTOR_PARAM_NAME = "Last Updated by";
    private static final String ENTRY_DATE_PARAM_NAME = "Last Updated on";
    private static final String MSG_ADD_DATA_ALREADY_OPEN = "Add Data window is already open";
    private static final String MSG_EVENT_ALREADY_OPEN = "Add Events Data window is already open";
    private static final String TOOLTIP_EDIT_COMBINED_INFO = "Edit Data for this reference for selected timespan";
    private static final String MSG_NO_DATA_TO_EDIT = "Cannot edit data as timespan has not been selected";
    private static final String MSG_NEED_DISPLACEMENT = "Displacement data does not exist for this timespan.\nDo you want to add that?";
    private static final String MSG_NEED_SLIP_RATE = "Slip Rate data does not exist for this timespan.\nDo you want to add that?";
    private static final String MSG_NEED_NUM_EVENTS = "Num Events data does not exist for this timespan.\nDo you want to add that?";
    private static final String EDIT_INFO = "Edit Data";
    private JCheckBox slipRateCheckBox;
    private JCheckBox cumDispCheckBox;
    private JCheckBox numEventsCheckBox;
    private JCheckBox individualEventsCheckBox;
    private JCheckBox sequenceCheckBox;
    private StringParameter siteNameParam;
    private StringParameter referencesForSiteParam;
    public static final String TEST_SITE = "A Sample Site";
    private static final String MSG_TEST_SITE_NOT_EDITABLE = "Sample site is non-editable";
    private ConstrainedStringParameterEditor siteNameParamEditor;
    private ConstrainedStringParameterEditor referencesForSiteParamEditor;
    private InfoLabel siteLocationLabel = new InfoLabel();
    private InfoLabel siteElevationLabel = new InfoLabel();
    private InfoLabel assocWithFaultLabel = new InfoLabel();
    private InfoLabel siteTypeLabel = new InfoLabel();
    private InfoLabel siteRepresentationLabel = new InfoLabel();
    private InfoLabel lastEntryDateLabel = new InfoLabel();
    private InfoLabel sendEmailLabel = new InfoLabel("To change the above info, send email to perry@gps.caltech.edu");
    private InfoLabel contributorNameLabel = new InfoLabel();
    private LabeledBoxPanel iHaveInfoOnPanel;
    private String ADD_SITE = "Add New Site";
    private JButton editSiteButton = new JButton("Edit");
    private JButton editCombinedInfoButton = new JButton("Edit Data");
    private JButton qFaultsEntriesButton = new JButton("Show QFault entries");
    private JButton addInfoButton = new JButton("Add Data");
    private JSplitPane splitPane = new JSplitPane();
    private JPanel addEditSitePanel = new TitledBorderPanel("Site Characteristics");
    private ArrayList paleoSiteSummaryList;
    private ArrayList siteNamesList;
    private PaleoSite paleoSite;
    private SiteSelectionAPI siteSelectionListener;
    private AddEditSiteCharacteristics addEditSiteChars;
    private AddSiteInfo addSiteInfo;
    private AddEditIndividualEvent addEditIndividualEvent;
    private PaleoSiteDB_DAO paleoSiteDAO;
    private DB_AccessAPI dbConnection;

    public ViewSiteCharacteristics(DB_AccessAPI dbConnection, SiteSelectionAPI siteSelectionListener) {
        this.dbConnection = dbConnection;
        this.paleoSiteDAO = new PaleoSiteDB_DAO(dbConnection);
        try {
            this.siteSelectionListener = siteSelectionListener;
            this.addEditSitePanel.setLayout(GUI_Utils.gridBagLayout);
            this.qFaultsEntriesButton.setEnabled(false);
            this.initSiteNamesParameterAndEditor();
            this.addUserProvidedInfoChoices();
            this.jbInit();
            this.addActionListeners();
            if (SessionInfo.getContributor() == null) {
                this.addInfoButton.setEnabled(false);
                this.editCombinedInfoButton.setEnabled(false);
                this.editSiteButton.setEnabled(false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addUserProvidedInfoChoices() {
        this.iHaveInfoOnPanel = new LabeledBoxPanel(GUI_Utils.gridBagLayout);
        this.iHaveInfoOnPanel.setTitle(AVAILABLE_INFO_PARAM_NAME);
        this.slipRateCheckBox = new JCheckBox(SLIP_RATE_INFO);
        this.cumDispCheckBox = new JCheckBox(CUMULATIVE_DISPLACEMENT_INFO);
        this.numEventsCheckBox = new JCheckBox(NUM_EVENTS_INFO);
        this.individualEventsCheckBox = new JCheckBox(INDIVIDUAL_EVENTS_INFO);
        this.sequenceCheckBox = new JCheckBox(SEQUENCE_INFO);
        this.slipRateCheckBox.addActionListener(this);
        this.cumDispCheckBox.addActionListener(this);
        int yPos = 0;
        this.iHaveInfoOnPanel.add((Component)this.slipRateCheckBox, new GridBagConstraints(0, yPos++, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.iHaveInfoOnPanel.add((Component)this.cumDispCheckBox, new GridBagConstraints(0, yPos++, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.iHaveInfoOnPanel.add((Component)this.numEventsCheckBox, new GridBagConstraints(0, yPos++, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.iHaveInfoOnPanel.add((Component)this.individualEventsCheckBox, new GridBagConstraints(0, yPos++, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.iHaveInfoOnPanel.add((Component)this.sequenceCheckBox, new GridBagConstraints(0, yPos++, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.iHaveInfoOnPanel.add((Component)this.addInfoButton, new GridBagConstraints(0, yPos++, 1, 1, 1.0, 1.0, 10, 0, new Insets(2, 2, 2, 2), 0, 0));
    }

    private void jbInit() {
        this.setLayout(GUI_Utils.gridBagLayout);
        this.splitPane.setOrientation(0);
        this.setMinimumSize(new Dimension(0, 0));
        this.add((Component)this.splitPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.splitPane.add((Component)this.addEditSitePanel, "top");
        this.addEditSiteCharacteristicsPanel();
        this.splitPane.add((Component)this.iHaveInfoOnPanel, "bottom");
        this.splitPane.setDividerLocation(375);
    }

    private void addEditSiteCharacteristicsPanel() {
        int siteYPos = 1;
        this.addEditSitePanel.add((Component)this.siteLocationLabel, new GridBagConstraints(0, siteYPos++, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.addEditSitePanel.add((Component)this.siteElevationLabel, new GridBagConstraints(0, siteYPos++, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.addEditSitePanel.add((Component)this.assocWithFaultLabel, new GridBagConstraints(0, siteYPos++, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.addEditSitePanel.add((Component)this.sendEmailLabel, new GridBagConstraints(0, siteYPos++, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        int n = ++siteYPos;
        this.addEditSitePanel.add((Component)this.siteTypeLabel, new GridBagConstraints(0, n, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        int n2 = ++siteYPos;
        this.addEditSitePanel.add((Component)this.siteRepresentationLabel, new GridBagConstraints(0, n2, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        int n3 = ++siteYPos;
        this.addEditSitePanel.add((Component)this.lastEntryDateLabel, new GridBagConstraints(0, n3, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        int n4 = ++siteYPos;
        this.addEditSitePanel.add((Component)this.contributorNameLabel, new GridBagConstraints(0, n4, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        int n5 = ++siteYPos;
        this.addEditSitePanel.add((Component)this.editCombinedInfoButton, new GridBagConstraints(0, n5, 1, 1, 1.0, 1.0, 10, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.editCombinedInfoButton.setToolTipText(TOOLTIP_EDIT_COMBINED_INFO);
        int n6 = ++siteYPos;
        ++siteYPos;
        this.addEditSitePanel.add((Component)this.qFaultsEntriesButton, new GridBagConstraints(0, n6, 1, 1, 1.0, 1.0, 10, 0, new Insets(2, 2, 2, 2), 0, 0));
    }

    private void addActionListeners() {
        this.editSiteButton.addActionListener(this);
        this.addInfoButton.addActionListener(this);
        this.editCombinedInfoButton.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        try {
            if (this.paleoSite == null) {
                JOptionPane.showMessageDialog(this, MSG_TEST_SITE_NOT_EDITABLE);
                return;
            }
            if (source == this.editSiteButton) {
                this.addEditSiteChars.addDbAdditionSuccessListener(this);
            } else if (source == this.addInfoButton) {
                this.addNewCombinedInfo();
            } else if (source == this.editCombinedInfoButton) {
                this.editCombinedInfo();
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.getMessage());
        }
    }

    private void editCombinedInfo() {
        CombinedEventsInfo combinedInfo = this.siteSelectionListener.getSelectedCombinedInfo();
        if (combinedInfo == null) {
            JOptionPane.showMessageDialog(this, MSG_NO_DATA_TO_EDIT);
            return;
        }
        if (this.addSiteInfo != null && this.addSiteInfo.isVisible()) {
            JOptionPane.showMessageDialog(this, MSG_ADD_DATA_ALREADY_OPEN);
            return;
        }
        boolean isDispVisible = false;
        boolean isSlipRateVisible = false;
        boolean isNumEventsVisible = false;
        CombinedDisplacementInfo combinedDisplacementInfo = combinedInfo.getCombinedDisplacementInfo();
        if (combinedDisplacementInfo != null) {
            isDispVisible = true;
        } else {
            int option = JOptionPane.showConfirmDialog(this, MSG_NEED_DISPLACEMENT, EDIT_INFO, 0);
            if (option == 0) {
                isDispVisible = true;
            }
        }
        CombinedSlipRateInfo combinedSlipRateInfo = combinedInfo.getCombinedSlipRateInfo();
        if (combinedSlipRateInfo != null) {
            isSlipRateVisible = true;
        } else {
            int option = JOptionPane.showConfirmDialog(this, MSG_NEED_SLIP_RATE, EDIT_INFO, 0);
            if (option == 0) {
                isSlipRateVisible = true;
            }
        }
        CombinedNumEventsInfo combinedNumEventsInfo = combinedInfo.getCombinedNumEventsInfo();
        if (combinedNumEventsInfo != null) {
            isNumEventsVisible = true;
        } else {
            int option = JOptionPane.showConfirmDialog(this, MSG_NEED_NUM_EVENTS, EDIT_INFO, 0);
            if (option == 0) {
                isNumEventsVisible = true;
            }
        }
        combinedInfo.setPaleoSitePublication(this.getPaleoSitePublication((String)this.referencesForSiteParam.getValue()));
        this.addSiteInfo = new AddSiteInfo(this.dbConnection, this.paleoSite.getSiteId(), this.paleoSite.getEntryDate(), isSlipRateVisible, isDispVisible, isNumEventsVisible, false, combinedInfo);
        this.addSiteInfo.addDbAdditionSuccessListener(this);
    }

    private void addNewCombinedInfo() {
        if (this.slipRateCheckBox.isSelected() || this.cumDispCheckBox.isSelected() || this.numEventsCheckBox.isSelected() || this.sequenceCheckBox.isSelected()) {
            if (this.addSiteInfo != null && this.addSiteInfo.isVisible()) {
                JOptionPane.showMessageDialog(this, MSG_ADD_DATA_ALREADY_OPEN);
                return;
            }
            this.addSiteInfo = new AddSiteInfo(this.dbConnection, this.paleoSite.getSiteId(), this.paleoSite.getEntryDate(), this.slipRateCheckBox.isSelected(), this.cumDispCheckBox.isSelected(), this.numEventsCheckBox.isSelected(), this.sequenceCheckBox.isSelected());
            this.addSiteInfo.addDbAdditionSuccessListener(this);
        }
        if (this.individualEventsCheckBox.isSelected()) {
            if (this.addEditIndividualEvent != null && this.addEditIndividualEvent.isVisible()) {
                JOptionPane.showMessageDialog(this, MSG_EVENT_ALREADY_OPEN);
                return;
            }
            this.showIndividualEventWindow();
        }
    }

    private void initSiteNamesParameterAndEditor() throws Exception {
        if (this.siteNameParamEditor != null) {
            this.addEditSitePanel.remove(this.siteNameParamEditor);
        }
        ArrayList availableSites = this.getSiteNames();
        this.siteNameParam = new StringParameter(SITE_NAME_PARAM_NAME, availableSites, (String)availableSites.get(0));
        this.siteNameParamEditor = new ConstrainedStringParameterEditor(this.siteNameParam);
        this.siteNameParam.addParameterChangeListener(this);
        this.addEditSitePanel.add((Component)this.siteNameParamEditor, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.setSiteInfo((String)availableSites.get(0));
    }

    private void initReferencesForSiteParameterAndEditor() {
        if (this.referencesForSiteParamEditor != null) {
            this.addEditSitePanel.remove(this.referencesForSiteParamEditor);
        }
        ArrayList<String> pubNames = new ArrayList<String>();
        if (this.paleoSite != null) {
            ArrayList<PaleoSitePublication> paleoSitePubList = this.paleoSite.getPaleoSitePubList();
            for (int i = 0; i < paleoSitePubList.size(); ++i) {
                pubNames.add(paleoSitePubList.get(i).getReference().getSummary());
            }
        } else {
            pubNames.add("Ref 1");
            pubNames.add("Ref 2");
        }
        this.referencesForSiteParam = new StringParameter(SITE_REFERENCES_PARAM_NAME, pubNames, (String)pubNames.get(0));
        this.referencesForSiteParam.addParameterChangeListener(this);
        this.referencesForSiteParamEditor = new ConstrainedStringParameterEditor(this.referencesForSiteParam);
        this.addEditSitePanel.add((Component)this.referencesForSiteParamEditor, new GridBagConstraints(0, 5, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.setValuesBasedOnReference((String)pubNames.get(0));
    }

    private void setValuesBasedOnReference(String refName) {
        Object siteType = null;
        String siteRepresentation = null;
        String lastEntryDate = null;
        String lastUpdatedBy = null;
        int refId = -1;
        if (this.paleoSite == null) {
            siteType = "Trench";
            siteRepresentation = "Most Significant Strand";
            lastEntryDate = "Not Available";
            lastUpdatedBy = "Test";
        } else {
            PaleoSitePublication paleoSitePub = this.getPaleoSitePublication(refName);
            refId = paleoSitePub.getReference().getReferenceId();
            ArrayList<String> studyTypes = paleoSitePub.getSiteTypeNames();
            siteType = "";
            for (int j = 0; j < studyTypes.size(); ++j) {
                siteType = (String)siteType + String.valueOf(studyTypes.get(j)) + ",";
            }
            siteRepresentation = paleoSitePub.getRepresentativeStrandName();
            lastEntryDate = paleoSitePub.getEntryDate();
            lastUpdatedBy = paleoSitePub.getContributorName();
        }
        this.siteTypeLabel.setTextAsHTML(SITE_TYPE_PARAM_NAME, (String)siteType);
        this.siteRepresentationLabel.setTextAsHTML(SITE_REPRESENTATION_PARAM_NAME, siteRepresentation);
        this.lastEntryDateLabel.setTextAsHTML(ENTRY_DATE_PARAM_NAME, lastEntryDate);
        this.contributorNameLabel.setTextAsHTML(CONTRIBUTOR_PARAM_NAME, lastUpdatedBy);
        this.siteSelectionListener.siteSelected(this.paleoSite, refId);
    }

    private PaleoSitePublication getPaleoSitePublication(String refName) {
        ArrayList<PaleoSitePublication> paleoSitePubList = this.paleoSite.getPaleoSitePubList();
        for (int i = 0; i < paleoSitePubList.size(); ++i) {
            PaleoSitePublication paleoSitePub = paleoSitePubList.get(i);
            String summary = paleoSitePub.getReference().getSummary();
            if (!summary.equalsIgnoreCase(refName)) continue;
            return paleoSitePub;
        }
        return null;
    }

    private void setSiteInfo(String siteName) {
        float elevation;
        float longitude;
        float latitude;
        String faultSectionName;
        if (siteName.equalsIgnoreCase(TEST_SITE)) {
            faultSectionName = "FaultSection1";
            latitude = 34.0f;
            longitude = -116.0f;
            elevation = 0.0f;
            this.paleoSite = null;
        } else {
            int index = this.siteNamesList.indexOf(siteName) - 1;
            PaleoSiteSummary paleoSiteSummary = (PaleoSiteSummary)this.paleoSiteSummaryList.get(index);
            this.paleoSite = this.paleoSiteDAO.getPaleoSite(paleoSiteSummary.getSiteId());
            FaultSectionSummary fs = this.paleoSite.getFaultSectionSummary();
            faultSectionName = fs == null ? "(null)" : fs.getSectionName();
            latitude = this.paleoSite.getSiteLat1();
            longitude = this.paleoSite.getSiteLon1();
            elevation = this.paleoSite.getSiteElevation1();
        }
        this.siteLocationLabel.setTextAsHTML(SITE_LOCATION_PARAM_NAME, GUI_Utils.latFormat.format(latitude) + "," + GUI_Utils.lonFormat.format(longitude));
        String elevationStr = null;
        if (!Float.isNaN(elevation)) {
            elevationStr = GUI_Utils.decimalFormat.format(elevation);
        }
        this.siteElevationLabel.setTextAsHTML(SITE_ELEVATION_PARAM_NAME, elevationStr);
        this.assocWithFaultLabel.setTextAsHTML(ASSOCIATED_WITH_FAULT_PARAM_NAME, faultSectionName);
        this.initReferencesForSiteParameterAndEditor();
    }

    @Override
    public void parameterChange(ParameterChangeEvent event) {
        String paramName = event.getParameterName();
        if (paramName.equalsIgnoreCase(SITE_NAME_PARAM_NAME)) {
            String siteName = (String)this.siteNameParam.getValue();
            if (siteName.equalsIgnoreCase(this.ADD_SITE)) {
                this.addEditSiteChars = new AddEditSiteCharacteristics(this.dbConnection);
                this.addEditSiteChars.addDbAdditionSuccessListener(this);
            } else {
                this.setSiteInfo(siteName);
            }
        } else if (paramName.equalsIgnoreCase(SITE_REFERENCES_PARAM_NAME)) {
            String refName = (String)this.referencesForSiteParam.getValue();
            this.setValuesBasedOnReference(refName);
        }
    }

    private ArrayList getSiteNames() {
        this.paleoSiteSummaryList = this.paleoSiteDAO.getAllPaleoSiteNames();
        this.siteNamesList = new ArrayList();
        this.siteNamesList.add(TEST_SITE);
        int numSites = this.paleoSiteSummaryList.size();
        for (int i = 0; i < numSites; ++i) {
            PaleoSiteSummary paleoSiteSummary = (PaleoSiteSummary)this.paleoSiteSummaryList.get(i);
            Object siteName = paleoSiteSummary.getSiteName().trim();
            if (siteName == null || ((String)siteName).equalsIgnoreCase("")) {
                siteName = NO_SITE_NAME + i;
            }
            this.siteNamesList.add(siteName);
        }
        this.siteNamesList.add(this.ADD_SITE);
        return this.siteNamesList;
    }

    @Override
    public void dbAdditionSuccessful(DbAdditionSuccessEvent event) {
        String siteName;
        Object source = event.getSource();
        if (source == this.addEditIndividualEvent) {
            this.addEditIndividualEvent.dispose();
            this.showIndividualEventWindow();
        }
        if ((siteName = (String)this.siteNameParam.getValue()).equalsIgnoreCase(this.ADD_SITE)) {
            try {
                this.initSiteNamesParameterAndEditor();
                this.updateUI();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            this.setSiteInfo(siteName);
        }
    }

    private void showIndividualEventWindow() {
        this.addEditIndividualEvent = new AddEditIndividualEvent(this.dbConnection, this.paleoSite.getSiteId(), this.paleoSite.getEntryDate());
        this.addEditIndividualEvent.addDbAdditionSuccessListener(this);
    }
}

