/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.calc;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import org.opensha.commons.data.Site;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.data.region.SitesInGriddedRegion;
import org.opensha.commons.exceptions.InvalidRangeException;
import org.opensha.commons.geo.Location;
import org.opensha.sha.earthquake.AbstractERF;
import org.opensha.sha.earthquake.ERF;
import org.opensha.sha.earthquake.ProbEqkRupture;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.gui.infoTools.CalcProgressBar;
import org.opensha.sha.gui.infoTools.IMT_Info;
import org.opensha.sha.imr.AttenuationRelationship;
import org.opensha.sha.imr.ScalarIMR;

public class HazusMapCalculator {
    protected static final String C = "HazusMapCalculator";
    protected static final boolean D = false;
    protected double MAX_DISTANCE = 2500.0;
    private DecimalFormat format = new DecimalFormat("0.000000##");
    boolean showProgressBar = true;
    private CalcProgressBar progressClass;
    private static final double hazusTimePeriod = 50.0;
    private DecimalFormat decimalFormat = new DecimalFormat("0.000000##");
    public static final String DATASETS_PATH = "HazusMapDataSets/";
    boolean xLogFlag = true;
    private String newDir;
    private double duration;
    boolean pgvSupported = true;
    private double[] returnPd = new double[]{100.0, 250.0, 500.0, 750.0, 1000.0, 1500.0, 2000.0, 2500.0};
    private String hazusMapMetadata;

    public void setMaxSourceDistance(double distance) {
        this.MAX_DISTANCE = distance;
    }

    public void getHazardMapCurves(SitesInGriddedRegion sites, ScalarIMR imr, AbstractERF eqkRupForecast, String mapParametersInfo) {
        boolean success;
        File mainDir = new File(DATASETS_PATH);
        this.hazusMapMetadata = mapParametersInfo;
        if (!mainDir.isDirectory()) {
            success = new File(DATASETS_PATH).mkdir();
            this.newDir = "HazusMapDataSets/Set-1";
        } else if (mainDir.list() != null) {
            int numDataSets = mainDir.list().length;
            this.newDir = "HazusMapDataSets/Set-" + numDataSets;
        } else {
            this.newDir = "HazusMapDataSets/Set-1";
        }
        success = new File(this.newDir).mkdir();
        try {
            FileWriter fr = new FileWriter(this.newDir + "/metadata.dat");
            fr.write(mapParametersInfo + "\n");
            fr.close();
            fr = new FileWriter(this.newDir + "/sites.dat");
            fr.write(sites.getRegion().getMinLat() + " " + sites.getRegion().getMaxLat() + " " + sites.getRegion().getSpacing() + "\n" + sites.getRegion().getMinLon() + " " + sites.getRegion().getMaxLon() + " " + sites.getRegion().getSpacing() + "\n");
            fr.close();
        }
        catch (IOException ee) {
            ee.printStackTrace();
        }
        this.calculate(sites, imr, eqkRupForecast);
    }

    public void getHazardMapCurves(String dirName, SitesInGriddedRegion sites, ScalarIMR imr, AbstractERF eqkRupForecast, String mapParametersInfo) {
        File mainDir = new File(DATASETS_PATH);
        this.hazusMapMetadata = mapParametersInfo;
        if (!mainDir.isDirectory()) {
            boolean bl = new File(DATASETS_PATH).mkdir();
        }
        this.newDir = DATASETS_PATH + dirName;
        File f = new File(this.newDir);
        int counter = 2;
        while (f.exists()) {
            this.newDir = DATASETS_PATH + dirName + "_" + counter;
            f = new File(this.newDir);
            ++counter;
        }
        boolean success = new File(this.newDir).mkdir();
        try {
            FileWriter fr = new FileWriter(this.newDir + "/metadata.dat");
            fr.write(mapParametersInfo + "\n");
            fr.close();
            fr = new FileWriter(this.newDir + "/sites.dat");
            fr.write(sites.getRegion().getMinLat() + " " + sites.getRegion().getMaxLat() + " " + sites.getRegion().getSpacing() + "\n" + sites.getRegion().getMinLon() + " " + sites.getRegion().getMaxLon() + " " + sites.getRegion().getSpacing() + "\n");
            fr.close();
        }
        catch (IOException ee) {
            ee.printStackTrace();
        }
        this.calculate(sites, imr, eqkRupForecast);
    }

    private void calculate(SitesInGriddedRegion sites, ScalarIMR imr, AbstractERF eqkRupForecast) {
        try {
            int j;
            int numSites = sites.getRegion().getNodeCount();
            this.duration = eqkRupForecast.getTimeSpan().getDuration();
            FileWriter[] fw = new FileWriter[this.returnPd.length];
            for (j = 0; j < this.returnPd.length; ++j) {
                fw[j] = new FileWriter(this.newDir + "/final_" + this.returnPd[j] + ".dat");
                fw[j].write(this.hazusMapMetadata + "\n");
                fw[j].write("##Column Info: Lat,Lon,PGA,PGV,SA-0.3,SA-1\n");
            }
            imr.setUserMaxDistance(this.MAX_DISTANCE);
            ((AttenuationRelationship)imr).resetParameterEventListeners();
            for (int i = 0; i < numSites; ++i) {
                Site site = sites.getSite(i);
                imr.setSite(site);
                DiscretizedFunc[] hazardFunc = this.getSiteHazardCurve(site, imr, eqkRupForecast);
                this.writeToFile(fw, site.getLocation(), hazardFunc);
            }
            for (j = 0; j < fw.length; ++j) {
                fw[j].close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void writeToFile(FileWriter[] fw, Location loc, DiscretizedFunc[] hazardFuncs) throws IOException {
        DiscretizedFunc pgaHazardFunction = hazardFuncs[0];
        DiscretizedFunc sa03HazardFunction = hazardFuncs[1];
        DiscretizedFunc sa1HazardFunction = hazardFuncs[2];
        DiscretizedFunc pgvHazardFunction = hazardFuncs[3];
        for (int i = 0; i < this.returnPd.length; ++i) {
            double rate = 1.0 / this.returnPd[i];
            double prob = 1.0 - Math.exp(-1.0 * rate * this.duration);
            double pgaIML = 0.0;
            double sa03IML = 0.0;
            double sa1IML = 0.0;
            double pgvIML = 0.0;
            try {
                pgaIML = ((ArbitrarilyDiscretizedFunc)pgaHazardFunction).getFirstInterpolatedX_inLogXLogYDomain(prob);
                sa03IML = ((ArbitrarilyDiscretizedFunc)sa03HazardFunction).getFirstInterpolatedX_inLogXLogYDomain(prob);
                sa1IML = ((ArbitrarilyDiscretizedFunc)sa1HazardFunction).getFirstInterpolatedX_inLogXLogYDomain(prob);
                pgvIML = ((ArbitrarilyDiscretizedFunc)pgvHazardFunction).getFirstInterpolatedX_inLogXLogYDomain(prob);
            }
            catch (InvalidRangeException invalidRangeException) {
                // empty catch block
            }
            if (!this.pgvSupported) {
                pgvIML = pgvIML * 37.24 * 2.54;
            }
            fw[i].write(this.format.format(loc.getLatitude()) + "," + this.format.format(loc.getLongitude()) + "," + this.format.format(pgaIML) + "," + this.format.format(pgvIML / 2.5) + "," + this.format.format(sa03IML) + "," + this.format.format(sa1IML) + "\n");
        }
    }

    private DiscretizedFunc initDiscretizedValuesToLog(DiscretizedFunc linearFunc, double val) {
        ArbitrarilyDiscretizedFunc toXLogFunc = new ArbitrarilyDiscretizedFunc();
        for (int i = 0; i < linearFunc.size(); ++i) {
            toXLogFunc.set(Math.log(linearFunc.getX(i)), val);
        }
        return toXLogFunc;
    }

    public DiscretizedFunc[] getSiteHazardCurve(Site site, ScalarIMR imr, ERF eqkRupForecast) {
        int i;
        int j;
        boolean poissonSource = false;
        int numIMTs = 4;
        ArbitrarilyDiscretizedFunc[] hazFunction = new ArbitrarilyDiscretizedFunc[numIMTs];
        ArbitrarilyDiscretizedFunc[] sourceHazFunc = new ArbitrarilyDiscretizedFunc[numIMTs];
        hazFunction[0] = IMT_Info.getUSGS_PGA_Function();
        hazFunction[1] = IMT_Info.getUSGS_SA_Function();
        hazFunction[2] = hazFunction[1].deepClone();
        IMT_Info imtInfo = new IMT_Info();
        ArbitrarilyDiscretizedFunc pgvFunction = imtInfo.getDefaultHazardCurve("PGV");
        hazFunction[3] = pgvFunction.deepClone();
        sourceHazFunc[0] = hazFunction[0].deepClone();
        sourceHazFunc[1] = hazFunction[1].deepClone();
        sourceHazFunc[2] = hazFunction[1].deepClone();
        sourceHazFunc[3] = hazFunction[1].deepClone();
        for (int m = 0; m < numIMTs; ++m) {
            this.initDiscretizeValues(hazFunction[m], 1.0);
            this.initDiscretizeValues(sourceHazFunc[m], 1.0);
        }
        DiscretizedFunc condProbFunc = null;
        String pgv = "PGV";
        this.pgvSupported = ((AttenuationRelationship)imr).isIntensityMeasureSupported(pgv);
        int numSources = eqkRupForecast.getNumSources();
        int totRuptures = 0;
        for (int sourceIndex = 0; sourceIndex < numSources; ++sourceIndex) {
            totRuptures += eqkRupForecast.getSource(sourceIndex).getNumRuptures();
        }
        int currRuptures = 0;
        boolean sourceUsed = false;
        int numPoints = 0;
        for (int sourceIndex = 0; sourceIndex < numSources; ++sourceIndex) {
            int k;
            ProbEqkSource source = eqkRupForecast.getSource(sourceIndex);
            double distance = source.getMinDistance(site);
            if (distance > this.MAX_DISTANCE) {
                currRuptures += source.getNumRuptures();
                continue;
            }
            sourceUsed = true;
            poissonSource = source.isSourcePoissonian();
            if (!poissonSource) {
                for (int m = 0; m < numIMTs; ++m) {
                    this.initDiscretizeValues(sourceHazFunc[m], 0.0);
                }
            }
            int numRuptures = source.getNumRuptures();
            int n = 0;
            while (n < numRuptures) {
                ProbEqkRupture rupture = source.getRupture(n);
                double qkProb = rupture.getProbability();
                imr.setEqkRupture(rupture);
                for (int imtIndex = 0; imtIndex < numIMTs; ++imtIndex) {
                    if (imtIndex == 0) {
                        condProbFunc = IMT_Info.getUSGS_PGA_Function();
                        imr.setIntensityMeasure("PGA");
                    } else if (imtIndex == 1) {
                        condProbFunc = IMT_Info.getUSGS_SA_Function();
                        imr.setIntensityMeasure("SA");
                        imr.getParameter("SA Period").setValue(0.3);
                    } else if (imtIndex == 2) {
                        condProbFunc = IMT_Info.getUSGS_SA_Function();
                        imr.setIntensityMeasure("SA");
                        imr.getParameter("SA Period").setValue(1.0);
                    } else if (imtIndex == 3) {
                        condProbFunc = pgvFunction.deepClone();
                        if (this.pgvSupported) {
                            imr.setIntensityMeasure(pgv);
                        } else {
                            imr.setIntensityMeasure("SA");
                            imr.getParameter("SA Period").setValue(1.0);
                        }
                    }
                    numPoints = condProbFunc.size();
                    condProbFunc = this.initDiscretizedValuesToLog(condProbFunc, 1.0);
                    condProbFunc = (ArbitrarilyDiscretizedFunc)imr.getExceedProbabilities(condProbFunc);
                    if (poissonSource) {
                        if (Math.log(1.0 - qkProb) < -30.0) {
                            throw new RuntimeException("Error: The probability for this ProbEqkRupture (" + qkProb + ") is too high for a Possion source (~infinite number of events)");
                        }
                        for (k = 0; k < numPoints; ++k) {
                            hazFunction[imtIndex].set(k, hazFunction[imtIndex].getY(k) * Math.pow(1.0 - qkProb, condProbFunc.getY(k)));
                        }
                        continue;
                    }
                    for (k = 0; k < numPoints; ++k) {
                        sourceHazFunc[imtIndex].set(k, sourceHazFunc[imtIndex].getY(k) + qkProb * condProbFunc.getY(k));
                    }
                }
                ++n;
                ++currRuptures;
            }
            if (poissonSource) continue;
            for (int i2 = 0; i2 < numIMTs; ++i2) {
                numPoints = hazFunction[i2].size();
                for (k = 0; k < numPoints; ++k) {
                    hazFunction[i2].set(k, hazFunction[i2].getY(k) * (1.0 - sourceHazFunc[i2].getY(k)));
                }
            }
        }
        if (sourceUsed) {
            for (j = 0; j < numIMTs; ++j) {
                numPoints = hazFunction[j].size();
                for (i = 0; i < numPoints; ++i) {
                    hazFunction[j].set(i, 1.0 - hazFunction[j].getY(i));
                }
            }
        } else {
            for (j = 0; j < numIMTs; ++j) {
                numPoints = hazFunction[j].size();
                for (i = 0; i < numPoints; ++i) {
                    hazFunction[j].set(i, 0.0);
                }
            }
        }
        DiscretizedFunc[] tempHazFunction = new ArbitrarilyDiscretizedFunc[numIMTs];
        for (int j2 = 0; j2 < numIMTs; ++j2) {
            tempHazFunction[j2] = new ArbitrarilyDiscretizedFunc();
        }
        numPoints = hazFunction[0].size();
        for (i = 0; i < numPoints; ++i) {
            tempHazFunction[0].set(hazFunction[0].getX(i), hazFunction[0].getY(i));
        }
        numPoints = hazFunction[1].size();
        for (i = 0; i < numPoints; ++i) {
            tempHazFunction[1].set(hazFunction[1].getX(i), hazFunction[1].getY(i));
        }
        numPoints = hazFunction[2].size();
        for (i = 0; i < numPoints; ++i) {
            tempHazFunction[2].set(hazFunction[2].getX(i), hazFunction[2].getY(i));
        }
        numPoints = hazFunction[3].size();
        for (i = 0; i < numPoints; ++i) {
            tempHazFunction[3].set(hazFunction[3].getX(i), hazFunction[3].getY(i));
        }
        return tempHazFunction;
    }

    private void initDiscretizeValues(DiscretizedFunc arb, double val) {
        int num = arb.size();
        for (int i = 0; i < num; ++i) {
            arb.set(i, val);
        }
    }

    public void showProgressBar(boolean show) {
        this.showProgressBar = show;
    }
}

