/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.calc.IM_EventSet;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.opensha.commons.data.Site;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.sha.calc.IM_EventSet.AbstractIMEventSetCalc;
import org.opensha.sha.calc.IM_EventSet.IMEventSetCalcAPI;
import org.opensha.sha.earthquake.ERF;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.imr.ScalarIMR;

public abstract class IM_EventSetOutputWriter {
    protected static Logger logger = AbstractIMEventSetCalc.logger;
    protected IMEventSetCalcAPI calc;
    private float sourceCutOffDistance = 0.0f;
    private Site siteForSourceCutOff = null;
    public static final DecimalFormat meanSigmaFormat = new DecimalFormat("0.####");
    public static final DecimalFormat distFormat = new DecimalFormat("0.###");
    public static final DecimalFormat rateFormat = new DecimalFormat("####0E0");

    public IM_EventSetOutputWriter(IMEventSetCalcAPI calc) {
        this.calc = calc;
    }

    public abstract void writeFiles(ArrayList<ERF> var1, ArrayList<ScalarIMR> var2, ArrayList<String> var3) throws IOException;

    public void writeFiles(ERF erf, ArrayList<ScalarIMR> attenRels, ArrayList<String> imts) throws IOException {
        ArrayList<ERF> erfs = new ArrayList<ERF>();
        erfs.add(erf);
        this.writeErfImrMetaFile(erfs, attenRels);
        this.writeFiles(erfs, attenRels, imts);
    }

    public void writeFiles(ERF erf, ScalarIMR imr, String imt) throws IOException {
        ArrayList<ScalarIMR> imrs = new ArrayList<ScalarIMR>();
        imrs.add(imr);
        ArrayList<String> imts = new ArrayList<String>();
        imts.add(imt);
        this.writeFiles(erf, imrs, imts);
    }

    public abstract String getName();

    private void writeErfImrMetaFile(ArrayList<ERF> erfs, ArrayList<ScalarIMR> attenRels) throws IOException {
        logger.log(Level.INFO, "Writing ERF/IMR metadata file");
        String fname = "erf_imr_metadata.txt";
        File outputDir = this.calc.getOutputDir();
        FileWriter fw = new FileWriter(outputDir.getAbsolutePath() + File.separator + fname);
        fw.write("IMR Param List:\n---------------");
        for (ScalarIMR attenRel : attenRels) {
            fw.write("\nIMR = " + attenRel.getName() + "; ");
            fw.write(attenRel.getOtherParams().getVisibleParams().getParameterListMetadataString());
        }
        fw.write("\n\nForecast Param List:\n---------------");
        for (ERF erf : erfs) {
            fw.write("\nEqk Rup Forecast = " + erf.getName() + "; ");
            fw.write(erf.getAdjustableParameterList().getParameterListMetadataString());
        }
        fw.close();
    }

    public static String getHAZ01IMTString(Parameter<?> param) {
        Object imt = param.getName();
        if (param instanceof Parameter) {
            Parameter<?> depParam = param;
            for (Parameter<?> dep : depParam.getIndependentParameterList()) {
                if (!dep.getName().equals("SA Period")) continue;
                double period = (Double)dep.getValue();
                int p10 = (int)(period * 10.0 + 0.5);
                String p10Str = "" + p10;
                if (p10Str.length() < 2) {
                    p10Str = "0" + p10Str;
                }
                imt = (String)imt + p10Str;
                break;
            }
        }
        return imt;
    }

    public static String getRegularIMTString(Parameter<?> param) {
        Object imt = param.getName();
        if (param instanceof Parameter) {
            Parameter<?> depParam = param;
            for (Parameter<?> dep : depParam.getIndependentParameterList()) {
                if (!dep.getName().equals("SA Period")) continue;
                double period = (Double)dep.getValue();
                imt = (String)imt + " " + (float)period;
                break;
            }
        }
        return imt;
    }

    public static void setIMTFromString(String imtStr, ScalarIMR attenRel) {
        String imt = imtStr.trim();
        if (imt.startsWith("SA") || imt.startsWith("SD")) {
            double period;
            logger.log(Level.FINE, "Parsing IMT with Period: " + imt);
            String perSt = imt.substring(2);
            String theIMT = imt.substring(0, 2);
            if (perSt.startsWith(" ") || perSt.startsWith("\t")) {
                logger.log(Level.FINEST, "Split into IMT: " + theIMT + ", Period portion: " + perSt);
                period = Double.parseDouble(perSt.trim());
            } else {
                logger.log(Level.FINEST, "Split into IMT: " + theIMT + ", Period portion (HAZ01 style): " + perSt);
                period = Double.parseDouble(perSt) / 10.0;
            }
            attenRel.setIntensityMeasure(theIMT);
            Parameter imtParam = attenRel.getIntensityMeasure();
            imtParam.getIndependentParameter("SA Period").setValue(period);
            logger.log(Level.FINE, "Parsed IMT with Period: " + imt + " => " + theIMT + ", period: " + period);
        } else {
            logger.log(Level.FINE, "Setting IMT from String");
            attenRel.setIntensityMeasure(imt);
        }
    }

    protected ArrayList<Parameter> getDefaultSiteParams(ScalarIMR attenRel) {
        logger.log(Level.FINE, "Storing default IMR site related params.");
        ListIterator<Parameter<?>> siteParamsIt = attenRel.getSiteParamsIterator();
        ArrayList<Parameter> defaultSiteParams = new ArrayList<Parameter>();
        while (siteParamsIt.hasNext()) {
            defaultSiteParams.add((Parameter)siteParamsIt.next().clone());
        }
        return defaultSiteParams;
    }

    protected void setSiteParams(ScalarIMR attenRel, ArrayList<Parameter> defaultSiteParams) {
        logger.log(Level.FINE, "Restoring default IMR site related params.");
        for (Parameter param : defaultSiteParams) {
            Parameter attenParam = attenRel.getParameter(param.getName());
            attenParam.setValue(param.getValue());
        }
    }

    protected ArrayList<Site> getInitializedSites(ScalarIMR attenRel) {
        logger.log(Level.FINE, "Retrieving and setting Site related params for IMR");
        ArrayList<Site> sites = this.calc.getSites();
        ArrayList<ParameterList> sitesData = this.calc.getSitesData();
        ListIterator<Parameter<?>> siteParamsIt = attenRel.getSiteParamsIterator();
        while (siteParamsIt.hasNext()) {
            Parameter<?> attenParam = siteParamsIt.next();
            for (int i = 0; i < sites.size(); ++i) {
                Parameter siteParam;
                Site site = sites.get(i);
                ParameterList siteData = sitesData.get(i);
                if (site.containsParameter(attenParam.getName())) {
                    siteParam = site.getParameter(attenParam.getName());
                } else {
                    siteParam = (Parameter)attenParam.clone();
                    site.addParameter(siteParam);
                }
                boolean success = false;
                for (Parameter<?> siteDatum : siteData) {
                    if (!siteDatum.getName().equals(siteParam.getName())) continue;
                    siteParam.setValue(siteDatum.getValue());
                    success = true;
                    break;
                }
                if (success) {
                    logger.log(Level.FINE, "Set site " + i + " param '" + siteParam.getName() + "' from data. New value: " + String.valueOf(siteParam.getValue()));
                    continue;
                }
                logger.log(Level.FINE, "Couldn't set site " + i + " param '" + siteParam.getName() + "' from data, setting to IMR default of: " + String.valueOf(attenParam.getValue()));
                siteParam.setValue(attenParam.getValue());
            }
        }
        return sites;
    }

    private float getSourceCutOffDistance() {
        if (this.sourceCutOffDistance == 0.0f) {
            this.createSiteList();
        }
        return this.sourceCutOffDistance;
    }

    private Site getSiteForSourceCutOff() {
        if (this.siteForSourceCutOff == null) {
            this.createSiteList();
        }
        return this.siteForSourceCutOff;
    }

    protected void createSiteList() {
        logger.log(Level.FINE, "Calculating source cutoff site and distance");
        double minLon = Double.MAX_VALUE;
        double maxLon = Double.NEGATIVE_INFINITY;
        double minLat = Double.MAX_VALUE;
        double maxLat = Double.NEGATIVE_INFINITY;
        int numSites = this.calc.getNumSites();
        for (int i = 0; i < numSites; ++i) {
            Location loc = this.calc.getSiteLocation(i);
            double lon = loc.getLongitude();
            double lat = loc.getLatitude();
            if (lon > maxLon) {
                maxLon = lon;
            }
            if (lon < minLon) {
                minLon = lon;
            }
            if (lat > maxLat) {
                maxLat = lat;
            }
            if (!(lat < minLat)) continue;
            minLat = lat;
        }
        double middleLon = (minLon + maxLon) / 2.0;
        double middleLat = (minLat + maxLat) / 2.0;
        this.sourceCutOffDistance = (float)LocationUtils.horzDistance(new Location(middleLat, middleLon), new Location(minLat, minLon)) + 200.0f;
        this.siteForSourceCutOff = new Site(new Location(middleLat, middleLon));
    }

    public boolean shouldIncludeSource(ProbEqkSource source) {
        float sourceCutOffDistance = this.getSourceCutOffDistance();
        Site siteForSourceCutOff = this.getSiteForSourceCutOff();
        double sourceDistFromSite = source.getMinDistance(siteForSourceCutOff);
        if (sourceDistFromSite > (double)sourceCutOffDistance) {
            logger.log(Level.FINEST, "Source outside of cutoff distance, skipping");
            return false;
        }
        return true;
    }

    public String toString() {
        return this.getName();
    }
}

