/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.calc.IM_EventSet.gui;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.opensha.commons.data.siteData.OrderedSiteDataProviderList;
import org.opensha.commons.data.siteData.SiteDataValue;
import org.opensha.commons.geo.Location;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.editor.impl.ParameterListEditor;
import org.opensha.commons.param.impl.DoubleParameter;
import org.opensha.nshmp2.imr.impl.Campbell_2003_AttenRel;
import org.opensha.sha.imr.AttenuationRelationship;
import org.opensha.sha.imr.IntensityMeasureRelationship;
import org.opensha.sha.imr.attenRelImpl.Field_2000_AttenRel;
import org.opensha.sha.util.SiteTranslator;

public class AddSitePanel
extends JPanel
implements ActionListener {
    private final ParameterListEditor siteDataParamEditor;
    private final DoubleParameter latParam;
    private final DoubleParameter lonParam;
    private static final boolean D = false;
    private JButton setFromWebButton;
    OrderedSiteDataProviderList providers;

    public AddSitePanel(ParameterList siteDataParams, OrderedSiteDataProviderList providers, Location loc) {
        this.setLayout(new BoxLayout(this, 0));
        this.providers = providers;
        ParameterList paramList = new ParameterList();
        this.latParam = new DoubleParameter("Latitude", loc.getLatitude());
        this.lonParam = new DoubleParameter("Longitude", loc.getLongitude());
        paramList.addParameter(this.latParam);
        paramList.addParameter(this.lonParam);
        ParameterListEditor paramEdit = new ParameterListEditor(paramList);
        paramEdit.setTitle("New Site Location");
        JPanel setFromWebPanel = new JPanel();
        setFromWebPanel.setLayout(new BoxLayout(setFromWebPanel, 1));
        setFromWebPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.setFromWebButton = new JButton("Set Params from Web Services");
        JTextArea infoText = new JTextArea("Clicking the above button will overwrite user-provided site data values\nwith the values from the web services. See the \"Site Data Providers\" pane\nto add or remove selected providers.\nLeaving a field blank will also fetch from web services.\n\nHover over site data types on right for more information.\nHover over text fields for min and max values for numeric inputs.\n");
        setFromWebPanel.add(Box.createVerticalStrut(5));
        setFromWebPanel.add(this.setFromWebButton);
        this.setFromWebButton.addActionListener(this);
        setFromWebPanel.add(Box.createVerticalStrut(5));
        setFromWebPanel.add(infoText);
        JPanel leftCol = new JPanel();
        leftCol.setLayout(new BoxLayout(leftCol, 1));
        leftCol.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 10));
        leftCol.add(paramEdit);
        leftCol.add(setFromWebPanel);
        this.add(leftCol);
        this.siteDataParamEditor = new ParameterListEditor(siteDataParams);
        this.siteDataParamEditor.setPreferredSize(new Dimension(250, this.siteDataParamEditor.getPreferredSize().height));
        this.siteDataParamEditor.setMaximumSize(new Dimension(250, 500));
        this.siteDataParamEditor.setTitle("Set Site Params");
        this.add(this.siteDataParamEditor);
    }

    public AddSitePanel(ParameterList siteDataParams, OrderedSiteDataProviderList providers) {
        this(siteDataParams, providers, new Location(34.0, -118.0));
    }

    public Location getSiteLocation() {
        return new Location((Double)this.latParam.getValue(), (Double)this.lonParam.getValue());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.setFromWebButton)) {
            ArrayList<SiteDataValue<?>> provData = this.providers.getBestAvailableData(this.getSiteLocation());
            ParameterList siteDataParams = this.siteDataParamEditor.getParameterList();
            SiteTranslator siteTrans = new SiteTranslator();
            for (Parameter<?> param : siteDataParams) {
                siteTrans.setParameterValue(param, provData);
            }
            this.siteDataParamEditor.refreshParamEditor();
        }
    }

    public static void main(String[] args) {
        ArrayList<AttenuationRelationship> imrs = new ArrayList<AttenuationRelationship>();
        imrs.add(new Campbell_2003_AttenRel(null));
        imrs.add(new Field_2000_AttenRel(null));
        ParameterList siteDataParams = ParameterList.union((ParameterList[])imrs.stream().map(IntensityMeasureRelationship::getSiteParams).toArray(ParameterList[]::new));
        JOptionPane.showConfirmDialog(null, siteDataParams, "Add Site", 2);
    }
}

