/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.calc;

import org.opensha.commons.data.Site;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.sha.earthquake.ERF;
import org.opensha.sha.earthquake.ProbEqkRupture;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.imr.AttenuationRelationship;
import org.opensha.sha.imr.ScalarIMR;

public class PortfolioLossCurveCalculator {
    protected static final String C = "HazardCurveCalculator";
    protected static final boolean D = false;
    public static final double MAX_DISTANCE_DEFAULT = 200.0;
    protected double MAX_DISTANCE = 200.0;
    protected int currRuptures = -1;
    protected int totRuptures = 0;
    protected int sourceIndex;
    protected int numSources;

    public void setMaxSourceDistance(double distance) {
        this.MAX_DISTANCE = distance;
    }

    public DiscretizedFunc getAnnualizedRates(DiscretizedFunc hazFunction, double years) {
        DiscretizedFunc annualizedRateFunc = hazFunction.deepClone();
        int size = annualizedRateFunc.size();
        for (int i = 0; i < size; ++i) {
            annualizedRateFunc.set(i, -Math.log(1.0 - annualizedRateFunc.getY(i)) / years);
        }
        return annualizedRateFunc;
    }

    public DiscretizedFunc getLossCurve(DiscretizedFunc hazFunction, Site site, ScalarIMR imr, ERF eqkRupForecast) {
        this.currRuptures = -1;
        boolean poissonSource = false;
        ArbitrarilyDiscretizedFunc condProbFunc = (ArbitrarilyDiscretizedFunc)hazFunction.deepClone();
        ArbitrarilyDiscretizedFunc sourceHazFunc = (ArbitrarilyDiscretizedFunc)hazFunction.deepClone();
        ((AttenuationRelationship)imr).resetParameterEventListeners();
        int numPoints = hazFunction.size();
        imr.setUserMaxDistance(this.MAX_DISTANCE);
        this.numSources = eqkRupForecast.getNumSources();
        this.totRuptures = 0;
        this.sourceIndex = 0;
        this.sourceIndex = 0;
        while (this.sourceIndex < this.numSources) {
            this.totRuptures += eqkRupForecast.getSource(this.sourceIndex).getNumRuptures();
            ++this.sourceIndex;
        }
        this.currRuptures = 0;
        this.initDiscretizeValues(hazFunction, 1.0);
        imr.setSite(site);
        boolean sourceUsed = false;
        this.sourceIndex = 0;
        while (this.sourceIndex < this.numSources) {
            ProbEqkSource source = eqkRupForecast.getSource(this.sourceIndex);
            double distance = source.getMinDistance(site);
            if (distance > this.MAX_DISTANCE) {
                this.currRuptures += source.getNumRuptures();
            } else {
                int k;
                sourceUsed = true;
                poissonSource = source.isSourcePoissonian();
                if (!poissonSource) {
                    this.initDiscretizeValues(sourceHazFunc, 0.0);
                }
                int numRuptures = source.getNumRuptures();
                int n = 0;
                while (n < numRuptures) {
                    ProbEqkRupture rupture = source.getRupture(n);
                    double qkProb = rupture.getProbability();
                    imr.setEqkRupture(rupture);
                    condProbFunc = (ArbitrarilyDiscretizedFunc)imr.getExceedProbabilities(condProbFunc);
                    if (poissonSource) {
                        if (Math.log(1.0 - qkProb) < -30.0) {
                            throw new RuntimeException("Error: The probability for this ProbEqkRupture (" + qkProb + ") is too high for a Possion source (~infinite number of events)");
                        }
                        for (k = 0; k < numPoints; ++k) {
                            hazFunction.set(k, hazFunction.getY(k) * Math.pow(1.0 - qkProb, condProbFunc.getY(k)));
                        }
                    } else {
                        for (k = 0; k < numPoints; ++k) {
                            sourceHazFunc.set(k, sourceHazFunc.getY(k) + qkProb * condProbFunc.getY(k));
                        }
                    }
                    ++n;
                    ++this.currRuptures;
                }
                if (!poissonSource) {
                    for (k = 0; k < numPoints; ++k) {
                        hazFunction.set(k, hazFunction.getY(k) * (1.0 - sourceHazFunc.getY(k)));
                    }
                }
            }
            ++this.sourceIndex;
        }
        if (sourceUsed) {
            for (int i = 0; i < numPoints; ++i) {
                hazFunction.set(i, 1.0 - hazFunction.getY(i));
            }
        } else {
            for (int i = 0; i < numPoints; ++i) {
                hazFunction.set(i, 0.0);
            }
        }
        return hazFunction;
    }

    public int getCurrRuptures() {
        return this.currRuptures;
    }

    public int getTotRuptures() {
        return this.totRuptures;
    }

    public void stopCalc() {
        this.sourceIndex = this.numSources;
    }

    protected void initDiscretizeValues(DiscretizedFunc arb, double val) {
        int num = arb.size();
        for (int i = 0; i < num; ++i) {
            arb.set(i, val);
        }
    }

    public static void main(String[] args) {
        for (double n = 1.0; n < 2.0; n += 0.02) {
            double temp1 = Math.pow(10.0, n);
            double temp2 = 1.0 - Math.exp(-temp1);
            double temp3 = Math.log(1.0 - temp2);
            double temp4 = (temp3 + temp1) / temp1;
            boolean OK = temp1 <= 30.0;
            System.out.println((float)n + "\t" + temp1 + "\t" + temp2 + "\t" + temp3 + "\t" + temp4 + "\t" + OK);
        }
    }
}

