/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.calc;

import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import org.opensha.commons.data.Site;
import org.opensha.commons.data.xyz.ArbDiscrGeoDataSet;
import org.opensha.commons.data.xyz.GeoDataSet;
import org.opensha.commons.exceptions.ParameterException;
import org.opensha.commons.param.ParameterList;
import org.opensha.sha.earthquake.EqkRupture;
import org.opensha.sha.gui.servlets.ScenarioShakeMapCalcServlet;
import org.opensha.sha.imr.AttenuationRelationship;

public class ScenarioShakeMapCalculator {
    protected static final String C = "ScenarioShakeMapCalculator";
    protected static final boolean D = false;
    private int numSites;
    private int currentSiteBeingProcessed;
    private FileWriter fw;
    private DecimalFormat locFormat = new DecimalFormat("0.000000");
    private ParameterList adjustableParams = new ParameterList();

    public GeoDataSet getScenarioShakeMapData(List<AttenuationRelationship> selectedAttenRels, List<Double> attenRelWts, Iterable<Site> sites, EqkRupture rupture, boolean isProbAtIML, double value) throws ParameterException {
        ArbDiscrGeoDataSet xyzDataSet = null;
        int size = selectedAttenRels.size();
        for (int i = 0; i < size; ++i) {
            AttenuationRelationship attenRel = selectedAttenRels.get(i);
            attenRel.resetParameterEventListeners();
            if (isProbAtIML) {
                attenRel.setIntensityMeasureLevel(value);
                continue;
            }
            try {
                attenRel.setExceedProb(value);
                continue;
            }
            catch (ParameterException e) {
                throw new ParameterException(e.getMessage());
            }
        }
        double attenRelsAvgValForSite = 0.0;
        xyzDataSet = new ArbDiscrGeoDataSet(true);
        this.currentSiteBeingProcessed = 0;
        for (Site site : sites) {
            ++this.currentSiteBeingProcessed;
            attenRelsAvgValForSite = 0.0;
            for (int i = 0; i < size; ++i) {
                AttenuationRelationship attenRel = selectedAttenRels.get(i);
                double val = this.scenarioShakeMapDataCalc(rupture, site, attenRel, isProbAtIML);
                attenRelsAvgValForSite += (val *= attenRelWts.get(i).doubleValue());
            }
            xyzDataSet.set(site.getLocation(), attenRelsAvgValForSite);
        }
        return xyzDataSet;
    }

    public String getScenarioShakeMapDataUsingServer(ArrayList selectedAttenRels, ArrayList attenRelWts, String griddedRegionSitesFile, EqkRupture rupture, boolean isProbAtIML, double value, String selectedIMT) throws ParameterException {
        ObjectOutputStream outputToServlet = null;
        ObjectInputStream inputToServlet = null;
        try {
            URL scenarioshakeMapCalcServlet = new URL(ScenarioShakeMapCalcServlet.SERVLET_URL);
            URLConnection servletConnection = scenarioshakeMapCalcServlet.openConnection();
            servletConnection.setDoInput(true);
            servletConnection.setDoOutput(true);
            servletConnection.setUseCaches(false);
            servletConnection.setDefaultUseCaches(false);
            servletConnection.setRequestProperty("Content-Type", "application/octet-stream");
            outputToServlet = new ObjectOutputStream(servletConnection.getOutputStream());
            outputToServlet.writeObject(selectedAttenRels);
            outputToServlet.writeObject(attenRelWts);
            outputToServlet.writeObject(griddedRegionSitesFile);
            outputToServlet.writeObject(rupture);
            outputToServlet.writeObject(isProbAtIML);
            outputToServlet.writeObject(value);
            outputToServlet.writeObject(selectedIMT);
            inputToServlet = new ObjectInputStream(servletConnection.getInputStream());
            String xyzDataFile = (String)inputToServlet.readObject();
            if (xyzDataFile.startsWith("Error")) {
                throw new RuntimeException(xyzDataFile.substring(6));
            }
            inputToServlet.close();
            String string = xyzDataFile;
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Server is down , please try again later");
        }
        finally {
            try {
                if (outputToServlet != null) {
                    outputToServlet.flush();
                    outputToServlet.close();
                }
                if (inputToServlet != null) {
                    inputToServlet.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RuntimeException("Server is down , please try again later");
            }
        }
    }

    private double scenarioShakeMapDataCalc(EqkRupture rupture, Site site, AttenuationRelationship imr, boolean isProbAtIML) throws ParameterException {
        imr.setEqkRupture(rupture);
        imr.setSite(site);
        if (isProbAtIML) {
            return imr.getExceedProbability();
        }
        try {
            return imr.getIML_AtExceedProb();
        }
        catch (ParameterException e) {
            throw new ParameterException(e.getMessage());
        }
    }

    public int getNumSites() {
        return this.numSites;
    }

    public int getCurrentSite() {
        return this.currentSiteBeingProcessed;
    }

    public boolean done() {
        return this.currentSiteBeingProcessed == this.numSites;
    }

    public ParameterList getAdjustableParams() {
        return this.adjustableParams;
    }
}

