/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.calc.disaggregation.chart3d;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.swing.event.EventListenerList;
import org.jfree.chart3d.Chart3D;
import org.jfree.chart3d.Chart3DChangeEvent;
import org.jfree.chart3d.Chart3DChangeListener;
import org.jfree.chart3d.Chart3DFactory;
import org.jfree.chart3d.Chart3DHints;
import org.jfree.chart3d.ChartElementVisitor;
import org.jfree.chart3d.Orientation;
import org.jfree.chart3d.TitleAnchor;
import org.jfree.chart3d.TitleUtils;
import org.jfree.chart3d.axis.TickData;
import org.jfree.chart3d.axis.ValueAxis3D;
import org.jfree.chart3d.data.ItemKey;
import org.jfree.chart3d.graphics2d.Anchor2D;
import org.jfree.chart3d.graphics2d.RefPt2D;
import org.jfree.chart3d.graphics2d.TextAnchor;
import org.jfree.chart3d.graphics3d.Dimension3D;
import org.jfree.chart3d.graphics3d.DoubleSidedFace;
import org.jfree.chart3d.graphics3d.Face;
import org.jfree.chart3d.graphics3d.LabelFace;
import org.jfree.chart3d.graphics3d.Object3D;
import org.jfree.chart3d.graphics3d.Offset2D;
import org.jfree.chart3d.graphics3d.Point3D;
import org.jfree.chart3d.graphics3d.RenderedElement;
import org.jfree.chart3d.graphics3d.RenderingInfo;
import org.jfree.chart3d.graphics3d.ViewPoint3D;
import org.jfree.chart3d.graphics3d.World;
import org.jfree.chart3d.graphics3d.internal.FaceSorter;
import org.jfree.chart3d.graphics3d.internal.StandardFaceSorter;
import org.jfree.chart3d.graphics3d.internal.Utils2D;
import org.jfree.chart3d.interaction.InteractiveElementType;
import org.jfree.chart3d.internal.Args;
import org.jfree.chart3d.internal.ChartBox3D;
import org.jfree.chart3d.internal.ObjectUtils;
import org.jfree.chart3d.internal.OnDrawHandler;
import org.jfree.chart3d.internal.TextUtils;
import org.jfree.chart3d.legend.LegendAnchor;
import org.jfree.chart3d.legend.LegendBuilder;
import org.jfree.chart3d.legend.StandardLegendBuilder;
import org.jfree.chart3d.marker.Marker;
import org.jfree.chart3d.marker.MarkerData;
import org.jfree.chart3d.plot.CategoryPlot3D;
import org.jfree.chart3d.plot.PiePlot3D;
import org.jfree.chart3d.plot.Plot3D;
import org.jfree.chart3d.plot.Plot3DChangeEvent;
import org.jfree.chart3d.plot.Plot3DChangeListener;
import org.jfree.chart3d.plot.XYZPlot;
import org.jfree.chart3d.style.ChartStyle;
import org.jfree.chart3d.style.ChartStyleChangeEvent;
import org.jfree.chart3d.style.ChartStyleChangeListener;
import org.jfree.chart3d.style.ChartStyler;
import org.jfree.chart3d.table.RectanglePainter;
import org.jfree.chart3d.table.StandardRectanglePainter;
import org.jfree.chart3d.table.TableElement;
import org.jfree.chart3d.table.TableElementOnDraw;
import org.jfree.chart3d.table.TextElement;

class DisaggChart3D
extends Chart3D {
    public static final double DEFAULT_PROJ_DIST = 1500.0;
    public static final String INTERACTIVE_ELEMENT_TYPE = "interactive_element_type";
    public static final String SERIES_KEY = "series_key";
    private String id;
    private RectanglePainter background;
    private TableElement title;
    private Anchor2D titleAnchor;
    private LegendBuilder legendBuilder;
    private Anchor2D legendAnchor;
    private Orientation legendOrientation;
    private Plot3D plot;
    private ViewPoint3D viewPoint;
    private double projDist;
    private Color chartBoxColor;
    private Offset2D translate2D;
    private transient EventListenerList listenerList;
    private boolean notify;
    private transient RenderingHints renderingHints;
    private ChartStyle style;
    private transient World world;
    private FaceSorter faceSorter;
    private boolean elementHinting;

    public DisaggChart3D(String title, String subtitle, Plot3D plot) {
        this(title, subtitle, plot, Chart3DFactory.getDefaultChartStyle());
    }

    public DisaggChart3D(String title, String subtitle, Plot3D plot, ChartStyle style) {
        super(title, subtitle, plot, style);
        Args.nullNotPermitted((Object)plot, (String)"plot");
        Args.nullNotPermitted((Object)style, (String)"style");
        plot.setChart((Chart3D)this);
        this.background = new StandardRectanglePainter((Paint)Color.WHITE);
        if (title != null) {
            this.title = TitleUtils.createTitle((String)title, (String)subtitle);
        }
        this.titleAnchor = TitleAnchor.TOP_LEFT;
        this.legendBuilder = new StandardLegendBuilder();
        this.legendAnchor = LegendAnchor.BOTTOM_RIGHT;
        this.legendOrientation = Orientation.HORIZONTAL;
        this.plot = plot;
        this.plot.addChangeListener((Plot3DChangeListener)this);
        Dimension3D dim = this.plot.getDimensions();
        float distance = (float)dim.getDiagonalLength() * 3.0f;
        this.viewPoint = ViewPoint3D.createAboveViewPoint((double)distance);
        this.projDist = 1500.0;
        this.chartBoxColor = new Color(255, 255, 255, 100);
        this.translate2D = new Offset2D();
        this.faceSorter = new StandardFaceSorter();
        this.renderingHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.renderingHints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        this.elementHinting = false;
        this.notify = true;
        this.listenerList = new EventListenerList();
        this.style = style;
        this.style.addChangeListener((ChartStyleChangeListener)this);
        this.receive((ChartElementVisitor)new ChartStyler(this.style));
    }

    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        this.id = id;
    }

    public RectanglePainter getBackground() {
        return this.background;
    }

    public void setBackground(RectanglePainter background) {
        this.background = background;
        this.fireChangeEvent();
    }

    public TableElement getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        if (title == null) {
            this.setTitle((TableElement)null);
        } else {
            this.setTitle(title, this.style.getTitleFont(), TitleUtils.DEFAULT_TITLE_COLOR);
        }
    }

    public void setTitle(String title, Font font, Color color) {
        Args.nullNotPermitted((Object)font, (String)"font");
        Args.nullNotPermitted((Object)color, (String)"color");
        TextElement te = new TextElement(title);
        te.setTag("CHART_TITLE");
        te.setFont(font);
        te.setColor(color);
        this.setTitle((TableElement)te);
    }

    public void setTitle(TableElement title) {
        this.title = title;
        this.fireChangeEvent();
    }

    public Anchor2D getTitleAnchor() {
        return this.titleAnchor;
    }

    public void setTitleAnchor(Anchor2D anchor) {
        Args.nullNotPermitted((Object)anchor, (String)"anchor");
        this.titleAnchor = anchor;
        this.fireChangeEvent();
    }

    public Plot3D getPlot() {
        return this.plot;
    }

    public Color getChartBoxColor() {
        return this.chartBoxColor;
    }

    public void setChartBoxColor(Color color) {
        Args.nullNotPermitted((Object)color, (String)"color");
        this.chartBoxColor = color;
        this.fireChangeEvent();
    }

    public Dimension3D getDimensions() {
        return this.plot.getDimensions();
    }

    public ViewPoint3D getViewPoint() {
        return this.viewPoint;
    }

    public void setViewPoint(ViewPoint3D viewPoint) {
        Args.nullNotPermitted((Object)viewPoint, (String)"viewPoint");
        this.viewPoint = viewPoint;
        this.fireChangeEvent();
    }

    public double getProjDistance() {
        return this.projDist;
    }

    public void setProjDistance(double dist) {
        this.projDist = dist;
        this.fireChangeEvent();
    }

    public Offset2D getTranslate2D() {
        return this.translate2D;
    }

    public void setTranslate2D(Offset2D offset) {
        Args.nullNotPermitted((Object)offset, (String)"offset");
        this.translate2D = offset;
        this.fireChangeEvent();
    }

    public LegendBuilder getLegendBuilder() {
        return this.legendBuilder;
    }

    public void setLegendBuilder(LegendBuilder legendBuilder) {
        this.legendBuilder = legendBuilder;
        this.fireChangeEvent();
    }

    public Anchor2D getLegendAnchor() {
        return this.legendAnchor;
    }

    public void setLegendAnchor(Anchor2D anchor) {
        Args.nullNotPermitted((Object)anchor, (String)"anchor");
        this.legendAnchor = anchor;
        this.fireChangeEvent();
    }

    public Orientation getLegendOrientation() {
        return this.legendOrientation;
    }

    public void setLegendOrientation(Orientation orientation) {
        Args.nullNotPermitted((Object)orientation, (String)"orientation");
        this.legendOrientation = orientation;
        this.fireChangeEvent();
    }

    public void setLegendPosition(Anchor2D anchor, Orientation orientation) {
        this.setNotify(false);
        this.setLegendAnchor(anchor);
        this.setLegendOrientation(orientation);
        this.setNotify(true);
    }

    public RenderingHints getRenderingHints() {
        return this.renderingHints;
    }

    public void setRenderingHints(RenderingHints hints) {
        Args.nullNotPermitted((Object)hints, (String)"hints");
        this.renderingHints = hints;
        this.fireChangeEvent();
    }

    public boolean getAntiAlias() {
        Object val = this.renderingHints.get(RenderingHints.KEY_ANTIALIASING);
        return RenderingHints.VALUE_ANTIALIAS_ON.equals(val);
    }

    public void setAntiAlias(boolean flag) {
        if (flag) {
            this.renderingHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            this.renderingHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        this.fireChangeEvent();
    }

    public boolean getElementHinting() {
        return this.elementHinting;
    }

    public void setElementHinting(boolean hinting) {
        this.elementHinting = hinting;
        this.fireChangeEvent();
    }

    public ChartStyle getStyle() {
        return this.style;
    }

    public void setStyle(ChartStyle style) {
        Args.nullNotPermitted((Object)style, (String)"style");
        this.style.removeChangeListener((ChartStyleChangeListener)this);
        this.style = style;
        this.style.addChangeListener((ChartStyleChangeListener)this);
        this.setNotify(false);
        this.receive((ChartElementVisitor)new ChartStyler(this.style));
        this.setNotify(true);
    }

    private World createWorld(ChartBox3D chartBox) {
        World result = new World();
        Dimension3D dim = this.plot.getDimensions();
        double w = dim.getWidth();
        double h = dim.getHeight();
        double d = dim.getDepth();
        if (chartBox != null) {
            result.add("chartbox", chartBox.createObject3D());
        }
        this.plot.compose(result, -w / 2.0, -h / 2.0, -d / 2.0);
        return result;
    }

    public RenderingInfo draw(Graphics2D g2, Rectangle2D bounds) {
        TableElement legend;
        this.beginElement(g2, this.id, "ORSON_CHART_TOP_LEVEL");
        Shape savedClip = g2.getClip();
        g2.clip(bounds);
        g2.addRenderingHints(this.renderingHints);
        g2.setStroke(new BasicStroke(1.5f, 1, 1, 1.0f));
        Dimension3D dim3D = this.plot.getDimensions();
        double w = dim3D.getWidth();
        double h = dim3D.getHeight();
        double depth = dim3D.getDepth();
        ChartBox3D chartBox = null;
        if (this.plot instanceof XYZPlot || this.plot instanceof CategoryPlot3D) {
            double[] tickUnits = this.findAxisTickUnits(g2, w, h, depth);
            chartBox = new ChartBox3D(w, h, depth, -w / 2.0, -h / 2.0, -depth / 2.0, this.chartBoxColor);
            chartBox.setXTicks(this.fetchXTickData(this.plot, tickUnits[0]));
            chartBox.setYTicks(this.fetchYTickData(this.plot, tickUnits[1]));
            chartBox.setZTicks(this.fetchZTickData(this.plot, tickUnits[2]));
            chartBox.setXMarkers(this.fetchXMarkerData(this.plot));
            chartBox.setYMarkers(this.fetchYMarkerData(this.plot));
            chartBox.setZMarkers(this.fetchZMarkerData(this.plot));
        }
        if (this.world == null) {
            this.world = this.createWorld(chartBox);
            this.world.setSunSource(Math.toRadians(-25.0), Math.toRadians(-5.0), Math.toRadians(55.0));
        } else if (chartBox != null) {
            this.world.clear("chartbox");
            this.world.add("chartbox", chartBox.createObject3D());
        }
        if (this.background != null) {
            this.background.fill(g2, bounds);
        }
        AffineTransform saved = g2.getTransform();
        double dx = bounds.getX() + bounds.getWidth() / 2.0 + this.translate2D.getDX();
        double dy = bounds.getY() + bounds.getHeight() / 2.0 + this.translate2D.getDY();
        g2.translate(dx, dy);
        Point3D[] eyePts = this.world.calculateEyeCoordinates(this.viewPoint);
        Point2D[] pts = this.world.calculateProjectedPoints(this.viewPoint, this.projDist);
        List facesInPaintOrder = new ArrayList(this.world.getFaces());
        facesInPaintOrder = this.faceSorter.sort(facesInPaintOrder, eyePts);
        RenderingInfo info = new RenderingInfo(facesInPaintOrder, pts, dx, dy);
        if (this.plot instanceof XYZPlot || this.plot instanceof CategoryPlot3D) {
            this.drawAxes(g2, chartBox, pts, info);
        }
        Line2D.Float line = null;
        BasicStroke stroke = new BasicStroke(1.0f);
        for (Face f : facesInPaintOrder) {
            Path2D p;
            if (f.getVertexCount() == 2) {
                g2.setPaint(f.getColor());
                if (line == null) {
                    line = new Line2D.Float();
                }
                int v0 = f.getVertexIndex(0);
                int v1 = f.getVertexIndex(1);
                ((Line2D)line).setLine(pts[v0].getX(), pts[v0].getY(), pts[v1].getX(), pts[v1].getY());
                g2.setStroke(stroke);
                g2.draw(line);
                continue;
            }
            boolean drawOutline = f.getOutline();
            double[] plane = f.calculateNormal(eyePts);
            double inprod = plane[0] * this.world.getSunX() + plane[1] * this.world.getSunY() + plane[2] * this.world.getSunZ();
            double shade = (inprod + 1.0) / 2.0;
            if (f instanceof DoubleSidedFace || Utils2D.area2((Point2D)pts[f.getVertexIndex(0)], (Point2D)pts[f.getVertexIndex(1)], (Point2D)pts[f.getVertexIndex(2)]) > 0.0) {
                Color c = f.getColor();
                p = f.createPath(pts);
                g2.setPaint(new Color((int)((double)c.getRed() * shade), (int)((double)c.getGreen() * shade), (int)((double)c.getBlue() * shade), c.getAlpha()));
                if (this.elementHinting) {
                    this.beginElementGroup(f, g2);
                }
                g2.fill(p);
                g2.setStroke(new BasicStroke(1.0f));
                g2.setPaint(Color.BLACK);
                g2.draw(p);
                if (this.elementHinting) {
                    this.endElementGroup(f, g2);
                }
                if (!(f instanceof ChartBox3D.ChartBoxFace) || !(this.plot instanceof CategoryPlot3D) && !(this.plot instanceof XYZPlot)) continue;
                Stroke savedStroke = g2.getStroke();
                ChartBox3D.ChartBoxFace cbf = (ChartBox3D.ChartBoxFace)f;
                this.drawGridlines(g2, cbf, pts);
                this.drawMarkers(g2, cbf, pts);
                g2.setStroke(savedStroke);
                continue;
            }
            if (!(f instanceof LabelFace)) continue;
            LabelFace lf = (LabelFace)f;
            p = lf.createPath(pts);
            Rectangle2D lb = p.getBounds2D();
            g2.setFont(lf.getFont());
            g2.setColor(lf.getBackgroundColor());
            Rectangle2D bb = TextUtils.calcAlignedStringBounds((String)lf.getLabel(), (Graphics2D)g2, (float)((float)lb.getCenterX()), (float)((float)lb.getCenterY()), (TextAnchor)TextAnchor.CENTER);
            g2.fill(bb);
            g2.setColor(lf.getTextColor());
            Rectangle2D r = TextUtils.drawAlignedString((String)lf.getLabel(), (Graphics2D)g2, (float)((float)lb.getCenterX()), (float)((float)lb.getCenterY()), (TextAnchor)TextAnchor.CENTER);
            lf.getOwner().setProperty("labelBounds", (Object)r);
        }
        OnDrawHandler onDrawHandler = new OnDrawHandler(info, this.elementHinting);
        if (this.plot instanceof PiePlot3D) {
            this.drawPieLabels(g2, w, h, depth, info);
        }
        g2.setTransform(saved);
        if (this.legendBuilder != null && (legend = this.legendBuilder.createLegend(this.plot, this.legendAnchor, this.legendOrientation, this.style)) != null) {
            Dimension2D legendSize = legend.preferredSize(g2, bounds);
            Rectangle2D legendArea = this.calculateDrawArea(legendSize, this.legendAnchor, bounds);
            legend.draw(g2, legendArea, (TableElementOnDraw)onDrawHandler);
        }
        if (this.title != null) {
            Dimension2D titleSize = this.title.preferredSize(g2, bounds);
            Rectangle2D titleArea = this.calculateDrawArea(titleSize, this.titleAnchor, bounds);
            this.title.draw(g2, titleArea, (TableElementOnDraw)onDrawHandler);
        }
        g2.setClip(savedClip);
        this.endElement(g2);
        return info;
    }

    private void beginElementGroup(Face face, Graphics2D g2) {
        Object3D owner = face.getOwner();
        ItemKey itemKey = (ItemKey)owner.getProperty("key");
        if (itemKey != null) {
            HashMap<String, String> m = new HashMap<String, String>();
            m.put("ref", itemKey.toJSONString());
            g2.setRenderingHint((RenderingHints.Key)Chart3DHints.KEY_BEGIN_ELEMENT, m);
        }
    }

    private void endElementGroup(Face face, Graphics2D g2) {
        Object3D owner = face.getOwner();
        ItemKey itemKey = (ItemKey)owner.getProperty("key");
        if (itemKey != null) {
            g2.setRenderingHint((RenderingHints.Key)Chart3DHints.KEY_END_ELEMENT, Boolean.TRUE);
        }
    }

    private List<TickData> fetchXTickData(Plot3D plot, double tickUnit) {
        if (plot instanceof CategoryPlot3D) {
            CategoryPlot3D cp = (CategoryPlot3D)plot;
            return cp.getColumnAxis().generateTickDataForColumns(cp.getDataset());
        }
        if (plot instanceof XYZPlot) {
            XYZPlot xp = (XYZPlot)plot;
            return xp.getXAxis().generateTickData(tickUnit);
        }
        return Collections.emptyList();
    }

    private List<TickData> fetchYTickData(Plot3D plot, double tickUnit) {
        if (plot instanceof CategoryPlot3D) {
            CategoryPlot3D cp = (CategoryPlot3D)plot;
            return cp.getValueAxis().generateTickData(tickUnit);
        }
        if (plot instanceof XYZPlot) {
            XYZPlot xp = (XYZPlot)plot;
            return xp.getYAxis().generateTickData(tickUnit);
        }
        return Collections.emptyList();
    }

    private List<TickData> fetchZTickData(Plot3D plot, double tickUnit) {
        if (plot instanceof CategoryPlot3D) {
            CategoryPlot3D cp = (CategoryPlot3D)plot;
            return cp.getRowAxis().generateTickDataForRows(cp.getDataset());
        }
        if (plot instanceof XYZPlot) {
            XYZPlot xp = (XYZPlot)plot;
            return xp.getZAxis().generateTickData(tickUnit);
        }
        return Collections.emptyList();
    }

    private List<MarkerData> fetchXMarkerData(Plot3D plot) {
        if (plot instanceof CategoryPlot3D) {
            return ((CategoryPlot3D)plot).getColumnAxis().generateMarkerData();
        }
        if (plot instanceof XYZPlot) {
            return ((XYZPlot)plot).getXAxis().generateMarkerData();
        }
        return new ArrayList<MarkerData>(0);
    }

    private List<MarkerData> fetchYMarkerData(Plot3D plot) {
        if (plot instanceof CategoryPlot3D) {
            return ((CategoryPlot3D)plot).getValueAxis().generateMarkerData();
        }
        if (plot instanceof XYZPlot) {
            return ((XYZPlot)plot).getYAxis().generateMarkerData();
        }
        return new ArrayList<MarkerData>(0);
    }

    private List<MarkerData> fetchZMarkerData(Plot3D plot) {
        if (plot instanceof CategoryPlot3D) {
            return ((CategoryPlot3D)plot).getRowAxis().generateMarkerData();
        }
        if (plot instanceof XYZPlot) {
            return ((XYZPlot)plot).getZAxis().generateMarkerData();
        }
        return new ArrayList<MarkerData>(0);
    }

    private void drawGridlines(Graphics2D g2, ChartBox3D.ChartBoxFace face, Point2D[] pts) {
        Line2D.Double line;
        int i;
        if (this.isGridlinesVisibleForX(this.plot)) {
            g2.setPaint(this.fetchGridlinePaintX(this.plot));
            g2.setStroke(this.fetchGridlineStrokeX(this.plot));
            List xA = face.getXTicksA();
            List xB = face.getXTicksB();
            for (i = 0; i < xA.size(); ++i) {
                line = new Line2D.Double(pts[face.getOffset() + ((TickData)xA.get(i)).getVertexIndex()], pts[face.getOffset() + ((TickData)xB.get(i)).getVertexIndex()]);
                g2.draw(line);
            }
        }
        if (this.isGridlinesVisibleForY(this.plot)) {
            g2.setPaint(this.fetchGridlinePaintY(this.plot));
            g2.setStroke(this.fetchGridlineStrokeY(this.plot));
            List yA = face.getYTicksA();
            List yB = face.getYTicksB();
            for (i = 0; i < yA.size(); ++i) {
                line = new Line2D.Double(pts[face.getOffset() + ((TickData)yA.get(i)).getVertexIndex()], pts[face.getOffset() + ((TickData)yB.get(i)).getVertexIndex()]);
                g2.draw(line);
            }
        }
        if (this.isGridlinesVisibleForZ(this.plot)) {
            g2.setPaint(this.fetchGridlinePaintZ(this.plot));
            g2.setStroke(this.fetchGridlineStrokeZ(this.plot));
            List zA = face.getZTicksA();
            List zB = face.getZTicksB();
            for (i = 0; i < zA.size(); ++i) {
                line = new Line2D.Double(pts[face.getOffset() + ((TickData)zA.get(i)).getVertexIndex()], pts[face.getOffset() + ((TickData)zB.get(i)).getVertexIndex()]);
                g2.draw(line);
            }
        }
    }

    private boolean isGridlinesVisibleForX(Plot3D plot) {
        if (plot instanceof CategoryPlot3D) {
            CategoryPlot3D cp = (CategoryPlot3D)plot;
            return cp.getGridlinesVisibleForColumns();
        }
        if (plot instanceof XYZPlot) {
            XYZPlot xp = (XYZPlot)plot;
            return xp.isGridlinesVisibleX();
        }
        return false;
    }

    private boolean isGridlinesVisibleForY(Plot3D plot) {
        if (plot instanceof CategoryPlot3D) {
            CategoryPlot3D cp = (CategoryPlot3D)plot;
            return cp.getGridlinesVisibleForValues();
        }
        if (plot instanceof XYZPlot) {
            XYZPlot xp = (XYZPlot)plot;
            return xp.isGridlinesVisibleY();
        }
        return false;
    }

    private boolean isGridlinesVisibleForZ(Plot3D plot) {
        if (plot instanceof CategoryPlot3D) {
            CategoryPlot3D cp = (CategoryPlot3D)plot;
            return cp.getGridlinesVisibleForRows();
        }
        if (plot instanceof XYZPlot) {
            XYZPlot xp = (XYZPlot)plot;
            return xp.isGridlinesVisibleZ();
        }
        return false;
    }

    private Paint fetchGridlinePaintX(Plot3D plot) {
        if (plot instanceof CategoryPlot3D) {
            CategoryPlot3D cp = (CategoryPlot3D)plot;
            return cp.getGridlinePaintForColumns();
        }
        if (plot instanceof XYZPlot) {
            XYZPlot xp = (XYZPlot)plot;
            return xp.getGridlinePaintX();
        }
        return null;
    }

    private Paint fetchGridlinePaintY(Plot3D plot) {
        if (plot instanceof CategoryPlot3D) {
            CategoryPlot3D cp = (CategoryPlot3D)plot;
            return cp.getGridlinePaintForValues();
        }
        if (plot instanceof XYZPlot) {
            XYZPlot xp = (XYZPlot)plot;
            return xp.getGridlinePaintY();
        }
        return null;
    }

    private Paint fetchGridlinePaintZ(Plot3D plot) {
        if (plot instanceof CategoryPlot3D) {
            CategoryPlot3D cp = (CategoryPlot3D)plot;
            return cp.getGridlinePaintForRows();
        }
        if (plot instanceof XYZPlot) {
            XYZPlot xp = (XYZPlot)plot;
            return xp.getGridlinePaintZ();
        }
        return null;
    }

    private Stroke fetchGridlineStrokeX(Plot3D plot) {
        if (plot instanceof CategoryPlot3D) {
            CategoryPlot3D cp = (CategoryPlot3D)plot;
            return cp.getGridlineStrokeForColumns();
        }
        if (plot instanceof XYZPlot) {
            XYZPlot xp = (XYZPlot)plot;
            return xp.getGridlineStrokeX();
        }
        return null;
    }

    private Stroke fetchGridlineStrokeY(Plot3D plot) {
        if (plot instanceof CategoryPlot3D) {
            CategoryPlot3D cp = (CategoryPlot3D)plot;
            return cp.getGridlineStrokeForValues();
        }
        if (plot instanceof XYZPlot) {
            XYZPlot xp = (XYZPlot)plot;
            return xp.getGridlineStrokeY();
        }
        return null;
    }

    private Stroke fetchGridlineStrokeZ(Plot3D plot) {
        if (plot instanceof CategoryPlot3D) {
            CategoryPlot3D cp = (CategoryPlot3D)plot;
            return cp.getGridlineStrokeForRows();
        }
        if (plot instanceof XYZPlot) {
            XYZPlot xp = (XYZPlot)plot;
            return xp.getGridlineStrokeZ();
        }
        return null;
    }

    private void drawPieLabels(Graphics2D g2, double w, double h, double depth, RenderingInfo info) {
        PiePlot3D p = (PiePlot3D)this.plot;
        World labelOverlay = new World();
        List objs = p.getLabelFaces(-w / 2.0, -h / 2.0, -depth / 2.0);
        for (Object3D obj : objs) {
            labelOverlay.add(obj);
        }
        Point2D[] ppts = labelOverlay.calculateProjectedPoints(this.viewPoint, this.projDist);
        for (int i = 0; i < p.getDataset().getItemCount() * 2; ++i) {
            Face f;
            if (p.getDataset().getValue(i / 2) == null || !(Utils2D.area2((Point2D)ppts[(f = (Face)labelOverlay.getFaces().get(i)).getVertexIndex(0)], (Point2D)ppts[f.getVertexIndex(1)], (Point2D)ppts[f.getVertexIndex(2)]) > 0.0)) continue;
            Comparable key = p.getDataset().getKey(i / 2);
            g2.setColor(p.getSectionLabelColorSource().getColor(key));
            g2.setFont(p.getSectionLabelFontSource().getFont((Object)key));
            Point2D pt = Utils2D.centerPoint((Point2D)ppts[f.getVertexIndex(0)], (Point2D)ppts[f.getVertexIndex(1)], (Point2D)ppts[f.getVertexIndex(2)], (Point2D)ppts[f.getVertexIndex(3)]);
            String label = p.getSectionLabelGenerator().generateLabel(p.getDataset(), key);
            String ref = "{\"type\": \"sectionLabel\", \"key\": \"" + key.toString() + "\"}";
            this.beginElementWithRef(g2, ref);
            Rectangle2D bounds = TextUtils.drawAlignedString((String)label, (Graphics2D)g2, (float)((float)pt.getX()), (float)((float)pt.getY()), (TextAnchor)TextAnchor.CENTER);
            this.endElement(g2);
            if (info == null) continue;
            RenderedElement pieLabelRE = new RenderedElement((Object)InteractiveElementType.SECTION_LABEL, (Shape)bounds);
            pieLabelRE.setProperty("key", (Object)key);
            info.addOffsetElement(pieLabelRE);
        }
    }

    private void beginElementWithRef(Graphics2D g2, String ref) {
        this.beginElement(g2, null, ref);
    }

    private void beginElement(Graphics2D g2, String id, String ref) {
        if (this.elementHinting) {
            HashMap<String, String> m = new HashMap<String, String>();
            if (id != null) {
                m.put("id", id);
            }
            m.put("ref", ref);
            g2.setRenderingHint((RenderingHints.Key)Chart3DHints.KEY_BEGIN_ELEMENT, m);
        }
    }

    private void endElement(Graphics2D g2) {
        if (this.elementHinting) {
            g2.setRenderingHint((RenderingHints.Key)Chart3DHints.KEY_END_ELEMENT, Boolean.TRUE);
        }
    }

    private double[] findAxisTickUnits(Graphics2D g2, double w, double h, double depth) {
        XYZPlot pp;
        World tempWorld = new World();
        ChartBox3D chartBox = new ChartBox3D(w, h, depth, -w / 2.0, -h / 2.0, -depth / 2.0, Color.WHITE);
        tempWorld.add(chartBox.createObject3D());
        Point2D[] axisPts2D = tempWorld.calculateProjectedPoints(this.viewPoint, this.projDist);
        Point2D v0 = axisPts2D[0];
        Point2D v1 = axisPts2D[1];
        Point2D v2 = axisPts2D[2];
        Point2D v3 = axisPts2D[3];
        Point2D v4 = axisPts2D[4];
        Point2D v5 = axisPts2D[5];
        Point2D v6 = axisPts2D[6];
        Point2D v7 = axisPts2D[7];
        boolean a = chartBox.faceA().isFrontFacing(axisPts2D);
        boolean b = chartBox.faceB().isFrontFacing(axisPts2D);
        boolean c = chartBox.faceC().isFrontFacing(axisPts2D);
        boolean d = chartBox.faceD().isFrontFacing(axisPts2D);
        boolean e = chartBox.faceE().isFrontFacing(axisPts2D);
        boolean f = chartBox.faceF().isFrontFacing(axisPts2D);
        double xtick = 0.0;
        double ytick = 0.0;
        double ztick = 0.0;
        ValueAxis3D xAxis = null;
        ValueAxis3D yAxis = null;
        ValueAxis3D zAxis = null;
        if (this.plot instanceof XYZPlot) {
            pp = (XYZPlot)this.plot;
            xAxis = pp.getXAxis();
            yAxis = pp.getYAxis();
            zAxis = pp.getZAxis();
        } else if (this.plot instanceof CategoryPlot3D) {
            pp = (CategoryPlot3D)this.plot;
            xAxis = pp.getColumnAxis();
            yAxis = pp.getValueAxis();
            zAxis = pp.getRowAxis();
        }
        if (xAxis != null && yAxis != null && zAxis != null) {
            double ce;
            double ab = this.count(a, b) == 1 ? v0.distance(v1) : 0.0;
            double bc = this.count(b, c) == 1 ? v3.distance(v2) : 0.0;
            double cd = this.count(c, d) == 1 ? v4.distance(v7) : 0.0;
            double da = this.count(d, a) == 1 ? v5.distance(v6) : 0.0;
            double be = this.count(b, e) == 1 ? v0.distance(v3) : 0.0;
            double bf = this.count(b, f) == 1 ? v1.distance(v2) : 0.0;
            double df = this.count(d, f) == 1 ? v6.distance(v7) : 0.0;
            double de = this.count(d, e) == 1 ? v5.distance(v4) : 0.0;
            double ae = this.count(a, e) == 1 ? v0.distance(v5) : 0.0;
            double af = this.count(a, f) == 1 ? v1.distance(v6) : 0.0;
            double cf = this.count(c, f) == 1 ? v2.distance(v7) : 0.0;
            double d2 = ce = this.count(c, e) == 1 ? v3.distance(v4) : 0.0;
            if (this.count(a, b) == 1 && this.longest(ab, bc, cd, da) && xAxis instanceof ValueAxis3D) {
                xtick = xAxis.selectTick(g2, v0, v1, v7);
            }
            if (this.count(b, c) == 1 && this.longest(bc, ab, cd, da) && xAxis instanceof ValueAxis3D) {
                xtick = xAxis.selectTick(g2, v3, v2, v6);
            }
            if (this.count(c, d) == 1 && this.longest(cd, ab, bc, da) && xAxis instanceof ValueAxis3D) {
                xtick = xAxis.selectTick(g2, v4, v7, v1);
            }
            if (this.count(d, a) == 1 && this.longest(da, ab, bc, cd) && xAxis instanceof ValueAxis3D) {
                xtick = xAxis.selectTick(g2, v5, v6, v3);
            }
            if (this.count(b, e) == 1 && this.longest(be, bf, df, de)) {
                ytick = yAxis.selectTick(g2, v0, v3, v7);
            }
            if (this.count(b, f) == 1 && this.longest(bf, be, df, de)) {
                ytick = yAxis.selectTick(g2, v1, v2, v4);
            }
            if (this.count(d, f) == 1 && this.longest(df, be, bf, de)) {
                ytick = yAxis.selectTick(g2, v6, v7, v0);
            }
            if (this.count(d, e) == 1 && this.longest(de, be, bf, df)) {
                ytick = yAxis.selectTick(g2, v5, v4, v1);
            }
            if (this.count(a, e) == 1 && this.longest(ae, af, cf, ce) && zAxis instanceof ValueAxis3D) {
                ztick = zAxis.selectTick(g2, v0, v5, v2);
            }
            if (this.count(a, f) == 1 && this.longest(af, ae, cf, ce) && zAxis instanceof ValueAxis3D) {
                ztick = zAxis.selectTick(g2, v1, v6, v3);
            }
            if (this.count(c, f) == 1 && this.longest(cf, ae, af, ce) && zAxis instanceof ValueAxis3D) {
                ztick = zAxis.selectTick(g2, v2, v7, v5);
            }
            if (this.count(c, e) == 1 && this.longest(ce, ae, af, cf) && zAxis instanceof ValueAxis3D) {
                ztick = zAxis.selectTick(g2, v3, v4, v6);
            }
        }
        return new double[]{xtick, ytick, ztick};
    }

    private void populateAnchorPoints(List<TickData> tickData, Point2D[] pts) {
        for (TickData t : tickData) {
            t.setAnchorPt(pts[t.getVertexIndex()]);
        }
    }

    private void drawAxes(Graphics2D g2, ChartBox3D chartBox, Point2D[] pts, RenderingInfo info) {
        XYZPlot pp;
        Point2D v0 = pts[0];
        Point2D v1 = pts[1];
        Point2D v2 = pts[2];
        Point2D v3 = pts[3];
        Point2D v4 = pts[4];
        Point2D v5 = pts[5];
        Point2D v6 = pts[6];
        Point2D v7 = pts[7];
        boolean a = chartBox.faceA().isFrontFacing(pts);
        boolean b = chartBox.faceB().isFrontFacing(pts);
        boolean c = chartBox.faceC().isFrontFacing(pts);
        boolean d = chartBox.faceD().isFrontFacing(pts);
        boolean e = chartBox.faceE().isFrontFacing(pts);
        boolean f = chartBox.faceF().isFrontFacing(pts);
        ValueAxis3D xAxis = null;
        ValueAxis3D yAxis = null;
        ValueAxis3D zAxis = null;
        if (this.plot instanceof XYZPlot) {
            pp = (XYZPlot)this.plot;
            xAxis = pp.getXAxis();
            yAxis = pp.getYAxis();
            zAxis = pp.getZAxis();
        } else if (this.plot instanceof CategoryPlot3D) {
            pp = (CategoryPlot3D)this.plot;
            xAxis = pp.getColumnAxis();
            yAxis = pp.getValueAxis();
            zAxis = pp.getRowAxis();
        }
        if (xAxis != null && yAxis != null && zAxis != null) {
            double ab = this.count(a, b) == 1 ? v0.distance(v1) : 0.0;
            double bc = this.count(b, c) == 1 ? v3.distance(v2) : 0.0;
            double cd = this.count(c, d) == 1 ? v4.distance(v7) : 0.0;
            double da = this.count(d, a) == 1 ? v5.distance(v6) : 0.0;
            double be = this.count(b, e) == 1 ? v0.distance(v3) : 0.0;
            double bf = this.count(b, f) == 1 ? v1.distance(v2) : 0.0;
            double df = this.count(d, f) == 1 ? v6.distance(v7) : 0.0;
            double de = this.count(d, e) == 1 ? v5.distance(v4) : 0.0;
            double ae = this.count(a, e) == 1 ? v0.distance(v5) : 0.0;
            double af = this.count(a, f) == 1 ? v1.distance(v6) : 0.0;
            double cf = this.count(c, f) == 1 ? v2.distance(v7) : 0.0;
            double ce = this.count(c, e) == 1 ? v3.distance(v4) : 0.0;
            List ticks = chartBox.faceA().getXTicksB();
            this.populateAnchorPoints(ticks, pts);
            xAxis.draw(g2, v5, v6, v3, ticks, info, this.elementHinting);
            ticks = chartBox.faceB().getYTicksB();
            this.populateAnchorPoints(ticks, pts);
            yAxis.draw(g2, v1, v2, v4, ticks, info, this.elementHinting);
            ticks = chartBox.faceA().getZTicksB();
            this.populateAnchorPoints(ticks, pts);
            zAxis.draw(g2, v1, v6, v3, ticks, info, this.elementHinting);
            Line2D[] thinLines = new Line2D[]{new Line2D.Float(v0, v3), new Line2D.Float(v3, v2), new Line2D.Float(v3, v4), new Line2D.Float(v4, v5)};
            Line2D[] thickLines = new Line2D[]{new Line2D.Float(v0, v5), new Line2D.Float(v0, v1), new Line2D.Float(v1, v2), new Line2D.Float(v1, v6), new Line2D.Float(v5, v6)};
            g2.setStroke(new BasicStroke(1.0f));
            g2.setPaint(Color.BLACK);
            for (Line2D line : thinLines) {
                g2.draw(line);
            }
            g2.setStroke(new BasicStroke(2.0f));
            for (Line2D line : thickLines) {
                g2.draw(line);
            }
        }
    }

    private void drawMarkers(Graphics2D g2, ChartBox3D.ChartBoxFace face, Point2D[] pts) {
        List xmarkers = face.getXMarkers();
        for (Object m : xmarkers) {
            m.updateProjection(pts);
            Marker marker = this.fetchXMarker(this.plot, m.getMarkerKey());
            this.beginElementWithRef(g2, "{\"type\": \"xMarker\", \"key\": \"" + m.getMarkerKey() + "\"}");
            marker.draw(g2, (MarkerData)m, true);
            this.endElement(g2);
        }
        List ymarkers = face.getYMarkers();
        for (MarkerData m : ymarkers) {
            m.updateProjection(pts);
            Marker marker = this.fetchYMarker(this.plot, m.getMarkerKey());
            this.beginElementWithRef(g2, "{\"type\": \"yMarker\", \"key\": \"" + m.getMarkerKey() + "\"}");
            marker.draw(g2, m, false);
            this.endElement(g2);
        }
        List zmarkers = face.getZMarkers();
        for (MarkerData m : zmarkers) {
            m.updateProjection(pts);
            this.beginElementWithRef(g2, "{\"type\": \"zMarker\", \"key\": \"" + m.getMarkerKey() + "\"}");
            Marker marker = this.fetchZMarker(this.plot, m.getMarkerKey());
            marker.draw(g2, m, false);
            this.endElement(g2);
        }
    }

    private Marker fetchXMarker(Plot3D plot, String key) {
        if (plot instanceof CategoryPlot3D) {
            return ((CategoryPlot3D)plot).getColumnAxis().getMarker(key);
        }
        if (plot instanceof XYZPlot) {
            return ((XYZPlot)plot).getXAxis().getMarker(key);
        }
        return null;
    }

    private Marker fetchYMarker(Plot3D plot, String key) {
        if (plot instanceof CategoryPlot3D) {
            return ((CategoryPlot3D)plot).getValueAxis().getMarker(key);
        }
        if (plot instanceof XYZPlot) {
            return ((XYZPlot)plot).getYAxis().getMarker(key);
        }
        return null;
    }

    private Marker fetchZMarker(Plot3D plot, String key) {
        if (plot instanceof CategoryPlot3D) {
            return ((CategoryPlot3D)plot).getRowAxis().getMarker(key);
        }
        if (plot instanceof XYZPlot) {
            return ((XYZPlot)plot).getZAxis().getMarker(key);
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Chart3D)) {
            return false;
        }
        DisaggChart3D that = (DisaggChart3D)((Object)obj);
        if (!ObjectUtils.equals((Object)this.background, (Object)that.background)) {
            return false;
        }
        if (!ObjectUtils.equals((Object)this.title, (Object)that.title)) {
            return false;
        }
        if (!this.titleAnchor.equals((Object)that.titleAnchor)) {
            return false;
        }
        if (!ObjectUtils.equalsPaint((Paint)this.chartBoxColor, (Paint)that.chartBoxColor)) {
            return false;
        }
        if (!ObjectUtils.equals((Object)this.legendBuilder, (Object)that.legendBuilder)) {
            return false;
        }
        if (!this.legendAnchor.equals((Object)that.legendAnchor)) {
            return false;
        }
        if (this.legendOrientation != that.legendOrientation) {
            return false;
        }
        if (!this.renderingHints.equals(that.renderingHints)) {
            return false;
        }
        return this.projDist == that.projDist;
    }

    private Rectangle2D calculateDrawArea(Dimension2D dim, Anchor2D anchor, Rectangle2D bounds) {
        double y;
        double x;
        Args.nullNotPermitted((Object)dim, (String)"dim");
        Args.nullNotPermitted((Object)anchor, (String)"anchor");
        Args.nullNotPermitted((Object)bounds, (String)"bounds");
        double w = Math.min(dim.getWidth(), bounds.getWidth());
        double h = Math.min(dim.getHeight(), bounds.getHeight());
        if (anchor.getRefPt().equals((Object)RefPt2D.CENTER)) {
            x = bounds.getCenterX() - w / 2.0;
            y = bounds.getCenterY() - h / 2.0;
        } else if (anchor.getRefPt().equals((Object)RefPt2D.CENTER_LEFT)) {
            x = bounds.getX() + anchor.getOffset().getDX();
            y = bounds.getCenterY() - h / 2.0;
        } else if (anchor.getRefPt().equals((Object)RefPt2D.CENTER_RIGHT)) {
            x = bounds.getMaxX() - anchor.getOffset().getDX() - dim.getWidth();
            y = bounds.getCenterY() - h / 2.0;
        } else if (anchor.getRefPt().equals((Object)RefPt2D.TOP_CENTER)) {
            x = bounds.getCenterX() - w / 2.0;
            y = bounds.getY() + anchor.getOffset().getDY();
        } else if (anchor.getRefPt().equals((Object)RefPt2D.TOP_LEFT)) {
            x = bounds.getX() + anchor.getOffset().getDX();
            y = bounds.getY() + anchor.getOffset().getDY();
        } else if (anchor.getRefPt().equals((Object)RefPt2D.TOP_RIGHT)) {
            x = bounds.getMaxX() - anchor.getOffset().getDX() - dim.getWidth();
            y = bounds.getY() + anchor.getOffset().getDY();
        } else if (anchor.getRefPt().equals((Object)RefPt2D.BOTTOM_CENTER)) {
            x = bounds.getCenterX() - w / 2.0;
            y = bounds.getMaxY() - anchor.getOffset().getDY() - dim.getHeight();
        } else if (anchor.getRefPt().equals((Object)RefPt2D.BOTTOM_RIGHT)) {
            x = bounds.getMaxX() - anchor.getOffset().getDX() - dim.getWidth();
            y = bounds.getMaxY() - anchor.getOffset().getDY() - dim.getHeight();
        } else if (anchor.getRefPt().equals((Object)RefPt2D.BOTTOM_LEFT)) {
            x = bounds.getX() + anchor.getOffset().getDX();
            y = bounds.getMaxY() - anchor.getOffset().getDY() - dim.getHeight();
        } else {
            x = 0.0;
            y = 0.0;
        }
        return new Rectangle2D.Double(x, y, w, h);
    }

    private boolean longest(double x, double a, double b, double c) {
        return x >= a && x >= b && x >= c;
    }

    private int count(boolean a, boolean b) {
        int result = 0;
        if (a) {
            ++result;
        }
        if (b) {
            ++result;
        }
        return result;
    }

    public void plotChanged(Plot3DChangeEvent event) {
        if (event.requiresWorldUpdate()) {
            this.world = null;
        }
        this.notifyListeners(new Chart3DChangeEvent((Object)event, (Chart3D)this));
    }

    public void styleChanged(ChartStyleChangeEvent event) {
        ChartStyler styler = new ChartStyler(event.getChartStyle());
        this.receive((ChartElementVisitor)styler);
        this.notifyListeners(new Chart3DChangeEvent((Object)event, (Chart3D)this));
    }

    public void addChangeListener(Chart3DChangeListener listener) {
        this.listenerList.add(Chart3DChangeListener.class, listener);
    }

    public void removeChangeListener(Chart3DChangeListener listener) {
        this.listenerList.remove(Chart3DChangeListener.class, listener);
    }

    public void notifyListeners(Chart3DChangeEvent event) {
        if (!this.notify) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != Chart3DChangeListener.class) continue;
            ((Chart3DChangeListener)listeners[i + 1]).chartChanged(event);
        }
    }

    public boolean isNotify() {
        return this.notify;
    }

    public void setNotify(boolean notify) {
        this.notify = notify;
        if (notify) {
            this.world = null;
            this.fireChangeEvent();
        }
    }

    protected void fireChangeEvent() {
        this.notifyListeners(new Chart3DChangeEvent((Object)this, (Chart3D)this));
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.listenerList = new EventListenerList();
        this.plot.addChangeListener((Plot3DChangeListener)this);
        this.renderingHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.renderingHints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
    }

    public static String renderedElementToString(RenderedElement element) {
        Object type = element.getProperty("type");
        if (InteractiveElementType.SECTION_LABEL.equals(type)) {
            StringBuilder sb = new StringBuilder();
            sb.append("Section label with key '");
            Object key = element.getProperty("key");
            sb.append(key.toString());
            sb.append("'");
            return sb.toString();
        }
        if (InteractiveElementType.LEGEND_ITEM.equals(type)) {
            StringBuilder sb = new StringBuilder();
            sb.append("Legend item with section key '");
            Object key = element.getProperty(SERIES_KEY);
            sb.append(key);
            sb.append("'");
            return sb.toString();
        }
        if (InteractiveElementType.AXIS_LABEL.equals(type)) {
            return "Axis label with the label '" + String.valueOf(element.getProperty("label")) + "'";
        }
        if (InteractiveElementType.CATEGORY_AXIS_TICK_LABEL.equals(type)) {
            return "Axis tick label with the label '" + String.valueOf(element.getProperty("label")) + "'";
        }
        if (InteractiveElementType.VALUE_AXIS_TICK_LABEL.equals(type)) {
            return "Axis tick label with the value '" + String.valueOf(element.getProperty("value")) + "'";
        }
        if ("obj3d".equals(type)) {
            StringBuilder sb = new StringBuilder();
            sb.append("An object in the 3D model");
            ItemKey itemKey = (ItemKey)element.getProperty("key");
            if (itemKey != null) {
                sb.append(" representing the data item [");
                sb.append(itemKey);
                sb.append("]");
            }
            return sb.toString();
        }
        return element.toString();
    }
}

