/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.calc.disaggregation.chart3d;

import com.google.common.base.Preconditions;
import java.awt.Color;
import java.awt.Font;
import java.awt.Shape;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.util.List;
import org.jfree.chart3d.Orientation;
import org.jfree.chart3d.graphics2d.Anchor2D;
import org.jfree.chart3d.interaction.InteractiveElementType;
import org.jfree.chart3d.internal.Args;
import org.jfree.chart3d.internal.ObjectUtils;
import org.jfree.chart3d.legend.LegendBuilder;
import org.jfree.chart3d.legend.LegendItemInfo;
import org.jfree.chart3d.plot.Plot3D;
import org.jfree.chart3d.style.ChartStyle;
import org.jfree.chart3d.table.GridElement;
import org.jfree.chart3d.table.HAlign;
import org.jfree.chart3d.table.ShapeElement;
import org.jfree.chart3d.table.TableElement;
import org.jfree.chart3d.table.TextElement;
import org.jfree.chart3d.table.VAlign;
import org.opensha.sha.calc.disaggregation.chart3d.CustomWidthGridElement;

final class DisaggLegendBuilder
implements LegendBuilder,
Serializable {
    private String header;
    private HAlign headerAlignment;
    private String footer;
    private HAlign footerAlignment;
    private HAlign rowAlignment;
    private VAlign columnAlignment;

    public DisaggLegendBuilder() {
        this(null, null);
    }

    public DisaggLegendBuilder(String header, String footer) {
        this.header = header;
        this.headerAlignment = HAlign.LEFT;
        this.footer = footer;
        this.footerAlignment = HAlign.RIGHT;
        this.rowAlignment = null;
        this.columnAlignment = null;
    }

    public String getHeader() {
        return this.header;
    }

    public void setHeader(String header) {
        this.header = header;
    }

    public HAlign getHeaderAlignment() {
        return this.headerAlignment;
    }

    public void setHeaderAlignment(HAlign align) {
        Args.nullNotPermitted((Object)align, (String)"align");
        this.headerAlignment = align;
    }

    public String getFooter() {
        return this.footer;
    }

    public void setFooter(String footer) {
        this.footer = footer;
    }

    public HAlign getFooterAlignment() {
        return this.footerAlignment;
    }

    public void setFooterAlignment(HAlign align) {
        Args.nullNotPermitted((Object)align, (String)"align");
        this.footerAlignment = align;
    }

    public HAlign getRowAlignment() {
        return this.rowAlignment;
    }

    public void setRowAlignment(HAlign alignment) {
        this.rowAlignment = alignment;
    }

    public VAlign getColumnAlignment() {
        return this.columnAlignment;
    }

    public void setColumnAlignment(VAlign alignment) {
        this.columnAlignment = alignment;
    }

    public TableElement createLegend(Plot3D plot, Anchor2D anchor, Orientation orientation, ChartStyle style) {
        TableElement legend = this.createSimpleLegend(plot.getLegendInfo(), anchor, orientation, style);
        if (this.header != null || this.footer != null) {
            GridElement compositeLegend = new GridElement();
            compositeLegend.setBackground(null);
            if (this.header != null) {
                TextElement he = new TextElement(this.header, style.getLegendHeaderFont());
                he.setHorizontalAligment(this.headerAlignment);
                he.setBackgroundColor(style.getLegendHeaderBackgroundColor());
                compositeLegend.setElement((TableElement)he, (Comparable)((Object)"R0"), (Comparable)((Object)"C1"));
            }
            compositeLegend.setElement(legend, (Comparable)((Object)"R1"), (Comparable)((Object)"C1"));
            if (this.footer != null) {
                TextElement fe = new TextElement(this.footer, style.getLegendFooterFont());
                fe.setHorizontalAligment(this.footerAlignment);
                fe.setBackgroundColor(style.getLegendFooterBackgroundColor());
                compositeLegend.setElement((TableElement)fe, (Comparable)((Object)"R2"), (Comparable)((Object)"C1"));
            }
            return compositeLegend;
        }
        return legend;
    }

    private TableElement createSimpleLegend(List<LegendItemInfo> items, Anchor2D anchor, Orientation orientation, ChartStyle style) {
        Args.nullNotPermitted(items, (String)"items");
        Args.nullNotPermitted((Object)orientation, (String)"orientation");
        Preconditions.checkState((orientation == Orientation.HORIZONTAL ? 1 : 0) != 0);
        CustomWidthGridElement<String, CallSite> legend = new CustomWidthGridElement<String, CallSite>();
        for (int i = 0; i < items.size(); ++i) {
            LegendItemInfo item = items.get(i);
            Shape shape = item.getShape();
            if (shape == null) {
                shape = style.getLegendItemShape();
            }
            TableElement legendItem = this.createLegendItem(item.getLabel(), style.getLegendItemFont(), style.getLegendItemColor(), shape, item.getColor(), style.getLegendItemBackgroundColor());
            legendItem.setProperty("class", (Object)InteractiveElementType.LEGEND_ITEM);
            legendItem.setProperty("series_key", (Object)item.getSeriesKey());
            legend.setElement(legendItem, "R0", (CallSite)((Object)("C" + i)));
        }
        return legend;
    }

    private TableElement createLegendItem(String text, Font font, Color textColor, Shape shape, Color shapeColor, Color background) {
        ShapeElement se = new ShapeElement(shape, shapeColor){};
        se.setBackgroundColor(background);
        TextElement te = new TextElement(text, font);
        te.setColor(textColor);
        te.setBackgroundColor(background);
        te.setHorizontalAligment(HAlign.CENTER);
        CustomWidthGridElement<String, String> ge = new CustomWidthGridElement<String, String>();
        ge.setElement((TableElement)se, "R1", "C1");
        ge.setElement((TableElement)te, "R2", "C1");
        return ge;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DisaggLegendBuilder)) {
            return false;
        }
        DisaggLegendBuilder that = (DisaggLegendBuilder)obj;
        if (!ObjectUtils.equals((Object)this.header, (Object)that.header)) {
            return false;
        }
        if (this.headerAlignment != that.headerAlignment) {
            return false;
        }
        if (!ObjectUtils.equals((Object)this.footer, (Object)that.footer)) {
            return false;
        }
        return this.footerAlignment == that.footerAlignment;
    }
}

