/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.calc.hazardMap;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.geo.Location;
import org.opensha.sha.calc.hazardMap.BinaryHazardCurveReader;
import org.opensha.sha.calc.hazardMap.BinaryHazardCurveWriter;

public class BinaryCurveAverager {
    private List<File> binFiles;
    private List<Double> weights;
    private File outputFile;

    public BinaryCurveAverager(List<File> binFiles, File outputFile) {
        this(binFiles, null, outputFile);
    }

    public BinaryCurveAverager(List<File> binFiles, List<Double> weights, File outputFile) {
        if (weights == null) {
            double weight = 1.0 / (double)binFiles.size();
            weights = Lists.newArrayList();
            for (int i = 0; i < binFiles.size(); ++i) {
                weights.add(weight);
            }
        } else {
            double weightTot = 0.0;
            for (double weight : weights) {
                weightTot += weight;
            }
            if (weightTot != 1.0) {
                weights = Lists.newArrayList((Iterable)weights);
                for (int i = 0; i < weights.size(); ++i) {
                    weights.set(i, (Double)weights.get(i) / weightTot);
                }
            }
        }
        Preconditions.checkArgument((binFiles.size() == weights.size() ? 1 : 0) != 0);
        Preconditions.checkArgument((binFiles.size() >= 2 ? 1 : 0) != 0);
        this.binFiles = binFiles;
        this.weights = weights;
        this.outputFile = outputFile;
    }

    public void averageDirs() throws Exception {
        ArrayList maps = Lists.newArrayList();
        for (File file : this.binFiles) {
            maps.add(new BinaryHazardCurveReader(file.getAbsolutePath()).getCurveMap());
        }
        HashSet commonLocs = null;
        for (Map map : maps) {
            if (commonLocs == null) {
                commonLocs = new HashSet(map.keySet());
                continue;
            }
            commonLocs.retainAll(map.keySet());
        }
        System.out.println("Averaging " + commonLocs.size() + " curves from " + maps.size() + " sources");
        Preconditions.checkState((!commonLocs.isEmpty() ? 1 : 0) != 0);
        String string2 = this.outputFile.getName();
        string2 = string2.replaceAll(".bin", "");
        ArbitrarilyDiscretizedFunc xVals = ((ArbitrarilyDiscretizedFunc)((Map)maps.get(0)).values().iterator().next()).deepClone();
        for (int i = 0; i < xVals.size(); ++i) {
            xVals.set(i, 0.0);
        }
        HashMap xValsMap = Maps.newHashMap();
        xValsMap.put(string2, xVals);
        ArrayList curves = Lists.newArrayList();
        ArrayList locs = Lists.newArrayList();
        for (Location loc : commonLocs) {
            DiscretizedFunc avgFunc = xVals.deepClone();
            for (int i = 0; i < maps.size(); ++i) {
                double weight = this.weights.get(i);
                DiscretizedFunc curve = (DiscretizedFunc)((Map)maps.get(i)).get(loc);
                for (int j = 0; j < avgFunc.size(); ++j) {
                    avgFunc.set(j, avgFunc.getY(j) + curve.getY(j) * weight);
                }
            }
            locs.add(loc);
            curves.add(avgFunc);
        }
        BinaryHazardCurveWriter writer = new BinaryHazardCurveWriter(this.outputFile);
        writer.writeCurves(curves, locs);
    }

    public static void main(String[] args) {
        ArrayList binFiles = Lists.newArrayList();
        File outputFile = null;
        if (args.length > 3) {
            for (int i = 0; i < args.length - 1; ++i) {
                File binFile = new File(args[i]);
                Preconditions.checkArgument((boolean)binFile.exists());
                binFiles.add(binFile);
            }
            outputFile = new File(args[args.length - 1]);
        } else {
            System.out.println("USAGE: BinaryCurveAverager file1 file2 file3 [... dirN] outputFile");
            System.exit(2);
        }
        BinaryCurveAverager ave = new BinaryCurveAverager(binFiles, outputFile);
        try {
            ave.averageDirs();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

