/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.calc.hazardMap.components;

import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import org.dom4j.Element;
import org.opensha.commons.data.function.AbstractDiscretizedFunc;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.geo.Location;
import org.opensha.sha.calc.hazardMap.components.CurveMetadata;
import org.opensha.sha.calc.hazardMap.components.CurveResultsArchiver;

public class AsciiFileCurveArchiver
implements CurveResultsArchiver {
    private static final boolean D = false;
    public static final String XML_METADATA_NAME = "AsciiFileCurveArchiver";
    private String outputDir;
    private boolean binByLat;
    private boolean binByLon;
    private static DecimalFormat decimalFormat = new DecimalFormat("0.00##");

    public AsciiFileCurveArchiver(String outputDir, boolean binByLat, boolean binByLon) throws IOException {
        if (!((String)outputDir).endsWith(File.separator)) {
            outputDir = (String)outputDir + File.separator;
        }
        this.binByLat = binByLat;
        this.binByLon = binByLon;
        this.setOutputDir((String)outputDir);
        System.out.println("Output Dir: " + (String)outputDir);
    }

    @Override
    public void archiveCurve(DiscretizedFunc curve, CurveMetadata meta) throws IOException {
        String outFileName = this.getFileName(meta);
        AbstractDiscretizedFunc.writeSimpleFuncFile(curve, outFileName);
    }

    private synchronized String getFileName(CurveMetadata meta) {
        File dirFile;
        Location loc = meta.getSite().getLocation();
        Object dir = this.outputDir;
        dir = (String)dir + meta.getShortLabel() + File.separator;
        if (this.binByLat) {
            dir = (String)dir + loc.getLatitude() + File.separator;
        }
        if (this.binByLon) {
            dir = (String)dir + loc.getLongitude() + File.separator;
        }
        if (!(dirFile = new File((String)dir)).exists()) {
            dirFile.mkdirs();
        }
        return (String)dir + AsciiFileCurveArchiver.formatLocation(loc) + ".txt";
    }

    public String getOutputDir() {
        return this.outputDir;
    }

    public void setOutputDir(String outputDir) throws IOException {
        this.outputDir = outputDir;
        File outputDirFile = new File(outputDir);
        if (!outputDirFile.exists()) {
            if (!outputDirFile.mkdir()) {
                System.err.println("WARNING: Output directory could not be created: '" + outputDir + "'");
            } else if (!outputDirFile.isDirectory()) {
                throw new IOException("Output directory already exists and is not a directory: '" + outputDir + "'");
            }
        }
    }

    private static String formatLocation(Location loc) {
        return decimalFormat.format(loc.getLatitude()) + "_" + decimalFormat.format(loc.getLongitude());
    }

    @Override
    public Element toXMLMetadata(Element root) {
        Element el = root.addElement(XML_METADATA_NAME);
        el.addAttribute("outputDir", this.outputDir);
        el.addAttribute("binByLat", "" + this.binByLat);
        el.addAttribute("binByLon", "" + this.binByLon);
        return root;
    }

    public static AsciiFileCurveArchiver fromXMLMetadata(Element archiverEl) throws IOException {
        String outputDir = archiverEl.attributeValue("outputDir");
        boolean binByLat = Boolean.parseBoolean(archiverEl.attributeValue("binByLat"));
        boolean binByLon = Boolean.parseBoolean(archiverEl.attributeValue("binByLon"));
        return new AsciiFileCurveArchiver(outputDir, binByLat, binByLon);
    }

    @Override
    public boolean isCurveCalculated(CurveMetadata meta, DiscretizedFunc xVals) {
        String outFileName = this.getFileName(meta);
        File file = new File(outFileName);
        if (file.exists()) {
            try {
                ArbitrarilyDiscretizedFunc func = ArbitrarilyDiscretizedFunc.loadFuncFromSimpleFile(outFileName);
                if (func.size() == xVals.size()) {
                    boolean match = true;
                    for (int i = 0; i < func.size(); ++i) {
                        if (func.getX(i) == xVals.getX(i)) continue;
                        match = false;
                        break;
                    }
                    return match;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public File getStoreDir() {
        return new File(this.outputDir);
    }

    @Override
    public void close() {
    }
}

