/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.calc.params.filters;

import org.opensha.commons.data.Site;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.sha.calc.params.MaxDistanceParam;
import org.opensha.sha.calc.params.filters.SourceFilter;
import org.opensha.sha.earthquake.EqkRupture;
import org.opensha.sha.earthquake.EqkSource;

public class FixedDistanceCutoffFilter
implements SourceFilter,
ParameterChangeListener {
    private MaxDistanceParam distParam = new MaxDistanceParam();
    private double maxDist = (Double)this.distParam.getValue();
    private ParameterList params;

    public FixedDistanceCutoffFilter() {
        this.distParam.addParameterChangeListener(this);
        this.params = new ParameterList();
        this.params.addParameter(this.distParam);
    }

    public FixedDistanceCutoffFilter(double maxDistance) {
        this();
        this.distParam.setValue(maxDistance);
    }

    public void setMaxDistance(double maxDist) {
        this.distParam.setValue(maxDist);
    }

    public double getMaxDistance() {
        return this.maxDist;
    }

    public MaxDistanceParam getParam() {
        return this.distParam;
    }

    @Override
    public boolean canSkipSource(EqkSource source, Site site, double sourceSiteDistance) {
        return sourceSiteDistance > this.maxDist;
    }

    @Override
    public boolean canSkipRupture(EqkRupture rup, Site site) {
        return rup.getRuptureSurface().getQuickDistance(site.getLocation()) > this.maxDist;
    }

    @Override
    public ParameterList getAdjustableParams() {
        return this.params;
    }

    @Override
    public void parameterChange(ParameterChangeEvent event) {
        this.maxDist = (Double)this.distParam.getValue();
    }

    public String toString() {
        return "MaxDist=" + (float)this.maxDist;
    }
}

