/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.calc.params.filters;

import org.opensha.commons.data.Site;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.sha.calc.params.MinMagnitudeParam;
import org.opensha.sha.calc.params.filters.SourceFilter;
import org.opensha.sha.earthquake.EqkRupture;
import org.opensha.sha.earthquake.EqkSource;

public class MinMagFilter
implements SourceFilter,
ParameterChangeListener {
    private MinMagnitudeParam param = new MinMagnitudeParam();
    private double minMag = (Double)this.param.getValue();
    private ParameterList params;

    public MinMagFilter() {
        this.param.addParameterChangeListener(this);
        this.params = new ParameterList();
        this.params.addParameter(this.param);
    }

    public void setMinMagnitude(double minMag) {
        this.param.setValue(minMag);
    }

    public double getMinMagnitude() {
        return this.minMag;
    }

    @Override
    public boolean canSkipSource(EqkSource source, Site site, double sourceSiteDistance) {
        return false;
    }

    @Override
    public boolean canSkipRupture(EqkRupture rup, Site site) {
        return rup.getMag() < this.minMag;
    }

    @Override
    public ParameterList getAdjustableParams() {
        return this.params;
    }

    @Override
    public void parameterChange(ParameterChangeEvent event) {
        this.minMag = (Double)this.param.getValue();
    }

    public String toString() {
        return "MinMag=" + (float)this.minMag;
    }
}

