/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.calc.params.filters;

import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.editor.AbstractParameterEditor;
import org.opensha.commons.param.editor.ParameterEditor;
import org.opensha.commons.param.editor.impl.ParameterListEditor;
import org.opensha.sha.calc.params.filters.SourceFilterManager;
import org.opensha.sha.calc.params.filters.SourceFilters;
import org.opensha.sha.calc.params.filters.SourceFiltersParam;

public class SourceFiltersParamEditor
extends AbstractParameterEditor<SourceFilterManager>
implements ActionListener {
    private static final SourceFilters[] filters = SourceFilters.values();
    private JPanel panel;
    private JCheckBox[] checkBoxes;
    private ParameterList params;
    private ParameterListEditor paramsEdit;
    private boolean globalEnabled = true;

    public SourceFiltersParamEditor(SourceFiltersParam param) {
        super(param);
    }

    @Override
    public boolean isParameterSupported(Parameter<SourceFilterManager> param) {
        return param instanceof SourceFiltersParam;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.panel == null) {
            return;
        }
        this.globalEnabled = enabled;
        this.updateWidget();
        for (JCheckBox box : this.checkBoxes) {
            box.setEnabled(enabled);
        }
        SourceFilterManager manager = (SourceFilterManager)this.getParameter().getValue();
        for (int i = 0; i < filters.length; ++i) {
            boolean selected = manager.isEnabled(filters[i]);
            ParameterList filterParams = manager.getFilterInstance(filters[i]).getAdjustableParams();
            if (filterParams == null) continue;
            for (Parameter<?> param : filterParams) {
                param.getEditor().setEnabled(enabled && selected);
            }
        }
        this.paramsEdit.refreshParamEditor();
    }

    @Override
    public boolean isEnabled() {
        return this.globalEnabled;
    }

    @Override
    protected JComponent buildWidget() {
        this.globalEnabled = true;
        this.panel = new JPanel();
        this.panel.setLayout(new BoxLayout(this.panel, 1));
        SourceFilterManager manager = (SourceFilterManager)this.getParameter().getValue();
        this.params = new ParameterList();
        this.checkBoxes = new JCheckBox[filters.length];
        for (int i = 0; i < filters.length; ++i) {
            SourceFilters filter = filters[i];
            this.checkBoxes[i] = new JCheckBox(filter.toString(), null, manager.isEnabled(filter));
            this.checkBoxes[i].addActionListener(this);
            this.checkBoxes[i].setHorizontalAlignment(2);
            JPanel subPanel = new JPanel(new FlowLayout(0));
            subPanel.add(this.checkBoxes[i]);
            this.panel.add(subPanel);
            ParameterList filterParams = manager.getFilterInstance(filter).getAdjustableParams();
            if (filterParams == null) continue;
            for (Parameter<?> param : filterParams) {
                this.params.addParameter(param);
                ParameterEditor editor = param.getEditor();
                if (!(editor instanceof AbstractParameterEditor)) continue;
                ((AbstractParameterEditor)editor).setShowDisabledStatusInTitle(true);
            }
            this.params.addParameterList(filterParams);
        }
        this.paramsEdit = new ParameterListEditor(this.params);
        this.paramsEdit.setTitle("Adjustable Parameters");
        this.panel.add(this.paramsEdit);
        this.updateWidget();
        return this.panel;
    }

    @Override
    protected JComponent updateWidget() {
        SourceFilterManager manager = (SourceFilterManager)this.getParameter().getValue();
        for (int i = 0; i < filters.length; ++i) {
            boolean checked = this.checkBoxes[i].isSelected();
            boolean filterEnabled = manager.isEnabled(filters[i]);
            if (filterEnabled != checked) {
                this.checkBoxes[i].setSelected(filterEnabled);
            }
            this.checkBoxes[i].setEnabled(this.globalEnabled);
            ParameterList filterParams = manager.getFilterInstance(filters[i]).getAdjustableParams();
            if (filterParams == null) continue;
            for (Parameter<?> param : filterParams) {
                param.getEditor().setEnabled(this.globalEnabled && filterEnabled);
                param.getEditor().refreshParamEditor();
            }
        }
        this.paramsEdit.refreshParamEditor();
        return this.panel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        for (int i = 0; i < this.checkBoxes.length; ++i) {
            if (e.getSource() != this.checkBoxes[i]) continue;
            boolean selected = this.checkBoxes[i].isSelected();
            SourceFilterManager manager = (SourceFilterManager)this.getParameter().getValue();
            manager.setEnabled(filters[i], selected);
            this.updateWidget();
            break;
        }
    }

    public static void main(String[] args) {
        SourceFiltersParam param = new SourceFiltersParam();
        SourceFiltersParamEditor editor = new SourceFiltersParamEditor(param);
        JFrame frame = new JFrame();
        frame.setContentPane(editor.buildWidget());
        frame.setVisible(true);
        frame.setSize(400, 400);
        frame.setDefaultCloseOperation(3);
        frame.validate();
    }
}

