/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake;

import java.util.ArrayList;
import org.opensha.sha.earthquake.AbstractERF;
import org.opensha.sha.earthquake.ProbEqkRupture;

public abstract class AbstractNthRupERF
extends AbstractERF {
    private static final long serialVersionUID = 1L;
    protected int totNumRups = -1;
    protected ArrayList<int[]> nthRupIndicesForSource;
    protected int[] srcIndexForNthRup;
    protected int[] rupIndexForNthRup;

    public int[] get_nthRupIndicesForSource(int iSource) {
        return this.nthRupIndicesForSource.get(iSource);
    }

    public int getTotNumRups() {
        return this.totNumRups;
    }

    public int getIndexN_ForSrcAndRupIndices(int s, int r) {
        return this.get_nthRupIndicesForSource(s)[r];
    }

    public int getSrcIndexForNthRup(int nthRup) {
        return this.srcIndexForNthRup[nthRup];
    }

    public int getRupIndexInSourceForNthRup(int nthRup) {
        return this.rupIndexForNthRup[nthRup];
    }

    public ProbEqkRupture getNthRupture(int n) {
        return this.getRupture(this.getSrcIndexForNthRup(n), this.getRupIndexInSourceForNthRup(n));
    }

    protected void setAllNthRupRelatedArrays() {
        this.totNumRups = 0;
        this.nthRupIndicesForSource = new ArrayList();
        ArrayList<Integer> tempSrcIndexForNthRup = new ArrayList<Integer>();
        ArrayList<Integer> tempRupIndexForNthRup = new ArrayList<Integer>();
        int n = 0;
        for (int s = 0; s < this.getNumSources(); ++s) {
            int numRups = this.getSource(s).getNumRuptures();
            this.totNumRups += numRups;
            int[] nthRupsForSrc = new int[numRups];
            for (int r = 0; r < numRups; ++r) {
                tempSrcIndexForNthRup.add(s);
                tempRupIndexForNthRup.add(r);
                nthRupsForSrc[r] = n++;
            }
            this.nthRupIndicesForSource.add(nthRupsForSrc);
        }
        this.srcIndexForNthRup = new int[tempSrcIndexForNthRup.size()];
        this.rupIndexForNthRup = new int[tempRupIndexForNthRup.size()];
        for (n = 0; n < this.totNumRups; ++n) {
            this.srcIndexForNthRup[n] = (Integer)tempSrcIndexForNthRup.get(n);
            this.rupIndexForNthRup[n] = (Integer)tempRupIndexForNthRup.get(n);
        }
    }

    public void testNthRupIndicesForSource() {
        int index = 0;
        for (int s = 0; s < this.getNumSources(); ++s) {
            int[] test = this.get_nthRupIndicesForSource(s);
            for (int r = 0; r < test.length; ++r) {
                int nthRup = test[r];
                if (nthRup != index) {
                    throw new RuntimeException("Error found");
                }
                ++index;
            }
        }
        System.out.println("testNthRupIndicesForSource() was successful");
    }
}

