/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake;

import java.io.Serializable;
import java.util.ListIterator;
import org.opensha.commons.exceptions.InvalidRangeException;
import org.opensha.commons.geo.Location;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.util.FaultUtils;
import org.opensha.sha.faultSurface.PointSurface;
import org.opensha.sha.faultSurface.RuptureSurface;

public class EqkRupture
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static final String C = "EqkRupture";
    protected static final boolean D = false;
    protected double mag = Double.NaN;
    protected double aveRake = Double.NaN;
    protected Location hypocenterLocation = null;
    protected RuptureSurface ruptureSurface = null;
    protected ParameterList otherParams;

    public EqkRupture() {
    }

    public EqkRupture(double mag, double aveRake, RuptureSurface ruptureSurface, Location hypocenterLocation) throws InvalidRangeException {
        this.mag = mag;
        FaultUtils.assertValidRake(aveRake);
        this.hypocenterLocation = hypocenterLocation;
        this.aveRake = aveRake;
        this.ruptureSurface = ruptureSurface;
    }

    public void addParameter(Parameter<?> parameter) {
        if (this.otherParams == null) {
            this.otherParams = new ParameterList();
        }
        if (!this.otherParams.containsParameter(parameter)) {
            this.otherParams.addParameter(parameter);
        } else {
            this.otherParams.updateParameter(parameter);
        }
    }

    public void removeParameter(Parameter<?> parameter) {
        if (this.otherParams == null) {
            return;
        }
        this.otherParams.removeParameter(parameter);
    }

    public ListIterator<Parameter<?>> getAddedParametersIterator() {
        if (this.otherParams == null) {
            return null;
        }
        return this.otherParams.getParametersIterator();
    }

    public double getMag() {
        return this.mag;
    }

    public void setMag(double mag) {
        this.mag = mag;
    }

    public double getAveRake() {
        return this.aveRake;
    }

    public void setAveRake(double aveRake) throws InvalidRangeException {
        FaultUtils.assertValidRake(aveRake);
        this.aveRake = aveRake;
    }

    public RuptureSurface getRuptureSurface() {
        return this.ruptureSurface;
    }

    public void setRuptureSurface(RuptureSurface r) {
        this.ruptureSurface = r;
    }

    public Location getHypocenterLocation() {
        return this.hypocenterLocation;
    }

    public void setHypocenterLocation(Location h) {
        this.hypocenterLocation = h;
    }

    public void setPointSurface(Location location) {
        PointSurface ps = new PointSurface(location);
        this.setPointSurface(ps);
    }

    public void setPointSurface(Location location, double aveDip) {
        this.setPointSurface(location);
        ((PointSurface)this.ruptureSurface).setAveDip(aveDip);
    }

    public void setPointSurface(Location location, double aveStrike, double aveDip) {
        this.setPointSurface(location);
        ((PointSurface)this.ruptureSurface).setAveStrike(aveStrike);
        ((PointSurface)this.ruptureSurface).setAveDip(aveDip);
    }

    public void setPointSurface(PointSurface pointSurface) {
        this.ruptureSurface = pointSurface;
    }

    public String getInfo() {
        Object info = new String("\tMag. = " + (float)this.mag + "\n\tAve. Rake = " + (float)this.aveRake + "\n\tAve. Dip = " + (float)this.ruptureSurface.getAveDip() + "\n\tHypocenter = " + String.valueOf(this.hypocenterLocation) + "\n");
        info = (String)info + this.ruptureSurface.getInfo();
        return info;
    }
}

