/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake;

import org.opensha.commons.exceptions.InvalidRangeException;
import org.opensha.commons.geo.Location;
import org.opensha.sha.earthquake.EqkRupture;
import org.opensha.sha.faultSurface.RuptureSurface;

public class ProbEqkRupture
extends EqkRupture {
    private static final long serialVersionUID = 1L;
    protected double probability;

    public ProbEqkRupture() {
    }

    public ProbEqkRupture(double mag, double aveRake, double probability, RuptureSurface ruptureSurface, Location hypocenterLocation) throws InvalidRangeException {
        super(mag, aveRake, ruptureSurface, hypocenterLocation);
        this.probability = probability;
    }

    public double getProbability() {
        return this.probability;
    }

    public void setProbability(double p) {
        this.probability = p;
    }

    public double getMeanAnnualRate(double duration) {
        return -Math.log(1.0 - this.probability) / duration;
    }

    @Override
    public String getInfo() {
        Object info = new String("\tMag. = " + (float)this.mag + "\n\tAve. Rake = " + (float)this.aveRake + "\n\tProb. = " + (float)this.probability + "\n\tAve. Dip = " + (float)this.ruptureSurface.getAveDip() + "\n\tHypocenter = " + String.valueOf(this.hypocenterLocation) + "\n");
        info = (String)info + this.ruptureSurface.getInfo();
        return info;
    }

    public String getRuptureMetadata() {
        String ruptureMetadata = (float)this.mag + "\t";
        ruptureMetadata = ruptureMetadata + (float)this.probability + "\t";
        ruptureMetadata = ruptureMetadata + (float)this.aveRake + "\t";
        ruptureMetadata = ruptureMetadata + (float)this.ruptureSurface.getAveDip();
        return ruptureMetadata;
    }

    public Object clone() {
        ProbEqkRupture eqkRuptureClone = new ProbEqkRupture();
        eqkRuptureClone.setAveRake(this.aveRake);
        eqkRuptureClone.setMag(this.mag);
        eqkRuptureClone.setRuptureSurface(this.ruptureSurface);
        eqkRuptureClone.setHypocenterLocation(this.hypocenterLocation);
        eqkRuptureClone.setProbability(this.probability);
        return eqkRuptureClone;
    }
}

