/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.calc;

import com.google.common.primitives.Ints;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.ListIterator;
import org.opensha.commons.data.xyz.GriddedGeoDataSet;
import org.opensha.commons.eq.MagUtils;
import org.opensha.commons.geo.GriddedRegion;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.geo.Region;
import org.opensha.commons.geo.RegionUtils;
import org.opensha.sha.earthquake.ERF;
import org.opensha.sha.earthquake.ProbEqkRupture;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.faultSurface.FaultTrace;
import org.opensha.sha.faultSurface.RupInRegionCache;
import org.opensha.sha.faultSurface.RupNodesCache;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import org.opensha.sha.magdist.SummedMagFreqDist;

public class ERF_Calculator {
    public static SummedMagFreqDist getTotalMFD_ForERF(ERF eqkRupForecast, double min, double max, int num, boolean preserveRates) {
        return ERF_Calculator.getTotalMFD_ForSourceRange(eqkRupForecast, min, max, num, preserveRates, 0, eqkRupForecast.getNumSources() - 1);
    }

    public static SummedMagFreqDist getTotalMFD_ForSourceRange(ERF eqkRupForecast, double min, double max, int num, boolean preserveRates, int firstSourceIndex, int lastSourceIndex) {
        SummedMagFreqDist mfd = new SummedMagFreqDist(min, max, num);
        double duration = eqkRupForecast.getTimeSpan().getDuration();
        for (int s = firstSourceIndex; s <= lastSourceIndex; ++s) {
            ProbEqkSource src = eqkRupForecast.getSource(s);
            for (int r = 0; r < src.getNumRuptures(); ++r) {
                ProbEqkRupture rup = src.getRupture(r);
                mfd.addResampledMagRate(rup.getMag(), rup.getMeanAnnualRate(duration), preserveRates);
            }
        }
        return mfd;
    }

    public static SummedMagFreqDist getTotalMFD_ForSource(ProbEqkSource src, double duration, double min, double max, int num, boolean preserveRates) {
        SummedMagFreqDist mfd = new SummedMagFreqDist(min, max, num);
        for (int r = 0; r < src.getNumRuptures(); ++r) {
            ProbEqkRupture rup = src.getRupture(r);
            mfd.addResampledMagRate(rup.getMag(), rup.getMeanAnnualRate(duration), preserveRates);
        }
        return mfd;
    }

    public static double getTotalRateAboveMagForSource(ProbEqkSource src, double duration, double magThresh) {
        double totRate = 0.0;
        for (int r = 0; r < src.getNumRuptures(); ++r) {
            ProbEqkRupture rup = src.getRupture(r);
            if (!(rup.getMag() >= magThresh)) continue;
            totRate += rup.getMeanAnnualRate(duration);
        }
        return totRate;
    }

    public static double getTotalMomentRateForSource(ProbEqkSource src, double duration) {
        double totMoRate = 0.0;
        for (int r = 0; r < src.getNumRuptures(); ++r) {
            ProbEqkRupture rup = src.getRupture(r);
            totMoRate += MagUtils.magToMoment(rup.getMag()) * rup.getMeanAnnualRate(duration);
        }
        return totMoRate;
    }

    public static SummedMagFreqDist getMagFreqDistInRegion(ERF erf, Region region, double minMag, int numMag, double deltaMag, boolean preserveRates) {
        SummedMagFreqDist magFreqDist = new SummedMagFreqDist(minMag, numMag, deltaMag);
        double duration = erf.getTimeSpan().getDuration();
        for (int s = 0; s < erf.getNumSources(); ++s) {
            ProbEqkSource source = erf.getSource(s);
            for (int r = 0; r < source.getNumRuptures(); ++r) {
                ProbEqkRupture rupture = source.getRupture(r);
                double mag = rupture.getMag();
                double equivRate = rupture.getMeanAnnualRate(duration);
                LocationList surfLocs = rupture.getRuptureSurface().getEvenlyDiscritizedListOfLocsOnSurface();
                double ptRate = equivRate / (double)surfLocs.size();
                ListIterator it = surfLocs.listIterator();
                while (it.hasNext()) {
                    if (!region.contains((Location)it.next())) continue;
                    magFreqDist.addResampledMagRate(mag, ptRate, preserveRates);
                }
            }
        }
        return magFreqDist;
    }

    public static SummedMagFreqDist getMagFreqDistInRegionFaster(ERF erf, Region region, double minMag, int numMag, double deltaMag, boolean preserveRates) {
        SummedMagFreqDist magFreqDist = new SummedMagFreqDist(minMag, numMag, deltaMag);
        double duration = erf.getTimeSpan().getDuration();
        for (int s = 0; s < erf.getNumSources(); ++s) {
            ProbEqkSource source = erf.getSource(s);
            for (int r = 0; r < source.getNumRuptures(); ++r) {
                ProbEqkRupture rupture = source.getRupture(r);
                double mag = rupture.getMag();
                double equivRate = rupture.getMeanAnnualRate(duration);
                FaultTrace surfLocs = rupture.getRuptureSurface().getEvenlyDiscritizedUpperEdge();
                double ptRate = equivRate / (double)surfLocs.size();
                ListIterator it = surfLocs.listIterator();
                while (it.hasNext()) {
                    if (!region.contains((Location)it.next())) continue;
                    magFreqDist.addResampledMagRate(mag, ptRate, preserveRates);
                }
            }
        }
        return magFreqDist;
    }

    public static SummedMagFreqDist getParticipationMagFreqDistInRegion(ERF erf, Region region, double minMag, int numMag, double deltaMag, boolean preserveRates) {
        return ERF_Calculator.getParticipationMagFreqDistInRegion(erf, region, minMag, numMag, deltaMag, preserveRates, null);
    }

    public static SummedMagFreqDist getParticipationMagFreqDistInRegion(ERF erf, Region region, double minMag, int numMag, double deltaMag, boolean preserveRates, RupInRegionCache rupInRegionCache) {
        SummedMagFreqDist magFreqDist = new SummedMagFreqDist(minMag, numMag, deltaMag);
        double duration = erf.getTimeSpan().getDuration();
        int srcIndex = 0;
        for (ProbEqkSource source : erf) {
            int rupIndex = 0;
            for (ProbEqkRupture rupture : source) {
                boolean isInside = false;
                if (rupInRegionCache == null) {
                    for (Location loc : rupture.getRuptureSurface().getEvenlyDiscritizedListOfLocsOnSurface()) {
                        if (!region.contains(loc)) continue;
                        isInside = true;
                        break;
                    }
                } else {
                    isInside = rupInRegionCache.isRupInRegion(erf, source, rupture, srcIndex, rupIndex, region);
                }
                if (isInside) {
                    double equivRate = rupture.getMeanAnnualRate(duration);
                    magFreqDist.addResampledMagRate(rupture.getMag(), equivRate, preserveRates);
                }
                ++rupIndex;
            }
            ++srcIndex;
        }
        return magFreqDist;
    }

    public static double getTotalRateInRegion(ERF erf, Region region, double minMag) {
        double duration = erf.getTimeSpan().getDuration();
        double totRate = 0.0;
        for (int s = 0; s < erf.getNumSources(); ++s) {
            ProbEqkSource source = erf.getSource(s);
            for (int r = 0; r < source.getNumRuptures(); ++r) {
                ProbEqkRupture rupture = source.getRupture(r);
                if (!(rupture.getMag() >= minMag)) continue;
                double fractionInside = RegionUtils.getFractionInside(region, rupture.getRuptureSurface().getEvenlyDiscritizedListOfLocsOnSurface());
                totRate += fractionInside * rupture.getMeanAnnualRate(duration);
            }
        }
        return totRate;
    }

    public static double getTotalMomentRateInRegion(ERF erf, Region region) {
        double duration = erf.getTimeSpan().getDuration();
        double totMoRate = 0.0;
        double totMoRateOutside = 0.0;
        for (int s = 0; s < erf.getNumSources(); ++s) {
            ProbEqkSource source = erf.getSource(s);
            for (int r = 0; r < source.getNumRuptures(); ++r) {
                ProbEqkRupture rupture = source.getRupture(r);
                double rupMoment = MagUtils.magToMoment(rupture.getMag());
                if (region != null) {
                    double fractionInside = RegionUtils.getFractionInside(region, rupture.getRuptureSurface().getEvenlyDiscritizedListOfLocsOnSurface());
                    totMoRate += fractionInside * rupMoment * rupture.getMeanAnnualRate(duration);
                    totMoRateOutside += (1.0 - fractionInside) * rupMoment * rupture.getMeanAnnualRate(duration);
                    continue;
                }
                totMoRate += rupMoment * rupture.getMeanAnnualRate(duration);
            }
        }
        if (region != null) {
            System.out.println("totMoRateOutside=" + totMoRateOutside);
        }
        return totMoRate;
    }

    public static ArrayList<SummedMagFreqDist> getMagFreqDistsAtLocsInRegion(ERF erf, GriddedRegion griddedRegion, double minMag, int numMag, double deltaMag, boolean preserveRates) {
        ArrayList<SummedMagFreqDist> magFreqDists = new ArrayList<SummedMagFreqDist>();
        for (Location loc : griddedRegion) {
            magFreqDists.add(new SummedMagFreqDist(minMag, numMag, deltaMag));
        }
        SummedMagFreqDist unassignedMFD = new SummedMagFreqDist(minMag, numMag, deltaMag);
        double duration = erf.getTimeSpan().getDuration();
        for (int s = 0; s < erf.getNumSources(); ++s) {
            ProbEqkSource source = erf.getSource(s);
            for (int r = 0; r < source.getNumRuptures(); ++r) {
                ProbEqkRupture rupture = source.getRupture(r);
                double mag = rupture.getMag();
                double equivRate = rupture.getMeanAnnualRate(duration);
                LocationList surfLocs = rupture.getRuptureSurface().getEvenlyDiscritizedListOfLocsOnSurface();
                double ptRate = equivRate / (double)surfLocs.size();
                ListIterator it = surfLocs.listIterator();
                while (it.hasNext()) {
                    Location loc = (Location)it.next();
                    int index = griddedRegion.indexForLocation(loc);
                    if (index >= 0) {
                        magFreqDists.get(index).addResampledMagRate(mag, ptRate, preserveRates);
                        continue;
                    }
                    unassignedMFD.addResampledMagRate(mag, ptRate, preserveRates);
                }
            }
        }
        return magFreqDists;
    }

    public static GriddedGeoDataSet get_bValueAtPointsInRegion(ERF erf, GriddedRegion griddedRegion, double min_bValMag, double max_bValMag) {
        ArrayList<SummedMagFreqDist> mfdList = ERF_Calculator.getMagFreqDistsAtLocsInRegion(erf, griddedRegion, 0.05, 100, 0.1, true);
        GriddedGeoDataSet xyzData = new GriddedGeoDataSet(griddedRegion, true);
        System.out.println(mfdList.get(1536));
        for (int i = 0; i < xyzData.size(); ++i) {
            xyzData.set(i, mfdList.get(i).compute_bValue(min_bValMag, max_bValMag));
        }
        return xyzData;
    }

    public static GriddedGeoDataSet getNucleationRatesInRegion(ERF erf, GriddedRegion griddedRegion, double minMag, double maxMag) {
        return ERF_Calculator.getNucleationRatesInRegion(erf, griddedRegion, minMag, maxMag, null);
    }

    public static GriddedGeoDataSet getNucleationRatesInRegion(ERF erf, GriddedRegion griddedRegion, double minMag, double maxMag, RupNodesCache rupNodesCache) {
        GriddedGeoDataSet xyzData = new GriddedGeoDataSet(griddedRegion, true);
        double[] zVals = new double[griddedRegion.getNodeCount()];
        double duration = erf.getTimeSpan().getDuration();
        for (int srcIndex = 0; srcIndex < erf.getNumSources(); ++srcIndex) {
            ProbEqkSource source = erf.getSource(srcIndex);
            for (int rupIndex = 0; rupIndex < source.getNumRuptures(); ++rupIndex) {
                ProbEqkRupture rupture = source.getRupture(rupIndex);
                double mag = rupture.getMag();
                if (!(mag >= minMag) || !(mag < maxMag)) continue;
                int[] nodes = null;
                if (rupNodesCache != null) {
                    nodes = rupNodesCache.getNodesForRup(source, rupture, srcIndex, rupIndex, griddedRegion);
                }
                if (nodes == null) {
                    LocationList surfLocs = rupture.getRuptureSurface().getEvenlyDiscritizedListOfLocsOnSurface();
                    double ptRate = rupture.getMeanAnnualRate(duration) / (double)surfLocs.size();
                    for (Location loc : surfLocs) {
                        int index = griddedRegion.indexForLocation(loc);
                        if (index < 0) continue;
                        int n = index;
                        zVals[n] = zVals[n] + ptRate;
                    }
                    continue;
                }
                double[] fracts = rupNodesCache.getFractsInNodesForRup(source, rupture, srcIndex, rupIndex, griddedRegion);
                double rate = rupture.getMeanAnnualRate(duration);
                for (int i = 0; i < nodes.length; ++i) {
                    int n = nodes[i];
                    zVals[n] = zVals[n] + rate * fracts[i];
                }
            }
        }
        for (int i = 0; i < griddedRegion.getNodeCount(); ++i) {
            xyzData.set(i, zVals[i]);
        }
        return xyzData;
    }

    public static GriddedGeoDataSet getMomentRatesInRegion(ERF erf, GriddedRegion griddedRegion) {
        GriddedGeoDataSet xyzData = new GriddedGeoDataSet(griddedRegion, true);
        double[] zVals = new double[griddedRegion.getNodeCount()];
        double duration = erf.getTimeSpan().getDuration();
        double moRateOutsideRegion = 0.0;
        for (ProbEqkSource source : erf) {
            for (ProbEqkRupture rupture : source) {
                LocationList surfLocs = rupture.getRuptureSurface().getEvenlyDiscritizedListOfLocsOnSurface();
                double ptMoRate = MagUtils.magToMoment(rupture.getMag()) * rupture.getMeanAnnualRate(duration) / (double)surfLocs.size();
                for (Location loc : surfLocs) {
                    int index = griddedRegion.indexForLocation(loc);
                    if (index >= 0) {
                        int n = index;
                        zVals[n] = zVals[n] + ptMoRate;
                        continue;
                    }
                    moRateOutsideRegion += ptMoRate;
                }
            }
        }
        System.out.println("moRateOutsideRegion=" + moRateOutsideRegion);
        for (int i = 0; i < griddedRegion.getNodeCount(); ++i) {
            xyzData.set(i, zVals[i]);
        }
        return xyzData;
    }

    public static GriddedGeoDataSet getParticipationRatesInRegion(ERF erf, GriddedRegion griddedRegion, double minMag, double maxMag) {
        return ERF_Calculator.getParticipationRatesInRegion(erf, griddedRegion, minMag, maxMag, null);
    }

    public static GriddedGeoDataSet getParticipationRatesInRegion(ERF erf, GriddedRegion griddedRegion, double minMag, double maxMag, RupNodesCache rupNodesCache) {
        GriddedGeoDataSet xyzData = new GriddedGeoDataSet(griddedRegion, true);
        double[] zVals = new double[griddedRegion.getNodeCount()];
        double duration = erf.getTimeSpan().getDuration();
        for (int srcIndex = 0; srcIndex < erf.getNumSources(); ++srcIndex) {
            ProbEqkSource source = erf.getSource(srcIndex);
            for (int rupIndex = 0; rupIndex < source.getNumRuptures(); ++rupIndex) {
                ProbEqkRupture rupture = source.getRupture(rupIndex);
                double mag = rupture.getMag();
                if (!(mag >= minMag) || !(mag < maxMag)) continue;
                int[] rupNodes = null;
                if (rupNodesCache != null) {
                    rupNodes = rupNodesCache.getNodesForRup(source, rupture, srcIndex, rupIndex, griddedRegion);
                }
                if (rupNodes == null) {
                    rupNodes = ERF_Calculator.getRupNodesInRegion(rupture, griddedRegion);
                }
                double qkRate = rupture.getMeanAnnualRate(duration);
                int[] nArray = rupNodes;
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    int locIndex;
                    int n2 = locIndex = nArray[i];
                    zVals[n2] = zVals[n2] + qkRate;
                }
            }
        }
        for (int i = 0; i < griddedRegion.getNodeCount(); ++i) {
            xyzData.set(i, zVals[i]);
        }
        return xyzData;
    }

    public static int[] getRupNodesInRegion(ProbEqkRupture rupture, GriddedRegion griddedRegion) {
        HashSet<Integer> locIndices = new HashSet<Integer>();
        for (Location loc : rupture.getRuptureSurface().getEvenlyDiscritizedListOfLocsOnSurface()) {
            int index = griddedRegion.indexForLocation(loc);
            if (index < 0) continue;
            locIndices.add(index);
        }
        return Ints.toArray(locIndices);
    }

    /*
     * WARNING - void declaration
     */
    public static void writeSTEP_FormatFile(ArrayList<SummedMagFreqDist> mfds, GriddedRegion griddedRegion, String filePathAndName) {
        SummedMagFreqDist totalMFD = new SummedMagFreqDist(5.05, 36, 0.1);
        for (IncrementalMagFreqDist incrementalMagFreqDist : mfds) {
            totalMFD.addResampledMagFreqDist(incrementalMagFreqDist, true);
        }
        System.out.println(totalMFD.getCumRateDistWithOffset());
        try {
            void var5_7;
            FileWriter fw = new FileWriter(filePathAndName);
            String string = "lat\tlon";
            for (int m = 0; m < totalMFD.size(); ++m) {
                String string2 = (String)var5_7 + "\t" + (float)totalMFD.getX(m);
            }
            fw.write((String)var5_7 + "\n");
            for (int i = 0; i < griddedRegion.getNodeCount(); ++i) {
                Location loc = griddedRegion.locationForIndex(i);
                String line = (float)loc.getLatitude() + "\t" + (float)loc.getLongitude();
                IncrementalMagFreqDist mfd = mfds.get(i);
                for (int m = 0; m < mfd.size(); ++m) {
                    line = line + "\t" + (float)mfd.getY(m);
                }
                fw.write(line + "\n");
            }
            fw.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void main(String[] args) {
    }
}

