/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.calc.recurInterval;

import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.sha.earthquake.calc.recurInterval.EqkProbDistCalc;

public final class ExponentialDistCalc
extends EqkProbDistCalc
implements ParameterChangeListener {
    public ExponentialDistCalc() {
        this.NAME = "Exponential";
        this.adjustableParams.removeParameter(this.aperiodicityParam);
    }

    public void setAll(double mean, double deltaX, int numPoints) {
        this.mean = mean;
        this.deltaX = deltaX;
        this.numPoints = numPoints;
        this.upToDate = false;
    }

    public void setAll(double mean, double deltaX, int numPoints, double duration) {
        this.mean = mean;
        this.deltaX = deltaX;
        this.numPoints = numPoints;
        this.duration = duration;
        this.upToDate = false;
    }

    public void setAll(double mean, double deltaX, int numPoints, double duration, double histOpenInterval) {
        this.mean = mean;
        this.deltaX = deltaX;
        this.numPoints = numPoints;
        this.duration = duration;
        this.histOpenInterval = histOpenInterval;
        this.upToDate = false;
    }

    public void setAll(double mean) {
        this.mean = mean;
        this.deltaX = 0.001 * mean;
        this.numPoints = (int)Math.round(this.aperiodicity * 10.0 * mean / this.deltaX) + 1;
        this.upToDate = false;
    }

    @Override
    protected void computeDistributions() {
        this.integratedCDF = null;
        this.integratedOneMinusCDF = null;
        this.pdf = new EvenlyDiscretizedFunc(0.0, this.numPoints, this.deltaX);
        this.cdf = new EvenlyDiscretizedFunc(0.0, this.numPoints, this.deltaX);
        double rate = 1.0 / this.mean;
        for (int i = 0; i < this.pdf.size(); ++i) {
            double t = this.pdf.getX(i);
            this.pdf.set(i, rate * Math.exp(-t * rate));
            this.cdf.set(i, 1.0 - Math.exp(-t * rate));
        }
        this.upToDate = true;
    }

    public static void main(String[] args) {
    }
}

